/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;

public class FrogMenuItemUI
extends MenuItemUI {
    public static final String __PerforceId = "$Id$";
    private static JMenuItem mCurrentSelectedMenuItem;
    InputMap windowInputMap;
    protected JMenuItem menuItem = null;
    protected Color acceleratorForeground;
    protected Color mItemBackground;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected static int mIconGap;
    protected boolean oldBorderPainted;
    protected String mPrefix = null;
    static Rectangle zeroRect;
    static Rectangle iconRect;
    static Rectangle textRect;
    static Rectangle acceleratorRect;
    static Rectangle checkIconRect;
    static Rectangle arrowIconRect;
    static Rectangle viewRect;
    static Rectangle r;
    static /* synthetic */ Class class$0;

    static {
        mIconGap = 3;
        zeroRect = new Rectangle(0, 0, 0, 0);
        iconRect = new Rectangle();
        textRect = new Rectangle();
        acceleratorRect = new Rectangle();
        checkIconRect = new Rectangle();
        arrowIconRect = new Rectangle();
        viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        r = new Rectangle();
    }

    public static ComponentUI createUI(JComponent c) {
        ComponentUI compUI = FrogMenuItemUI.createOSUI(c);
        if (compUI != null) {
            return compUI;
        }
        return new FrogMenuItemUI();
    }

    public void installUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        this.mPrefix = this.getPropertyPrefix();
        this.acceleratorFont = this.menuItem.getClientProperty("InfoContent") != null ? UIManager.getFont(String.valueOf(this.mPrefix) + ".font") : UIManager.getFont("MenuItem.acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(String.valueOf(this.mPrefix) + ".margin"));
        }
        this.defaultTextIconGap = 4;
        LookAndFeel.installBorder(this.menuItem, String.valueOf(this.mPrefix) + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIManager.get(String.valueOf(this.mPrefix) + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, String.valueOf(this.mPrefix) + ".background", String.valueOf(this.mPrefix) + ".foreground", String.valueOf(this.mPrefix) + ".font");
        this.menuItem.setBackground(UIManager.getColor(String.valueOf(this.mPrefix) + ".background"));
        this.mItemBackground = SystemHueShift.getColor((JComponent)this.menuItem, String.valueOf(this.mPrefix) + ".background");
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(String.valueOf(this.mPrefix) + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(String.valueOf(this.mPrefix) + ".checkIcon");
        }
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem);
        this.menuKeyListener = this.createMenuKeyListener(this.menuItem);
        if (FrogLookAndFeel.isVMVersion1dot2()) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.addMenuKeyListener(this.menuKeyListener);
    }

    protected void installKeyboardActions() {
        if (FrogLookAndFeel.isVMVersion1dot2()) {
            ActionMap actionMap = this.getActionMap();
            SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
            this.updateAcceleratorBinding();
        }
    }

    ActionMap getActionMap() {
        String propertyPrefix = this.getPropertyPrefix();
        String uiKey = String.valueOf(propertyPrefix) + ".actionMap";
        ActionMap am = (ActionMap)UIManager.get(uiKey);
        if (am == null) {
            am = this.createActionMap();
            UIManager.put(uiKey, am);
        }
        return am;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        if (FrogLookAndFeel.isVMVersion1dot2()) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
    }

    protected void uninstallKeyboardActions() {
        if (FrogLookAndFeel.isTracing()) {
            SwingUtilities.replaceUIActionMap(this.menuItem, null);
            if (this.windowInputMap != null) {
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
                this.windowInputMap = null;
            }
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("doClick", new ClickAction());
        return map;
    }

    InputMap createInputMap(int condition) {
        if (condition == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke accelerator = this.menuItem.getAccelerator();
        if (accelerator != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(accelerator, "doClick");
        } else if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    protected void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        boolean acceleratorTextIsEmpty;
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (text != null && b.getClientProperty(text) != null) {
            acceleratorText = (String)b.getClientProperty(text);
        } else if (accelerator != null) {
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = String.valueOf(acceleratorText) + "+";
            }
            acceleratorText = String.valueOf(acceleratorText) + KeyEvent.getKeyText(accelerator.getKeyCode());
        }
        Font font = b.getFont();
        FontMetrics fm = b.getToolkit().getFontMetrics(font);
        FontMetrics fmAccel = b.getToolkit().getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(FrogMenuItemUI.iconRect.x, FrogMenuItemUI.iconRect.y, FrogMenuItemUI.iconRect.width, FrogMenuItemUI.iconRect.height, r);
        boolean bl = acceleratorTextIsEmpty = acceleratorText == null || acceleratorText.equals("");
        if (!acceleratorTextIsEmpty) {
            FrogMenuItemUI.r.width += FrogMenuItemUI.acceleratorRect.width;
            FrogMenuItemUI.r.width += 7 * defaultTextIconGap;
        }
        if (this.useCheckAndArrow()) {
            FrogMenuItemUI.r.width += FrogMenuItemUI.checkIconRect.width;
            FrogMenuItemUI.r.width += defaultTextIconGap;
            FrogMenuItemUI.r.width += defaultTextIconGap;
            FrogMenuItemUI.r.width += FrogMenuItemUI.arrowIconRect.width;
        }
        FrogMenuItemUI.r.width += 2 * defaultTextIconGap;
        Insets insets = b.getInsets();
        if (insets != null) {
            FrogMenuItemUI.r.width += insets.left + insets.right;
            FrogMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (FrogMenuItemUI.r.width % 2 == 0) {
            ++FrogMenuItemUI.r.width;
        }
        if (FrogMenuItemUI.r.height % 2 == 0) {
            ++FrogMenuItemUI.r.height;
        }
        return r.getSize();
    }

    public JMenuItem getmenuItem() {
        return this.menuItem;
    }

    private void setSelectedItem(JMenuItem item) {
        mCurrentSelectedMenuItem = item;
    }

    public static boolean isMenuItemSelected(JMenuItem selectedItem) {
        return selectedItem == mCurrentSelectedMenuItem;
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, null, null, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        FrogMenuItemUI.viewRect.x += i.left;
        FrogMenuItemUI.viewRect.y += i.top;
        FrogMenuItemUI.viewRect.width -= i.right + FrogMenuItemUI.viewRect.x;
        FrogMenuItemUI.viewRect.height -= i.bottom + FrogMenuItemUI.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        Color holdc = g.getColor();
        if (c.isOpaque()) {
            if (model.isArmed()) {
                g.setColor(SystemHueShift.getColor(c, "MenuItem.selectionBackground"));
            } else if (!model.isEnabled()) {
                if (FrogMenuItemUI.isMenuItemSelected((JMenuItem)c)) {
                    g.setColor(SystemHueShift.getColor(c, "MenuItem.selectionBackground"));
                } else {
                    g.setColor(SystemHueShift.getColor(c, "MenuItem.background"));
                }
            } else {
                g.setColor(SystemHueShift.getColor(c, "MenuItem.background"));
            }
            g.fillRect(0, 0, menuWidth, menuHeight);
            g.setColor(holdc);
        } else {
            g.setColor(Color.orange);
            g.fillRect(0, 0, menuWidth, menuHeight);
            g.setColor(holdc);
        }
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (b.getClientProperty(b.getText()) != null) {
            acceleratorText = (String)b.getClientProperty(b.getText());
        } else if (accelerator != null) {
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = String.valueOf(acceleratorText) + "+";
            }
            acceleratorText = String.valueOf(acceleratorText) + KeyEvent.getKeyText(accelerator.getKeyCode());
        }
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        if (checkIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(SystemHueShift.getColor(c, String.valueOf(this.mPrefix) + ".selectionForeground"));
            } else {
                g.setColor(b.getForeground());
            }
            if (c instanceof JCheckBoxMenuItem) {
                checkIcon.paintIcon(c, g, FrogMenuItemUI.checkIconRect.x + c.getInsets().left + mIconGap, FrogMenuItemUI.checkIconRect.y);
            }
            if (this.useCheckAndArrow()) {
                checkIcon.paintIcon(c, g, FrogMenuItemUI.checkIconRect.x + c.getInsets().left + mIconGap, FrogMenuItemUI.checkIconRect.y);
            }
            g.setColor(holdc);
        }
        if (b.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(c, g, FrogMenuItemUI.iconRect.x, FrogMenuItemUI.iconRect.y);
            }
        }
        if (text != null && !text.equals("")) {
            if (!model.isEnabled()) {
                if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                    g.setColor(SystemHueShift.getColor(c, "MenuItem.disabledForeground"));
                    BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), FrogMenuItemUI.textRect.x, FrogMenuItemUI.textRect.y + fm.getAscent());
                } else {
                    g.setColor(this.mItemBackground.brighter());
                    BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), FrogMenuItemUI.textRect.x, FrogMenuItemUI.textRect.y + fm.getAscent());
                    g.setColor(this.mItemBackground.darker());
                    BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), FrogMenuItemUI.textRect.x - 1, FrogMenuItemUI.textRect.y + fm.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(SystemHueShift.getColor((JComponent)b, String.valueOf(this.mPrefix) + ".selectionForeground"));
                } else {
                    g.setColor(b.getForeground());
                }
                BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), FrogMenuItemUI.textRect.x, FrogMenuItemUI.textRect.y + fm.getAscent());
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (SystemHueShift.getColor(c, "MenuItem.disabledForeground") != null) {
                    g.setColor(SystemHueShift.getColor(c, "MenuItem.disabledForeground"));
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, FrogMenuItemUI.acceleratorRect.x, FrogMenuItemUI.acceleratorRect.y + fm.getAscent());
                } else {
                    g.setColor(this.mItemBackground.brighter());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, FrogMenuItemUI.acceleratorRect.x, FrogMenuItemUI.acceleratorRect.y + fm.getAscent());
                    g.setColor(this.mItemBackground.darker());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, FrogMenuItemUI.acceleratorRect.x - 1, FrogMenuItemUI.acceleratorRect.y + fm.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(SystemHueShift.getColor(c, String.valueOf(this.mPrefix) + ".acceleratorSelectionForeground"));
                } else if (this.menuItem.getClientProperty("InfoContent") != null) {
                    g.setColor(SystemHueShift.getColor(c, String.valueOf(this.mPrefix) + ".acceleratorSelectionForeground"));
                } else {
                    g.setColor(SystemHueShift.getColor(c, String.valueOf(this.mPrefix) + ".acceleratorForeground"));
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, FrogMenuItemUI.acceleratorRect.x, FrogMenuItemUI.acceleratorRect.y + fm.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(Color.orange);
            }
            if (this.useCheckAndArrow()) {
                arrowIcon.paintIcon(c, g, FrogMenuItemUI.arrowIconRect.x, FrogMenuItemUI.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    protected String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, Rectangle acceleratorR, Rectangle checkIconR, Rectangle arrowIconR, int textIconGap, int menuItemGap) {
        boolean acceleratorTextIsEmpty;
        SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
        boolean bl = acceleratorTextIsEmpty = acceleratorText == null || acceleratorText.equals("");
        if (acceleratorTextIsEmpty) {
            acceleratorR.height = 0;
            acceleratorR.width = 0;
            acceleratorText = "";
        } else {
            acceleratorR.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorR.height = fmAccel.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconR.width = checkIcon.getIconWidth();
                checkIconR.height = checkIcon.getIconHeight();
            } else {
                checkIconR.height = 0;
                checkIconR.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconR.width = arrowIcon.getIconWidth();
                arrowIconR.height = arrowIcon.getIconHeight();
            } else {
                arrowIconR.height = 0;
                arrowIconR.width = 0;
            }
            textR.x += checkIconR.width;
            iconR.x += checkIconR.width;
        }
        textR.x += menuItemGap;
        iconR.x += menuItemGap;
        Rectangle labelR = iconR.union(textR);
        acceleratorR.x += viewR.width - arrowIconR.width - menuItemGap - acceleratorR.width;
        acceleratorR.y = viewR.y + viewR.height / 2 - acceleratorR.height / 2;
        if (this.useCheckAndArrow()) {
            arrowIconR.x += viewR.width - arrowIconR.width;
            arrowIconR.y = viewR.y + labelR.height / 2 - arrowIconR.height / 2;
            checkIconR.y = viewR.y + labelR.height / 2 - checkIconR.height / 2;
            checkIconR.x += viewR.x;
        }
        return text;
    }

    protected boolean useCheckAndArrow() {
        boolean b = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            b = false;
        }
        return b;
    }

    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m.getSelectedPath();
        int i = oldPath.length;
        if (i == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i - 1].getComponent() == parent) {
            newPath = new MenuElement[i + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i);
            newPath[i] = this.menuItem;
        } else {
            int j = oldPath.length - 1;
            while (j >= 0) {
                if (oldPath[j].getComponent() == parent) break;
                --j;
            }
            newPath = new MenuElement[j + 2];
            System.arraycopy(oldPath, 0, newPath, 0, j + 1);
            newPath[j + 1] = this.menuItem;
        }
        return newPath;
    }

    void printMenuElementArray(MenuElement[] path, boolean dumpStack) {
        System.out.println("Path is(");
        int i = 0;
        int j = path.length;
        while (i < j) {
            int k = 0;
            while (k <= i) {
                System.out.print("  ");
                ++k;
            }
            MenuElement me = path[i];
            if (me instanceof JMenuItem) {
                System.out.println(String.valueOf(((JMenuItem)me).getText()) + ", ");
            } else if (me == null) {
                System.out.println("NULL , ");
            } else {
                System.out.println(me + ", ");
            }
            ++i;
        }
        System.out.println(")");
        if (dumpStack) {
            Thread.dumpStack();
        }
    }

    private static ComponentUI createOSUI(JComponent c) {
        Class<?> theInputClass = null;
        try {
            theInputClass = Class.forName("com.sap.platin.base.macosx.menu.GuiMacOSXMenuItemWrap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (theInputClass != null && c.getClass().getName().equals(theInputClass.getName())) {
            try {
                Class<?> initClass = Class.forName("com.apple.mrj.swing.MacMenuItemUI");
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("javax.swing.JComponent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Method initMethod = initClass.getMethod("createUI", classArray);
                return (ComponentUI)initMethod.invoke(null, c);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < FrogMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < FrogMenuItemUI.this.menuItem.getHeight()) {
                manager.clearSelectedPath();
                FrogMenuItemUI.this.menuItem.doClick(0);
            } else {
                manager.processMouseEvent(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                manager.setSelectedPath(FrogMenuItemUI.this.getPath());
                if (!FrogMenuItemUI.this.menuItem.isEnabled()) {
                    mCurrentSelectedMenuItem = FrogMenuItemUI.this.menuItem;
                    String mPrefix = FrogMenuItemUI.this.getPropertyPrefix();
                    FrogMenuItemUI.this.menuItem.setBackground((Color)UIManager.get("MenuItem.selectionBackground"));
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!FrogMenuItemUI.this.menuItem.isEnabled()) {
                mCurrentSelectedMenuItem = null;
                FrogMenuItemUI.this.menuItem.setBackground((Color)UIManager.get("MenuItem.background"));
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                MenuElement[] path = manager.getSelectedPath();
                if (path.length > 1) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    int i = 0;
                    int c = path.length - 1;
                    while (i < c) {
                        newPath[i] = path[i];
                        ++i;
                    }
                    manager.setSelectedPath(newPath);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < FrogMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < FrogMenuItemUI.this.menuItem.getHeight()) {
                manager.clearSelectedPath();
                FrogMenuItemUI.this.menuItem.doClick(0);
            } else {
                manager.clearSelectedPath();
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
            int key = FrogMenuItemUI.this.menuItem.getMnemonic();
            if (key == 0) {
                return;
            }
            if (this.lower(key) == this.lower(e.getKeyChar())) {
                MenuSelectionManager manager = e.getMenuSelectionManager();
                manager.clearSelectedPath();
                FrogMenuItemUI.this.menuItem.doClick(0);
                e.consume();
            }
        }

        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        private int lower(int ascii) {
            if (ascii >= 65 && ascii <= 90) {
                return ascii + 97 - 65;
            }
            return ascii;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("labelFor") || name.equals("displayedMnemonic") || name.equals("accelerator")) {
                FrogMenuItemUI.this.updateAcceleratorBinding();
            } else if (name.equals("text")) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            }
        }
    }

    private static class ClickAction
    extends AbstractAction {
        ClickAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }
}

