/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.hueshift.SystemHueShift;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public class FrogMenuBarUI
extends BasicMenuBarUI {
    protected SystemListener mSystemListener;

    public static ComponentUI createUI(JComponent c) {
        ComponentUI compUI = FrogMenuBarUI.createOSUI(c);
        if (compUI != null) {
            return compUI;
        }
        return new FrogMenuBarUI();
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.mSystemListener);
        super.uninstallUI(c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (this.mSystemListener == null) {
            this.mSystemListener = this.createSystemListener();
        }
        c.addPropertyChangeListener(this.mSystemListener);
    }

    public void installDefaults() {
        super.installDefaults();
        this.setBorder();
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(SystemHueShift.getColor(c, "MenuBar.background"));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    private void setBorder() {
        Border b = SystemHueShift.getBorder(this.menuBar, "MenuBar.border");
        this.menuBar.setBorder(b);
    }

    protected SystemListener createSystemListener() {
        return new SystemListener();
    }

    private static ComponentUI createOSUI(JComponent c) {
        Class<?> theInputClass = null;
        try {
            theInputClass = Class.forName("com.sap.platin.base.macosx.menu.GuiMacOSXMenuBarWrap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (theInputClass != null && c.getClass().getName().equals(theInputClass.getName())) {
            try {
                Class<?> theRes = Class.forName("apple.laf.AquaMenuBarUI");
                return (ComponentUI)theRes.newInstance();
            }
            catch (Exception e) {
                try {
                    Class<?> theRes2 = Class.forName("com.apple.mrj.swing.MacMenuBarUI");
                    return (ComponentUI)theRes2.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    class SystemListener
    implements PropertyChangeListener {
        SystemListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("system") || name.equals("theme")) {
                FrogMenuBarUI.this.setBorder();
            }
        }
    }
}

