/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.DynamicColorUIResource;
import com.sap.plaf.common.FontInfo;
import com.sap.plaf.common.LookAndFeelUtil;
import com.sap.plaf.frog.DefaultFrogTheme;
import com.sap.plaf.frog.FrogBorders;
import com.sap.plaf.frog.FrogCheckBoxIcon;
import com.sap.plaf.frog.FrogGIFReader;
import com.sap.plaf.frog.FrogIconFactory;
import com.sap.plaf.frog.FrogImageData;
import com.sap.plaf.frog.FrogTheme;
import com.sap.plaf.frog.FrogUtils;
import com.sap.plaf.frog.hueshift.FrogHueShift;
import com.sap.plaf.frog.hueshift.HueShiftTheme;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import com.sap.plaf.frog.util.ThemeData;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class FrogLookAndFeel
extends MetalLookAndFeel {
    public static final String __PerforceId = "$Id:$";
    protected FrogHueShift mHueShift;
    protected static FrogTheme currentTheme;
    protected static boolean mMACOS9;
    protected int mDefaultLabelFontSize = 12;
    protected int mDefaultPropFontSize = 12;
    protected int mDefaultFixedFontSize = 12;
    private static boolean mTracing;
    private static FrogLookAndFeel mTheInstance;
    private static boolean mIsJVM1dot4;
    private static String mTheme;
    static /* synthetic */ Class class$0;

    static {
        mMACOS9 = false;
        mTracing = false;
        mIsJVM1dot4 = FrogLookAndFeel.isVMVersion1dot4();
        mTheme = "null";
    }

    public FrogLookAndFeel() {
        this.initializeLF();
        this.printVersion(mTheme);
    }

    public FrogLookAndFeel(Boolean doprint) {
        this.initializeLF();
        if (doprint.booleanValue()) {
            this.printVersion(mTheme);
        }
    }

    protected void initializeLF() {
        mTheme = "null";
        try {
            ThemeData.createXMLInfo();
        }
        catch (Exception e) {
            System.err.println("Error: can not create XMLInfo");
            e.printStackTrace();
        }
        FrogLookAndFeel.setInstance(this);
        try {
            mTheme = System.getProperty("sap.theme");
        }
        catch (SecurityException e) {
            mTheme = "null for applet";
        }
        UIManager.put("currentTheme", mTheme);
    }

    public void printVersion(String theme) {
        System.err.println("<<< frog.jar: version 5.2.4  03/03/05  sap.theme: " + theme + " >>>");
    }

    public static void setInstance(FrogLookAndFeel f) {
        mTheInstance = f;
    }

    public static FrogLookAndFeel getInstance() {
        return mTheInstance;
    }

    public static boolean isMACOS9() {
        return mMACOS9;
    }

    public String getName() {
        return "Frog";
    }

    public String getID() {
        return "Frog";
    }

    public String getDescription() {
        return "SAP design for swing applications";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public void initThemeSpecificDefaults(HueShiftTheme currentTheme, UIDefaults table) {
        ColorUIResource[] colors = currentTheme.getColors();
        String themeName = currentTheme.getName();
        String prefix = currentTheme.isMaskedAsDefaultTheme() ? "" : String.valueOf(currentTheme.getName()) + ".";
        UIDefaults propertyTable = table == null ? UIManager.getLookAndFeelDefaults() : table;
        ImageIcon statusBarRightArrow = new ImageIcon(FrogLookAndFeel.getCropImage2(currentTheme, ThemeData.getImageData(null, "Statusbar.RightArrow")));
        if (currentTheme.isMaskedAsDefaultTheme()) {
            UIManager.put(String.valueOf(currentTheme.getName()) + "." + "Statusbar.RightArrow", null);
            UIManager.put(String.valueOf(currentTheme.getName()) + "." + "Statusbar.LeftArrow", null);
            UIManager.put("Statusbar.RightArrow", null);
            UIManager.put("Statusbar.LeftArrow", null);
        }
        propertyTable.put(String.valueOf(prefix) + "CheckBox.icon", new FrogCheckBoxIcon(currentTheme));
        propertyTable.put(String.valueOf(prefix) + "RadioButton.icon", FrogIconFactory.reloadRadioButtonIcon(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "textActive", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "PasswordField.background", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextField.background", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.borderRightDownColor", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextPane.editBackground", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Panel.okCodeField.TextBackground", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "PasswordField.background", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ComboBox.background", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ComboBox.listBackground", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "List.background", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CalendarControl.colorCellBackgroundLight", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.highlightLine0", colors[1]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "activeCaption", colors[2]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "menu", colors[2]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.background4", colors[2]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.background", colors[2]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.background", colors[2]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToolTip.background", colors[2]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.highlightLine1", colors[2]);
        if (!currentTheme.getRootThemeName().equals("Streamline") && !currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.background", colors[2]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.background", colors[2]);
        }
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.background3", colors[3]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "listColorBackgroundIntensifiedBg", colors[3]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CalendarControl.colorCellBackgroundDark", colors[3]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.highlightLineDefault", colors[3]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.background2", colors[4]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "frame", colors[5]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.background1", colors[5]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "appToolbar", colors[5]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.primaryTabBackground", colors[5]);
        if (!currentTheme.getRootThemeName().equals("Streamline") && !currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.primaryStripBackground", colors[5]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.primaryStripTextBackground", colors[5]);
        }
        if (!currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToolBar.applicationbackground", colors[5]);
        }
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "GroupBox.background", colors[5]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.shadowLine0", colors[5]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Table.background", colors[5]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Slider.background", colors[5]);
        if (!currentTheme.getRootThemeName().equals("Streamline") && !currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ScrollPane.background", colors[6]);
        }
        if (currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToolBar.applicationbackground", colors[6]);
        }
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ScrollPane.background", colors[6]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.shadowLine1", colors[6]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "PopupMenu.borderColor", colors[6]);
        if (!currentTheme.getRootThemeName().equals("Streamline") && !currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.selectionBackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.selectionBackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "StatusBar.background", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextPane.readOnlyBackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "outputBackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextField.inactiveBackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextField.inactiveFocusBackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "GroupBox.textBackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ComboBox.disabledBackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.shadowLineDefault", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToolBar.controlbackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "PasswordField.inactiveBackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CheckBoxMenuItem.selectionBackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "RadioButtonMenuItem.selectionBackground", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Control.controlBackgroundEnabledTable", colors[7]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Control.controlBackground_CFT", colors[7]);
        }
        if (currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.secondaryTabBackground", colors[7]);
        }
        if (currentTheme.getRootThemeName().equals("Streamline") || currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.disabledForegroundPrim", colors[8]);
        }
        if (themeName.equals("Harmonic") || themeName.equals("Complementary")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Panel.background", FrogLookAndFeel.getHarmonicBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "userAreaBackground", FrogLookAndFeel.getHarmonicBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "generalBackground", FrogLookAndFeel.getHarmonicBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "RadioButton.background", FrogLookAndFeel.getHarmonicBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CheckBox.background", FrogLookAndFeel.getHarmonicBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "control", FrogLookAndFeel.getHarmonicBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "OptionPane.background", FrogLookAndFeel.getHarmonicBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ScrollBar.background", FrogLookAndFeel.getHarmonicBackground());
        } else if (themeName.equals("BrightComplementary")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Panel.background", FrogLookAndFeel.getBrghtComplBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "userAreaBackground", FrogLookAndFeel.getBrghtComplBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "generalBackground", FrogLookAndFeel.getBrghtComplBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "RadioButton.background", FrogLookAndFeel.getBrghtComplBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CheckBox.background", FrogLookAndFeel.getBrghtComplBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "control", FrogLookAndFeel.getBrghtComplBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "OptionPane.background", FrogLookAndFeel.getBrghtComplBackground());
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ScrollBar.background", FrogLookAndFeel.getBrghtComplBackground());
        } else if (currentTheme.getRootThemeName().equals("Streamline")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Panel.background", colors[22]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "userAreaBackground", colors[22]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "generalBackground", colors[22]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "RadioButton.background", colors[22]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CheckBox.background", colors[22]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "control", colors[22]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "OptionPane.background", colors[22]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ScrollBar.background", colors[22]);
        } else if (currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Panel.background", colors[2]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "userAreaBackground", colors[2]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "generalBackground", colors[2]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "RadioButton.background", colors[2]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CheckBox.background", colors[2]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "control", colors[2]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "OptionPane.background", colors[2]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ScrollBar.background", colors[2]);
        } else {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Panel.background", colors[21]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "userAreaBackground", colors[21]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "generalBackground", colors[21]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "RadioButton.background", colors[21]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CheckBox.background", colors[21]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "control", colors[21]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "OptionPane.background", colors[21]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ScrollBar.background", colors[21]);
        }
        if (!currentTheme.getRootThemeName().equals("Streamline") && !currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.secondaryTabBackground", colors[8]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Slider.background", colors[8]);
        }
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToggleButton.background", colors[8]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToggleButton.disabledBackground", colors[8]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ProgressBar.background", colors[8]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "windowBorder", colors[8]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextPane.background", colors[8]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "EditPane.background", colors[8]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TableHeader.background", colors[8]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "window", colors[9]);
        if (currentTheme.getRootThemeName().equals("Streamline") || currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.disabledForeground", colors[9]);
        }
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.disabledForeground", colors[10]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.disabledForeground", colors[10]);
        if (!currentTheme.getRootThemeName().equals("Streamline") && !currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.disabledForeground", colors[10]);
        }
        if (currentTheme.getRootThemeName().equals("Streamline")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.secondaryTabBackground", colors[10]);
        }
        if (currentTheme.getRootThemeName().equals("Streamline") || currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "StatusBar.background", colors[10]);
        }
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.disabledForeground", colors[10]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CheckBoxMenuItem.disabledForeground", colors[10]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "RadioButtonMenuItem.disabledForeground", colors[10]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "SplitPane.background", colors[10]);
        if (currentTheme.getRootThemeName().equals("Streamline") || currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CheckBoxMenuItem.selectionBackground", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "RadioButtonMenuItem.selectionBackground", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextPane.readOnlyBackground", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "outputBackground", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextField.inactiveBackground", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextField.inactiveFocusBackground", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "PasswordField.inactiveBackground", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "GroupBox.textBackground", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ComboBox.disabledBackground", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.shadowLineDefault", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToolBar.controlbackground", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Control.controlBackgroundEnabledTable", colors[11]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Control.controlBackground_CFT", colors[11]);
        }
        if (currentTheme.getRootThemeName().equals("Streamline")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "GroupBox.textBackground", colors[11]);
        }
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ScrollPane.borderColor", colors[12]);
        if (!currentTheme.getRootThemeName().equals("Streamline") && !currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.disabledForegroundPrim", colors[12]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.disabledForegroundSec", colors[12]);
        }
        if (!currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Table.gridColor", colors[14]);
        }
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "GroupBox.textBorderColor", colors[14]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.borderLeftUpColor", colors[14]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToolTip.borderColor", colors[14]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Button.disabledText", colors[14]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CheckBox.disabledText", colors[14]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "RadioButton.disabledText", colors[14]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToggleButton.disabledText", colors[14]);
        if (currentTheme.getRootThemeName().equals("Streamline") || currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.disabledForegroundSec", colors[15]);
        }
        if (currentTheme.getRootThemeName().equals("Streamline") || currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.primaryStripBackground", colors[15]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.primaryStripTextBackground", colors[15]);
        }
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CalendarControl.colorFocus", colors[15]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CalendarControl.colorWeekend", colors[15]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Button.defaultBackground", colors[15]);
        if (currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Table.gridColor", colors[18]);
        }
        if (currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "GroupBox.textBackground", colors[20]);
        }
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Tree.columnDivider", colors[21]);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.TopMenuselectionForeground", FrogLookAndFeel.getTopMenuSelectionForeground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.TopMenuforeground", FrogLookAndFeel.getTopMenuForeground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Button.background", FrogLookAndFeel.getToolbarBackground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ScrollPane.background", FrogLookAndFeel.getScrollPaneBackground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.primaryTabforeground", FrogLookAndFeel.getPrimaryTabForeground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.disabledForeground", FrogLookAndFeel.getMenuDisabledForeground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.disabledForeground", FrogLookAndFeel.getMenuDisabledForeground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "CheckBoxMenuItem.disabledForeground", FrogLookAndFeel.getMenuDisabledForeground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToolBar.background", FrogLookAndFeel.getToolbarBackground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuBar.background", FrogLookAndFeel.getTopMenuBackground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.TopMenubackground", FrogLookAndFeel.getTopMenuBackground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "RadioButtonMenuItem.disabledForeground", FrogLookAndFeel.getMenuDisabledForeground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToolBar.dockingBackground", FrogLookAndFeel.getToolbarBackground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToolBar.floatingBackground", FrogLookAndFeel.getToolbarBackground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.rolloverForeground", FrogLookAndFeel.getRolloverForeground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Panel.okCodeField.Background", FrogLookAndFeel.getokCodeFieldBackground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextField.InnerBorderColor", FrogLookAndFeel.getTextFieldInnerBorderColor(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TitleBar.foreground", FrogLookAndFeel.getTitleBarForeground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.selectionBackground", FrogLookAndFeel.getMenuSelectedBackground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.selectionBackground", FrogLookAndFeel.getMenuSelectedBackground(currentTheme));
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ToolBar.foreground", FrogLookAndFeel.getMenuForeground());
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Label.disabledForeground", FrogLookAndFeel.getInactiveSystemTextColor());
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.selectionForeground", FrogLookAndFeel.getMenuForeground());
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.acceleratorForeground", FrogLookAndFeel.getAcceleratorForeground());
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.acceleratorSelectionForeground", FrogLookAndFeel.getAcceleratorSelectedForeground());
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.foreground", FrogLookAndFeel.getMenuForeground());
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.foreground", FrogLookAndFeel.getMenuForeground());
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.selectionForeground", FrogLookAndFeel.getMenuSelectedForeground());
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.acceleratorForeground", FrogLookAndFeel.getAcceleratorForeground());
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.acceleratorSelectionForeground", FrogLookAndFeel.getAcceleratorSelectedForeground());
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TabbedPane.tabAreaBackground", FrogLookAndFeel.getControl());
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextField.inactiveFocusBorderColor", null);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "TextField.focusBorderColor", null);
        FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "ComboBox.foreground", FrogLookAndFeel.getControlTextColor());
        UIManager.put(String.valueOf(prefix) + "Panel.okCodeField.LeftBtnIcon", new IconLazyValue(currentTheme, ThemeData.getImageDataFromThemeName(currentTheme.getName(), "Toolbar.LeftBtn")));
        UIManager.put(String.valueOf(prefix) + "Table.settingsIcon", new IconLazyValue(currentTheme, ThemeData.getImageDataFromThemeName(currentTheme.getName(), "TableIcon.TIcon.Settings")));
        UIManager.put(String.valueOf(prefix) + "Grid.selectionIcon", new IconLazyValue(currentTheme, ThemeData.getImageDataFromThemeName(currentTheme.getName(), "TableIcon.TIcon.Selection")));
        UIManager.put(String.valueOf(prefix) + "Panel.okCodeField.LeftBtnPIcon", new IconLazyValue(currentTheme, ThemeData.getImageDataFromThemeName(currentTheme.getName(), "Toolbar.LeftBtnP")));
        UIManager.put(String.valueOf(prefix) + "Panel.okCodeField.RightBtnIcon", new IconLazyValue(currentTheme, ThemeData.getImageDataFromThemeName(currentTheme.getName(), "Toolbar.RightBtn")));
        UIManager.put(String.valueOf(prefix) + "Panel.okCodeField.RightBtnPIcon", new IconLazyValue(currentTheme, ThemeData.getImageDataFromThemeName(currentTheme.getName(), "Toolbar.RightBtnP")));
        UIManager.put(String.valueOf(prefix) + "StatusBar.leftArrow", new IconLazyValue(currentTheme, ThemeData.getImageDataFromThemeName(currentTheme.getName(), "Statusbar.LeftArrow")));
        UIManager.put(String.valueOf(prefix) + "StatusBar.menuIcon", new IconLazyValue(currentTheme, ThemeData.getImageDataFromThemeName(currentTheme.getName(), "Statusbar.Menu")));
        UIManager.put(String.valueOf(prefix) + "ComboBox.iconButton", new IconLazyValue(currentTheme, ThemeData.getImageDataFromThemeName(currentTheme.getName(), "Combobox.Button")));
        UIManager.put(String.valueOf(prefix) + "TabbedPane.listIconButton", new IconLazyValue(currentTheme, ThemeData.getImageDataFromThemeName(currentTheme.getName(), "TabStripCtl.TabList")));
        UIManager.put(String.valueOf(prefix) + "TabbedPane.listIconButtonPS", new IconLazyValue(currentTheme, ThemeData.getImageDataFromThemeName(currentTheme.getName(), "TabStripCtl.TabList.PS")));
        UIManager.put(String.valueOf(prefix) + "Slider.horizontalThumbIcon", FrogIconFactory.getHorizontalSliderThumbIcon(currentTheme));
        UIManager.put(String.valueOf(prefix) + "Slider.verticalThumbIcon", FrogIconFactory.getVerticalSliderThumbIcon(currentTheme));
        propertyTable.put(String.valueOf(prefix) + "Tree.SAPexpandedIcon", FrogIconFactory.getTreeControlIcon(false, currentTheme));
        propertyTable.put(String.valueOf(prefix) + "Tree.SlimBorder", new FrogBorders.SlimBorder(1));
        propertyTable.put(String.valueOf(prefix) + "Tree.openIcon", FrogIconFactory.getTreeOpenIcon(currentTheme));
        propertyTable.put(String.valueOf(prefix) + "Tree.SlimBorder", new FrogBorders.SlimBorder(1));
        propertyTable.put(String.valueOf(prefix) + "Tree.leafIcon", FrogIconFactory.getTreeLeafIcon(currentTheme));
        propertyTable.put(String.valueOf(prefix) + "Tree.SlimBorder", new FrogBorders.SlimBorder(1));
        propertyTable.put(String.valueOf(prefix) + "Tree.SAPcollapsedIcon", FrogIconFactory.getTreeControlIcon(true, currentTheme));
        propertyTable.put(String.valueOf(prefix) + "Tree.SlimBorder", new FrogBorders.SlimBorder(1));
        propertyTable.put(String.valueOf(prefix) + "Tree.closedIcon", FrogIconFactory.getTreeFolderIcon(currentTheme));
        if (currentTheme.getRootThemeName().equals("Streamline") || currentTheme.getRootThemeName().equals("Tradeshow")) {
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "MenuItem.background", colors[22]);
            FrogLookAndFeel.putDynamicColor(propertyTable, String.valueOf(prefix) + "Menu.background", colors[22]);
        }
        if (currentTheme.getRootThemeName().equals("Streamline") || currentTheme.getRootThemeName().equals("Tradeshow")) {
            propertyTable.put(String.valueOf(prefix) + "MenuBar.border", new FrogBorders.NotchBorder());
        } else {
            propertyTable.put(String.valueOf(prefix) + "MenuBar.border", new EmptyBorder(0, 0, 0, 0));
        }
        propertyTable.put(String.valueOf(prefix) + "StatusBar.textfieldBorder", new FrogBorders.StatusTextFieldBorder());
        propertyTable.put(String.valueOf(prefix) + "StatusBar.systemInfoBorder", new FrogBorders.SystemInfoBorder());
        propertyTable.put(String.valueOf(prefix) + "StatusBar.pcInfoBorder", new FrogBorders.StatusPCInfoBorder());
        propertyTable.put(String.valueOf(prefix) + "ToolBar.applicationborder", new FrogBorders.ApplicationToolBarBorder());
        propertyTable.put(String.valueOf(prefix) + "OKCodeTextField.border", new FrogBorders.OKCodeTextFieldBorder());
        propertyTable.put(String.valueOf(prefix) + "ToolBar.border", new FrogBorders.ToolBarBorder());
        propertyTable.put(String.valueOf(prefix) + "StatusBar.statusAreaBorder", new FrogBorders.StatusAreaBorder());
        propertyTable.put(String.valueOf(prefix) + "TitleBar.font", FrogLookAndFeel.getTitleBarFont(currentTheme));
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String frogPackageName = "com.sap.plaf.frog.";
        Object[] uiDefaults = new Object[]{"ButtonUI", String.valueOf(frogPackageName) + "FrogButtonUI", "CheckBoxUI", String.valueOf(frogPackageName) + "FrogCheckBoxUI", "ComboBoxUI", String.valueOf(frogPackageName) + "FrogComboBoxUI", "GroupBoxUI", String.valueOf(frogPackageName) + "FrogGroupBoxUI", "MenuUI", String.valueOf(frogPackageName) + "FrogMenuUI", "PanelUI", String.valueOf(frogPackageName) + "FrogPanelUI", "MenuItemUI", String.valueOf(frogPackageName) + "FrogMenuItemUI", "CheckBoxMenuItemUI", String.valueOf(frogPackageName) + "FrogMenuItemUI", "PopupMenuUI", String.valueOf(frogPackageName) + "FrogPopupMenuUI", "RadioButtonUI", String.valueOf(frogPackageName) + "FrogRadioButtonUI", "ToggleButtonUI", String.valueOf(frogPackageName) + "FrogToggleButtonUI", "ProgressBarUI", String.valueOf(frogPackageName) + "FrogProgressBarUI", "ScrollBarUI", String.valueOf(frogPackageName) + "FrogScrollBarUI", "ScrollPaneUI", String.valueOf(frogPackageName) + "FrogScrollPaneUI", "SplitPaneUI", String.valueOf(frogPackageName) + "FrogSplitPaneUI", "SliderUI", String.valueOf(frogPackageName) + "FrogSliderUI", "SeparatorUI", String.valueOf(frogPackageName) + "FrogSeparatorUI", "PasswordFieldUI", String.valueOf(frogPackageName) + "FrogPasswordFieldUI", "PopupMenuSeparatorUI", String.valueOf(frogPackageName) + "FrogPopupMenuSeparatorUI", "TabbedPaneUI", String.valueOf(frogPackageName) + "FrogTabbedPaneUI", "TextFieldUI", String.valueOf(frogPackageName) + "FrogTextFieldUI", "FormattedTextFieldUI", String.valueOf(frogPackageName) + "FrogTextFieldUI", "TextAreaUI", String.valueOf(frogPackageName) + "FrogTextAreaUI", "TextPaneUI", String.valueOf(frogPackageName) + "FrogTextPaneUI", "TreeUI", String.valueOf(frogPackageName) + "FrogTreeUI", "LabelUI", String.valueOf(frogPackageName) + "FrogLabelUI", "ListUI", String.valueOf(frogPackageName) + "FrogListUI", "ToolBarUI", String.valueOf(frogPackageName) + "FrogToolBarUI", "ToolBarSeparatorUI", String.valueOf(frogPackageName) + "FrogToolBarSeparatorUI", "ToolTipUI", String.valueOf(frogPackageName) + "FrogToolTipUI", "InternalFrameUI", String.valueOf(frogPackageName) + "FrogInternalFrameUI", "DesktopIconUI", String.valueOf(frogPackageName) + "FrogDesktopIconUI", "FileChooserUI", String.valueOf(frogPackageName) + "FrogFileChooserUI", "SystemCheckBoxUI", String.valueOf(frogPackageName) + "FrogSystemCheckBoxUI", "MenuBarUI", String.valueOf(frogPackageName) + "FrogMenuBarUI"};
        table.putDefaults(uiDefaults);
    }

    public static String[] getFrogClasses() {
        String[] frogClasses = new String[]{(String)UIManager.get("ButtonUI"), (String)UIManager.get("ScrollBarUI"), (String)UIManager.get("RadioButtonUI")};
        return frogClasses;
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        ColorUIResource ColRed = new ColorUIResource(255, 0, 0);
        ColorUIResource ColBlack = new ColorUIResource(0, 0, 0);
        Object[] systemColors = new Object[]{"desktop", FrogLookAndFeel.getDesktopColor(), "activeCaptionText", FrogLookAndFeel.getWindowTitleForeground(), "activeCaptionBorder", FrogLookAndFeel.getPrimaryControlShadow(), "inactiveCaption", FrogLookAndFeel.getWindowTitleInactiveBackground(), "inactiveCaptionText", FrogLookAndFeel.getWindowTitleInactiveForeground(), "inactiveCaptionBorder", FrogLookAndFeel.getControlShadow(), "windowText", FrogLookAndFeel.getUserTextColor(), "menuText", FrogLookAndFeel.getMenuForeground(), "text", FrogLookAndFeel.getWindowBackground(), "textText", FrogLookAndFeel.getUserTextColor(), "textHighlight", FrogLookAndFeel.getTextHighlightColor(), "textHighlightText", FrogLookAndFeel.getHighlightedTextColor(), "textInactiveText", FrogLookAndFeel.getInactiveSystemTextColor(), "controlText", FrogLookAndFeel.getControlTextColor(), "controlHighlight", FrogLookAndFeel.getControlHighlight(), "controlLtHighlight", FrogLookAndFeel.getControlHighlight(), "controlShadow", FrogLookAndFeel.getControlShadow(), "controlDkShadow", FrogLookAndFeel.getControlDarkShadow(), "scrollbar", FrogLookAndFeel.getControl(), "info", FrogLookAndFeel.getToolTipBackground(), "infoText", FrogLookAndFeel.getPrimaryControlInfo(), "focusEnabledText", FrogLookAndFeel.getFocusEnabledFieldBackground(), "textSelectedInputBackground", FrogLookAndFeel.getSelectedInputBackground(), "textSelectedOutputBackground", FrogLookAndFeel.getSelectedOutputBackground(), "INPUTINTFOREGROUND", ColRed, "LABELFOREGROUND", ColBlack, "outputIntForeground", FrogLookAndFeel.getOutputIntForeground(), "textSelectedInputForeground", FrogLookAndFeel.getSelectedInputForeground(), "textSelectedOutputForeground", FrogLookAndFeel.getSelectedInputForeground(), "generalForeground", FrogLookAndFeel.getUserTextColor(), "listColorBackgroundIntensifiedBg", FrogLookAndFeel.getListColorBackgroundIntensifiedBg(), "listColorBackgroundBg", FrogLookAndFeel.getListColorBackgroundBg(), "listColorBackgroundInverseBg", FrogLookAndFeel.getListColorBackgroundInverseBg(), "listColorHeadingIntensifiedBg", FrogLookAndFeel.getListColorHeadingIntensifiedBg(), "listColorHeadingBg", FrogLookAndFeel.getListColorHeadingBg(), "listColorHeadingInverseBg", FrogLookAndFeel.getListColorHeadingInverseBg(), "listColorNormalIntensifiedBg", FrogLookAndFeel.getListColorNormalIntensifiedBg(), "listColorNormalBg", FrogLookAndFeel.getListColorNormalBg(), "listColorNormalInverseBg", FrogLookAndFeel.getListColorNormalInverseBg(), "listColorTotalIntensifiedBg", FrogLookAndFeel.getListColorTotalIntensifiedBg(), "listColorTotalBg", FrogLookAndFeel.getListColorTotalBg(), "listColorTotalInverseBg", FrogLookAndFeel.getListColorTotalInverseBg(), "listColorKeyIntensifiedBg", FrogLookAndFeel.getListColorKeyIntensifiedBg(), "listColorKeyBg", FrogLookAndFeel.getListColorKeyBg(), "listColorKeyInverseBg", FrogLookAndFeel.getListColorKeyInverseBg(), "listColorPositiveIntensifiedBg", FrogLookAndFeel.getListColorPositiveIntensifiedBg(), "listColorPositiveBg", FrogLookAndFeel.getListColorPositiveBg(), "listColorPositiveInverseBg", FrogLookAndFeel.getListColorPositiveInverseBg(), "listColorNegativeIntensifiedBg", FrogLookAndFeel.getListColorNegativeIntensifiedBg(), "listColorNegativeBg", FrogLookAndFeel.getListColorNegativeBg(), "listColorNegativeInverseBg", FrogLookAndFeel.getListColorNegativeInverseBg(), "listColorGroupIntensifiedBg", FrogLookAndFeel.getListColorGroupIntensifiedBg(), "listColorGroupBg", FrogLookAndFeel.getListColorGroupBg(), "listColorGroupInverseBg", FrogLookAndFeel.getListColorGroupInverseBg()};
        int i = 0;
        while (i < systemColors.length) {
            table.put((String)systemColors[i], systemColors[i + 1]);
            i += 2;
        }
    }

    protected void loadResourceBundle(UIDefaults table) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.sap.plaf.frog.resources.frog");
        Enumeration<String> iter = bundle.getKeys();
        while (iter.hasMoreElements()) {
            String key = iter.nextElement();
            table.put(key, bundle.getObject(key));
        }
    }

    protected void initComponentDefaults(UIDefaults table) {
        String osname;
        if (FrogHueShift.getCurrentTheme().isMaskedAsDefaultTheme()) {
            String prefix = "";
        } else {
            String prefix = String.valueOf(FrogHueShift.getCurrentTheme().getName()) + ".";
        }
        if (UIManager.get("FastFrog") == null) {
            UIManager.put("FastFrog", Boolean.TRUE);
        }
        if ((osname = System.getProperty("os.name").toUpperCase()).startsWith("MAC") && !osname.equals("MAC OS X")) {
            mMACOS9 = true;
        }
        super.initComponentDefaults(table);
        FrogBorders.initializeImageData();
        this.loadResourceBundle(table);
        LookAndFeelUtil.fixLookAndFeel();
        Object fieldBindings = table.get("TextField.focusInputMap");
        LookAndFeelUtil.fixInputMap((InputMap)fieldBindings);
        Object multilineBindings = table.get("TextArea.focusInputMap");
        LookAndFeelUtil.fixInputMap((InputMap)multilineBindings);
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        FrogBorders.Flush3DBorder flush3DBorder = new FrogBorders.Flush3DBorder();
        FrogBorders.TextFieldBorder textFieldBorder = new FrogBorders.TextFieldBorder(new FrogBorders.FrogTextFieldBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        Border emptyBorder0 = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        Border emptyBorder2 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        BorderUIResource.CompoundBorderUIResource textBorder = new BorderUIResource.CompoundBorderUIResource(flush3DBorder, marginBorder);
        FrogBorders.ScrollPaneBorder scrollPaneBorder = new FrogBorders.ScrollPaneBorder();
        FrogBorders.ButtonBorder buttonBorder = new FrogBorders.ButtonBorder();
        FrogBorders.ToggleButtonBorder toggleButtonBorder = new FrogBorders.ToggleButtonBorder();
        BorderUIResource.LineBorderUIResource titledBorderBorder = new BorderUIResource.LineBorderUIResource(table.getColor("controlShadow"));
        BorderUIResource.CompoundBorderUIResource desktopIconBorder = new BorderUIResource.CompoundBorderUIResource(new LineBorder(FrogLookAndFeel.getControlDarkShadow(), 1), new MatteBorder(2, 2, 1, 2, FrogLookAndFeel.getControl()));
        FrogBorders.NotchBorder notchBorder = new FrogBorders.NotchBorder();
        FrogBorders.MenuItemBorder menuItemBorder = new FrogBorders.MenuItemBorder();
        FrogBorders.TopMenuBorder topMenuBorder = new FrogBorders.TopMenuBorder();
        FrogBorders.ToolBarBorder toolBarBorder = new FrogBorders.ToolBarBorder();
        FrogBorders.ControlToolBarBorder toolBarControlBorder = new FrogBorders.ControlToolBarBorder();
        FrogBorders.PopupMenuDockedBorder popupMenuDockedBorder = new FrogBorders.PopupMenuDockedBorder();
        FrogBorders.PopupMenuUndockedBorder popupMenuUndockedBorder = new FrogBorders.PopupMenuUndockedBorder();
        FrogBorders.ApplicationToolBarBorder applicationToolBarBorder = new FrogBorders.ApplicationToolBarBorder();
        FrogBorders.TitleBarBorder titleBarBorder = new FrogBorders.TitleBarBorder();
        FrogBorders.OKCodeFieldBorder okCodeFieldBorder = new FrogBorders.OKCodeFieldBorder();
        FrogBorders.StatusTextFieldBorder statusTextFieldBorder = new FrogBorders.StatusTextFieldBorder();
        FrogBorders.SystemInfoBorder systemInfoBorder = new FrogBorders.SystemInfoBorder();
        FrogBorders.StatusPCInfoBorder statusPCInfoBorder = new FrogBorders.StatusPCInfoBorder();
        FrogBorders.GroupBoxBorder groupBoxBorder = new FrogBorders.GroupBoxBorder();
        FrogBorders.TableBorder tableBorder = new FrogBorders.TableBorder();
        FrogBorders.TableTitleBorder tableTitleBorder = new FrogBorders.TableTitleBorder();
        FrogBorders.LabelFocusBorder componentFocusBorder = new FrogBorders.LabelFocusBorder();
        FrogBorders.ComponentCellFocusBorder componentCellFocusBorder = new FrogBorders.ComponentCellFocusBorder();
        BorderUIResource.LineBorderUIResource progressBarBorder = new BorderUIResource.LineBorderUIResource(FrogLookAndFeel.getControlDarkShadow(), 1);
        FrogBorders.ToolTipBorder toolTipBorder = new FrogBorders.ToolTipBorder(FrogLookAndFeel.getPrimaryControlDarkShadow());
        BorderUIResource.LineBorderUIResource focusCellHighlightBorder = new BorderUIResource.LineBorderUIResource(FrogLookAndFeel.getFocusColor());
        InsetsUIResource tabbedPaneTabAreaInsets = new InsetsUIResource(4, 2, 0, 6);
        InsetsUIResource sliderFocusInsets = new InsetsUIResource(0, 0, 0, 0);
        Integer NULL = new Integer(0);
        int[] invisibleComponentList = new int[]{2, 4};
        int internalFrameIconSize = 16;
        Object[] objectArray = new Object[642];
        objectArray[0] = "PopupMenu.selectedWindowInputMapBindings";
        objectArray[1] = new Object[]{"ESCAPE", "cancel", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return", "alt DOWN", "cancel", "alt KP_DOWN", "cancel"};
        objectArray[2] = "TextField.border";
        objectArray[3] = textFieldBorder;
        objectArray[4] = "TextField.font";
        objectArray[5] = FrogLookAndFeel.getUserTextFont();
        objectArray[6] = "TextField.caretForeground";
        objectArray[7] = FrogLookAndFeel.getUserTextColor();
        objectArray[8] = "Notch.border";
        objectArray[9] = notchBorder;
        objectArray[10] = "Component.focusBorder";
        objectArray[11] = componentFocusBorder;
        objectArray[12] = "Component.cellFocusBorder";
        objectArray[13] = componentCellFocusBorder;
        objectArray[14] = "PasswordField.border";
        objectArray[15] = textFieldBorder;
        objectArray[16] = "PasswordField.font";
        objectArray[17] = FrogLookAndFeel.getUserTextFont();
        objectArray[18] = "PasswordField.caretForeground";
        objectArray[19] = FrogLookAndFeel.getUserTextColor();
        objectArray[20] = "TextArea.font";
        objectArray[21] = FrogLookAndFeel.getUserTextFont();
        objectArray[22] = "TextArea.caretForeground";
        objectArray[23] = FrogLookAndFeel.getUserTextColor();
        objectArray[24] = "TextArea.inactiveForeground";
        objectArray[25] = table.get("textText");
        objectArray[26] = "TextComponent.ListBorder";
        objectArray[27] = emptyBorder0;
        objectArray[28] = "TextComponent.2DBorder";
        objectArray[29] = emptyBorder0;
        objectArray[30] = "TextComponent.3DBorder";
        objectArray[31] = textFieldBorder;
        objectArray[32] = "TextComponent.TableBorder";
        objectArray[33] = emptyBorder0;
        objectArray[34] = "TextComponent.LabelBorder";
        objectArray[35] = new FrogBorders.LabelFocusBorder();
        objectArray[36] = "TextComponent.ListBorderWidth";
        objectArray[37] = NULL;
        objectArray[38] = "TextComponent.2DBorderWidth";
        objectArray[39] = NULL;
        objectArray[40] = "TextComponent.3DBorderWidth";
        objectArray[41] = new Integer(4);
        objectArray[42] = "TextComponent.TableBorderWidth";
        objectArray[43] = NULL;
        objectArray[44] = "TextComponent.LabelBorderWith";
        objectArray[45] = new Integer(3);
        objectArray[46] = "TextField.background";
        objectArray[47] = table.get("textActive");
        objectArray[48] = "TextField.inactiveBackground";
        objectArray[49] = table.get("outputBackground");
        objectArray[50] = "TextField.inactiveForeground";
        objectArray[51] = FrogLookAndFeel.getUserTextColor();
        objectArray[52] = "Textfield.InputBackEnabledFocus";
        objectArray[53] = table.get("focusEnabledText");
        objectArray[54] = "Textfield.InputBackSelectFocusTable";
        objectArray[55] = table.get("focusEnabledText");
        objectArray[56] = "Textfield.InputForeSelectTable";
        objectArray[57] = table.get("textText");
        objectArray[58] = "Textfield.InputForeSelectFocusTable";
        objectArray[59] = table.get("textText");
        objectArray[60] = "Textfield.OutputForeSelectFocusTable";
        objectArray[61] = table.get("textText");
        objectArray[62] = "Textfield.OutputBackSelectTable";
        objectArray[63] = table.get("textSelectedOutputBackground");
        objectArray[64] = "Textfield.InputBackSelectTable";
        objectArray[65] = table.get("textSelectedInputBackground");
        objectArray[66] = "Textfield.OutputBackSelectFocusTable";
        objectArray[67] = table.get("focusEnabledText");
        objectArray[68] = "Textfield.OutputForeSelectTable";
        objectArray[69] = table.get("textText");
        objectArray[70] = "TextPane.selectionBackground";
        objectArray[71] = table.get("textHighlight");
        objectArray[72] = "TextPane.selectionForeground";
        objectArray[73] = table.get("textHighlightText");
        objectArray[74] = "TextPane.background";
        objectArray[75] = table.get("window");
        objectArray[76] = "TextPane.foreground";
        objectArray[77] = table.get("textText");
        objectArray[78] = "TextPane.font";
        objectArray[79] = FrogLookAndFeel.getUserTextFont();
        objectArray[80] = "TextPane.fixed";
        objectArray[81] = FrogLookAndFeel.getFixedFont();
        objectArray[82] = "TextPane.proportional";
        objectArray[83] = FrogLookAndFeel.getProportionalFont();
        objectArray[84] = "TextPane.caretForeground";
        objectArray[85] = FrogLookAndFeel.getUserTextColor();
        objectArray[86] = "TextPane.breakpointBackground";
        objectArray[87] = FrogLookAndFeel.getBreakpointBackground();
        objectArray[88] = "TextPane.highlightForeground";
        objectArray[89] = FrogLookAndFeel.getHighlightForeground();
        objectArray[90] = "TextPane.editBackground";
        objectArray[91] = FrogLookAndFeel.getEditBackground();
        objectArray[92] = "TextPane.editForeground";
        objectArray[93] = FrogLookAndFeel.getEditForeground();
        objectArray[94] = "TextPane.readOnlyBackground";
        objectArray[95] = FrogLookAndFeel.getReadOnlyBackground();
        objectArray[96] = "TextPane.readOnlyForeground";
        objectArray[97] = FrogLookAndFeel.getReadOnlyForeground();
        objectArray[98] = "TextPane.editProtectedForeground";
        objectArray[99] = FrogLookAndFeel.getEditProtectedForeground();
        objectArray[100] = "TextPane.readOnlyProtectedForeground";
        objectArray[101] = FrogLookAndFeel.getReadOnlyProtectedForeground();
        objectArray[102] = "CalendarControl.colorHighlight1";
        objectArray[103] = FrogLookAndFeel.getColorHighlight1();
        objectArray[104] = "CalendarControl.colorHighlight2";
        objectArray[105] = FrogLookAndFeel.getColorHighlight2();
        objectArray[106] = "CalendarControl.colorHighlight3";
        objectArray[107] = FrogLookAndFeel.getColorHighlight3();
        objectArray[108] = "CalendarControl.colorHighlight4";
        objectArray[109] = FrogLookAndFeel.getColorHighlight4();
        objectArray[110] = "CalendarControl.colorHighlight5";
        objectArray[111] = FrogLookAndFeel.getColorHighlight5();
        objectArray[112] = "CalendarControl.colorHighlight6";
        objectArray[113] = FrogLookAndFeel.getColorHighlight6();
        objectArray[114] = "CalendarControl.colorHighlight7";
        objectArray[115] = FrogLookAndFeel.getColorHighlight7();
        objectArray[116] = "CalendarControl.colorHighlight8";
        objectArray[117] = FrogLookAndFeel.getColorHighlight8();
        objectArray[118] = "CalendarControl.colorWeekend";
        objectArray[119] = FrogLookAndFeel.getColorWeekend();
        objectArray[120] = "CalendarControl.colorWeekendHighlight";
        objectArray[121] = FrogLookAndFeel.getColorWeekendHighlight();
        objectArray[122] = "CalendarControl.colorCellBackgroundDark";
        objectArray[123] = FrogLookAndFeel.getColorCellBackgroundDark();
        objectArray[124] = "CalendarControl.colorCellBackgroundLight";
        objectArray[125] = FrogLookAndFeel.getColorCellBackgroundLight();
        objectArray[126] = "CalendarControl.colorFocus";
        objectArray[127] = FrogLookAndFeel.getColorFocus();
        objectArray[128] = "DateNavigator.calendarFont";
        objectArray[129] = FrogLookAndFeel.getLabelSmallFont();
        objectArray[130] = "EditorPane.selectionBackground";
        objectArray[131] = table.get("textHighlight");
        objectArray[132] = "EditorPane.selectionForeground";
        objectArray[133] = table.get("textHighlightText");
        objectArray[134] = "EditorPane.background";
        objectArray[135] = table.get("window");
        objectArray[136] = "EditorPane.foreground";
        objectArray[137] = table.get("textText");
        objectArray[138] = "EditorPane.font";
        objectArray[139] = FrogLookAndFeel.getUserTextFont();
        objectArray[140] = "EditorPane.caretForeground";
        objectArray[141] = FrogLookAndFeel.getUserTextColor();
        objectArray[142] = "TextField.keyBindings";
        objectArray[143] = fieldBindings;
        objectArray[144] = "PasswordField.keyBindings";
        objectArray[145] = fieldBindings;
        objectArray[146] = "TextArea.keyBindings";
        objectArray[147] = multilineBindings;
        objectArray[148] = "TextPane.keyBindings";
        objectArray[149] = multilineBindings;
        objectArray[150] = "EditorPane.keyBindings";
        objectArray[151] = multilineBindings;
        objectArray[152] = "TextField.focusInputMap";
        objectArray[153] = fieldBindings;
        objectArray[154] = "PasswordField.focusInputMap";
        objectArray[155] = fieldBindings;
        objectArray[156] = "TextArea.focusInputMap";
        objectArray[157] = multilineBindings;
        objectArray[158] = "TextPane.focusInputMap";
        objectArray[159] = multilineBindings;
        objectArray[160] = "EditorPane.focusInputMap";
        objectArray[161] = multilineBindings;
        objectArray[162] = "Button.Border";
        objectArray[163] = new FrogBorders.ButtonBorder();
        objectArray[164] = "Button.foreground";
        objectArray[165] = FrogLookAndFeel.getControlTextColor();
        objectArray[166] = "Button.disabledText";
        objectArray[167] = FrogLookAndFeel.getInactiveControlTextColor();
        objectArray[168] = "Button.select";
        objectArray[169] = FrogLookAndFeel.getControlShadow();
        objectArray[170] = "Button.border";
        objectArray[171] = buttonBorder;
        objectArray[172] = "Button.borderWidth";
        objectArray[173] = new Integer(6);
        objectArray[174] = "Button.font";
        objectArray[175] = FrogLookAndFeel.getControlTextFont();
        objectArray[176] = "Button.focus";
        objectArray[177] = FrogLookAndFeel.getFocusColor();
        objectArray[178] = "Button.defaultBorderColor";
        objectArray[179] = new ColorUIResource(Color.black);
        objectArray[180] = "Button.defaultButtonInsets";
        objectArray[181] = new InsetsUIResource(1, 1, 1, 1);
        objectArray[182] = "CheckBox.foreground";
        objectArray[183] = FrogLookAndFeel.getControlTextColor();
        objectArray[184] = "CheckBox.disabledText";
        objectArray[185] = FrogLookAndFeel.getInactiveControlTextColor();
        objectArray[186] = "Checkbox.select";
        objectArray[187] = FrogLookAndFeel.getControlShadow();
        objectArray[188] = "CheckBox.font";
        objectArray[189] = FrogLookAndFeel.getControlTextFont();
        objectArray[190] = "CheckBox.focus";
        objectArray[191] = FrogLookAndFeel.getFocusColor();
        objectArray[192] = "CheckBox.borderWidth";
        objectArray[193] = NULL;
        objectArray[194] = "CheckBox.border";
        objectArray[195] = new FrogBorders.LabelFocusBorder();
        objectArray[196] = "RadioButton.background";
        objectArray[197] = FrogLookAndFeel.getControl();
        objectArray[198] = "RadioButton.border";
        objectArray[199] = new FrogBorders.LabelFocusBorder();
        objectArray[200] = "RadioButton.foreground";
        objectArray[201] = FrogLookAndFeel.getControlTextColor();
        objectArray[202] = "RadioButton.disabledText";
        objectArray[203] = FrogLookAndFeel.getInactiveControlTextColor();
        objectArray[204] = "RadioButton.select";
        objectArray[205] = FrogLookAndFeel.getControlShadow();
        objectArray[206] = "RadioButton.font";
        objectArray[207] = FrogLookAndFeel.getControlTextFont();
        objectArray[208] = "RadioButton.borderWidth";
        objectArray[209] = NULL;
        objectArray[210] = "RadioButton.focus";
        objectArray[211] = FrogLookAndFeel.getFocusColor();
        objectArray[212] = "ToggleButton.background";
        objectArray[213] = FrogLookAndFeel.getControl();
        objectArray[214] = "ToggleButton.foreground";
        objectArray[215] = FrogLookAndFeel.getControlTextColor();
        objectArray[216] = "ToggleButton.select";
        objectArray[217] = FrogLookAndFeel.getControlShadow();
        objectArray[218] = "ToggleButton.text";
        objectArray[219] = FrogLookAndFeel.getControl();
        objectArray[220] = "ToggleButton.disabledText";
        objectArray[221] = FrogLookAndFeel.getInactiveControlTextColor();
        objectArray[222] = "ToggleButton.disabledSelectedText";
        objectArray[223] = FrogLookAndFeel.getControlDarkShadow();
        objectArray[224] = "ToggleButton.disabledBackground";
        objectArray[225] = FrogLookAndFeel.getControl();
        objectArray[226] = "ToggleButton.disabledSelectedBackground";
        objectArray[227] = FrogLookAndFeel.getControlShadow();
        objectArray[228] = "ToggleButton.focus";
        objectArray[229] = FrogLookAndFeel.getFocusColor();
        objectArray[230] = "ToggleButton.font";
        objectArray[231] = FrogLookAndFeel.getControlTextFont();
        objectArray[232] = "ToggleButton.borderWidth";
        objectArray[233] = new Integer(6);
        objectArray[234] = "ToggleButton.border";
        objectArray[235] = toggleButtonBorder;
        objectArray[236] = "FileView.directoryIcon";
        objectArray[237] = FrogIconFactory.getTreeFolderIcon(FrogHueShift.getCurrentTheme());
        objectArray[238] = "FileView.fileIcon";
        objectArray[239] = FrogIconFactory.getTreeLeafIcon(FrogHueShift.getCurrentTheme());
        objectArray[240] = "FileView.computerIcon";
        objectArray[241] = FrogIconFactory.getTreeComputerIcon();
        objectArray[242] = "FileView.hardDriveIcon";
        objectArray[243] = FrogIconFactory.getTreeHardDriveIcon();
        objectArray[244] = "FileView.floppyDriveIcon";
        objectArray[245] = FrogIconFactory.getTreeFloppyDriveIcon();
        objectArray[246] = "FileChooser.detailsViewIcon";
        objectArray[247] = FrogIconFactory.getFileChooserDetailViewIcon();
        objectArray[248] = "FileChooser.homeFolderIcon";
        objectArray[249] = FrogIconFactory.getFileChooserHomeFolderIcon();
        objectArray[250] = "FileChooser.listViewIcon";
        objectArray[251] = FrogIconFactory.getFileChooserListViewIcon();
        objectArray[252] = "FileChooser.newFolderIcon";
        objectArray[253] = FrogIconFactory.getFileChooserNewFolderIcon();
        objectArray[254] = "FileChooser.upFolderIcon";
        objectArray[255] = FrogIconFactory.getFileChooserUpFolderIcon();
        objectArray[256] = "FileChooser.lookInLabelMnemonic";
        objectArray[257] = new Integer(73);
        objectArray[258] = "FileChooser.fileNameLabelMnemonic";
        objectArray[259] = new Integer(78);
        objectArray[260] = "FileChooser.filesOfTypeLabelMnemonic";
        objectArray[261] = new Integer(84);
        objectArray[262] = "ToolTip.font";
        objectArray[263] = FrogLookAndFeel.getSystemTextFont();
        objectArray[264] = "ToolTip.border";
        objectArray[265] = toolTipBorder;
        objectArray[266] = "ToolTip.background";
        objectArray[267] = table.get("info");
        objectArray[268] = "ToolTip.foreground";
        objectArray[269] = table.get("infoText");
        objectArray[270] = "ToolTip.borderColor";
        objectArray[271] = FrogLookAndFeel.getPrimaryControlDarkShadow();
        objectArray[272] = "Slider.border";
        objectArray[274] = "Slider.foreground";
        objectArray[275] = FrogLookAndFeel.getPrimaryControlShadow();
        objectArray[276] = "Slider.focus";
        objectArray[277] = FrogLookAndFeel.getFocusColor();
        objectArray[278] = "Slider.focusInsets";
        objectArray[279] = sliderFocusInsets;
        objectArray[280] = "Slider.trackWidth";
        objectArray[281] = new Integer(7);
        objectArray[282] = "Slider.majorTickLength";
        objectArray[283] = new Integer(6);
        objectArray[284] = "Slider.thumb";
        objectArray[285] = FrogLookAndFeel.getControl();
        objectArray[286] = "Slider.highlight";
        objectArray[287] = FrogLookAndFeel.getControl();
        objectArray[288] = "Slider.darkShadow";
        objectArray[289] = FrogLookAndFeel.getControlDarkShadow();
        objectArray[290] = "ProgressBar.font";
        objectArray[291] = FrogLookAndFeel.getControlTextFont();
        objectArray[292] = "ProgressBar.foreground";
        objectArray[293] = FrogLookAndFeel.getFocusColor();
        objectArray[294] = "ProgressBar.background";
        objectArray[295] = FrogLookAndFeel.getControl();
        objectArray[296] = "ProgressBar.foregroundHighlight";
        objectArray[297] = FrogLookAndFeel.getPrimaryControlShadow();
        objectArray[298] = "ProgressBar.backgroundHighlight";
        objectArray[299] = FrogLookAndFeel.getControl();
        objectArray[300] = "ProgressBar.selectionForeground";
        objectArray[301] = FrogLookAndFeel.getControl();
        objectArray[302] = "ProgressBar.selectionBackground";
        objectArray[303] = FrogLookAndFeel.getPrimaryControlDarkShadow();
        objectArray[304] = "ProgressBar.border";
        objectArray[305] = progressBarBorder;
        objectArray[306] = "ProgressBar.cellSpacing";
        objectArray[307] = new Integer(0);
        objectArray[308] = "ProgressBar.cellLength";
        objectArray[309] = new Integer(1);
        objectArray[310] = "ComboBox.border";
        objectArray[311] = textFieldBorder;
        objectArray[312] = "ComboBox.background";
        objectArray[313] = table.get("textActive");
        objectArray[314] = "ComboBox.foreground";
        objectArray[315] = table.get("controlText");
        objectArray[316] = "ComboBox.selectionBackground";
        objectArray[317] = table.get("textHighlight");
        objectArray[318] = "ComboBox.selectionForeground";
        objectArray[319] = table.get("textHighlightText");
        objectArray[320] = "ComboBox.listBackground";
        objectArray[321] = table.get("textActive");
        objectArray[322] = "ComboBox.listForeground";
        objectArray[323] = FrogLookAndFeel.getControlTextColor();
        objectArray[324] = "ComboBox.font";
        objectArray[325] = FrogLookAndFeel.getControlTextFont();
        objectArray[326] = "ComboBox.maxPopupWidth";
        objectArray[327] = new Integer(310);
        objectArray[328] = "ComboBox.maximumRowCount";
        objectArray[329] = new Integer(9);
        objectArray[330] = "ComboBoxRenderer.border";
        objectArray[331] = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        objectArray[332] = "InternalFrame.icon";
        objectArray[333] = FrogIconFactory.getInternalFrameDefaultMenuIcon();
        objectArray[334] = "InternalFrame.border";
        objectArray[335] = new FrogBorders.InternalFrameBorder();
        objectArray[336] = "InternalFrame.paletteBorder";
        objectArray[337] = new FrogBorders.PaletteBorder();
        objectArray[338] = "InternalFrame.paletteTitleHeight";
        objectArray[339] = new Integer(11);
        objectArray[340] = "InternalFrame.paletteCloseIcon";
        objectArray[341] = new FrogIconFactory.PaletteCloseIcon();
        objectArray[342] = "InternalFrame.closeIcon";
        objectArray[343] = FrogIconFactory.getInternalFrameCloseIcon(internalFrameIconSize);
        objectArray[344] = "InternalFrame.maximizeIcon";
        objectArray[345] = FrogIconFactory.getInternalFrameMaximizeIcon(internalFrameIconSize);
        objectArray[346] = "InternalFrame.iconizeIcon";
        objectArray[347] = FrogIconFactory.getInternalFrameMinimizeIcon(internalFrameIconSize);
        objectArray[348] = "InternalFrame.minimizeIcon";
        objectArray[349] = FrogIconFactory.getInternalFrameAltMaximizeIcon(internalFrameIconSize);
        objectArray[350] = "InternalFrame.font";
        objectArray[351] = FrogLookAndFeel.getWindowTitleFont();
        objectArray[352] = "DesktopIcon.border";
        objectArray[353] = desktopIconBorder;
        objectArray[354] = "DesktopIcon.font";
        objectArray[355] = FrogLookAndFeel.getControlTextFont();
        objectArray[356] = "DesktopIcon.foreground";
        objectArray[357] = FrogLookAndFeel.getControlTextColor();
        objectArray[358] = "DesktopIcon.background";
        objectArray[359] = FrogLookAndFeel.getControl();
        objectArray[360] = "TitledBorder.font";
        objectArray[361] = FrogLookAndFeel.getControlTextFont();
        objectArray[362] = "TitledBorder.titleColor";
        objectArray[363] = FrogLookAndFeel.getSystemTextColor();
        objectArray[364] = "TitledBorder.border";
        objectArray[365] = titledBorderBorder;
        objectArray[366] = "Label.font";
        objectArray[367] = FrogLookAndFeel.getControlTextFont();
        objectArray[368] = "Label.fontBold";
        objectArray[369] = FrogLookAndFeel.getControlTextFontBold();
        objectArray[370] = "Label.background";
        objectArray[371] = table.get("control");
        objectArray[372] = "Label.foreground";
        objectArray[373] = FrogLookAndFeel.getSystemTextColor();
        objectArray[374] = "Label.disabledForeground";
        objectArray[375] = FrogLookAndFeel.getInactiveSystemTextColor();
        objectArray[376] = "SAPLabel.Border";
        objectArray[377] = new FrogBorders.LabelFocusBorder();
        objectArray[378] = "List.focusCellHighlightBorder";
        objectArray[379] = focusCellHighlightBorder;
        objectArray[380] = "List.font";
        objectArray[381] = FrogLookAndFeel.getUserTextFont();
        objectArray[382] = "OptionPane.background";
        objectArray[383] = table.get("control");
        objectArray[384] = "ScrollBar.background";
        objectArray[385] = FrogLookAndFeel.getControl();
        objectArray[386] = "ScrollBar.highlight";
        objectArray[387] = FrogLookAndFeel.getControlHighlight();
        objectArray[388] = "ScrollBar.shadow";
        objectArray[389] = FrogLookAndFeel.getControlShadow();
        objectArray[390] = "ScrollBar.darkShadow";
        objectArray[391] = FrogLookAndFeel.getControlDarkShadow();
        objectArray[392] = "ScrollBar.thumb";
        objectArray[393] = FrogLookAndFeel.getPrimaryControlShadow();
        objectArray[394] = "ScrollBar.thumbShadow";
        objectArray[395] = FrogLookAndFeel.getPrimaryControlDarkShadow();
        objectArray[396] = "ScrollBar.thumbHighlight";
        objectArray[397] = FrogLookAndFeel.getPrimaryControl();
        objectArray[398] = "ScrollBar.width";
        objectArray[399] = new Integer(19);
        objectArray[400] = "ScrollPane.border";
        objectArray[401] = scrollPaneBorder;
        objectArray[402] = "ScrollPane.borderColor";
        objectArray[403] = FrogLookAndFeel.getScrollPaneBorderColor();
        objectArray[404] = "TabbedPane.font";
        objectArray[405] = FrogLookAndFeel.getControlTextFont();
        objectArray[406] = "TabbedPane.background";
        objectArray[407] = FrogLookAndFeel.getControlShadow();
        objectArray[408] = "TabbedPane.foreground";
        objectArray[409] = FrogLookAndFeel.getControlTextColor();
        objectArray[410] = "TabbedPane.highlight";
        objectArray[411] = FrogLookAndFeel.getControl();
        objectArray[412] = "TabbedPane.lightHighlight";
        objectArray[413] = FrogLookAndFeel.getControlHighlight();
        objectArray[414] = "TabbedPane.darkShadow";
        objectArray[415] = FrogLookAndFeel.getControlDarkShadow();
        objectArray[416] = "TabbedPane.focus";
        objectArray[417] = FrogLookAndFeel.getPrimaryControlDarkShadow();
        objectArray[418] = "TabbedPane.selected";
        objectArray[419] = FrogLookAndFeel.getControl();
        objectArray[420] = "TabbedPane.selectHighlight";
        objectArray[421] = FrogLookAndFeel.getControlHighlight();
        objectArray[422] = "TabbedPane.tabAreaInsets";
        objectArray[423] = tabbedPaneTabAreaInsets;
        objectArray[424] = "TabbedPane.primaryTabBackground";
        objectArray[425] = FrogLookAndFeel.getPrimaryTabBackground();
        objectArray[426] = "TabbedPane.secondaryTabBackground";
        objectArray[427] = FrogLookAndFeel.getSecondaryTabBackground();
        objectArray[428] = "TabbedPane.maxRowsForTabList";
        objectArray[429] = new Integer(12);
        objectArray[430] = "Table.focusCellHighlightBorder";
        objectArray[431] = focusCellHighlightBorder;
        objectArray[432] = "Table.focusCellBackground";
        objectArray[433] = table.get("window");
        objectArray[434] = "Table.scrollPaneBorder";
        objectArray[435] = scrollPaneBorder;
        objectArray[436] = "Table.gridColor";
        objectArray[437] = FrogLookAndFeel.getTableGridColor();
        objectArray[438] = "Table.font";
        objectArray[439] = FrogLookAndFeel.getUserTextFont();
        objectArray[440] = "TableHeader.cellBorder";
        objectArray[441] = new FrogUtils.TableHeaderBorder();
        objectArray[442] = "Table.border";
        objectArray[443] = tableBorder;
        objectArray[444] = "TableTitle.border";
        objectArray[445] = tableTitleBorder;
        objectArray[446] = "Table.selectionBackground";
        objectArray[447] = table.get("textSelectedInputBackground");
        objectArray[448] = "Table.selectionForeground";
        objectArray[449] = Color.black;
        objectArray[450] = "MenuBar.font";
        objectArray[451] = FrogLookAndFeel.getMenuTextFont();
        objectArray[452] = "MenuBar.foreground";
        objectArray[453] = FrogLookAndFeel.getMenuForeground();
        objectArray[454] = "Menu.border";
        objectArray[455] = menuItemBorder;
        objectArray[456] = "Menu.borderPainted";
        objectArray[457] = Boolean.TRUE;
        objectArray[458] = "Menu.font";
        objectArray[459] = FrogLookAndFeel.getMenuTextFont();
        objectArray[460] = "Menu.acceleratorFont";
        objectArray[461] = FrogLookAndFeel.getSubTextFont();
        objectArray[462] = "Menu.checkIcon";
        objectArray[463] = FrogIconFactory.getMenuItemCheckIcon();
        objectArray[464] = "Menu.arrowIcon";
        objectArray[465] = FrogIconFactory.getMenuArrowIcon();
        objectArray[466] = "Menu.TopMenuselectionBackground";
        objectArray[467] = FrogLookAndFeel.getTopMenuSelectionBackground();
        objectArray[468] = "Menu.TopMenuborder";
        objectArray[469] = topMenuBorder;
        objectArray[470] = "MenuItem.border";
        objectArray[471] = menuItemBorder;
        objectArray[472] = "MenuItem.borderPainted";
        objectArray[473] = Boolean.TRUE;
        objectArray[474] = "MenuItem.font";
        objectArray[475] = FrogLookAndFeel.getMenuTextFont();
        objectArray[476] = "MenuItem.background";
        objectArray[477] = FrogLookAndFeel.getMenuBackground();
        objectArray[478] = "MenuItem.acceleratorFont";
        objectArray[479] = FrogLookAndFeel.getSubTextFont();
        objectArray[480] = "MenuItem.checkIcon";
        objectArray[481] = FrogIconFactory.getMenuItemCheckIcon();
        objectArray[482] = "MenuItem.arrowIcon";
        objectArray[483] = FrogIconFactory.getMenuItemArrowIcon();
        objectArray[484] = "Separator.background";
        objectArray[485] = FrogLookAndFeel.getSeparatorBackground();
        objectArray[486] = "Separator.foreground";
        objectArray[487] = FrogLookAndFeel.getSeparatorForeground();
        objectArray[488] = "PopupMenu.background";
        objectArray[489] = FrogLookAndFeel.getPopupMenuBackground();
        objectArray[490] = "PopupMenu.dockedBorder";
        objectArray[491] = popupMenuDockedBorder;
        objectArray[492] = "PopupMenu.undockedBorder";
        objectArray[493] = popupMenuUndockedBorder;
        objectArray[494] = "CheckBoxMenuItem.border";
        objectArray[495] = menuItemBorder;
        objectArray[496] = "CheckBoxMenuItem.borderPainted";
        objectArray[497] = Boolean.TRUE;
        objectArray[498] = "CheckBoxMenuItem.font";
        objectArray[499] = FrogLookAndFeel.getMenuTextFont();
        objectArray[500] = "CheckBoxMenuItem.foreground";
        objectArray[501] = FrogLookAndFeel.getMenuForeground();
        objectArray[502] = "CheckBoxMenuItem.background";
        objectArray[503] = FrogLookAndFeel.getMenuBackground();
        objectArray[504] = "CheckBoxMenuItem.selectionForeground";
        objectArray[505] = FrogLookAndFeel.getMenuSelectedForeground();
        objectArray[506] = "CheckBoxMenuItem.acceleratorFont";
        objectArray[507] = FrogLookAndFeel.getSubTextFont();
        objectArray[508] = "CheckBoxMenuItem.acceleratorForeground";
        objectArray[509] = FrogLookAndFeel.getAcceleratorForeground();
        objectArray[510] = "CheckBoxMenuItem.acceleratorSelectionForeground";
        objectArray[511] = FrogLookAndFeel.getAcceleratorSelectedForeground();
        objectArray[512] = "CheckBoxMenuItem.checkIcon";
        objectArray[513] = FrogIconFactory.getCheckBoxMenuItemIcon();
        objectArray[514] = "CheckBoxMenuItem.arrowIcon";
        objectArray[515] = FrogIconFactory.getMenuItemArrowIcon();
        objectArray[516] = "RadioButtonMenuItem.border";
        objectArray[517] = menuItemBorder;
        objectArray[518] = "RadioButtonMenuItem.borderPainted";
        objectArray[519] = Boolean.TRUE;
        objectArray[520] = "RadioButtonMenuItem.font";
        objectArray[521] = FrogLookAndFeel.getMenuTextFont();
        objectArray[522] = "RadioButtonMenuItem.foreground";
        objectArray[523] = FrogLookAndFeel.getMenuForeground();
        objectArray[524] = "RadioButtonMenuItem.background";
        objectArray[525] = FrogLookAndFeel.getMenuBackground();
        objectArray[526] = "RadioButtonMenuItem.selectionForeground";
        objectArray[527] = FrogLookAndFeel.getMenuSelectedForeground();
        objectArray[528] = "RadioButtonMenuItem.acceleratorFont";
        objectArray[529] = FrogLookAndFeel.getSubTextFont();
        objectArray[530] = "RadioButtonMenuItem.acceleratorForeground";
        objectArray[531] = FrogLookAndFeel.getAcceleratorForeground();
        objectArray[532] = "RadioButtonMenuItem.acceleratorSelectionForeground";
        objectArray[533] = FrogLookAndFeel.getAcceleratorSelectedForeground();
        objectArray[534] = "RadioButtonMenuItem.checkIcon";
        objectArray[535] = FrogIconFactory.getRadioButtonMenuItemIcon();
        objectArray[536] = "RadioButtonMenuItem.arrowIcon";
        objectArray[537] = FrogIconFactory.getMenuItemArrowIcon();
        objectArray[538] = "SplitPane.border";
        objectArray[540] = "SplitPane.dividerSize";
        objectArray[541] = new Integer(3);
        objectArray[542] = "SplitPane.background";
        objectArray[543] = FrogLookAndFeel.getControlShadow();
        objectArray[544] = "Tree.background";
        objectArray[545] = FrogLookAndFeel.getTreeBackground1();
        objectArray[546] = "Tree.background1";
        objectArray[547] = FrogLookAndFeel.getTreeBackground1();
        objectArray[548] = "Tree.background2";
        objectArray[549] = FrogLookAndFeel.getTreeBackground2();
        objectArray[550] = "Tree.background3";
        objectArray[551] = FrogLookAndFeel.getTreeBackground3();
        objectArray[552] = "Tree.background4";
        objectArray[553] = FrogLookAndFeel.getTreeBackground4();
        objectArray[554] = "Tree.intensifiedForeground";
        objectArray[555] = FrogLookAndFeel.getTreeIntensifiedForeground();
        objectArray[556] = "Tree.inactiveForeground";
        objectArray[557] = FrogLookAndFeel.getTreeInactiveForeground();
        objectArray[558] = "Tree.intensifiedCriticalBackground";
        objectArray[559] = FrogLookAndFeel.getTreeIntensifiedCriticalBackground();
        objectArray[560] = "Tree.emphasizedNegativeBackground";
        objectArray[561] = FrogLookAndFeel.getTreeEmphasizedNegativeBackground();
        objectArray[562] = "Tree.emphasizedPositiveBackground";
        objectArray[563] = FrogLookAndFeel.getTreeEmphasizedPositiveBackground();
        objectArray[564] = "Tree.emphasizedBackground";
        objectArray[565] = FrogLookAndFeel.getTreeEmphasizedBackground();
        objectArray[566] = "Tree.shadowLine0";
        objectArray[567] = FrogLookAndFeel.getTreeShadowLine0();
        objectArray[568] = "Tree.highlightLine0";
        objectArray[569] = FrogLookAndFeel.getTreeHighlightLine0();
        objectArray[570] = "Tree.shadowLine1";
        objectArray[571] = FrogLookAndFeel.getTreeShadowLine1();
        objectArray[572] = "Tree.highlightLine1";
        objectArray[573] = FrogLookAndFeel.getTreeHighlightLine1();
        objectArray[574] = "Tree.shadowLineDefault";
        objectArray[575] = FrogLookAndFeel.getTreeShadowLineDef();
        objectArray[576] = "Tree.highlightLineDefault";
        objectArray[577] = FrogLookAndFeel.getTreeHighlightLineDef();
        objectArray[578] = "Tree.font";
        objectArray[579] = FrogLookAndFeel.getSystemTextFont();
        objectArray[580] = "Tree.textForeground";
        objectArray[581] = table.get("textText");
        objectArray[582] = "Tree.textBackground";
        objectArray[583] = FrogLookAndFeel.getTreeBackground1();
        objectArray[584] = "Tree.selectionForeground";
        objectArray[585] = table.get("textText");
        objectArray[586] = "Tree.selectionBackground";
        objectArray[587] = table.get("textSelectedInputBackground");
        objectArray[588] = "Tree.selectionBorderColor";
        objectArray[589] = FrogLookAndFeel.getFocusColor();
        objectArray[590] = "Tree.line";
        objectArray[591] = FrogLookAndFeel.getPrimaryControl();
        objectArray[592] = "Tree.hash";
        objectArray[593] = FrogLookAndFeel.getPrimaryControlShadow();
        objectArray[594] = "Tree.rowHeight";
        objectArray[595] = new Integer(0);
        objectArray[596] = "Tree.borderLeftUpColor";
        objectArray[597] = FrogLookAndFeel.getTreeBorderLeftUpColor();
        objectArray[598] = "Tree.borderRightDownColor";
        objectArray[599] = FrogLookAndFeel.getTreeBorderRightDownColor();
        objectArray[600] = "Tree.columnDivider";
        objectArray[601] = FrogLookAndFeel.getTreeColumnDividerColor();
        objectArray[602] = "Tree.defaultExpandedIcon";
        objectArray[603] = FrogIconFactory.getDefaultTreeIcon();
        objectArray[604] = "Tree.defaultCollapsedIcon";
        objectArray[605] = FrogIconFactory.getDefaultTreeIcon();
        objectArray[606] = "Tree.synchronizeNodeIndents";
        objectArray[607] = Boolean.FALSE;
        objectArray[608] = "ToolBar.font";
        objectArray[609] = FrogLookAndFeel.getMenuTextFont();
        objectArray[610] = "ToolBar.dockingForeground";
        objectArray[611] = FrogLookAndFeel.getPrimaryControlDarkShadow();
        objectArray[612] = "ToolBar.floatingForeground";
        objectArray[613] = FrogLookAndFeel.getPrimaryControl();
        objectArray[614] = "ToolBar.controlbackground";
        objectArray[615] = new ColorUIResource(FrogLookAndFeel.getToolbarControlBackground());
        objectArray[616] = "ToolBar.controlborder";
        objectArray[617] = toolBarControlBorder;
        objectArray[618] = "ToolBar.applicationbackground";
        objectArray[619] = FrogLookAndFeel.getApplicationToolbarBackground();
        objectArray[620] = "Toolbar.invisibleComponentList";
        objectArray[621] = invisibleComponentList;
        objectArray[622] = "Panel.okCodeField.Border";
        objectArray[623] = okCodeFieldBorder;
        objectArray[624] = "Panel.okCodeField.TextBorder";
        objectArray[625] = textFieldBorder;
        objectArray[626] = "Panel.okCodeField.TextBackground";
        objectArray[627] = FrogLookAndFeel.getEnabledTextBackground();
        objectArray[628] = "Panel.okCodeField.Font";
        objectArray[629] = FrogLookAndFeel.getOKCodeFieldFont();
        objectArray[630] = "TitleBar.titleborder";
        objectArray[631] = titleBarBorder;
        objectArray[632] = "TitleBar.background";
        objectArray[633] = new ColorUIResource(Color.white);
        objectArray[634] = "StatusBar.textfieldBorder";
        objectArray[635] = statusTextFieldBorder;
        objectArray[636] = "StatusBar.systemInfoBorder";
        objectArray[637] = systemInfoBorder;
        objectArray[638] = "StatusBar.pcInfoBorder";
        objectArray[639] = statusPCInfoBorder;
        objectArray[640] = "GroupBox.border";
        objectArray[641] = groupBoxBorder;
        Object[] defaults = objectArray;
        table.putDefaults(defaults);
        this.initCustomDefaults();
        this.getFonts();
    }

    protected void initCustomDefaults() {
        UIManager.put("Tree.expandedIcon", FrogIconFactory.getDefaultTreeIcon());
        UIManager.put("Tree.collapsedIcon", FrogIconFactory.getDefaultTreeIcon());
    }

    protected void getFonts() {
        Font propFont = FontInfo.getDefaultFont(0);
        Font fixedFont = FontInfo.getDefaultFont(1);
        Font labelFont = FontInfo.getDefaultFont(2);
        FontInfo.updateFonts(labelFont, propFont, fixedFont);
    }

    protected void createDefaultTheme() {
        FrogGIFReader.getImage(null, "file://./sapctree.bmp");
        FrogGIFReader.getImage(null, "file://./sapfront.bmp");
        if (currentTheme == null) {
            currentTheme = new DefaultFrogTheme();
            MetalLookAndFeel.setCurrentTheme(currentTheme);
        }
    }

    public UIDefaults getDefaults() {
        this.mHueShift = new FrogHueShift();
        new SystemHueShift();
        this.createDefaultTheme();
        UIDefaults table = super.getDefaults();
        table.put("HueShiftObject", this.mHueShift);
        currentTheme.addCustomEntriesToTable(table);
        FrogLookAndFeel.getInstance().initThemeSpecificDefaults(FrogHueShift.getCurrentTheme(), table);
        return table;
    }

    public static void setCurrentTheme(FrogTheme theme) {
        if (theme == null) {
            throw new NullPointerException("Can't have null theme");
        }
        currentTheme = theme;
    }

    protected static DynamicColorUIResource updateDynamicColor(String name, ColorUIResource color) {
        Object dynamicColor = UIManager.get(name);
        if (dynamicColor != null && dynamicColor instanceof DynamicColorUIResource) {
            ((DynamicColorUIResource)dynamicColor).setResource(color);
        } else {
            dynamicColor = new DynamicColorUIResource(color);
        }
        return (DynamicColorUIResource)dynamicColor;
    }

    public static void putDynamicColor(UIDefaults propertyTable, String name, ColorUIResource color) {
        if (propertyTable == null || name == null || color == null) {
            return;
        }
        propertyTable.put(name, FrogLookAndFeel.updateDynamicColor(name, color));
    }

    public static FontUIResource getEmphasizedFont() {
        return currentTheme.getEmphasizedFont();
    }

    public static FontUIResource getHeader1Font() {
        return currentTheme.getHeader1Font();
    }

    public static FontUIResource getHeader2Font() {
        return currentTheme.getHeader2Font();
    }

    public static FontUIResource getHeader3Font() {
        return currentTheme.getHeader3Font();
    }

    public static FontUIResource getHeader4Font() {
        return currentTheme.getHeader4Font();
    }

    public static FontUIResource getLabelFont() {
        return currentTheme.getLabelFont();
    }

    public static FontUIResource getLabelSmallFont() {
        return currentTheme.getLabelSmallFont();
    }

    public static FontUIResource getLegendFont() {
        return currentTheme.getLegendFont();
    }

    public static FontUIResource getStandardFont() {
        return currentTheme.getStandardFont();
    }

    public static FontUIResource getMonospaceFont() {
        return currentTheme.getMonospaceFont();
    }

    public static FontUIResource getReferenceFont() {
        return currentTheme.getReferenceFont();
    }

    public static FontUIResource getControlTextFont() {
        return currentTheme.getControlTextFont();
    }

    public static FontUIResource getControlTextFontBold() {
        return currentTheme.getControlTextFontBold();
    }

    public static FontUIResource getSystemTextFont() {
        return currentTheme.getSystemTextFont();
    }

    public static FontUIResource getUserTextFont() {
        return currentTheme.getUserTextFont();
    }

    public static FontUIResource getMenuTextFont() {
        return currentTheme.getMenuTextFont();
    }

    public static FontUIResource getWindowTitleFont() {
        return currentTheme.getWindowTitleFont();
    }

    public static FontUIResource getSubTextFont() {
        return currentTheme.getSubTextFont();
    }

    public static ColorUIResource getDesktopColor() {
        return currentTheme.getDesktopColor();
    }

    public static ColorUIResource getFocusColor() {
        return currentTheme.getFocusColor();
    }

    public static ColorUIResource getWhite() {
        return currentTheme.getWhite();
    }

    public static ColorUIResource getBlack() {
        return currentTheme.getBlack();
    }

    public static ColorUIResource getControl() {
        return currentTheme.getControl();
    }

    public static ColorUIResource getControl(HueShiftTheme theme) {
        return currentTheme.getControl(theme);
    }

    public static ColorUIResource getControlShadow() {
        return currentTheme.getControlShadow();
    }

    public static ColorUIResource getControlDarkShadow() {
        return currentTheme.getControlDarkShadow();
    }

    public static ColorUIResource getControlInfo() {
        return currentTheme.getControlInfo();
    }

    public static ColorUIResource getControlHighlight() {
        return currentTheme.getControlHighlight();
    }

    public static ColorUIResource getControlDisabled() {
        return currentTheme.getControlDisabled();
    }

    public static ColorUIResource getPrimaryControl() {
        return currentTheme.getPrimaryControl();
    }

    public static ColorUIResource getPrimaryControlShadow() {
        return currentTheme.getPrimaryControlShadow();
    }

    public static ColorUIResource getPrimaryControlDarkShadow() {
        return currentTheme.getPrimaryControlDarkShadow();
    }

    public static ColorUIResource getPrimaryControlInfo() {
        return currentTheme.getPrimaryControlInfo();
    }

    public static ColorUIResource getPrimaryControlHighlight() {
        return currentTheme.getPrimaryControlHighlight();
    }

    public static ColorUIResource getSystemTextColor() {
        return currentTheme.getSystemTextColor();
    }

    public static ColorUIResource getControlTextColor() {
        return currentTheme.getControlTextColor();
    }

    public static ColorUIResource getInactiveControlTextColor() {
        return currentTheme.getInactiveControlTextColor();
    }

    public static ColorUIResource getInactiveSystemTextColor() {
        return currentTheme.getInactiveSystemTextColor();
    }

    public static ColorUIResource getUserTextColor() {
        return currentTheme.getUserTextColor();
    }

    public static ColorUIResource getTextHighlightColor() {
        return currentTheme.getTextHighlightColor();
    }

    public static ColorUIResource getHighlightedTextColor() {
        return currentTheme.getHighlightedTextColor();
    }

    public static ColorUIResource getWindowBackground() {
        return currentTheme.getWindowBackground();
    }

    public static ColorUIResource getWindowTitleBackground() {
        return currentTheme.getWindowTitleBackground();
    }

    public static ColorUIResource getWindowTitleForeground() {
        return currentTheme.getWindowTitleForeground();
    }

    public static ColorUIResource getWindowTitleInactiveBackground() {
        return currentTheme.getWindowTitleInactiveBackground();
    }

    public static ColorUIResource getWindowTitleInactiveForeground() {
        return currentTheme.getWindowTitleInactiveForeground();
    }

    public static ColorUIResource getMenuBackground() {
        return currentTheme.getMenuBackground();
    }

    public static ColorUIResource getMenuForeground() {
        return currentTheme.getMenuForeground();
    }

    public static ColorUIResource getMenuSelectedBackground(HueShiftTheme theme) {
        return currentTheme.getMenuSelectedBackground(theme);
    }

    public static ColorUIResource getMenuSelectedForeground() {
        return currentTheme.getMenuSelectedForeground();
    }

    public static ColorUIResource getMenuDisabledForeground(HueShiftTheme theme) {
        return currentTheme.getMenuDisabledForeground(theme);
    }

    public static ColorUIResource getSeparatorBackground() {
        return currentTheme.getSeparatorBackground();
    }

    public static ColorUIResource getSeparatorForeground() {
        return currentTheme.getSeparatorForeground();
    }

    public static ColorUIResource getAcceleratorForeground() {
        return currentTheme.getAcceleratorForeground();
    }

    public static ColorUIResource getAcceleratorSelectedForeground() {
        return currentTheme.getAcceleratorSelectedForeground();
    }

    public static ColorUIResource getFocusEnabledFieldBackground() {
        return currentTheme.getFocusEnabledFieldBackground();
    }

    public static ColorUIResource getRolloverForeground(HueShiftTheme theme) {
        return currentTheme.getRolloverForeground(theme);
    }

    public static ColorUIResource getPopupMenuBackground() {
        return currentTheme.getPopupMenuBackground();
    }

    public static ColorUIResource getTopMenuSelectionBackground() {
        return currentTheme.getTopMenuSelectionBackground();
    }

    public static ColorUIResource getTopMenuSelectionForeground(HueShiftTheme theme) {
        return currentTheme.getTopMenuSelectionForeground(theme);
    }

    public static ColorUIResource getTopMenuBackground(HueShiftTheme theme) {
        return currentTheme.getTopMenuBackground(theme);
    }

    public static ColorUIResource getTopMenuForeground(HueShiftTheme theme) {
        return currentTheme.getTopMenuForeground(theme);
    }

    public static ColorUIResource getEnabledTextBackground() {
        return currentTheme.getEnabledTextBackground();
    }

    public static ColorUIResource getSelectedInputBackground() {
        return currentTheme.getSelectedInputBackground();
    }

    public static ColorUIResource getSelectedOutputBackground() {
        return currentTheme.getSelectedOutputBackground();
    }

    public static ColorUIResource getOutputIntForeground() {
        return currentTheme.getOutputIntForeground();
    }

    public static ColorUIResource getSelectedInputForeground() {
        return currentTheme.getSelectedInputForeground();
    }

    public static ColorUIResource getOutputBackground() {
        return currentTheme.getOutputBackground();
    }

    public static ColorUIResource getUserAreaBackground() {
        return currentTheme.getUserAreaBackground();
    }

    public static ColorUIResource getFrameBackground() {
        return currentTheme.getFrameBackground();
    }

    public static ColorUIResource getTreeBackground1() {
        return currentTheme.getTreeBackground1();
    }

    public static ColorUIResource getTreeBackground2() {
        return currentTheme.getTreeBackground2();
    }

    public static ColorUIResource getTreeBackground3() {
        return currentTheme.getTreeBackground3();
    }

    public static ColorUIResource getTreeBackground4() {
        return currentTheme.getTreeBackground4();
    }

    public static ColorUIResource getTreeSelectionBackground() {
        return currentTheme.getTreeSelectionBackground();
    }

    public static ColorUIResource getTreeIntensifiedForeground() {
        return currentTheme.getTreeIntensifiedForeground();
    }

    public static ColorUIResource getTreeInactiveForeground() {
        return currentTheme.getTreeInactiveForeground();
    }

    public static ColorUIResource getTreeIntensifiedCriticalBackground() {
        return currentTheme.getTreeIntensifiedCriticalBackground();
    }

    public static ColorUIResource getTreeEmphasizedNegativeBackground() {
        return currentTheme.getTreeEmphasizedNegativeBackground();
    }

    public static ColorUIResource getTreeEmphasizedPositiveBackground() {
        return currentTheme.getTreeEmphasizedPositiveBackground();
    }

    public static ColorUIResource getTreeEmphasizedBackground() {
        return currentTheme.getTreeEmphasizedBackground();
    }

    public static ColorUIResource getTreeShadowLine0() {
        return currentTheme.getTreeShadowLine0();
    }

    public static ColorUIResource getTreeHighlightLine0() {
        return currentTheme.getTreeHighlightLine0();
    }

    public static ColorUIResource getTreeShadowLine1() {
        return currentTheme.getTreeShadowLine1();
    }

    public static ColorUIResource getTreeHighlightLine1() {
        return currentTheme.getTreeHighlightLine1();
    }

    public static ColorUIResource getTreeShadowLineDef() {
        return currentTheme.getTreeShadowLineDef();
    }

    public static ColorUIResource getTreeHighlightLineDef() {
        return currentTheme.getTreeHighlightLineDef();
    }

    public static ColorUIResource getTreeBorderLeftUpColor() {
        return currentTheme.getTreeBorderLeftUpColor();
    }

    public static ColorUIResource getTreeBorderRightDownColor() {
        return currentTheme.getTreeBorderRightDownColor();
    }

    public static ColorUIResource getTreeColumnDividerColor() {
        return currentTheme.getTreeColumnDividerColor();
    }

    public static ColorUIResource getBreakpointBackground() {
        return currentTheme.getBreakpointBackground();
    }

    public static ColorUIResource getHighlightForeground() {
        return currentTheme.getHighlightForeground();
    }

    public static ColorUIResource getEditBackground() {
        return currentTheme.getEditBackground();
    }

    public static ColorUIResource getEditForeground() {
        return currentTheme.getEditForeground();
    }

    public static ColorUIResource getReadOnlyBackground() {
        return currentTheme.getReadOnlyBackground();
    }

    public static ColorUIResource getReadOnlyForeground() {
        return currentTheme.getReadOnlyForeground();
    }

    public static FontUIResource getProportionalFont() {
        return currentTheme.getProportionalFont();
    }

    public static FontUIResource getFixedFont() {
        return currentTheme.getFixedFont();
    }

    public static ColorUIResource getEditProtectedForeground() {
        return currentTheme.getEditProtectedForeground();
    }

    public static ColorUIResource getReadOnlyProtectedForeground() {
        return currentTheme.getReadOnlyProtectedForeground();
    }

    public static ColorUIResource getTextFieldOuterBorderColor() {
        return currentTheme.getTextFieldOuterBorderColor();
    }

    public static ColorUIResource getTextFieldInnerBorderColor(HueShiftTheme theme) {
        return currentTheme.getTextFieldInnerBorderColor(theme);
    }

    public static ColorUIResource getInactiveFocusBorderC() {
        return currentTheme.getInactiveFocusBorderC();
    }

    public static ColorUIResource getTextFocusBorderColor() {
        return currentTheme.getTextFocusBorderColor();
    }

    public static ColorUIResource getColorHighlight1() {
        return currentTheme.getColorHighlight1();
    }

    public static ColorUIResource getColorHighlight2() {
        return currentTheme.getColorHighlight2();
    }

    public static ColorUIResource getColorHighlight3() {
        return currentTheme.getColorHighlight3();
    }

    public static ColorUIResource getColorHighlight4() {
        return currentTheme.getColorHighlight4();
    }

    public static ColorUIResource getColorHighlight5() {
        return currentTheme.getColorHighlight5();
    }

    public static ColorUIResource getColorHighlight6() {
        return currentTheme.getColorHighlight6();
    }

    public static ColorUIResource getColorHighlight7() {
        return currentTheme.getColorHighlight7();
    }

    public static ColorUIResource getColorHighlight8() {
        return currentTheme.getColorHighlight8();
    }

    public static ColorUIResource getColorWeekend() {
        return currentTheme.getColorWeekend();
    }

    public static ColorUIResource getColorWeekendHighlight() {
        return currentTheme.getColorWeekendHighlight();
    }

    public static ColorUIResource getColorCellBackgroundDark() {
        return currentTheme.getColorCellBackgroundDark();
    }

    public static ColorUIResource getColorCellBackgroundLight() {
        return currentTheme.getColorCellBackgroundLight();
    }

    public static ColorUIResource getColorFocus() {
        return currentTheme.getColorFocus();
    }

    public static ColorUIResource getPrimaryTabBackground() {
        return currentTheme.getPrimaryTabBackground();
    }

    public static ColorUIResource getSecondaryTabBackground() {
        return currentTheme.getSecondaryTabBackground();
    }

    public static ColorUIResource getPrimaryTabForeground(HueShiftTheme theme) {
        return currentTheme.getPrimaryTabForeground(theme);
    }

    public static ColorUIResource getokCodeFieldBackground(HueShiftTheme theme) {
        return currentTheme.getokCodeFieldBackground(theme);
    }

    public static FontUIResource getOKCodeFieldFont() {
        return currentTheme.getOKCodeFieldFont();
    }

    public static ColorUIResource getTitleBarForeground(HueShiftTheme theme) {
        return currentTheme.getTitleBarForeground(theme);
    }

    public static Color getListColorBackgroundIntensifiedBg() {
        return currentTheme.getListColorBackgroundIntensifiedBg();
    }

    public static Color getListColorBackgroundBg() {
        return currentTheme.getListColorBackgroundBg();
    }

    public static Color getListColorBackgroundInverseBg() {
        return currentTheme.getListColorBackgroundInverseBg();
    }

    public static Color getListColorHeadingIntensifiedBg() {
        return currentTheme.getListColorHeadingIntensifiedBg();
    }

    public static Color getListColorHeadingBg() {
        return currentTheme.getListColorHeadingBg();
    }

    public static Color getListColorHeadingInverseBg() {
        return currentTheme.getListColorHeadingInverseBg();
    }

    public static Color getListColorNormalIntensifiedBg() {
        return currentTheme.getListColorNormalIntensifiedBg();
    }

    public static Color getListColorNormalBg() {
        return currentTheme.getListColorNormalBg();
    }

    public static Color getListColorNormalInverseBg() {
        return currentTheme.getListColorNormalInverseBg();
    }

    public static Color getListColorTotalIntensifiedBg() {
        return currentTheme.getListColorTotalIntensifiedBg();
    }

    public static Color getListColorTotalBg() {
        return currentTheme.getListColorTotalBg();
    }

    public static Color getListColorTotalInverseBg() {
        return currentTheme.getListColorTotalInverseBg();
    }

    public static Color getListColorKeyIntensifiedBg() {
        return currentTheme.getListColorKeyIntensifiedBg();
    }

    public static Color getListColorKeyBg() {
        return currentTheme.getListColorKeyBg();
    }

    public static Color getListColorKeyInverseBg() {
        return currentTheme.getListColorKeyInverseBg();
    }

    public static Color getListColorPositiveIntensifiedBg() {
        return currentTheme.getListColorPositiveIntensifiedBg();
    }

    public static Color getListColorPositiveBg() {
        return currentTheme.getListColorPositiveBg();
    }

    public static Color getListColorPositiveInverseBg() {
        return currentTheme.getListColorPositiveInverseBg();
    }

    public static Color getListColorNegativeIntensifiedBg() {
        return currentTheme.getListColorNegativeIntensifiedBg();
    }

    public static Color getListColorNegativeBg() {
        return currentTheme.getListColorNegativeBg();
    }

    public static Color getListColorNegativeInverseBg() {
        return currentTheme.getListColorNegativeInverseBg();
    }

    public static Color getListColorGroupIntensifiedBg() {
        return currentTheme.getListColorGroupIntensifiedBg();
    }

    public static Color getListColorGroupBg() {
        return currentTheme.getListColorGroupBg();
    }

    public static Color getListColorGroupInverseBg() {
        return currentTheme.getListColorGroupInverseBg();
    }

    public static ColorUIResource getStatusbarBackground(HueShiftTheme theme) {
        return currentTheme.getStatusbarBackground(theme);
    }

    public static ColorUIResource getToolbarBackground(HueShiftTheme theme) {
        return currentTheme.getToolbarBackground(theme);
    }

    public static ColorUIResource getApplicationToolbarBackground() {
        return currentTheme.getApplicationToolbarBackground();
    }

    public static ColorUIResource getToolbarControlBackground() {
        return currentTheme.getToolbarControlBackground();
    }

    public static FontUIResource getTitleBarFont(HueShiftTheme theme) {
        return currentTheme.getTitleBarFont(theme);
    }

    public static ColorUIResource getTableGridColor() {
        return currentTheme.getTableGridColor();
    }

    public static ColorUIResource getToolTipBackground() {
        return currentTheme.getToolTipBackground();
    }

    public static ColorUIResource getGroupBoxBackground() {
        return currentTheme.getGroupBoxBackground();
    }

    public static ColorUIResource getGroupBoxTextBackground() {
        return currentTheme.getGroupBoxTextBackground();
    }

    public static ColorUIResource getGroupBoxTextBorderColor() {
        return currentTheme.getGroupBoxTextBorderColor();
    }

    public static ColorUIResource getHarmonicBackground() {
        return currentTheme.getHarmonicBackground();
    }

    public static ColorUIResource getBrghtComplBackground() {
        return currentTheme.getBrghtComplBackground();
    }

    public static ColorUIResource getScrollPaneBorderColor() {
        return currentTheme.getScrollPaneBorderColor();
    }

    public static ColorUIResource getScrollPaneBackground(HueShiftTheme theme) {
        return currentTheme.getScrollPaneBackground(theme);
    }

    public static synchronized Image getCropImage(int mLeft, int mTop, int mRight, int mBottom, String mImagePath) {
        return FrogGIFReader.getCropImage(mLeft, mTop, mRight, mBottom, mImagePath);
    }

    public static synchronized Image getCropImage(JComponent c, FrogImageData data) {
        return FrogGIFReader.getCropImage(c, data);
    }

    public static synchronized Image getCropImage(HueShiftTheme mTheme, int mLeft, int mTop, int mRight, int mBottom, String mImagePath) {
        return FrogGIFReader.getCropImage(mTheme, mLeft, mTop, mRight, mBottom, mImagePath);
    }

    public static synchronized Image getCropImage2(HueShiftTheme mTheme, FrogImageData data) {
        return FrogGIFReader.getCropImage(mTheme, data.getLeft(), data.getTop(), data.getRight(), data.getBottom(), data.getPath());
    }

    public static synchronized Image getImageFromData(JComponent c, FrogImageData imagedata) {
        return FrogLookAndFeel.getImageForComp(c, imagedata.getPath());
    }

    public static synchronized Image getImageForComp(JComponent c, String path) {
        return FrogGIFReader.getImageForComp(c, path);
    }

    public void uninitialize() {
        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        FrogGIFReader.uninitialize();
    }

    public static boolean isVMVersion1dot2() {
        boolean retVal = false;
        try {
            Method method;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            retVal = (method = clazz.getMethod("getProtectionDomain", null)) != null;
        }
        catch (NoSuchMethodException e) {
            retVal = false;
        }
        return retVal;
    }

    private static boolean isVMVersion1dot4() {
        boolean retVal = true;
        try {
            Method method;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            retVal = (method = clazz.getMethod("desiredAssertionStatus", null)) != null;
        }
        catch (NoSuchMethodException e) {
            retVal = false;
        }
        return retVal;
    }

    public static boolean isJVM1dot4() {
        return mIsJVM1dot4;
    }

    public static void setTracing(boolean tracing) {
        mTracing = tracing;
    }

    public static boolean isTracing() {
        return mTracing;
    }

    public static class IconLazyValue
    implements UIDefaults.LazyValue {
        int mLeft;
        int mRight;
        int mTop;
        int mBottom;
        String mImagePath;
        HueShiftTheme mTheme;

        public IconLazyValue(HueShiftTheme theme, int left, int top, int right, int bottom, String imagePath) {
            this.mTheme = theme;
            this.mImagePath = imagePath;
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
        }

        public IconLazyValue(HueShiftTheme theme, FrogImageData data) {
            this.mTheme = theme;
            this.mImagePath = data.getPath();
            this.mLeft = data.getLeft();
            this.mTop = data.getTop();
            this.mRight = data.getRight();
            this.mBottom = data.getBottom();
        }

        public Object createValue(UIDefaults table) {
            return new ImageIcon(FrogLookAndFeel.getCropImage(this.mTheme, this.mLeft, this.mTop, this.mRight, this.mBottom, this.mImagePath));
        }
    }
}

