/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.hueshift.SystemHueShift;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class FrogLabelUI
extends BasicLabelUI {
    public static final String __PerforceId = "$Id$";
    protected static FrogLabelUI frogLabelUI = new FrogLabelUI();
    protected SystemListener mSystemListener;
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle viewR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent c) {
        return frogLabelUI;
    }

    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        g.setColor(SystemHueShift.getColor((JComponent)l, "Label.disabledForeground"));
        BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (this.mSystemListener == null) {
            this.mSystemListener = this.createSystemListener();
        }
        c.addPropertyChangeListener(this.mSystemListener);
        String mStatusObject = (String)c.getClientProperty("statusbar");
        if (mStatusObject != null) {
            if (mStatusObject.equals("statusTextfield")) {
                LookAndFeel.installBorder(c, "StatusBar.textfieldBorder");
            } else if (mStatusObject.equals("systemInfo")) {
                LookAndFeel.installBorder(c, "StatusBar.systemInfoBorder");
            } else if (mStatusObject.equals("pcInfo")) {
                LookAndFeel.installBorder(c, "StatusBar.pcInfoBorder");
            } else if (mStatusObject.equals("insOvrField")) {
                LookAndFeel.installBorder(c, "StatusBar.pcInfoBorder");
            }
        } else if (c.getClientProperty("toolbarType") != null && (Integer)c.getClientProperty("toolbarType") == 2) {
            c.setFont(SystemHueShift.getFont(c, "TitleBar.font"));
            c.setForeground(SystemHueShift.getColor(c, "TitleBar.foreground"));
        }
    }

    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        if (l.getClientProperty("toolbarType") != null && (Integer)l.getClientProperty("toolbarType") == 2) {
            g.setColor(SystemHueShift.getColor((JComponent)l, "TitleBar.foreground"));
        } else {
            g.setColor(l.getForeground());
        }
        BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
    }

    public Dimension getPreferredSize(JComponent c) {
        int dy = 0;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon = label.getIcon();
        Insets insets = label.getInsets(viewInsets);
        Font font = label.getFont();
        int dx = insets.left + insets.right;
        dy = insets.top + insets.bottom;
        if (icon == null && (text == null || text != null && font == null)) {
            return new Dimension(dx, dy);
        }
        if (text == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + dx, icon.getIconHeight() + dy);
        }
        FontMetrics fm = label.getToolkit().getFontMetrics(font);
        FrogLabelUI.iconR.height = 0;
        FrogLabelUI.iconR.width = 0;
        FrogLabelUI.iconR.y = 0;
        FrogLabelUI.iconR.x = 0;
        FrogLabelUI.textR.height = 0;
        FrogLabelUI.textR.width = 0;
        FrogLabelUI.textR.y = 0;
        FrogLabelUI.textR.x = 0;
        FrogLabelUI.viewR.x = dx;
        FrogLabelUI.viewR.y = dy;
        FrogLabelUI.viewR.height = Short.MAX_VALUE;
        FrogLabelUI.viewR.width = Short.MAX_VALUE;
        this.layoutCL(label, fm, text, icon, viewR, iconR, textR);
        int x1 = Math.min(FrogLabelUI.iconR.x, FrogLabelUI.textR.x);
        int x2 = Math.max(FrogLabelUI.iconR.x + FrogLabelUI.iconR.width, FrogLabelUI.textR.x + FrogLabelUI.textR.width);
        int y1 = Math.min(FrogLabelUI.iconR.y, FrogLabelUI.textR.y);
        int y2 = Math.max(FrogLabelUI.iconR.y + FrogLabelUI.iconR.height, FrogLabelUI.textR.y + FrogLabelUI.textR.height);
        Dimension rv = new Dimension(x2 - x1, y2 - y1);
        if (icon != null && rv.height + dy - icon.getIconHeight() <= 2) {
            dy = 3;
        }
        rv.width += dx;
        rv.height += dy;
        return rv;
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            if (c.getClientProperty("statusbar") != null || c.getClientProperty("Table") != null) {
                g.setColor(SystemHueShift.getColor(c, "StatusBar.background"));
            } else {
                g.setColor(c.getBackground());
            }
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    protected void uninstallDefaults(JLabel c) {
        super.uninstallDefaults(c);
        c.removePropertyChangeListener(this.mSystemListener);
    }

    protected SystemListener createSystemListener() {
        return new SystemListener();
    }

    class SystemListener
    implements PropertyChangeListener {
        SystemListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            JComponent c = (JComponent)e.getSource();
            if ((name.equals("system") || name.equals("theme")) && c.getClientProperty("toolbarType") != null && (Integer)c.getClientProperty("toolbarType") == 2) {
                ((JLabel)c).setFont(SystemHueShift.getFont(c, "TitleBar.font"));
            }
        }
    }
}

