/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogInternalFrameTitlePane;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class FrogInternalFrameUI
extends BasicInternalFrameUI {
    private FrogInternalFrameTitlePane titlePane;
    private PropertyChangeListener paletteListener;
    private PropertyChangeListener contentPaneListener;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    protected static String IS_PALETTE = "JInternalFrame.isPalette";

    public FrogInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new FrogInternalFrameUI((JInternalFrame)c);
    }

    public void installUI(JComponent c) {
        this.frame = (JInternalFrame)c;
        this.paletteListener = new PaletteListener();
        this.contentPaneListener = new ContentPaneListener();
        c.addPropertyChangeListener(this.paletteListener);
        c.addPropertyChangeListener(this.contentPaneListener);
        super.installUI(c);
        Object paletteProp = c.getClientProperty(IS_PALETTE);
        if (paletteProp != null) {
            this.setPalette((Boolean)paletteProp);
        }
        Container content = this.frame.getContentPane();
        this.stripContentBorder(content);
        c.setOpaque(false);
    }

    public void uninstallUI(JComponent c) {
        JComponent content;
        c.removePropertyChangeListener(this.paletteListener);
        c.removePropertyChangeListener(this.contentPaneListener);
        Container cont = ((JInternalFrame)c).getContentPane();
        if (cont instanceof JComponent && (content = (JComponent)cont).getBorder() == handyEmptyBorder) {
            content.setBorder(null);
        }
        super.uninstallUI(c);
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    private void stripContentBorder(Object c) {
        JComponent contentComp;
        Border contentBorder;
        if (c instanceof JComponent && ((contentBorder = (contentComp = (JComponent)c).getBorder()) == null || contentBorder instanceof UIResource)) {
            contentComp.setBorder(handyEmptyBorder);
        }
    }

    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new FrogInternalFrameTitlePane(w);
        return this.titlePane;
    }

    protected void replacePane(JComponent currentPane, JComponent newPane) {
        super.replacePane(currentPane, newPane);
        if (currentPane != null && currentPane instanceof FrogInternalFrameTitlePane) {
            this.frame.removePropertyChangeListener((PropertyChangeListener)((Object)currentPane));
        }
    }

    public void setPalette(boolean isPalette) {
        if (isPalette) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        }
        this.titlePane.setPalette(isPalette);
    }

    class PaletteListener
    implements PropertyChangeListener {
        PaletteListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(IS_PALETTE)) {
                if (e.getNewValue() != null) {
                    FrogInternalFrameUI.this.setPalette((Boolean)e.getNewValue());
                } else {
                    FrogInternalFrameUI.this.setPalette(false);
                }
            }
        }
    }

    class ContentPaneListener
    implements PropertyChangeListener {
        ContentPaneListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("contentPane")) {
                FrogInternalFrameUI.this.stripContentBorder(e.getNewValue());
            }
        }
    }
}

