/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogBumps;
import com.sap.plaf.frog.FrogLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;

class FrogInternalFrameTitlePane
extends JComponent
implements LayoutManager,
ActionListener,
PropertyChangeListener {
    protected JMenuBar menuBar;
    protected boolean isPalette = false;
    JInternalFrame frame;
    protected JButton iconButton;
    protected JButton maxButton;
    protected JButton closeButton;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    Icon maxIcon;
    Icon altMaxIcon;
    Icon iconIcon;
    Icon closeIcon;
    int riseWidth = 0;
    int interButtonSpacing = 2;
    FrogBumps activeBumps = new FrogBumps(0, 0, FrogLookAndFeel.getPrimaryControlHighlight(), FrogLookAndFeel.getPrimaryControlDarkShadow(), FrogLookAndFeel.getPrimaryControl());
    FrogBumps inactiveBumps = new FrogBumps(0, 0, FrogLookAndFeel.getControlHighlight(), FrogLookAndFeel.getControlDarkShadow(), FrogLookAndFeel.getControl());
    FrogBumps paletteBumps;

    public FrogInternalFrameTitlePane(JInternalFrame f) {
        this.frame = f;
        this.setFont(UIManager.getFont("InternalFrame.font"));
        this.maxIcon = (Icon)UIManager.get("InternalFrame.maximizeIcon");
        this.altMaxIcon = (Icon)UIManager.get("InternalFrame.minimizeIcon");
        this.iconIcon = (Icon)UIManager.get("InternalFrame.iconizeIcon");
        this.closeIcon = (Icon)UIManager.get("InternalFrame.closeIcon");
        this.iconButton = new NoFocusButton(this.iconIcon);
        this.iconButton.putClientProperty("paintActive", Boolean.TRUE);
        this.iconButton.setFocusPainted(false);
        this.iconButton.setBorder(handyEmptyBorder);
        this.iconButton.setOpaque(false);
        this.iconButton.addActionListener(this);
        this.iconButton.setActionCommand("Iconify");
        this.iconButton.getAccessibleContext().setAccessibleName("Iconify");
        this.maxButton = new NoFocusButton(this.maxIcon);
        this.maxButton.putClientProperty("paintActive", Boolean.TRUE);
        this.maxButton.setBorder(handyEmptyBorder);
        this.maxButton.setOpaque(false);
        this.maxButton.setFocusPainted(false);
        this.maxButton.addActionListener(this);
        this.maxButton.setActionCommand("Maximize");
        this.maxButton.getAccessibleContext().setAccessibleName("Maximize");
        this.closeButton = new NoFocusButton(this.closeIcon);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.setOpaque(false);
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("Close");
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.setLayout(this);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
        this.frame.addPropertyChangeListener(this);
    }

    public void paintPalette(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.paletteBumps == null) {
            this.paletteBumps = new FrogBumps(0, 0, FrogLookAndFeel.getPrimaryControlHighlight(), FrogLookAndFeel.getPrimaryControlInfo(), FrogLookAndFeel.getPrimaryControlShadow());
        }
        ColorUIResource background = FrogLookAndFeel.getPrimaryControlShadow();
        ColorUIResource darkShadow = FrogLookAndFeel.getPrimaryControlDarkShadow();
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        g.setColor(darkShadow);
        g.drawLine(0, height - 1, width, height - 1);
        int xOffset = 5;
        int bumpLength = this.getWidth() - (xOffset + this.riseWidth + 2);
        int bumpHeight = this.getHeight() - 4;
        this.paletteBumps.setBumpArea(bumpLength, bumpHeight);
        this.paletteBumps.paintIcon(this, g, xOffset, 2);
        this.paintChildren(g);
    }

    public void paint(Graphics g) {
        FrogBumps bumps;
        ColorUIResource darkShadow;
        ColorUIResource foreground;
        ColorUIResource background;
        if (this.isPalette) {
            this.paintPalette(g);
            return;
        }
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        if (isSelected) {
            background = FrogLookAndFeel.getWindowTitleBackground();
            foreground = FrogLookAndFeel.getWindowTitleForeground();
            ColorUIResource shadow = FrogLookAndFeel.getPrimaryControlShadow();
            darkShadow = FrogLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource highlight = FrogLookAndFeel.getPrimaryControlHighlight();
            ColorUIResource black = FrogLookAndFeel.getPrimaryControlInfo();
            bumps = this.activeBumps;
        } else {
            background = FrogLookAndFeel.getWindowTitleInactiveBackground();
            foreground = FrogLookAndFeel.getWindowTitleInactiveForeground();
            ColorUIResource shadow = FrogLookAndFeel.getControlShadow();
            darkShadow = FrogLookAndFeel.getControlDarkShadow();
            ColorUIResource highlight = FrogLookAndFeel.getControlHighlight();
            ColorUIResource black = FrogLookAndFeel.getControlInfo();
            bumps = this.inactiveBumps;
        }
        ColorUIResource fillColor = darkShadow;
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        g.setColor(darkShadow);
        g.drawLine(0, height - 1, width, height - 1);
        g.drawLine(0, 0, 0, 0);
        g.drawLine(width - 1, 0, width - 1, 0);
        int titleLength = 0;
        int xOffset = 5;
        String frameTitle = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            int iconY = height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += icon.getIconWidth() + 2;
        }
        if (frameTitle != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            int fHeight = fm.getHeight();
            titleLength = fm.stringWidth(this.frame.getTitle());
            g.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            g.drawString(this.frame.getTitle(), xOffset, yOffset);
        }
        int bumpYOffset = 3;
        int bumpLength = this.getWidth() - ((xOffset += titleLength + this.interButtonSpacing) + this.riseWidth + this.interButtonSpacing + 5);
        int bumpHeight = this.getHeight() - 2 * bumpYOffset;
        bumps.setBumpArea(bumpLength, bumpHeight);
        bumps.paintIcon(this, g, xOffset, bumpYOffset);
        this.paintChildren(g);
    }

    public void actionPerformed(ActionEvent e) {
        if ("Close".equals(e.getActionCommand()) && this.frame.isClosable()) {
            try {
                this.frame.setClosed(true);
            }
            catch (PropertyVetoException e0) {}
        } else if ("Iconify".equals(e.getActionCommand()) && this.frame.isIconifiable()) {
            if (!this.frame.isIcon()) {
                try {
                    this.frame.setIcon(true);
                }
                catch (PropertyVetoException e1) {}
            } else {
                try {
                    this.frame.setIcon(false);
                }
                catch (PropertyVetoException e1) {
                    // empty catch block
                }
            }
            ButtonModel model = this.iconButton.getModel();
            if (model != null) {
                model.setRollover(false);
            }
        } else if ("Minimize".equals(e.getActionCommand()) && this.frame.isMaximizable()) {
            try {
                this.frame.setIcon(true);
            }
            catch (PropertyVetoException e2) {}
        } else if ("Maximize".equals(e.getActionCommand()) && this.frame.isMaximizable()) {
            if (!this.frame.isMaximum()) {
                try {
                    this.frame.setMaximum(true);
                }
                catch (PropertyVetoException e5) {}
            } else {
                try {
                    this.frame.setMaximum(false);
                }
                catch (PropertyVetoException e6) {}
            }
        } else if ("Restore".equals(e.getActionCommand()) && this.frame.isMaximizable() && this.frame.isMaximum()) {
            try {
                this.frame.setMaximum(false);
            }
            catch (PropertyVetoException e4) {}
        } else if ("Restore".equals(e.getActionCommand()) && this.frame.isIconifiable() && this.frame.isIcon()) {
            try {
                this.frame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        JInternalFrame f = (JInternalFrame)evt.getSource();
        boolean value = false;
        if (this.frame.isSelected()) {
            this.iconButton.putClientProperty("paintActive", Boolean.TRUE);
            this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
            this.maxButton.putClientProperty("paintActive", Boolean.TRUE);
            this.repaint();
        } else {
            this.iconButton.putClientProperty("paintActive", Boolean.FALSE);
            this.closeButton.putClientProperty("paintActive", Boolean.FALSE);
            this.maxButton.putClientProperty("paintActive", Boolean.FALSE);
            this.repaint();
        }
        if ("selected".equals(prop)) {
            this.repaint();
        } else if ("maximum".equals(prop)) {
            value = (Boolean)evt.getNewValue();
            if (value) {
                this.maxButton.setIcon(this.altMaxIcon);
            } else {
                this.maxButton.setIcon(this.maxIcon);
            }
        } else if ("icon".equals(prop)) {
            value = (Boolean)evt.getNewValue();
            if (value) {
                this.iconButton.setIcon(this.iconIcon);
            } else {
                this.iconButton.setIcon(this.iconIcon);
            }
        }
    }

    public void addLayoutComponent(String name, Component c) {
    }

    public void removeLayoutComponent(Component c) {
    }

    public Dimension preferredLayoutSize(Container c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(Container c) {
        return new Dimension(c.getSize().width, this.computeHeight());
    }

    public Dimension minimumLayoutSize(Container c) {
        return this.preferredLayoutSize(c);
    }

    protected int computeHeight() {
        if (this.isPalette) {
            return UIManager.getInt("InternalFrame.paletteTitleHeight");
        }
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int fontHeight = fm.getHeight();
        int iconHeight = this.frame.getFrameIcon().getIconHeight();
        int finalHeight = Math.max(fontHeight += 7, iconHeight += 5);
        return finalHeight;
    }

    public void layoutContainer(Container c) {
        int w = this.getWidth() - 2;
        int y = 2;
        int extraCloseOffset = 7;
        int buttonHeight = this.closeButton.getIcon().getIconHeight();
        int buttonWidth = this.closeButton.getIcon().getIconWidth();
        int x = w;
        if (this.frame.isClosable()) {
            if (this.isPalette) {
                this.closeButton.setBounds(x -= buttonWidth + 4, 2, buttonWidth + 2, this.getHeight() - 4);
                x -= 3;
            } else {
                this.closeButton.setBounds(x -= buttonWidth + this.interButtonSpacing, y, buttonWidth, buttonHeight);
                x -= extraCloseOffset;
            }
        } else if (this.closeButton.getParent() != null) {
            this.closeButton.getParent().remove(this.closeButton);
        }
        if (this.frame.isMaximizable() && !this.isPalette) {
            this.maxButton.setBounds(x -= buttonWidth + this.interButtonSpacing, y, buttonWidth, buttonHeight);
        } else if (this.maxButton.getParent() != null) {
            this.maxButton.getParent().remove(this.maxButton);
        }
        if (this.frame.isIconifiable() && !this.isPalette) {
            this.iconButton.setBounds(x -= buttonWidth + this.interButtonSpacing, y, buttonWidth, buttonHeight);
        } else if (this.iconButton.getParent() != null) {
            this.iconButton.getParent().remove(this.iconButton);
        }
        this.riseWidth = w - x;
    }

    public void setPalette(boolean b) {
        this.isPalette = b;
        if (this.isPalette) {
            this.closeButton.setIcon(UIManager.getIcon("InternalFrame.paletteCloseIcon"));
        } else {
            this.closeButton.setIcon(this.closeIcon);
        }
        this.repaint();
        this.revalidate();
    }

    private static class NoFocusButton
    extends JButton {
        public NoFocusButton(Icon icon) {
            super(icon);
            this.setFocusPainted(false);
        }

        public NoFocusButton() {
            this.setFocusPainted(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isOpaque() {
            return false;
        }

        public boolean isContentAreaFilled() {
            return false;
        }
    }
}

