/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogBumps;
import com.sap.plaf.frog.FrogImageData;
import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.hueshift.HueShiftTheme;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import com.sap.plaf.frog.util.ThemeData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class FrogIconFactory
implements Serializable {
    public static final String __PerforceId = "$Id$";
    private static boolean mMacVendor = false;
    private static Icon fileChooserDetailViewIcon;
    private static Icon fileChooserHomeFolderIcon;
    private static Icon fileChooserListViewIcon;
    private static Icon fileChooserNewFolderIcon;
    private static Icon fileChooserUpFolderIcon;
    private static Icon internalFrameAltMaximizeIcon;
    private static Icon internalFrameCloseIcon;
    private static Icon internalFrameDefaultMenuIcon;
    private static Icon internalFrameMaximizeIcon;
    private static Icon internalFrameMinimizeIcon;
    private static Icon radioButtonIcon;
    private static Icon treeComputerIcon;
    private static Icon treeFloppyDriveIcon;
    private static Icon treeHardDriveIcon;
    private static Icon menuArrowIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon mTreeControlIcon;
    private static Image mA_UE;
    private static Image mA_CE;
    private static Image mA_UF;
    private static Image mA_CF;
    private static Image mA_UD;
    private static Image mA_CD;
    private static FrogImageData m_UE;
    private static FrogImageData m_CE;
    private static FrogImageData m_UF;
    private static FrogImageData m_CF;
    private static FrogImageData m_UD;
    private static FrogImageData m_CD;
    private static FrogImageData mArrowRight_E;
    private static FrogImageData mArrowRight_D;
    private static FrogImageData mCheck_E;
    private static FrogImageData mCheck_D;
    private static Icon mDefaultTreeIcon;
    protected static FrogImageData[] mImageDataResources;
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;
    private static final Dimension folderIcon16Size;
    private static final Dimension fileIcon16Size;
    private static final Dimension treeControlSize;
    private static final Dimension menuArrowIconSize;
    private static final Dimension menuCheckIconSize;
    private static final int xOff = 4;

    static {
        mA_UE = null;
        mA_CE = null;
        mA_UF = null;
        mA_CF = null;
        mA_UD = null;
        mA_CD = null;
        m_UE = null;
        m_CE = null;
        m_UF = null;
        m_CF = null;
        m_UD = null;
        m_CD = null;
        mArrowRight_E = null;
        mArrowRight_D = null;
        mCheck_E = null;
        mCheck_D = null;
        mDefaultTreeIcon = new TreeControlIcon(false, null);
        folderIcon16Size = new Dimension(16, 16);
        fileIcon16Size = new Dimension(16, 16);
        treeControlSize = new Dimension(18, 18);
        menuArrowIconSize = new Dimension(4, 8);
        menuCheckIconSize = new Dimension(12, 10);
    }

    public static void initializeImageData() {
    }

    public static Icon getFileChooserDetailViewIcon() {
        if (fileChooserDetailViewIcon == null) {
            fileChooserDetailViewIcon = new FileChooserDetailViewIcon();
        }
        return fileChooserDetailViewIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
        if (fileChooserHomeFolderIcon == null) {
            fileChooserHomeFolderIcon = new FileChooserHomeFolderIcon();
        }
        return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserListViewIcon() {
        if (fileChooserListViewIcon == null) {
            fileChooserListViewIcon = new FileChooserListViewIcon();
        }
        return fileChooserListViewIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
        if (fileChooserNewFolderIcon == null) {
            fileChooserNewFolderIcon = new FileChooserNewFolderIcon();
        }
        return fileChooserNewFolderIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
        if (fileChooserUpFolderIcon == null) {
            fileChooserUpFolderIcon = new FileChooserUpFolderIcon();
        }
        return fileChooserUpFolderIcon;
    }

    public static Icon getInternalFrameAltMaximizeIcon(int size) {
        return new InternalFrameAltMaximizeIcon(size);
    }

    public static Icon getInternalFrameCloseIcon(int size) {
        return new InternalFrameCloseIcon(size);
    }

    public static Icon getInternalFrameDefaultMenuIcon() {
        if (internalFrameDefaultMenuIcon == null) {
            internalFrameDefaultMenuIcon = new InternalFrameDefaultMenuIcon();
        }
        return internalFrameDefaultMenuIcon;
    }

    public static Icon getInternalFrameMaximizeIcon(int size) {
        return new InternalFrameMaximizeIcon(size);
    }

    public static Icon getInternalFrameMinimizeIcon(int size) {
        return new InternalFrameMinimizeIcon(size);
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon(null);
        }
        return radioButtonIcon;
    }

    public static Icon reloadRadioButtonIcon(HueShiftTheme theme) {
        radioButtonIcon = new RadioButtonIcon(theme);
        return radioButtonIcon;
    }

    public static Icon getTreeComputerIcon() {
        if (treeComputerIcon == null) {
            treeComputerIcon = new TreeComputerIcon();
        }
        return treeComputerIcon;
    }

    public static Icon getTreeFloppyDriveIcon() {
        if (treeFloppyDriveIcon == null) {
            treeFloppyDriveIcon = new TreeFloppyDriveIcon();
        }
        return treeFloppyDriveIcon;
    }

    public static Icon getTreeFolderIcon(HueShiftTheme theme) {
        return new TreeFolderIcon(theme);
    }

    public static Icon getTreeOpenIcon(HueShiftTheme theme) {
        return new TreeOpenIcon(theme);
    }

    public static Icon getTreeHardDriveIcon() {
        if (treeHardDriveIcon == null) {
            treeHardDriveIcon = new TreeHardDriveIcon();
        }
        return treeHardDriveIcon;
    }

    public static Icon getTreeLeafIcon(HueShiftTheme theme) {
        return new TreeLeafIcon(theme);
    }

    public static Icon getTreeControlIcon(boolean isCollapsed, HueShiftTheme theme) {
        return new TreeControlIcon(isCollapsed, theme);
    }

    public static Icon getDefaultTreeIcon() {
        return mDefaultTreeIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getMenuItemCheckIcon() {
        if (menuItemCheckIcon == null) {
            menuItemCheckIcon = new MenuItemCheckIcon();
        }
        return menuItemCheckIcon;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getHorizontalSliderThumbIcon(HueShiftTheme currenttheme) {
        return new HorizontalSliderThumbIcon();
    }

    public static Icon getVerticalSliderThumbIcon(HueShiftTheme currenttheme) {
        return new VerticalSliderThumbIcon();
    }

    public static FrogImageData[] getImageDataResources() {
        if (mImageDataResources == null) {
            FrogIconFactory.initializeImageData();
            FrogImageData[] datas = new FrogImageData[]{m_UE, m_CE, m_UF, m_CF, m_UD, m_CD, mArrowRight_E, mArrowRight_D, mCheck_E, mCheck_D};
            mImageDataResources = datas;
        }
        return mImageDataResources;
    }

    private static class FileChooserDetailViewIcon
    implements Icon,
    UIResource,
    Serializable {
        FileChooserDetailViewIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(FrogLookAndFeel.getPrimaryControlInfo());
            g.drawLine(2, 2, 5, 2);
            g.drawLine(2, 3, 2, 7);
            g.drawLine(3, 7, 6, 7);
            g.drawLine(6, 6, 6, 3);
            g.drawLine(2, 10, 5, 10);
            g.drawLine(2, 11, 2, 15);
            g.drawLine(3, 15, 6, 15);
            g.drawLine(6, 14, 6, 11);
            g.drawLine(8, 5, 15, 5);
            g.drawLine(8, 13, 15, 13);
            g.setColor(FrogLookAndFeel.getPrimaryControl());
            g.drawRect(3, 3, 2, 3);
            g.drawRect(3, 11, 2, 3);
            g.setColor(FrogLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(4, 4, 4, 5);
            g.drawLine(4, 12, 4, 13);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserHomeFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        FileChooserHomeFolderIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(FrogLookAndFeel.getPrimaryControlInfo());
            g.drawLine(8, 1, 1, 8);
            g.drawLine(8, 1, 15, 8);
            g.drawLine(11, 2, 11, 3);
            g.drawLine(12, 2, 12, 4);
            g.drawLine(3, 7, 3, 15);
            g.drawLine(13, 7, 13, 15);
            g.drawLine(4, 15, 12, 15);
            g.drawLine(6, 9, 6, 14);
            g.drawLine(10, 9, 10, 14);
            g.drawLine(7, 9, 9, 9);
            g.setColor(FrogLookAndFeel.getControlDarkShadow());
            g.fillRect(8, 2, 1, 1);
            g.fillRect(7, 3, 3, 1);
            g.fillRect(6, 4, 5, 1);
            g.fillRect(5, 5, 7, 1);
            g.fillRect(4, 6, 9, 2);
            g.drawLine(9, 12, 9, 12);
            g.setColor(FrogLookAndFeel.getPrimaryControl());
            g.drawLine(4, 8, 12, 8);
            g.fillRect(4, 9, 2, 6);
            g.fillRect(11, 9, 2, 6);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserListViewIcon
    implements Icon,
    UIResource,
    Serializable {
        FileChooserListViewIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(FrogLookAndFeel.getPrimaryControlInfo());
            g.drawLine(2, 2, 5, 2);
            g.drawLine(2, 3, 2, 7);
            g.drawLine(3, 7, 6, 7);
            g.drawLine(6, 6, 6, 3);
            g.drawLine(10, 2, 13, 2);
            g.drawLine(10, 3, 10, 7);
            g.drawLine(11, 7, 14, 7);
            g.drawLine(14, 6, 14, 3);
            g.drawLine(2, 10, 5, 10);
            g.drawLine(2, 11, 2, 15);
            g.drawLine(3, 15, 6, 15);
            g.drawLine(6, 14, 6, 11);
            g.drawLine(10, 10, 13, 10);
            g.drawLine(10, 11, 10, 15);
            g.drawLine(11, 15, 14, 15);
            g.drawLine(14, 14, 14, 11);
            g.drawLine(8, 5, 8, 5);
            g.drawLine(16, 5, 16, 5);
            g.drawLine(8, 13, 8, 13);
            g.drawLine(16, 13, 16, 13);
            g.setColor(FrogLookAndFeel.getPrimaryControl());
            g.drawRect(3, 3, 2, 3);
            g.drawRect(11, 3, 2, 3);
            g.drawRect(3, 11, 2, 3);
            g.drawRect(11, 11, 2, 3);
            g.setColor(FrogLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(4, 4, 4, 5);
            g.drawLine(12, 4, 12, 5);
            g.drawLine(4, 12, 4, 13);
            g.drawLine(12, 12, 12, 13);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserNewFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        FileChooserNewFolderIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(FrogLookAndFeel.getPrimaryControl());
            g.fillRect(3, 5, 12, 9);
            g.setColor(FrogLookAndFeel.getPrimaryControlInfo());
            g.drawLine(1, 6, 1, 14);
            g.drawLine(2, 14, 15, 14);
            g.drawLine(15, 13, 15, 5);
            g.drawLine(2, 5, 9, 5);
            g.drawLine(10, 6, 14, 6);
            g.setColor(FrogLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(2, 6, 2, 13);
            g.drawLine(3, 6, 9, 6);
            g.drawLine(10, 7, 14, 7);
            g.setColor(FrogLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(11, 3, 15, 3);
            g.drawLine(10, 4, 15, 4);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserUpFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        FileChooserUpFolderIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(FrogLookAndFeel.getPrimaryControl());
            g.fillRect(3, 5, 12, 9);
            g.setColor(FrogLookAndFeel.getPrimaryControlInfo());
            g.drawLine(1, 6, 1, 14);
            g.drawLine(2, 14, 15, 14);
            g.drawLine(15, 13, 15, 5);
            g.drawLine(2, 5, 9, 5);
            g.drawLine(10, 6, 14, 6);
            g.drawLine(8, 13, 8, 16);
            g.drawLine(8, 9, 8, 9);
            g.drawLine(7, 10, 9, 10);
            g.drawLine(6, 11, 10, 11);
            g.drawLine(5, 12, 11, 12);
            g.setColor(FrogLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(2, 6, 2, 13);
            g.drawLine(3, 6, 9, 6);
            g.drawLine(10, 7, 14, 7);
            g.setColor(FrogLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(11, 3, 15, 3);
            g.drawLine(10, 4, 15, 4);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    static class PaletteCloseIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 7;

        PaletteCloseIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JButton parentButton = (JButton)c;
            ButtonModel buttonModel = parentButton.getModel();
            ColorUIResource highlight = FrogLookAndFeel.getPrimaryControlHighlight();
            ColorUIResource shadow = FrogLookAndFeel.getPrimaryControlInfo();
            ColorUIResource back = buttonModel.isPressed() && buttonModel.isArmed() ? shadow : FrogLookAndFeel.getPrimaryControlDarkShadow();
            g.translate(x, y);
            g.setColor(back);
            g.drawLine(0, 1, 5, 6);
            g.drawLine(1, 0, 6, 5);
            g.drawLine(1, 1, 6, 6);
            g.drawLine(6, 1, 1, 6);
            g.drawLine(5, 0, 0, 5);
            g.drawLine(5, 1, 1, 5);
            g.setColor(highlight);
            g.drawLine(6, 2, 5, 3);
            g.drawLine(2, 6, 3, 5);
            g.drawLine(6, 6, 6, 6);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameCloseIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameCloseIcon(int size) {
            this.iconSize = size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JButton parentButton = (JButton)c;
            ButtonModel buttonModel = parentButton.getModel();
            ColorUIResource backgroundColor = FrogLookAndFeel.getPrimaryControl();
            ColorUIResource internalBackgroundColor = FrogLookAndFeel.getPrimaryControl();
            ColorUIResource mainItemColor = FrogLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource darkHighlightColor = FrogLookAndFeel.getBlack();
            ColorUIResource xLightHighlightColor = FrogLookAndFeel.getWhite();
            ColorUIResource boxLightHighlightColor = FrogLookAndFeel.getWhite();
            if (parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                internalBackgroundColor = backgroundColor = FrogLookAndFeel.getControl();
                mainItemColor = FrogLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    xLightHighlightColor = internalBackgroundColor = FrogLookAndFeel.getControlShadow();
                    mainItemColor = darkHighlightColor;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                xLightHighlightColor = internalBackgroundColor = FrogLookAndFeel.getPrimaryControlShadow();
                mainItemColor = darkHighlightColor;
            }
            int oneHalf = this.iconSize / 2;
            g.translate(x, y);
            g.setColor(backgroundColor);
            g.fillRect(0, 0, this.iconSize, this.iconSize);
            g.setColor(internalBackgroundColor);
            g.fillRect(3, 3, this.iconSize - 6, this.iconSize - 6);
            g.setColor(darkHighlightColor);
            g.drawRect(1, 1, this.iconSize - 3, this.iconSize - 3);
            g.drawRect(2, 2, this.iconSize - 5, this.iconSize - 5);
            g.setColor(boxLightHighlightColor);
            g.drawRect(2, 2, this.iconSize - 3, this.iconSize - 3);
            g.setColor(mainItemColor);
            g.drawRect(2, 2, this.iconSize - 4, this.iconSize - 4);
            g.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            g.drawLine(this.iconSize - 3, 3, this.iconSize - 3, 3);
            g.setColor(darkHighlightColor);
            g.drawLine(4, 5, 5, 4);
            g.drawLine(4, this.iconSize - 6, this.iconSize - 6, 4);
            g.setColor(xLightHighlightColor);
            g.drawLine(6, this.iconSize - 5, this.iconSize - 5, 6);
            g.drawLine(oneHalf, oneHalf + 2, oneHalf + 2, oneHalf);
            g.drawLine(this.iconSize - 5, this.iconSize - 5, this.iconSize - 4, this.iconSize - 5);
            g.drawLine(this.iconSize - 5, this.iconSize - 4, this.iconSize - 5, this.iconSize - 4);
            g.setColor(mainItemColor);
            g.drawLine(5, 5, this.iconSize - 6, this.iconSize - 6);
            g.drawLine(6, 5, this.iconSize - 5, this.iconSize - 6);
            g.drawLine(5, 6, this.iconSize - 6, this.iconSize - 5);
            g.drawLine(5, this.iconSize - 5, this.iconSize - 5, 5);
            g.drawLine(5, this.iconSize - 6, this.iconSize - 6, 5);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameAltMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameAltMaximizeIcon(int size) {
            this.iconSize = size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JButton parentButton = (JButton)c;
            ButtonModel buttonModel = parentButton.getModel();
            ColorUIResource backgroundColor = FrogLookAndFeel.getPrimaryControl();
            ColorUIResource internalBackgroundColor = FrogLookAndFeel.getPrimaryControl();
            ColorUIResource mainItemColor = FrogLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource darkHighlightColor = FrogLookAndFeel.getBlack();
            ColorUIResource ulLightHighlightColor = FrogLookAndFeel.getWhite();
            ColorUIResource lrLightHighlightColor = FrogLookAndFeel.getWhite();
            if (parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                internalBackgroundColor = backgroundColor = FrogLookAndFeel.getControl();
                mainItemColor = FrogLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    ulLightHighlightColor = internalBackgroundColor = FrogLookAndFeel.getControlShadow();
                    mainItemColor = darkHighlightColor;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                ulLightHighlightColor = internalBackgroundColor = FrogLookAndFeel.getPrimaryControlShadow();
                mainItemColor = darkHighlightColor;
            }
            g.translate(x, y);
            g.setColor(backgroundColor);
            g.fillRect(0, 0, this.iconSize, this.iconSize);
            g.setColor(internalBackgroundColor);
            g.fillRect(3, 6, this.iconSize - 9, this.iconSize - 9);
            g.setColor(darkHighlightColor);
            g.drawRect(1, 5, this.iconSize - 8, this.iconSize - 8);
            g.drawLine(1, this.iconSize - 2, 1, this.iconSize - 2);
            g.setColor(lrLightHighlightColor);
            g.drawRect(2, 6, this.iconSize - 7, this.iconSize - 7);
            g.setColor(ulLightHighlightColor);
            g.drawRect(3, 7, this.iconSize - 9, this.iconSize - 9);
            g.setColor(mainItemColor);
            g.drawRect(2, 6, this.iconSize - 8, this.iconSize - 8);
            g.setColor(ulLightHighlightColor);
            g.drawLine(this.iconSize - 6, 8, this.iconSize - 6, 8);
            g.drawLine(this.iconSize - 9, 6, this.iconSize - 7, 8);
            g.setColor(mainItemColor);
            g.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            g.setColor(darkHighlightColor);
            g.drawLine(this.iconSize - 6, 9, this.iconSize - 6, 9);
            g.setColor(backgroundColor);
            g.drawLine(this.iconSize - 9, 5, this.iconSize - 9, 5);
            g.setColor(mainItemColor);
            g.fillRect(this.iconSize - 7, 3, 3, 5);
            g.drawLine(this.iconSize - 6, 5, this.iconSize - 3, 2);
            g.drawLine(this.iconSize - 6, 6, this.iconSize - 2, 2);
            g.drawLine(this.iconSize - 6, 7, this.iconSize - 3, 7);
            g.setColor(darkHighlightColor);
            g.drawLine(this.iconSize - 8, 2, this.iconSize - 7, 2);
            g.drawLine(this.iconSize - 8, 3, this.iconSize - 8, 7);
            g.drawLine(this.iconSize - 6, 4, this.iconSize - 3, 1);
            g.drawLine(this.iconSize - 4, 6, this.iconSize - 3, 6);
            g.setColor(lrLightHighlightColor);
            g.drawLine(this.iconSize - 6, 3, this.iconSize - 6, 3);
            g.drawLine(this.iconSize - 4, 5, this.iconSize - 2, 3);
            g.drawLine(this.iconSize - 4, 8, this.iconSize - 3, 8);
            g.drawLine(this.iconSize - 2, 8, this.iconSize - 2, 7);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameDefaultMenuIcon
    implements Icon,
    UIResource,
    Serializable {
        InternalFrameDefaultMenuIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            ColorUIResource windowBodyColor = FrogLookAndFeel.getWindowBackground();
            ColorUIResource titleColor = FrogLookAndFeel.getPrimaryControl();
            ColorUIResource edgeColor = FrogLookAndFeel.getPrimaryControlDarkShadow();
            g.translate(x, y);
            g.setColor(titleColor);
            g.fillRect(0, 0, 16, 16);
            g.setColor(windowBodyColor);
            g.fillRect(2, 6, 13, 9);
            g.drawLine(2, 2, 2, 2);
            g.drawLine(5, 2, 5, 2);
            g.drawLine(8, 2, 8, 2);
            g.drawLine(11, 2, 11, 2);
            g.setColor(edgeColor);
            g.drawRect(1, 1, 13, 13);
            g.drawLine(1, 0, 14, 0);
            g.drawLine(15, 1, 15, 14);
            g.drawLine(1, 15, 14, 15);
            g.drawLine(0, 1, 0, 14);
            g.drawLine(2, 5, 13, 5);
            g.drawLine(3, 3, 3, 3);
            g.drawLine(6, 3, 6, 3);
            g.drawLine(9, 3, 9, 3);
            g.drawLine(12, 3, 12, 3);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class InternalFrameMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        protected int iconSize = 16;

        public InternalFrameMaximizeIcon(int size) {
            this.iconSize = size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JButton parentButton = (JButton)c;
            ButtonModel buttonModel = parentButton.getModel();
            ColorUIResource backgroundColor = FrogLookAndFeel.getPrimaryControl();
            ColorUIResource internalBackgroundColor = FrogLookAndFeel.getPrimaryControl();
            ColorUIResource mainItemColor = FrogLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource darkHighlightColor = FrogLookAndFeel.getBlack();
            ColorUIResource ulLightHighlightColor = FrogLookAndFeel.getWhite();
            ColorUIResource lrLightHighlightColor = FrogLookAndFeel.getWhite();
            if (parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                internalBackgroundColor = backgroundColor = FrogLookAndFeel.getControl();
                mainItemColor = FrogLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    ulLightHighlightColor = internalBackgroundColor = FrogLookAndFeel.getControlShadow();
                    mainItemColor = darkHighlightColor;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                ulLightHighlightColor = internalBackgroundColor = FrogLookAndFeel.getPrimaryControlShadow();
                mainItemColor = darkHighlightColor;
            }
            g.translate(x, y);
            g.setColor(backgroundColor);
            g.fillRect(0, 0, this.iconSize, this.iconSize);
            g.setColor(internalBackgroundColor);
            g.fillRect(3, 7, this.iconSize - 10, this.iconSize - 10);
            g.setColor(ulLightHighlightColor);
            g.drawRect(3, 7, this.iconSize - 10, this.iconSize - 10);
            g.setColor(lrLightHighlightColor);
            g.drawRect(2, 6, this.iconSize - 7, this.iconSize - 7);
            g.setColor(darkHighlightColor);
            g.drawRect(1, 5, this.iconSize - 7, this.iconSize - 7);
            g.drawRect(2, 6, this.iconSize - 9, this.iconSize - 9);
            g.setColor(mainItemColor);
            g.drawRect(2, 6, this.iconSize - 8, this.iconSize - 8);
            g.setColor(darkHighlightColor);
            g.drawLine(3, this.iconSize - 5, this.iconSize - 9, 7);
            g.drawLine(this.iconSize - 6, 4, this.iconSize - 5, 3);
            g.drawLine(this.iconSize - 7, 1, this.iconSize - 7, 2);
            g.drawLine(this.iconSize - 6, 1, this.iconSize - 2, 1);
            g.setColor(ulLightHighlightColor);
            g.drawLine(5, this.iconSize - 4, this.iconSize - 8, 9);
            g.setColor(lrLightHighlightColor);
            g.drawLine(this.iconSize - 6, 3, this.iconSize - 4, 5);
            g.drawLine(this.iconSize - 4, 5, this.iconSize - 4, 6);
            g.drawLine(this.iconSize - 2, 7, this.iconSize - 1, 7);
            g.drawLine(this.iconSize - 1, 2, this.iconSize - 1, 6);
            g.setColor(mainItemColor);
            g.drawLine(3, this.iconSize - 4, this.iconSize - 3, 2);
            g.drawLine(3, this.iconSize - 3, this.iconSize - 2, 2);
            g.drawLine(4, this.iconSize - 3, 5, this.iconSize - 3);
            g.drawLine(this.iconSize - 7, 8, this.iconSize - 7, 9);
            g.drawLine(this.iconSize - 6, 2, this.iconSize - 4, 2);
            g.drawRect(this.iconSize - 3, 3, 1, 3);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameMinimizeIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameMinimizeIcon(int size) {
            this.iconSize = size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JButton parentButton = (JButton)c;
            ButtonModel buttonModel = parentButton.getModel();
            ColorUIResource backgroundColor = FrogLookAndFeel.getPrimaryControl();
            ColorUIResource internalBackgroundColor = FrogLookAndFeel.getPrimaryControl();
            ColorUIResource mainItemColor = FrogLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource darkHighlightColor = FrogLookAndFeel.getBlack();
            ColorUIResource ulLightHighlightColor = FrogLookAndFeel.getWhite();
            ColorUIResource lrLightHighlightColor = FrogLookAndFeel.getWhite();
            if (parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                internalBackgroundColor = backgroundColor = FrogLookAndFeel.getControl();
                mainItemColor = FrogLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    ulLightHighlightColor = internalBackgroundColor = FrogLookAndFeel.getControlShadow();
                    mainItemColor = darkHighlightColor;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                ulLightHighlightColor = internalBackgroundColor = FrogLookAndFeel.getPrimaryControlShadow();
                mainItemColor = darkHighlightColor;
            }
            g.translate(x, y);
            g.setColor(backgroundColor);
            g.fillRect(0, 0, this.iconSize, this.iconSize);
            g.setColor(internalBackgroundColor);
            g.fillRect(4, 11, this.iconSize - 13, this.iconSize - 13);
            g.setColor(lrLightHighlightColor);
            g.drawRect(2, 10, this.iconSize - 10, this.iconSize - 11);
            g.setColor(ulLightHighlightColor);
            g.drawRect(3, 10, this.iconSize - 12, this.iconSize - 12);
            g.setColor(darkHighlightColor);
            g.drawRect(1, 8, this.iconSize - 10, this.iconSize - 10);
            g.drawRect(2, 9, this.iconSize - 12, this.iconSize - 12);
            g.setColor(mainItemColor);
            g.drawRect(2, 9, this.iconSize - 11, this.iconSize - 11);
            g.drawLine(this.iconSize - 10, 10, this.iconSize - 10, 10);
            g.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            g.setColor(mainItemColor);
            g.fillRect(this.iconSize - 7, 3, 3, 5);
            g.drawLine(this.iconSize - 6, 5, this.iconSize - 3, 2);
            g.drawLine(this.iconSize - 6, 6, this.iconSize - 2, 2);
            g.drawLine(this.iconSize - 6, 7, this.iconSize - 3, 7);
            g.setColor(darkHighlightColor);
            g.drawLine(this.iconSize - 8, 2, this.iconSize - 7, 2);
            g.drawLine(this.iconSize - 8, 3, this.iconSize - 8, 7);
            g.drawLine(this.iconSize - 6, 4, this.iconSize - 3, 1);
            g.drawLine(this.iconSize - 4, 6, this.iconSize - 3, 6);
            g.setColor(lrLightHighlightColor);
            g.drawLine(this.iconSize - 6, 3, this.iconSize - 6, 3);
            g.drawLine(this.iconSize - 4, 5, this.iconSize - 2, 3);
            g.drawLine(this.iconSize - 7, 8, this.iconSize - 3, 8);
            g.drawLine(this.iconSize - 2, 8, this.iconSize - 2, 7);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    public static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int kRadioBoxSize = 15;

        public RadioButtonIcon(HueShiftTheme theme) {
            RadioButtonIcon.initializeImageData();
        }

        protected int getControlSize() {
            return 15;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JRadioButton rb = (JRadioButton)c;
            ButtonModel model = rb.getModel();
            if (mMacVendor) {
                if (model.isEnabled()) {
                    if (model.isPressed() && model.isArmed()) {
                        if (model.isSelected()) {
                            this.paintAFroggyStyle(g, c, x, y, mA_CF);
                        } else {
                            this.paintAFroggyStyle(g, c, x, y, mA_UF);
                        }
                    } else if (model.isSelected()) {
                        this.paintAFroggyStyle(g, c, x, y, mA_CE);
                    } else {
                        this.paintAFroggyStyle(g, c, x, y, mA_UE);
                    }
                } else if (model.isSelected()) {
                    this.paintAFroggyStyle(g, c, x, y, mA_CD);
                } else {
                    this.paintAFroggyStyle(g, c, x, y, mA_UD);
                }
            } else if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    if (model.isSelected()) {
                        this.paintFroggyStyle(g, c, x, y, ThemeData.getImageData(rb, "RButton.CF"));
                    } else {
                        this.paintFroggyStyle(g, c, x, y, ThemeData.getImageData(rb, "RButton.UF"));
                    }
                } else if (model.isSelected()) {
                    this.paintFroggyStyle(g, c, x, y, ThemeData.getImageData(rb, "RButton.CE"));
                } else {
                    this.paintFroggyStyle(g, c, x, y, ThemeData.getImageData(rb, "RButton.UE"));
                }
            } else if (model.isSelected()) {
                this.paintFroggyStyle(g, c, x, y, ThemeData.getImageData(rb, "RButton.CD"));
            } else {
                this.paintFroggyStyle(g, c, x, y, ThemeData.getImageData(rb, "RButton.UD"));
            }
        }

        private void paintAFroggyStyle(Graphics g, Component c, int x, int y, Image box) {
            g.drawImage(box, x, y, null);
        }

        private void paintFroggyStyle(Graphics g, Component c, int x, int y, FrogImageData box) {
            g.drawImage(FrogLookAndFeel.getImageFromData((JComponent)c, box), x, y, x + box.getWidth(), y + box.getHeight(), box.getLeft(), box.getTop(), box.getRight(), box.getBottom(), null);
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }

        private static void initializeImageData() {
            m_UE = ThemeData.getImageData(null, "RButton.UE");
            m_CE = ThemeData.getImageData(null, "RButton.CE");
            m_UF = ThemeData.getImageData(null, "RButton.UF");
            m_CF = ThemeData.getImageData(null, "RButton.CF");
            m_UD = ThemeData.getImageData(null, "RButton.UD");
            m_CD = ThemeData.getImageData(null, "RButton.CD");
        }
    }

    private static class TreeComputerIcon
    implements Icon,
    UIResource,
    Serializable {
        TreeComputerIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(FrogLookAndFeel.getPrimaryControl());
            g.fillRect(5, 4, 6, 4);
            g.setColor(FrogLookAndFeel.getPrimaryControlInfo());
            g.drawLine(2, 2, 2, 8);
            g.drawLine(13, 2, 13, 8);
            g.drawLine(3, 1, 12, 1);
            g.drawLine(12, 9, 12, 9);
            g.drawLine(3, 9, 3, 9);
            g.drawLine(4, 4, 4, 7);
            g.drawLine(5, 3, 10, 3);
            g.drawLine(11, 4, 11, 7);
            g.drawLine(5, 8, 10, 8);
            g.drawLine(1, 10, 14, 10);
            g.drawLine(14, 10, 14, 14);
            g.drawLine(1, 14, 14, 14);
            g.drawLine(1, 10, 1, 14);
            g.setColor(FrogLookAndFeel.getControlDarkShadow());
            g.drawLine(6, 12, 8, 12);
            g.drawLine(10, 12, 12, 12);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class TreeHardDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        TreeHardDriveIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(FrogLookAndFeel.getPrimaryControlInfo());
            g.drawLine(1, 4, 1, 5);
            g.drawLine(2, 3, 3, 3);
            g.drawLine(4, 2, 11, 2);
            g.drawLine(12, 3, 13, 3);
            g.drawLine(14, 4, 14, 5);
            g.drawLine(12, 6, 13, 6);
            g.drawLine(4, 7, 11, 7);
            g.drawLine(2, 6, 3, 6);
            g.drawLine(1, 7, 1, 8);
            g.drawLine(2, 9, 3, 9);
            g.drawLine(4, 10, 11, 10);
            g.drawLine(12, 9, 13, 9);
            g.drawLine(14, 7, 14, 8);
            g.drawLine(1, 10, 1, 11);
            g.drawLine(2, 12, 3, 12);
            g.drawLine(4, 13, 11, 13);
            g.drawLine(12, 12, 13, 12);
            g.drawLine(14, 10, 14, 11);
            g.setColor(FrogLookAndFeel.getControlShadow());
            g.drawLine(7, 6, 7, 6);
            g.drawLine(9, 6, 9, 6);
            g.drawLine(10, 5, 10, 5);
            g.drawLine(11, 6, 11, 6);
            g.drawLine(12, 5, 13, 5);
            g.drawLine(13, 4, 13, 4);
            g.drawLine(7, 9, 7, 9);
            g.drawLine(9, 9, 9, 9);
            g.drawLine(10, 8, 10, 8);
            g.drawLine(11, 9, 11, 9);
            g.drawLine(12, 8, 13, 8);
            g.drawLine(13, 7, 13, 7);
            g.drawLine(7, 12, 7, 12);
            g.drawLine(9, 12, 9, 12);
            g.drawLine(10, 11, 10, 11);
            g.drawLine(11, 12, 11, 12);
            g.drawLine(12, 11, 13, 11);
            g.drawLine(13, 10, 13, 10);
            g.setColor(FrogLookAndFeel.getControlHighlight());
            g.drawLine(4, 3, 5, 3);
            g.drawLine(7, 3, 9, 3);
            g.drawLine(11, 3, 11, 3);
            g.drawLine(2, 4, 6, 4);
            g.drawLine(8, 4, 8, 4);
            g.drawLine(2, 5, 3, 5);
            g.drawLine(4, 6, 4, 6);
            g.drawLine(2, 7, 3, 7);
            g.drawLine(2, 8, 3, 8);
            g.drawLine(4, 9, 4, 9);
            g.drawLine(2, 10, 3, 10);
            g.drawLine(2, 11, 3, 11);
            g.drawLine(4, 12, 4, 12);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class TreeFloppyDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        TreeFloppyDriveIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(FrogLookAndFeel.getPrimaryControl());
            g.fillRect(2, 2, 12, 12);
            g.setColor(FrogLookAndFeel.getPrimaryControlInfo());
            g.drawLine(1, 1, 13, 1);
            g.drawLine(14, 2, 14, 14);
            g.drawLine(1, 14, 14, 14);
            g.drawLine(1, 1, 1, 14);
            g.setColor(FrogLookAndFeel.getControlDarkShadow());
            g.fillRect(5, 2, 6, 5);
            g.drawLine(4, 8, 11, 8);
            g.drawLine(3, 9, 3, 13);
            g.drawLine(12, 9, 12, 13);
            g.setColor(FrogLookAndFeel.getPrimaryControlHighlight());
            g.fillRect(8, 3, 2, 3);
            g.fillRect(4, 9, 8, 5);
            g.setColor(FrogLookAndFeel.getPrimaryControlShadow());
            g.drawLine(5, 10, 9, 10);
            g.drawLine(5, 12, 8, 12);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    public static class FolderIcon16
    implements Icon,
    Serializable {
        transient Image folderIcon;
        protected FrogImageData mIconImageData;
        protected boolean mFolderIcon16MacVendor;

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            this.paintMe(c, g, x, y);
            g.translate(-x, -y);
        }

        protected void paintMe(Component c, Graphics g, int x, int y) {
            g.drawImage(this.folderIcon, 0, 0, null, null);
        }

        public int getIconWidth() {
            return folderIcon16Size.width;
        }

        public int getIconHeight() {
            return folderIcon16Size.height + this.getAdditionalHeight();
        }
    }

    public static class TreeFolderIcon
    extends FolderIcon16 {
        public TreeFolderIcon(HueShiftTheme theme) {
            this.initialize(theme);
        }

        public int getIconWidth() {
            return ThemeData.getImageData(null, "Tree.Folder").getWidth();
        }

        public int getIconHeight() {
            return ThemeData.getImageData(null, "Tree.Folder").getHeight();
        }

        protected void paintMe(Component c, Graphics g, int x, int y) {
            JComponent jc;
            JComponent jComponent = jc = c instanceof JComponent ? (JComponent)c : new JComponent(this){
                final /* synthetic */ TreeFolderIcon this$1;
                {
                    this.this$1 = treeFolderIcon;
                }
            };
            if (!this.mFolderIcon16MacVendor) {
                g.drawImage(FrogLookAndFeel.getImageFromData(jc, this.mIconImageData), 0, 0, this.getIconWidth(), this.getIconHeight(), this.mIconImageData.getLeft(), this.mIconImageData.getTop(), this.mIconImageData.getRight(), this.mIconImageData.getBottom(), null);
            } else {
                super.paintMe(c, g, x, y);
            }
        }

        private void initialize(HueShiftTheme theme) {
            this.mIconImageData = ThemeData.getImageData(null, "Tree.Folder");
        }
    }

    public static class TreeOpenIcon
    extends FolderIcon16 {
        public TreeOpenIcon(HueShiftTheme theme) {
            this.initialize(theme);
        }

        public int getIconWidth() {
            return ThemeData.getImageData(null, "Tree.Leaf").getWidth();
        }

        public int getIconHeight() {
            return ThemeData.getImageData(null, "Tree.Leaf").getHeight();
        }

        protected void paintMe(Component c, Graphics g, int x, int y) {
            if (!this.mFolderIcon16MacVendor) {
                JComponent jc = c instanceof JComponent ? (JComponent)c : new JComponent(this){
                    final /* synthetic */ TreeOpenIcon this$1;
                    {
                        this.this$1 = treeOpenIcon;
                    }
                };
                g.drawImage(FrogLookAndFeel.getImageFromData(jc, this.mIconImageData), 0, 0, this.getIconWidth(), this.getIconHeight(), this.mIconImageData.getLeft(), this.mIconImageData.getTop(), this.mIconImageData.getRight(), this.mIconImageData.getBottom(), null);
            } else {
                super.paintMe(c, g, x, y);
            }
        }

        private void initialize(HueShiftTheme theme) {
            this.mIconImageData = ThemeData.getImageDataFromThemeName(theme.getName(), "Tree.Leaf");
        }
    }

    public static class FileIcon16
    implements Icon,
    Serializable {
        transient Image image;
        transient Color cachedBackground;

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color background = c.getBackground();
            if (this.image == null || !this.cachedBackground.equals(background)) {
                this.cachedBackground = background;
                this.image = c.createImage(this.getIconWidth(), this.getIconHeight());
                Graphics imageG = this.image.getGraphics();
                this.paintMe(c, imageG);
            }
            g.drawImage(this.image, x, y + this.getShift(), null);
        }

        private void paintMe(Component c, Graphics g) {
            int right = fileIcon16Size.width - 1;
            int bottom = fileIcon16Size.height - 1;
            g.setColor(this.cachedBackground);
            g.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
            g.setColor(FrogLookAndFeel.getWindowBackground());
            g.fillRect(4, 2, 9, 12);
            g.setColor(FrogLookAndFeel.getPrimaryControlInfo());
            g.drawLine(2, 0, 2, bottom);
            g.drawLine(2, 0, right - 4, 0);
            g.drawLine(2, bottom, right - 1, bottom);
            g.drawLine(right - 1, 6, right - 1, bottom);
            g.drawLine(right - 6, 2, right - 2, 6);
            g.drawLine(right - 5, 1, right - 4, 1);
            g.drawLine(right - 3, 2, right - 3, 3);
            g.drawLine(right - 2, 4, right - 2, 5);
            g.setColor(FrogLookAndFeel.getPrimaryControl());
            g.drawLine(3, 1, 3, bottom - 1);
            g.drawLine(3, 1, right - 6, 1);
            g.drawLine(right - 2, 7, right - 2, bottom - 1);
            g.drawLine(right - 5, 2, right - 3, 4);
            g.drawLine(3, bottom - 1, right - 2, bottom - 1);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return fileIcon16Size.width;
        }

        public int getIconHeight() {
            return fileIcon16Size.height + this.getAdditionalHeight();
        }
    }

    public static class TreeLeafIcon
    extends FolderIcon16 {
        JLabel label = null;
        Component comp;

        public TreeLeafIcon(HueShiftTheme theme) {
            this.initialize(theme);
        }

        public int getIconWidth() {
            return ThemeData.getImageData(null, "Tree.OpenFolder").getWidth();
        }

        public int getIconHeight() {
            return ThemeData.getImageData(null, "Tree.OpenFolder").getHeight();
        }

        protected void paintMe(Component c, Graphics g, int x, int y) {
            JComponent jc;
            JComponent jComponent = jc = c instanceof JComponent ? (JComponent)c : new JComponent(this){
                final /* synthetic */ TreeLeafIcon this$1;
                {
                    this.this$1 = treeLeafIcon;
                }
            };
            if (!this.mFolderIcon16MacVendor) {
                g.drawImage(FrogLookAndFeel.getImageFromData(jc, this.mIconImageData), 0, 0, this.getIconWidth(), this.getIconHeight(), this.mIconImageData.getLeft(), this.mIconImageData.getTop(), this.mIconImageData.getLeft() + this.getIconWidth(), this.mIconImageData.getTop() + this.getIconHeight(), null);
            } else {
                super.paintMe(c, g, x, y);
            }
        }

        private void initialize(HueShiftTheme theme) {
            this.mIconImageData = ThemeData.getImageDataFromThemeName(theme.getName(), "Tree.OpenFolder");
        }
    }

    public static class TreeControlIcon
    implements Icon,
    Serializable {
        protected boolean isLight;
        private static transient Image collapsedIcon;
        private static transient Image expandedIcon;
        private static FrogImageData mTreeOpenToggle;
        private static FrogImageData mTreeCloseToggle;

        static {
            mTreeOpenToggle = null;
            mTreeCloseToggle = null;
        }

        public TreeControlIcon(boolean isCollapsed, HueShiftTheme theme) {
            this.isLight = isCollapsed;
            if (mTreeOpenToggle == null || mTreeCloseToggle == null) {
                TreeControlIcon.initializeImageData();
            }
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            this.paintMe(c, g, x, y);
            g.translate(-x, -y);
        }

        public void paintMe(Component c, Graphics g, int x, int y) {
            if (this.isLight) {
                g.drawImage(FrogLookAndFeel.getImageFromData((JComponent)c, mTreeCloseToggle), 5, 3, 5 + mTreeCloseToggle.getWidth(), 3 + mTreeCloseToggle.getHeight(), mTreeCloseToggle.getLeft(), mTreeCloseToggle.getTop(), mTreeCloseToggle.getRight(), mTreeCloseToggle.getBottom(), null, null);
            } else {
                g.drawImage(FrogLookAndFeel.getImageFromData((JComponent)c, mTreeOpenToggle), 2, 4, 2 + mTreeOpenToggle.getWidth(), 4 + mTreeOpenToggle.getHeight(), mTreeOpenToggle.getLeft(), mTreeOpenToggle.getTop(), mTreeOpenToggle.getRight(), mTreeOpenToggle.getBottom(), null, null);
            }
        }

        private static void initializeImageData() {
            mTreeCloseToggle = ThemeData.getImageData(null, "Tree.CloseToggle");
            mTreeOpenToggle = ThemeData.getImageData(null, "Tree.OpenToggle");
        }

        public int getIconWidth() {
            return treeControlSize.width;
        }

        public int getIconHeight() {
            return treeControlSize.height;
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private static boolean mMacVendor = false;

        public MenuArrowIcon() {
            MenuArrowIcon.initializeImageData();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            if (mMacVendor) {
                if (!model.isEnabled()) {
                    g.setColor(SystemHueShift.getColor((JComponent)b, "Menu.disabledForeground"));
                    g.drawImage(SystemHueShift.getCropImage((JComponent)c, mArrowRight_D), x, y, null);
                } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(FrogLookAndFeel.getMenuSelectedForeground());
                    g.drawImage(SystemHueShift.getCropImage((JComponent)c, ThemeData.getImageData(b, "PopupMenu.ArrowRight.E")), x, y, null);
                } else {
                    g.setColor(b.getForeground());
                    g.drawImage(SystemHueShift.getCropImage((JComponent)c, ThemeData.getImageData(b, "PopupMenu.ArrowRight.E")), x, y, null);
                }
            } else if (!model.isEnabled()) {
                g.setColor(Color.red);
                g.drawImage(FrogLookAndFeel.getImageFromData((JComponent)c, mArrowRight_D), x, y, x + mArrowRight_D.getWidth(), y + mArrowRight_D.getHeight(), mArrowRight_D.getLeft(), mArrowRight_D.getTop(), mArrowRight_D.getRight(), mArrowRight_D.getBottom(), null);
            } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(Color.green);
                g.drawImage(FrogLookAndFeel.getImageFromData((JComponent)c, ThemeData.getImageData(b, "PopupMenu.ArrowRight.E")), x, y, x + ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getWidth(), y + ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getHeight(), ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getLeft(), ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getTop(), ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getRight(), ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getBottom(), null);
            } else {
                g.setColor(Color.blue);
                g.drawImage(FrogLookAndFeel.getImageFromData((JComponent)c, ThemeData.getImageData(b, "PopupMenu.ArrowRight.E")), x, y, x + ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getWidth(), y + ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getHeight(), ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getLeft(), ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getTop(), ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getRight(), ThemeData.getImageData(b, "PopupMenu.ArrowRight.E").getBottom(), null);
            }
        }

        public int getIconWidth() {
            return menuArrowIconSize.width;
        }

        public int getIconHeight() {
            return menuArrowIconSize.height;
        }

        private static void initializeImageData() {
            mArrowRight_E = ThemeData.getImageData(null, "PopupMenu.ArrowRight.E");
            mArrowRight_D = ThemeData.getImageData(null, "PopupMenu.ArrowRight.D");
        }
    }

    private static class MenuItemCheckIcon
    implements Icon,
    UIResource,
    Serializable {
        private static boolean mMacVendor = false;

        public MenuItemCheckIcon() {
            MenuItemCheckIcon.initializeImageData();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (mMacVendor) {
                if (c instanceof JCheckBoxMenuItem && ((JCheckBoxMenuItem)c).getState()) {
                    JMenuItem b = (JMenuItem)c;
                    ButtonModel model = b.getModel();
                    if (!model.isEnabled()) {
                        g.setColor(SystemHueShift.getColor((JComponent)b, "Menu.disabledForeground"));
                        g.drawImage(SystemHueShift.getCropImage((JComponent)c, mCheck_D), x, y, null);
                    } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                        g.setColor(FrogLookAndFeel.getMenuSelectedForeground());
                        g.drawImage(SystemHueShift.getCropImage((JComponent)c, mCheck_E), x, y, null);
                    } else {
                        g.setColor(b.getForeground());
                        g.drawImage(SystemHueShift.getCropImage((JComponent)c, mCheck_E), x, y, null);
                    }
                }
            } else if (c instanceof JCheckBoxMenuItem && ((JCheckBoxMenuItem)c).getState()) {
                JMenuItem b = (JMenuItem)c;
                ButtonModel model = b.getModel();
                if (!model.isEnabled()) {
                    g.setColor(SystemHueShift.getColor((JComponent)b, "Menu.disabledForeground"));
                    g.drawImage(FrogLookAndFeel.getImageFromData((JComponent)c, mCheck_D), x, y, x + mCheck_D.getWidth(), y + mCheck_D.getHeight(), mCheck_D.getLeft(), mCheck_D.getTop(), mCheck_D.getRight(), mCheck_D.getBottom(), null);
                } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(FrogLookAndFeel.getMenuSelectedForeground());
                    g.drawImage(FrogLookAndFeel.getImageFromData((JComponent)c, mCheck_E), x, y, x + mCheck_E.getWidth(), y + mCheck_E.getHeight(), mCheck_E.getLeft(), mCheck_E.getTop(), mCheck_E.getRight(), mCheck_E.getBottom(), null);
                } else {
                    g.setColor(b.getForeground());
                    g.drawImage(FrogLookAndFeel.getImageFromData((JComponent)c, mCheck_E), x, y, x + mCheck_E.getWidth(), y + mCheck_E.getHeight(), mCheck_E.getLeft(), mCheck_E.getTop(), mCheck_E.getRight(), mCheck_E.getBottom(), null);
                }
            }
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }

        private static void initializeImageData() {
            mCheck_E = ThemeData.getImageData(null, "MainMenu.Check.E");
            mCheck_D = ThemeData.getImageData(null, "MainMenu.Check.D");
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        MenuItemArrowIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return menuArrowIconSize.width;
        }

        public int getIconHeight() {
            return menuArrowIconSize.height;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        CheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x + 4, y);
            if (isEnabled) {
                if (isPressed || isArmed) {
                    g.setColor(FrogLookAndFeel.getControlInfo());
                    g.drawLine(0, 0, 8, 0);
                    g.drawLine(0, 0, 0, 8);
                    g.drawLine(8, 2, 8, 8);
                    g.drawLine(2, 8, 8, 8);
                    g.setColor(FrogLookAndFeel.getPrimaryControl());
                    g.drawLine(1, 1, 7, 1);
                    g.drawLine(1, 1, 1, 7);
                    g.drawLine(9, 1, 9, 9);
                    g.drawLine(1, 9, 9, 9);
                } else {
                    g.setColor(FrogLookAndFeel.getControlDarkShadow());
                    g.drawLine(0, 0, 8, 0);
                    g.drawLine(0, 0, 0, 8);
                    g.drawLine(8, 2, 8, 8);
                    g.drawLine(2, 8, 8, 8);
                    g.setColor(FrogLookAndFeel.getControlHighlight());
                    g.drawLine(1, 1, 7, 1);
                    g.drawLine(1, 1, 1, 7);
                    g.drawLine(9, 1, 9, 9);
                    g.drawLine(1, 9, 9, 9);
                }
            } else {
                g.setColor(SystemHueShift.getColor((JComponent)b, "Menu.disabledForeground"));
                g.drawRect(0, 0, 8, 8);
            }
            if (isSelected) {
                if (isEnabled) {
                    if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                        g.setColor(FrogLookAndFeel.getMenuSelectedForeground());
                    } else {
                        g.setColor(b.getForeground());
                    }
                } else {
                    g.setColor(SystemHueShift.getColor((JComponent)b, "Menu.disabledForeground"));
                }
                g.drawLine(2, 2, 2, 6);
                g.drawLine(3, 2, 3, 6);
                g.drawLine(4, 4, 8, 0);
                g.drawLine(4, 5, 9, 0);
            }
            g.translate(-(x + 4), -y);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        RadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x + 4, y);
            if (isEnabled) {
                if (isPressed || isArmed) {
                    g.setColor(FrogLookAndFeel.getPrimaryControl());
                    g.drawLine(3, 1, 8, 1);
                    g.drawLine(2, 9, 7, 9);
                    g.drawLine(1, 3, 1, 8);
                    g.drawLine(9, 2, 9, 7);
                    g.drawLine(2, 2, 2, 2);
                    g.drawLine(8, 8, 8, 8);
                    g.setColor(FrogLookAndFeel.getControlInfo());
                    g.drawLine(2, 0, 6, 0);
                    g.drawLine(2, 8, 6, 8);
                    g.drawLine(0, 2, 0, 6);
                    g.drawLine(8, 2, 8, 6);
                    g.drawLine(1, 1, 1, 1);
                    g.drawLine(7, 1, 7, 1);
                    g.drawLine(1, 7, 1, 7);
                    g.drawLine(7, 7, 7, 7);
                } else {
                    g.setColor(FrogLookAndFeel.getControlHighlight());
                    g.drawLine(3, 1, 8, 1);
                    g.drawLine(2, 9, 7, 9);
                    g.drawLine(1, 3, 1, 8);
                    g.drawLine(9, 2, 9, 7);
                    g.drawLine(2, 2, 2, 2);
                    g.drawLine(8, 8, 8, 8);
                    g.setColor(FrogLookAndFeel.getControlDarkShadow());
                    g.drawLine(2, 0, 6, 0);
                    g.drawLine(2, 8, 6, 8);
                    g.drawLine(0, 2, 0, 6);
                    g.drawLine(8, 2, 8, 6);
                    g.drawLine(1, 1, 1, 1);
                    g.drawLine(7, 1, 7, 1);
                    g.drawLine(1, 7, 1, 7);
                    g.drawLine(7, 7, 7, 7);
                }
            } else {
                g.setColor(SystemHueShift.getColor((JComponent)b, "Menu.disabledForeground"));
                g.drawLine(2, 0, 6, 0);
                g.drawLine(2, 8, 6, 8);
                g.drawLine(0, 2, 0, 6);
                g.drawLine(8, 2, 8, 6);
                g.drawLine(1, 1, 1, 1);
                g.drawLine(7, 1, 7, 1);
                g.drawLine(1, 7, 1, 7);
                g.drawLine(7, 7, 7, 7);
            }
            if (isSelected) {
                if (isEnabled) {
                    if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                        g.setColor(FrogLookAndFeel.getMenuSelectedForeground());
                    } else {
                        g.setColor(b.getForeground());
                    }
                } else {
                    g.setColor(SystemHueShift.getColor((JComponent)b, "Menu.disabledForeground"));
                }
                g.drawLine(3, 2, 5, 2);
                g.drawLine(2, 3, 6, 3);
                g.drawLine(2, 4, 6, 4);
                g.drawLine(2, 5, 6, 5);
                g.drawLine(3, 6, 5, 6);
            }
            g.translate(-(x + 4), -y);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    private static class VerticalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        protected static FrogBumps controlBumps;
        protected static FrogBumps primaryBumps;

        public VerticalSliderThumbIcon() {
            controlBumps = new FrogBumps(6, 10, FrogLookAndFeel.getControlHighlight(), FrogLookAndFeel.getControlInfo(), FrogLookAndFeel.getControl());
            primaryBumps = new FrogBumps(6, 10, FrogLookAndFeel.getPrimaryControl(), FrogLookAndFeel.getPrimaryControlDarkShadow(), FrogLookAndFeel.getPrimaryControlShadow());
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JSlider slider = (JSlider)c;
            g.translate(x, y);
            if (slider.hasFocus()) {
                g.setColor(FrogLookAndFeel.getPrimaryControlInfo());
            } else {
                g.setColor(slider.isEnabled() ? FrogLookAndFeel.getPrimaryControlInfo() : FrogLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(1, 0, 8, 0);
            g.drawLine(0, 1, 0, 13);
            g.drawLine(1, 14, 8, 14);
            g.drawLine(9, 1, 15, 7);
            g.drawLine(9, 13, 15, 7);
            if (slider.hasFocus()) {
                g.setColor(c.getForeground());
            } else {
                g.setColor(FrogLookAndFeel.getControl());
            }
            g.fillRect(1, 1, 8, 13);
            g.drawLine(9, 2, 9, 12);
            g.drawLine(10, 3, 10, 11);
            g.drawLine(11, 4, 11, 10);
            g.drawLine(12, 5, 12, 9);
            g.drawLine(13, 6, 13, 8);
            g.drawLine(14, 7, 14, 7);
            if (slider.isEnabled()) {
                if (slider.hasFocus()) {
                    primaryBumps.paintIcon(c, g, 2, 2);
                } else {
                    controlBumps.paintIcon(c, g, 2, 2);
                }
            }
            if (slider.isEnabled()) {
                g.setColor(slider.hasFocus() ? FrogLookAndFeel.getPrimaryControl() : FrogLookAndFeel.getControlHighlight());
                g.drawLine(1, 1, 8, 1);
                g.drawLine(1, 1, 1, 13);
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 15;
        }
    }

    private static class HorizontalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        protected static FrogBumps controlBumps;
        protected static FrogBumps primaryBumps;

        public HorizontalSliderThumbIcon() {
            controlBumps = new FrogBumps(10, 6, FrogLookAndFeel.getControlHighlight(), FrogLookAndFeel.getControlInfo(), FrogLookAndFeel.getControl());
            primaryBumps = new FrogBumps(10, 6, FrogLookAndFeel.getPrimaryControl(), FrogLookAndFeel.getPrimaryControlDarkShadow(), FrogLookAndFeel.getPrimaryControlShadow());
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JSlider slider = (JSlider)c;
            g.translate(x, y);
            if (slider.hasFocus()) {
                g.setColor(FrogLookAndFeel.getPrimaryControlInfo());
            } else {
                g.setColor(slider.isEnabled() ? FrogLookAndFeel.getPrimaryControlInfo() : FrogLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(1, 0, 13, 0);
            g.drawLine(0, 1, 0, 8);
            g.drawLine(14, 1, 14, 8);
            g.drawLine(1, 9, 7, 15);
            g.drawLine(7, 15, 14, 8);
            if (slider.hasFocus()) {
                g.setColor(c.getForeground());
            } else {
                g.setColor(FrogLookAndFeel.getControl());
            }
            g.fillRect(1, 1, 13, 8);
            g.drawLine(2, 9, 12, 9);
            g.drawLine(3, 10, 11, 10);
            g.drawLine(4, 11, 10, 11);
            g.drawLine(5, 12, 9, 12);
            g.drawLine(6, 13, 8, 13);
            g.drawLine(7, 14, 7, 14);
            if (slider.isEnabled()) {
                if (slider.hasFocus()) {
                    primaryBumps.paintIcon(c, g, 2, 2);
                } else {
                    controlBumps.paintIcon(c, g, 2, 2);
                }
            }
            if (slider.isEnabled()) {
                g.setColor(slider.hasFocus() ? FrogLookAndFeel.getPrimaryControl() : FrogLookAndFeel.getControlHighlight());
                g.drawLine(1, 1, 13, 1);
                g.drawLine(1, 1, 1, 8);
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 16;
        }
    }
}

