/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.GroupBox;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.UIResource;

public class FrogGroupBoxUI
extends PanelUI {
    public static final String __PerforceId = "$Id: //javagui/700_COR/src/java/com/sap/plaf/frog/FrogGroupBoxUI.java#1 $";
    private static final FrogGroupBoxUI mFrogGroupBoxUI = new FrogGroupBoxUI();
    private static int mTextGap = 7;

    public static ComponentUI createUI(JComponent c) {
        return mFrogGroupBoxUI;
    }

    public void installUI(JComponent c) {
        GroupBox b = (GroupBox)c;
        super.installUI(c);
        this.installDefaults(b);
    }

    protected void installDefaults(GroupBox b) {
        Color bg = b.getBackground();
        if (bg == null || bg instanceof UIResource) {
            b.setBackground(UIManager.getColor("GroupBox.background"));
        }
        LookAndFeel.installBorder(b, "GroupBox.border");
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults((GroupBox)c);
    }

    protected void uninstallDefaults(GroupBox b) {
        LookAndFeel.uninstallBorder(b);
        b.setBackground(null);
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(UIManager.getColor("GroupBox.background"));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    public void paint(Graphics gc, JComponent c) {
        FontMetrics fm = gc.getFontMetrics();
        int ascent = fm.getAscent();
        String text = ((GroupBox)c).getText();
        if (text != null && !text.equals("")) {
            Polygon textFrame = new Polygon();
            int y1 = 1;
            int x1 = 1;
            textFrame.addPoint(x1, y1);
            textFrame.addPoint(fm.stringWidth(text) + mTextGap + ascent + ascent / 2, y1);
            textFrame.addPoint(fm.stringWidth(text) + mTextGap, ascent + ascent / 2);
            textFrame.addPoint(x1, ascent + ascent / 2);
            gc.setClip(gc.getClipBounds().x, gc.getClipBounds().y, gc.getClipBounds().width, gc.getClipBounds().height);
            gc.setColor(UIManager.getColor("GroupBox.textBackground"));
            gc.fillPolygon(textFrame);
            gc.setColor(UIManager.getColor("GroupBox.textBorderColor"));
            gc.drawLine(0, ascent + ascent / 2, fm.stringWidth(text) + mTextGap, ascent + ascent / 2);
            gc.drawLine(fm.stringWidth(text) + mTextGap, ascent + ascent / 2, fm.stringWidth(text) + mTextGap + ascent + ascent / 2, 0);
            gc.setColor(((GroupBox)c).getForeground());
            gc.drawString(text, mTextGap, ascent + 1);
            gc.setColor(UIManager.getColor("GroupBox.textBorderColor"));
        }
    }
}

