/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.ByteImage;
import com.sap.plaf.frog.FrogGIFImageFilter;
import com.sap.plaf.frog.FrogImageData;
import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.ImageModel;
import com.sap.plaf.frog.hueshift.FrogHueShift;
import com.sap.plaf.frog.hueshift.HueShiftTheme;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;

public class FrogGIFReader
extends Component {
    public static final String __PerforceId = "$Id$";
    private static FrogGIFImageFilter mImageFilter;
    public static IndexColorModel mColorModel;
    private static boolean mHueShiftOfDefaultTheme;
    private static Hashtable mImageHolder;
    protected static Hashtable mByteImageHolder;
    private static boolean mTrace;
    protected static FrogGIFReader mFrogGIFReader;
    static /* synthetic */ Class class$0;

    static {
        mColorModel = null;
        mHueShiftOfDefaultTheme = false;
        mImageHolder = new Hashtable(9);
        mByteImageHolder = new Hashtable(9);
        mTrace = false;
    }

    public FrogGIFReader() {
        mFrogGIFReader = this;
    }

    public FrogGIFReader(JComponent c) {
    }

    public static String calculateLocalPath(HueShiftTheme theme, String path) {
        String newPath = "";
        newPath = theme.getRootThemeName().equals("Streamline") ? "resources/2002/images/" + path.substring(9, path.indexOf("bmp")) + "gif" : (theme.getRootThemeName().equals("Tradeshow") ? "resources/tradeshow/images/" + path.substring(9, path.indexOf("bmp")) + "gif" : "resources/default/images/" + path.substring(9, path.indexOf("bmp")) + "gif");
        return newPath;
    }

    public static void calculateNewColorModel(boolean recalc) {
        mHueShiftOfDefaultTheme = recalc;
    }

    public static Image getImage(JComponent c, String path) {
        return FrogGIFReader.getRequestedImage(SystemHueShift.getDisplayedTheme(c), FrogGIFReader.calculateLocalPath(SystemHueShift.getDisplayedTheme(c), path));
    }

    public static Image getImageForComp(JComponent c, String path) {
        String localPath = null;
        localPath = FrogGIFReader.calculateLocalPath(SystemHueShift.getDisplayedTheme(c), path);
        return FrogGIFReader.getRequestedImage(SystemHueShift.getDisplayedTheme(c), localPath);
    }

    protected static Image getRequestedImage(HueShiftTheme theme, String path) {
        HueShiftTheme requestedTheme = theme;
        String localPath = path;
        String pathEntry = path;
        if (requestedTheme == null) {
            requestedTheme = FrogHueShift.getCurrentTheme();
        }
        pathEntry = String.valueOf(requestedTheme.getName()) + "." + path;
        if (mHueShiftOfDefaultTheme) {
            Enumeration e = mImageHolder.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!requestedTheme.isMaskedAsDefaultTheme()) continue;
                mImageHolder.remove(key);
            }
            FrogGIFImageFilter.calculateNewColorModel(false);
        }
        if (mImageHolder.get(pathEntry) == null) {
            FrogGIFImageFilter.setTheme(requestedTheme);
            if (path.endsWith("saptbgnd.gif")) {
                FrogGIFImageFilter.takeThemeColors(false);
            }
            FrogGIFImageFilter.calculateNewColorModel(true);
            Image imagehelper = FrogGIFReader.loadImage(localPath);
            ImageModel imageModel = new ImageModel(imagehelper, mColorModel);
            mImageHolder.put(pathEntry, imageModel);
            if (path.equals("file://./saptbgnd.bmp")) {
                FrogGIFImageFilter.takeThemeColors(true);
                FrogGIFImageFilter.setFrogColorModel(mColorModel);
            }
            FrogGIFImageFilter.calculateNewColorModel(false);
            FrogGIFReader.calculateNewColorModel(false);
        } else {
            if (mColorModel != ((ImageModel)mImageHolder.get(pathEntry)).getModel()) {
                FrogGIFReader.setColorModel(((ImageModel)mImageHolder.get(pathEntry)).getModel());
            }
            FrogGIFImageFilter.setFrogColorModel(mColorModel);
        }
        return ((ImageModel)mImageHolder.get(pathEntry)).getImage();
    }

    public static synchronized Image getCropImage(JComponent c, FrogImageData data) {
        return FrogGIFReader.getCropImage(SystemHueShift.getDisplayedTheme(c), data.getLeft(), data.getTop(), data.getRight(), data.getBottom(), data.getPath());
    }

    public static synchronized Image getCropImage(HueShiftTheme theme, int left, int top, int right, int bottom, String path) {
        if (mTrace) {
            System.err.println("GIFReader.getCropImage: theme: " + theme + " left: " + left + " top: " + top + " right: " + right + " bottom: " + bottom + " path: " + path);
        }
        FrogGIFReader cd = mFrogGIFReader;
        MediaTracker mediaTracker = new MediaTracker(cd);
        ImageProducer ip = FrogGIFReader.getRequestedImage(theme, FrogGIFReader.calculateLocalPath(theme, path)).getSource();
        CropImageFilter imgf = new CropImageFilter(left, top, right - left, bottom - top);
        ip = new FilteredImageSource(ip, imgf);
        Image cropImage = Toolkit.getDefaultToolkit().createImage(ip);
        try {
            mediaTracker.addImage(cropImage, 0);
            mediaTracker.waitForID(0);
        }
        catch (Exception e) {
            System.err.println("FrogGIFReader.read: Can't create cropped image");
            e.printStackTrace();
        }
        return cropImage;
    }

    public static Image getCropImage(int left, int top, int right, int bottom, String path) {
        return FrogGIFReader.getCropImage(FrogHueShift.getCurrentTheme(), left, top, right, bottom, path);
    }

    public static final ColorUIResource getColor(int index) {
        if (mColorModel != null) {
            return new ColorUIResource(mColorModel.getRGB(index));
        }
        return null;
    }

    public static ColorUIResource getColor(JComponent c, int index) {
        if (index >= 73 && index <= 95) {
            return SystemHueShift.getColor(c, index);
        }
        return FrogGIFReader.getColor(index);
    }

    public static ColorUIResource getColor(JComponent c, String path, int x, int y) {
        int paletteIndex = 0;
        FrogLookAndFeel.getImageForComp(c, path);
        ByteImage data = (ByteImage)mByteImageHolder.get(FrogGIFReader.calculateLocalPath(SystemHueShift.getDisplayedTheme(c), path));
        if (data != null) {
            paletteIndex = data.getByte(y * data.getWidth() + x);
        }
        if (FrogGIFReader.isTrace()) {
            System.err.println("FrogGIFReader.getColor()   imagePath: " + path + "   ByteImage: " + data + "   paletteIndex: " + paletteIndex + "x: " + x + " y:" + y);
        }
        if (paletteIndex <= 0 || paletteIndex > 255) {
            paletteIndex = 0;
        }
        if (mColorModel != null && mColorModel.getAlpha(paletteIndex) == 0) {
            return null;
        }
        return FrogGIFReader.getColor(c, paletteIndex);
    }

    public static void setColorModel(IndexColorModel model) {
        if (new Color(model.getRGB(75)).getRed() != 0 && model != mColorModel) {
            mColorModel = model;
        }
    }

    public static Image loadImage(String path) {
        FrogGIFReader cd = new FrogGIFReader();
        MediaTracker mediaTracker = new MediaTracker(cd);
        Image pictImage = null;
        URL url = null;
        try {
            url = cd.getClass().getResource(path);
            if (url == null) {
                ClassLoader loader;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sap.plaf.frog.FrogGIFReader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                url = (loader = clazz.getClassLoader()) == null ? ClassLoader.getSystemResource(path) : loader.getResource(path);
            }
            ImageProducer ip = (ImageProducer)url.getContent();
            FrogGIFImageFilter imgf = new FrogGIFImageFilter(cd, path);
            ip = new FilteredImageSource(ip, imgf);
            pictImage = cd.createImage(ip, path);
            mediaTracker.addImage(pictImage, 0);
            mediaTracker.waitForID(0);
        }
        catch (Exception e) {
            System.err.println("FrogGIFReader.initialize: " + path + " Can't read image from file");
            e.printStackTrace();
        }
        return pictImage;
    }

    public static void storeImageAsByteArray(String imagePath, byte[] b, int w, int h) {
        if (mByteImageHolder.get(imagePath) == null) {
            if (mTrace) {
                System.err.println("FrogGIFReader.storeImageAsByteArray()   imagePath: " + imagePath + "   imageHeight: " + h);
            }
            mByteImageHolder.put(imagePath, new ByteImage(b, w, h));
        }
    }

    public static boolean hasByteImage(String imagePath) {
        return mByteImageHolder.get(imagePath) != null;
    }

    public static boolean isTrace() {
        return mTrace;
    }

    public static void uninitialize() {
        mColorModel = null;
        mHueShiftOfDefaultTheme = false;
        mImageHolder = new Hashtable(9);
        mByteImageHolder = new Hashtable(9);
    }

    public Image createImage(ImageProducer ip, String path) {
        return super.createImage(ip);
    }
}

