/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogGIFReader;
import com.sap.plaf.frog.hueshift.HueShiftTheme;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RGBImageFilter;
import javax.swing.plaf.ColorUIResource;

public class FrogGIFImageFilter
extends RGBImageFilter {
    public static final String __PerforceId = "$Id$";
    static FrogGIFReader mFrogReader = null;
    static IndexColorModel mCurrentColorModel = null;
    static boolean mCanColorModelCalculated = true;
    static boolean mTakeThemeColors = true;
    static boolean mCalculatePreview = false;
    boolean mImageComplete = false;
    String mImagePath = null;
    byte[] mBytePixels;
    int mImageWidth;
    int mImageHeight;
    static ColorUIResource[] mThemeColors = null;
    static ColorUIResource[] mPreviewColors = null;

    public FrogGIFImageFilter(FrogGIFReader reader, String imagePath) {
        this.canFilterIndexColorModel = true;
        this.mImagePath = imagePath;
        if (mFrogReader == null) {
            mFrogReader = reader;
        }
    }

    public static void calculateNewColorModel(boolean calculate) {
        mCanColorModelCalculated = calculate;
    }

    public static void calculatePreview(boolean calculate) {
        mCalculatePreview = calculate;
    }

    public static void takeThemeColors(boolean takeTheme) {
        mTakeThemeColors = takeTheme;
    }

    public static void setTheme(HueShiftTheme newTheme) {
        mThemeColors = newTheme.getColors();
    }

    public static void setPreviewTheme(HueShiftTheme previewTheme) {
        mPreviewColors = previewTheme.getColors();
    }

    public IndexColorModel filterIndexColorModel(IndexColorModel model) {
        if (mCanColorModelCalculated) {
            mCurrentColorModel = this.calculateColorModel(model, mThemeColors);
            if (mFrogReader != null && mCurrentColorModel != null) {
                FrogGIFReader.setColorModel(mCurrentColorModel);
            }
            FrogGIFImageFilter.calculateNewColorModel(false);
            FrogGIFImageFilter.takeThemeColors(true);
        } else if (mCalculatePreview) {
            FrogGIFImageFilter.calculatePreview(false);
            return this.calculateColorModel(model, mPreviewColors);
        }
        return mCurrentColorModel;
    }

    public int filterRGB(int x, int y, int rgb) {
        return rgb;
    }

    public void filterRGBPixels(int x, int y, int w, int h, int[] pixels, int offset, int scansize) {
        super.filterRGBPixels(x, y, w, h, pixels, offset, scansize);
    }

    public synchronized void setPixels(int srcX, int srcY, int srcW, int srcH, ColorModel srcModel, byte[] srcPixels, int srcOff, int srcScan) {
        if (!FrogGIFReader.hasByteImage(this.mImagePath)) {
            if (this.mBytePixels == null) {
                this.mBytePixels = new byte[this.mImageWidth * this.mImageHeight];
            }
            int x = srcX;
            while (x < srcX + srcW) {
                int y = srcY;
                while (y < srcY + srcH) {
                    this.mBytePixels[y * this.mImageWidth + x] = srcPixels[(y - srcY) * srcScan + (x - srcX) + srcOff];
                    ++y;
                }
                ++x;
            }
        }
        if (FrogGIFReader.isTrace()) {
            System.err.println("FrogGIFImageFilter.setPixels()   this: " + this + "   mPixels: " + this.mBytePixels + " mImageWidth: " + this.mImageWidth + " mImageHeight: " + this.mImageHeight);
        }
        super.setPixels(srcX, srcY, srcW, srcH, srcModel, srcPixels, srcOff, srcScan);
    }

    public void setDimensions(int width, int height) {
        this.mImageWidth = width;
        this.mImageHeight = height;
        super.setDimensions(width, height);
    }

    public static void setFrogColorModel(IndexColorModel model) {
        mCurrentColorModel = model;
    }

    public void imageComplete(int status) {
        if (status == 3) {
            if (FrogGIFReader.isTrace()) {
                System.err.println("FrogGIFImageFilter.imageComplete()   mImagePath: " + this.mImagePath + "   mBytePixels: " + this.mBytePixels);
            }
            FrogGIFReader.storeImageAsByteArray(this.mImagePath, this.mBytePixels, this.mImageWidth, this.mImageHeight);
        }
        super.imageComplete(status);
    }

    private IndexColorModel calculateColorModel(IndexColorModel model, ColorUIResource[] themeColors) {
        Object transColorModel = null;
        IndexColorModel icm = model;
        byte[] reds = new byte[icm.getMapSize()];
        byte[] greens = new byte[icm.getMapSize()];
        byte[] blues = new byte[icm.getMapSize()];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        int j = 0;
        if (themeColors != null && mTakeThemeColors) {
            int i = 73;
            while (i < 96) {
                reds[i] = (byte)themeColors[j].getRed();
                greens[i] = (byte)themeColors[j].getGreen();
                blues[i] = (byte)themeColors[j].getBlue();
                ++j;
                ++i;
            }
        }
        return new IndexColorModel(icm.getPixelSize(), icm.getMapSize(), reds, greens, blues, icm.getTransparentPixel());
    }
}

