/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboPopup;

public class FrogComboPopup
extends BasicComboPopup {
    protected BasicComboPopup mPopup;
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION = "JComboBox.lightweightKeyboardNavigation";
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON = "Lightweight";
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF = "Heavyweight";
    protected boolean lightNav = false;

    public FrogComboPopup(JComboBox combo) {
        super(combo);
        this.comboBox = combo;
        Object keyNav = combo.getClientProperty(LIGHTWEIGHT_KEYBOARD_NAVIGATION);
        if (keyNav != null) {
            if (keyNav.equals(LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON)) {
                this.lightNav = true;
            } else if (keyNav.equals(LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF)) {
                this.lightNav = false;
            }
        }
        this.mPopup = this;
    }

    public JScrollPane getScroller() {
        return this.scroller;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    protected KeyListener createKeyListener() {
        return new InvocationKeyHandler();
    }

    protected void uninstallComboBoxModelListeners(ComboBoxModel c) {
        super.uninstallComboBoxModelListeners(c);
    }

    protected void installComboBoxModelListeners(ComboBoxModel model) {
        super.installComboBoxModelListeners(model);
    }

    public void show() {
        Dimension popupSize = this.comboBox.getSize();
        if (this.comboBox.getClientProperty("ComboBox.calculateMaxStringLength") != null && this.comboBox.getClientProperty("ComboBox.calculateMaxStringLength").equals(Boolean.TRUE) && this.list.getModel().getSize() != 0 && this.comboBox.getRenderer() instanceof JComponent) {
            popupSize.width = Math.max(this.getWidthOfMaxStringLength() + ((JComponent)((Object)this.comboBox.getRenderer())).getInsets().left + ((JComponent)((Object)this.comboBox.getRenderer())).getInsets().right, popupSize.width);
        }
        popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
        this.scroller.setMaximumSize(popupBounds.getSize());
        this.scroller.setPreferredSize(popupBounds.getSize());
        this.scroller.setMinimumSize(popupBounds.getSize());
        this.list.invalidate();
        this.syncListSelectionWithComboBoxSelection();
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.show(this.comboBox, popupBounds.x, popupBounds.y);
    }

    void syncListSelectionWithComboBoxSelection() {
        int selectedIndex = this.comboBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
        }
    }

    public void hide() {
        super.hide();
    }

    protected int getWidthOfMaxStringLength() {
        int maxWidth = 0;
        int currentWidth = 0;
        Font componentFont = this.comboBox.getFont();
        FontMetrics fontMetric = Toolkit.getDefaultToolkit().getFontMetrics(componentFont);
        int i = 0;
        while (i < this.list.getModel().getSize()) {
            Object element = this.list.getModel().getElementAt(i);
            currentWidth = SwingUtilities.computeStringWidth(fontMetric, element.toString());
            if (maxWidth < currentWidth) {
                maxWidth = currentWidth;
            }
            ++i;
        }
        if (this.comboBox.getMaximumRowCount() < this.comboBox.getModel().getSize()) {
            maxWidth += UIManager.getInt("ScrollBar.width");
        }
        return maxWidth;
    }

    protected void togglePopup() {
        super.togglePopup();
    }

    protected JComboBox getComboBox() {
        return this.comboBox;
    }

    public class InvocationKeyHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            boolean lightNav = false;
            if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                Object keyNav = FrogComboPopup.this.getComboBox().getClientProperty(FrogComboPopup.LIGHTWEIGHT_KEYBOARD_NAVIGATION);
                if (keyNav != null) {
                    if (keyNav.equals(FrogComboPopup.LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON)) {
                        lightNav = true;
                    } else if (keyNav.equals(FrogComboPopup.LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF)) {
                        lightNav = false;
                    }
                }
                if (FrogComboPopup.this.getComboBox().getClientProperty("SortedList") != null) {
                    FrogComboPopup.this.comboBox.getModel().setSelectedItem(FrogComboPopup.this.comboBox.getEditor().getItem());
                }
                if (lightNav && FrogComboPopup.this.isVisible()) {
                    FrogComboPopup.this.getComboBox().setSelectedIndex(FrogComboPopup.this.mPopup.getList().getSelectedIndex());
                }
                if (!FrogComboPopup.this.getComboBox().isEditable()) {
                    if (e.getKeyCode() == 32) {
                        e.consume();
                    } else if (e.getKeyCode() == 10 && FrogComboPopup.this.isVisible()) {
                        FrogComboPopup.this.togglePopup();
                        e.consume();
                    }
                }
            }
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("model")) {
                FrogComboPopup.this.uninstallComboBoxModelListeners((ComboBoxModel)e.getOldValue());
                FrogComboPopup.this.mPopup.getList().setModel((ComboBoxModel)e.getNewValue());
                FrogComboPopup.this.installComboBoxModelListeners((ComboBoxModel)e.getNewValue());
                if (FrogComboPopup.this.getComboBox().getItemCount() > 0) {
                    FrogComboPopup.this.getComboBox().setSelectedIndex(0);
                }
                if (FrogComboPopup.this.isVisible()) {
                    FrogComboPopup.this.hide();
                }
            } else if (propertyName.equals("renderer")) {
                FrogComboPopup.this.getList().setCellRenderer(FrogComboPopup.this.getComboBox().getRenderer());
                if (FrogComboPopup.this.isVisible()) {
                    FrogComboPopup.this.hide();
                }
            } else if (propertyName.equals(FrogComboPopup.LIGHTWEIGHT_KEYBOARD_NAVIGATION)) {
                Object newValue = e.getNewValue();
                if (newValue.equals(FrogComboPopup.LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON)) {
                    FrogComboPopup.this.lightNav = true;
                } else if (newValue.equals(FrogComboPopup.LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF)) {
                    FrogComboPopup.this.lightNav = false;
                }
            }
        }
    }
}

