/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogComboBoxButton;
import com.sap.plaf.frog.FrogComboBoxEditor;
import com.sap.plaf.frog.FrogComboBoxIcon;
import com.sap.plaf.frog.FrogComboBoxRenderer;
import com.sap.plaf.frog.FrogComboPopup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class FrogComboBoxUI
extends MetalComboBoxUI
implements DocumentListener,
PropertyChangeListener {
    protected boolean hasFocus = false;
    protected boolean lightNav = false;
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION = "JComboBox.lightweightKeyboardNavigation";
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON = "Lightweight";
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF = "Heavyweight";
    private static boolean mDefaultsInitialized = false;
    private Color mFrogEditorBackground = UIManager.getColor("ComboBox.background");
    protected static Icon mIconButton;
    Dimension cachedDisplaySize = new Dimension(0, 0);
    static DefaultListCellRenderer textRenderer;

    static {
        textRenderer = new DefaultListCellRenderer();
    }

    public static ComponentUI createUI(JComponent c) {
        return new FrogComboBoxUI();
    }

    public void installUI(JComponent c) {
        Object keyNav;
        super.installUI(c);
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(this.createRenderer());
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(this.createEditor());
        }
        if ((keyNav = c.getClientProperty(LIGHTWEIGHT_KEYBOARD_NAVIGATION)) != null) {
            if (keyNav.equals(LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON)) {
                this.lightNav = true;
            } else if (keyNav.equals(LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF)) {
                this.lightNav = false;
            }
        }
        this.comboBox.setMaximumRowCount(UIManager.getInt("ComboBox.maximumRowCount"));
        c.setOpaque(true);
    }

    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.installBorder(this.comboBox, "ComboBox.border");
        mIconButton = UIManager.getIcon("ComboBox.iconButton");
        mDefaultsInitialized = true;
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.uninstallBorder(this.comboBox);
        mIconButton = null;
        mDefaultsInitialized = false;
    }

    protected ComboPopup createPopup() {
        FrogComboPopup popup = new FrogComboPopup(this.comboBox);
        popup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return popup;
    }

    protected ListCellRenderer createRenderer() {
        return new FrogComboBoxRenderer();
    }

    protected ComboBoxEditor createEditor() {
        return new FrogComboBoxEditor.UIResource();
    }

    public void configureEditor() {
        AccessibleContext ac;
        super.configureEditor();
        if (this.comboBox.getClientProperty("SortedList") != null) {
            ((JTextComponent)this.comboBox.getEditor().getEditorComponent()).addPropertyChangeListener(this);
            ((JTextComponent)this.comboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        }
        if (this.popupKeyListener != null) {
            this.editor.addKeyListener(this.popupKeyListener);
        }
        if (this.editor instanceof Accessible && (ac = ((Accessible)((Object)this.editor)).getAccessibleContext()) != null) {
            ac.setAccessibleParent(this.comboBox);
        }
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.popupKeyListener != null) {
            this.editor.removeKeyListener(this.popupKeyListener);
        }
    }

    public void configureArrowButton() {
        super.configureArrowButton();
        this.arrowButton.setMargin(new Insets(0, 0, 0, 0));
        if (this.arrowButton != null) {
            this.arrowButton.setBackground(UIManager.getColor("control"));
            this.arrowButton.setIcon(mIconButton);
            this.arrowButton.setBorder(new EmptyBorder(0, 0, 0, 1));
            this.arrowButton.putClientProperty("ComboBoxButton", Boolean.TRUE);
        }
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setIcon(null);
            this.arrowButton.putClientProperty("system", null);
            this.arrowButton.putClientProperty("theme", null);
            if (this.popupMouseListener != null) {
                this.arrowButton.removeMouseListener(this.popupMouseListener);
            }
            if (this.popupMouseMotionListener != null) {
                this.arrowButton.removeMouseMotionListener(this.popupMouseMotionListener);
            }
            this.arrowButton.putClientProperty("ComboBoxButton", null);
            this.arrowButton.setBorder(null);
        }
    }

    protected JButton createArrowButton() {
        FrogComboBoxButton button = new FrogComboBoxButton(this.comboBox, (Icon)new FrogComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        button.setMargin(new Insets(0, 1, 1, 3));
        return button;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle r = this.rectangleForCurrentValue();
            if (c.isOpaque()) {
                this.paintCurrentValueBackground(g, new Rectangle(0, 0, this.comboBox.getWidth(), this.comboBox.getHeight()), this.hasFocus);
            }
            this.paintCurrentValue(g, r, this.hasFocus);
        } else {
            this.arrowButton.setBackground(this.comboBox.getBackground());
        }
    }

    protected int scrollToEditorItem(String s) {
        String typedText = s;
        JScrollBar frogScrollBar = ((FrogComboPopup)this.popup).getScroller().getVerticalScrollBar();
        int i = 0;
        while (i < this.comboBox.getItemCount()) {
            String typedTextLow = typedText.toLowerCase();
            String typedTextUp = typedText.toUpperCase();
            String comboBoxItem = (String)this.comboBox.getItemAt(i);
            String comparator = comboBoxItem.substring(0, Math.min(typedText.length(), comboBoxItem.length()));
            if (typedTextLow.equals(comparator) || typedTextUp.equals(comparator)) {
                Point itemLocation = this.popup.getList().indexToLocation(i);
                frogScrollBar.setValue(itemLocation.y);
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (this.comboBox.getSelectedIndex() == -1) {
            return;
        }
        Component c = hasFocus && !this.isPopupVisible(this.comboBox) ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        c.setFont(this.comboBox.getFont());
        this.setupComboBoxRenderer(c);
        c.setBackground(Color.magenta);
        this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    protected void setupComboBoxRenderer(Component c) {
        if (this.hasFocus && !this.isPopupVisible(this.comboBox)) {
            c.setForeground(this.listBox.getSelectionForeground());
            if (this.comboBox.getClientProperty("DoNotFrog") == null) {
                c.setBackground(this.listBox.getSelectionBackground());
            } else {
                c.setBackground(this.listBox.getSelectionBackground());
            }
        } else if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            if (this.comboBox.getClientProperty("DoNotFrog") == null) {
                c.setBackground(UIManager.getColor("ComboBox.background"));
            } else {
                c.setBackground(this.comboBox.getBackground());
            }
        } else {
            c.setForeground(this.comboBox.getForeground());
            if (this.comboBox.getClientProperty("DoNotFrog") == null) {
                c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            } else {
                c.setBackground(this.comboBox.getBackground());
            }
        }
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        Color t = g.getColor();
        if (this.comboBox.isEnabled()) {
            if (this.comboBox.getClientProperty("DoNotFrog") == null) {
                g.setColor(UIManager.getColor("ComboBox.background"));
            } else {
                g.setColor(this.comboBox.getBackground());
            }
        } else if (this.comboBox.getClientProperty("DoNotFrog") == null) {
            g.setColor(UIManager.getColor("ComboBox.disabledBackground"));
        } else {
            g.setColor(this.comboBox.getBackground());
        }
        this.arrowButton.setBackground(g.getColor());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.setColor(t);
    }

    void repaintCurrentValue() {
        Rectangle r = this.rectangleForCurrentValue();
        this.comboBox.repaint(r.x, r.y, r.width, r.height);
    }

    void togglePopup() {
        this.toggleOpenClose();
    }

    protected void installKeyboardActions() {
        if (this.comboBox != null) {
            super.installKeyboardActions();
            ActionListener spaceAction = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            };
            if (this.comboBox != null) {
                this.comboBox.registerKeyboardAction(spaceAction, KeyStroke.getKeyStroke(32, 0), 1);
            }
            ActionListener downAction = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (FrogComboBoxUI.this.comboBox != null && FrogComboBoxUI.this.comboBox.isEnabled()) {
                        if (FrogComboBoxUI.this.isPopupVisible(FrogComboBoxUI.this.comboBox)) {
                            if (FrogComboBoxUI.this.comboBox.getClientProperty("SortedList") != null && FrogComboBoxUI.this.comboBox.isEditable() && ((JTextComponent)FrogComboBoxUI.this.editor).hasFocus() && ((JTextComponent)FrogComboBoxUI.this.editor).getSelectedText() == null) {
                                if (FrogComboBoxUI.this.scrollToEditorItem(((JTextComponent)FrogComboBoxUI.this.editor).getText()) == -1) {
                                    FrogComboBoxUI.this.comboBox.setSelectedItem(FrogComboBoxUI.this.comboBox.getItemAt(0));
                                } else if (FrogComboBoxUI.this.comboBox.getSelectedItem().toString().equals(((JTextComponent)FrogComboBoxUI.this.editor).getText())) {
                                    FrogComboBoxUI.this.selectNextPossibleValue();
                                } else {
                                    FrogComboBoxUI.this.comboBox.setSelectedItem(FrogComboBoxUI.this.comboBox.getItemAt(FrogComboBoxUI.this.scrollToEditorItem(((JTextComponent)FrogComboBoxUI.this.editor).getText())));
                                }
                            } else {
                                FrogComboBoxUI.this.selectNextPossibleValue();
                            }
                        } else if (FrogComboBoxUI.this.comboBox.getClientProperty("SortedList") != null) {
                            FrogComboBoxUI.this.selectNextPossibleValue();
                        } else {
                            FrogComboBoxUI.this.setPopupVisible(FrogComboBoxUI.this.comboBox, true);
                        }
                    }
                }
            };
            if (this.comboBox != null) {
                this.comboBox.registerKeyboardAction(downAction, KeyStroke.getKeyStroke(40, 0), 1);
            }
            ActionListener altAction = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String typedText = (String)FrogComboBoxUI.this.comboBox.getEditor().getItem();
                    JList<Object> list = FrogComboBoxUI.this.popup.getList();
                    int currentScrolledIndex = -1;
                    FrogComboBoxUI.this.togglePopup();
                    if (FrogComboBoxUI.this.comboBox.isEditable() && FrogComboBoxUI.this.comboBox.getClientProperty("SortedList") != null && (currentScrolledIndex = FrogComboBoxUI.this.scrollToEditorItem(typedText)) != -1) {
                        list.setSelectedIndex(currentScrolledIndex);
                    }
                }
            };
            if (this.comboBox != null) {
                this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke(40, 8), 1);
            }
            if (this.comboBox != null) {
                this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke(38, 8), 1);
            }
            ActionListener upAction = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (FrogComboBoxUI.this.comboBox.getClientProperty("SortedList") != null && FrogComboBoxUI.this.comboBox.isEnabled()) {
                        FrogComboBoxUI.this.selectPreviousPossibleValue();
                    } else if (FrogComboBoxUI.this.comboBox.isEnabled() && FrogComboBoxUI.this.isPopupVisible(FrogComboBoxUI.this.comboBox)) {
                        FrogComboBoxUI.this.selectPreviousPossibleValue();
                    }
                }
            };
            if (this.comboBox != null) {
                this.comboBox.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 1);
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        String typedText = "";
        try {
            typedText = e.getDocument().getText(0, e.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.scrollToEditorItem(typedText);
    }

    public void removeUpdate(DocumentEvent e) {
    }

    public void changedUpdate(DocumentEvent e) {
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            buttonSize = this.arrowButton.getWidth();
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            Rectangle rect = new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
            return rect;
        }
        return new Rectangle(insets.left + buttonSize, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("document")) {
            ((JTextComponent)this.comboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        }
    }
}

