/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.hueshift.SystemHueShift;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalComboBoxButton;

public class FrogComboBoxButton
extends MetalComboBoxButton {
    public FrogComboBoxButton(JComboBox cb, Icon i, CellRendererPane pane, JList list) {
        super(cb, i, pane, list);
        this.comboBox = cb;
        this.comboIcon = i;
        this.rendererPane = pane;
        this.listBox = list;
        this.setEnabled(this.comboBox.isEnabled());
        this.setRequestFocusEnabled(this.comboBox.isEnabled());
    }

    public FrogComboBoxButton(JComboBox cb, Icon i, boolean onlyIcon, CellRendererPane pane, JList list) {
        this(cb, i, pane, list);
        this.iconOnly = onlyIcon;
    }

    public void paintComponent(Graphics g) {
        int iconLeft;
        boolean leftToRight = true;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            return;
        }
        int left = insets.left;
        int top = insets.top;
        int right = left + (width - 1);
        int bottom = top + (height - 1);
        int iconWidth = 0;
        int n = iconLeft = leftToRight ? right : left;
        if (this.comboIcon != null) {
            iconWidth = this.comboIcon.getIconWidth();
            int iconHeight = this.comboIcon.getIconHeight();
            int iconTop = 0;
            if (this.iconOnly) {
                iconLeft = this.getWidth() / 2 - iconWidth / 2;
                iconTop = this.getHeight() / 2 - iconHeight / 2;
            } else {
                iconLeft = left + (width - 1) - iconWidth;
                iconTop = top + (bottom - top) / 2 - iconHeight / 2;
            }
            this.comboIcon.paintIcon(this, g, iconLeft, iconTop);
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            boolean renderPressed = this.getModel().isPressed();
            Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, renderPressed, false);
            c.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    c.setBackground(SystemHueShift.getColor((JComponent)this.comboBox, "ComboBox.background"));
                }
                c.setForeground(this.comboBox.getForeground());
            } else if (!this.comboBox.isEnabled()) {
                if (this.isOpaque()) {
                    c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                }
                c.setForeground(SystemHueShift.getColor((JComponent)this.comboBox, "ComboBox.disabledForeground"));
            } else {
                c.setForeground(this.comboBox.getForeground());
                if (this.hasFocus() || this.comboBox.hasFocus()) {
                    c.setBackground(UIManager.getColor("focusEnabledText"));
                } else {
                    c.setBackground(SystemHueShift.getColor((JComponent)this.comboBox, "ComboBox.background"));
                }
            }
            int cWidth = width - (insets.right + iconWidth);
            this.rendererPane.paintComponent(g, c, this, left, top, cWidth, height);
        }
    }

    public void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 10 && !((JComboBox)this.getParent()).isPopupVisible()) {
            this.getParent().dispatchEvent(e);
        } else {
            super.processKeyEvent(e);
        }
    }
}

