/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogImageData;
import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.hueshift.HueShiftTheme;
import com.sap.plaf.frog.util.ThemeData;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class FrogCheckBoxIcon
implements Icon,
UIResource,
Serializable {
    private static final int kDefaultCheckBoxSize = 15;
    private String kCheckBoxSizeProperty = "";
    private HueShiftTheme mTheme = null;

    public FrogCheckBoxIcon(HueShiftTheme theme) {
        this.mTheme = theme;
    }

    public void reloadHueShiftDefaults() {
    }

    protected int getControlSize() {
        return this.kCheckBoxSizeProperty == "" ? 15 : (Integer)UIManager.get(this.kCheckBoxSizeProperty);
    }

    public void setControlSizeProperty(String p) {
        this.kCheckBoxSizeProperty = p;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        JCheckBox cb = (JCheckBox)c;
        ButtonModel model = cb.getModel();
        if (model.isEnabled()) {
            if (model.isPressed() && model.isArmed()) {
                if (model.isSelected()) {
                    this.paintFroggyStyle2(g, cb, x, y, ThemeData.getImageData(cb, "CButton.CF"));
                } else {
                    this.paintFroggyStyle2(g, cb, x, y, ThemeData.getImageData(cb, "CButton.UF"));
                }
            } else if (model.isSelected()) {
                this.paintFroggyStyle2(g, cb, x, y, ThemeData.getImageData(cb, "CButton.CE"));
            } else {
                this.paintFroggyStyle2(g, cb, x, y, ThemeData.getImageData(cb, "CButton.UE"));
            }
        } else if (model.isSelected()) {
            this.paintFroggyStyle2(g, cb, x, y, ThemeData.getImageData(cb, "CButton.CD"));
        } else {
            this.paintFroggyStyle2(g, cb, x, y, ThemeData.getImageData(cb, "CButton.UD"));
        }
    }

    private void paintFroggyStyle(Graphics g, Component c, int x, int y, Image box) {
        g.drawImage(box, x, y, this.getControlSize(), this.getControlSize(), null);
    }

    private void paintFroggyStyle2(Graphics g, JComponent c, int x, int y, FrogImageData imageData) {
        g.drawImage(FrogLookAndFeel.getImageFromData(c, imageData), x, y, this.getControlSize() + x, this.getControlSize() + y, imageData.getLeft(), imageData.getTop(), imageData.getRight(), imageData.getBottom(), null);
    }

    public int getIconWidth() {
        return this.getControlSize();
    }

    public int getIconHeight() {
        return this.getControlSize();
    }
}

