/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.FrogBorders;
import com.sap.plaf.frog.FrogGIFReader;
import com.sap.plaf.frog.FrogImageData;
import com.sap.plaf.frog.FrogLookAndFeel;
import com.sap.plaf.frog.hueshift.SystemHueShift;
import com.sap.plaf.frog.util.ThemeData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class FrogButtonUI
extends BasicButtonUI {
    public static final String __PerforceId = "$Id$";
    protected static boolean mMacVendor = false;
    private static final FrogButtonUI kFrogButtonUI = new FrogButtonUI();
    private static final String mLookAndFeelName = "Frog";
    private static boolean mStandardDefaultsInitialized = false;
    protected static FrogImageData[] mImageDataResources;
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;
    protected static Image mA_Bgnd_U_UE;
    protected static Image mA_Bgnd_M_UE;
    protected static Image mA_Bgnd_L_UE;
    protected static Image mA_Btn_LMB_In;
    protected static Image mA_Btn_MUB_In;
    protected static Image mA_Btn_RMB_In;
    protected static Image mA_Btn_MLB_In;
    protected static Image mA_Btn_MMM_In;
    protected static Image mA_Btn_LMB_Out;
    protected static Image mA_Btn_MUB_Out;
    protected static Image mA_Btn_RMB_Out;
    protected static Image mA_Btn_MLB_Out;
    protected static Image mA_Btn_MMM_Out;
    private static Rectangle viewRect;
    private static Rectangle textRect;
    private static Rectangle iconRect;

    static {
        mA_Bgnd_U_UE = null;
        mA_Bgnd_M_UE = null;
        mA_Bgnd_L_UE = null;
        mA_Btn_LMB_In = null;
        mA_Btn_MUB_In = null;
        mA_Btn_RMB_In = null;
        mA_Btn_MLB_In = null;
        mA_Btn_MMM_In = null;
        mA_Btn_LMB_Out = null;
        mA_Btn_MUB_Out = null;
        mA_Btn_RMB_Out = null;
        mA_Btn_MLB_Out = null;
        mA_Btn_MMM_Out = null;
        viewRect = new Rectangle();
        textRect = new Rectangle();
        iconRect = new Rectangle();
    }

    public static ComponentUI createUI(JComponent c) {
        return kFrogButtonUI;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setBackground(SystemHueShift.getColor((JComponent)b, String.valueOf(this.getPropertyPrefix()) + "background"));
        if (!mStandardDefaultsInitialized) {
            FrogButtonUI.initializeImageData();
            this.focusColor = SystemHueShift.getColor((JComponent)b, String.valueOf(this.getPropertyPrefix()) + "focus");
            this.selectColor = SystemHueShift.getColor((JComponent)b, String.valueOf(this.getPropertyPrefix()) + "select");
            this.disabledTextColor = SystemHueShift.getColor((JComponent)b, String.valueOf(this.getPropertyPrefix()) + "disabledText");
            mStandardDefaultsInitialized = true;
        }
    }

    public static boolean areDefaultsInitialized() {
        return mStandardDefaultsInitialized;
    }

    public void uninstallUI(JComponent c) {
        if (!UIManager.getLookAndFeel().getName().equals(mLookAndFeelName)) {
            c.putClientProperty("HueShifting", null);
            super.uninstallUI(c);
        }
    }

    public void uninstallDefaults(AbstractButton b) {
        mStandardDefaultsInitialized = false;
        super.uninstallDefaults(b);
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            this.paintBackground(g, c);
        }
        this.paint(g, c);
    }

    protected void paintBackground(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        int width = b.getBounds().width;
        int height = b.getBounds().height;
        if (c.getClientProperty("ComboBoxButton") != null) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        } else if (c.getClientProperty("StatusbarMenuButton") != null) {
            this.paintStatusMenuButton(g, c);
        } else if (c.getClientProperty("StatusbarSizeBox") != null) {
            this.paintStatusSizeBoxButton(g, c);
        } else if (c.getClientProperty("StatusbarOpenCloseButton") != null) {
            this.paintStatusOpenCloseButton(g, c);
        } else if (c.getClientProperty("OKCodeFieldButton") != null) {
            this.paintOKButton(g, c);
        } else if (c instanceof JToggleButton && model.isSelected() && this.isInToolbar(c) && !this.isInAppToolbar(c)) {
            this.paintToolBarPE(g, c);
        } else if (c instanceof JToggleButton && !model.isSelected() && this.isInToolbar(c) && !this.isInAppToolbar(c)) {
            this.paintToolBarUE(g, c);
        } else if (c instanceof JToggleButton && model.isSelected()) {
            this.paintColProgressPE(g, c);
        } else if (c instanceof JToggleButton && !model.isSelected()) {
            this.paintColProgressUE(g, c);
        } else if (c.getBackground() != null && !(c.getBackground() instanceof ColorUIResource)) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        } else if (this.isInAppToolbar(c) && !model.isRollover() && !model.isPressed()) {
            this.paintFlat(g, c);
        } else if (!this.isInAppToolbar(c) && !this.isInToolbar(c) && !model.isPressed() || this.isInAppToolbar(c) && !model.isPressed()) {
            this.paintColProgressUE(g, c);
        } else if (!this.isInToolbar(c) && model.isPressed()) {
            this.paintColProgressPE(g, c);
        } else if (this.isInToolbar(c) && !this.isInAppToolbar(c) && !model.isPressed() && model.isRollover()) {
            this.paintToolBarUE(g, c);
        } else if (this.isInToolbar(c) && !this.isInAppToolbar(c) && model.isPressed()) {
            this.paintToolBarPE(g, c);
        } else if (this.isInToolbar(c)) {
            g.setColor(SystemHueShift.getColor(c, "ToolBar.background"));
            g.fillRect(0, 0, c.getBounds().width, c.getBounds().height);
        }
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Icon defaultIcon = b.getIcon();
        Icon icon = null;
        if (b.getClientProperty("TableConfigButton") != null) {
            icon = defaultIcon;
            icon.paintIcon(c, g, iconRect.x + 1, iconRect.y);
        } else if (b.getClientProperty("StatusbarOpenCloseButton") != null) {
            icon = b.getClientProperty("isOpen") != null && b.getClientProperty("isOpen").equals(Boolean.FALSE) ? new ImageIcon(SystemHueShift.getCropImage(b, ThemeData.getImageData(b, "Statusbar.LeftArrow"))) : new ImageIcon(SystemHueShift.getCropImage(b, ThemeData.getImageData(b, "Statusbar.RightArrow")));
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
        } else {
            if (!model.isEnabled()) {
                icon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = defaultIcon;
                } else {
                    this.clearTextShiftOffset();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                icon = model.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon();
            } else if (model.isSelected()) {
                icon = b.getSelectedIcon();
            }
            if (icon == null) {
                icon = defaultIcon;
            }
            if (model.isPressed() && model.isArmed()) {
                icon.paintIcon(c, g, iconRect.x + this.getTextShiftOffset(), iconRect.y + this.getTextShiftOffset());
            } else {
                icon.paintIcon(c, g, iconRect.x, iconRect.y);
            }
        }
    }

    protected void paintToolBarPE(Graphics g, JComponent c) {
        this.paintFroggyStyle(g, c, ThemeData.getImageData(c, "Toolbar.Btn.LUC.Out"), ThemeData.getImageData(c, "Toolbar.Btn.LLC.Out"), ThemeData.getImageData(c, "Toolbar.Btn.RUC.Out"), ThemeData.getImageData(c, "Toolbar.Btn.RLC.Out"), ThemeData.getImageData(c, "Toolbar.Btn.LMB.Out"), ThemeData.getImageData(c, "Toolbar.Btn.MUB.Out"), ThemeData.getImageData(c, "Toolbar.Btn.RMB.Out"), ThemeData.getImageData(c, "Toolbar.Btn.MLB.Out"), ThemeData.getImageData(c, "Toolbar.Btn.MMM.Out"), ThemeData.getImageData(c, "Toolbar.Btn.MMM.Out"), ThemeData.getImageData(c, "Toolbar.Btn.MMM.Out"), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.LMB.Out")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.MUB.Out")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.RMB.Out")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.MLB.Out")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.MMM.Out")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.MMM.Out")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.MMM.Out")));
    }

    protected void paintToolBarUE(Graphics g, JComponent c) {
        this.paintFroggyStyle(g, c, ThemeData.getImageData(c, "Toolbar.Btn.LUC.In"), ThemeData.getImageData(c, "Toolbar.Btn.LLC.In"), ThemeData.getImageData(c, "Toolbar.Btn.RUC.In"), ThemeData.getImageData(c, "Toolbar.Btn.RLC.In"), ThemeData.getImageData(c, "Toolbar.Btn.LMB.In"), ThemeData.getImageData(c, "Toolbar.Btn.MUB.In"), ThemeData.getImageData(c, "Toolbar.Btn.RMB.In"), ThemeData.getImageData(c, "Toolbar.Btn.MLB.In"), ThemeData.getImageData(c, "Toolbar.Btn.MMM.In"), ThemeData.getImageData(c, "Toolbar.Btn.MMM.In"), ThemeData.getImageData(c, "Toolbar.Btn.MMM.In"), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.LMB.In")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.MUB.In")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.RMB.In")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.MLB.In")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.MMM.In")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.MMM.In")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "Toolbar.Btn.MMM.In")));
    }

    protected void paintFlat(Graphics g, JComponent c) {
        this.paintFroggyStyle(g, c, ThemeData.getImageData(c, "PButton.Bord.LUC.FL"), ThemeData.getImageData(c, "PButton.Bord.LBC.FL"), ThemeData.getImageData(c, "PButton.Bord.RUC.FL"), ThemeData.getImageData(c, "PButton.Bord.RBC.FL"), ThemeData.getImageData(c, "PButton.Bord.LB.FL"), ThemeData.getImageData(c, "PButton.Bord.UB.FL"), ThemeData.getImageData(c, "PButton.Bord.RB.FL"), ThemeData.getImageData(c, "PButton.Bord.BB.FL"), ThemeData.getImageData(c, "PButton.Bgnd.U.FE"), ThemeData.getImageData(c, "PButton.Bgnd.M.FE"), ThemeData.getImageData(c, "PButton.Bgnd.L.FE"), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.LB.FL")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.UB.FL")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.RB.FL")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.BB.FL")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bgnd.U.FE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bgnd.M.FE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bgnd.L.FE")));
        Rectangle bounds = c.getBounds();
        if (mMacVendor) {
            g.drawImage(SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bgnd.M.FE")), ThemeData.getImageData(c, "PButton.Bord.LUC.FL").getWidth() - 1, ThemeData.getImageData(c, "PButton.Bord.LUC.FL").getHeight() + ThemeData.getImageData(c, "PButton.Bgnd.M.FE").getHeight() - 2, bounds.width - ThemeData.getImageData(c, "PButton.Bord.RUC.FL").getWidth() + 1, bounds.height - ThemeData.getImageData(c, "PButton.Bord.LBC.FL").getHeight() - ThemeData.getImageData(c, "PButton.Bgnd.M.FE").getHeight() + 2, 0, 0, ThemeData.getImageData(c, "PButton.Bgnd.M.FE").getWidth(), ThemeData.getImageData(c, "PButton.Bgnd.M.FE").getHeight(), Color.green, null);
        }
    }

    protected void paintColProgressPE(Graphics g, JComponent c) {
        this.paintFroggyStyle(g, c, ThemeData.getImageData(c, "PButton.Bord.LUC.PE"), ThemeData.getImageData(c, "PButton.Bord.LBC.PE"), ThemeData.getImageData(c, "PButton.Bord.RUC.PE"), ThemeData.getImageData(c, "PButton.Bord.RBC.PE"), ThemeData.getImageData(c, "PButton.Bord.LB.PE"), ThemeData.getImageData(c, "PButton.Bord.UB.PE"), ThemeData.getImageData(c, "PButton.Bord.RB.PE"), ThemeData.getImageData(c, "PButton.Bord.BB.PE"), ThemeData.getImageData(c, "PButton.Bgnd.U.PE"), ThemeData.getImageData(c, "PButton.Bgnd.M.PE"), ThemeData.getImageData(c, "PButton.Bgnd.L.PE"), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.LB.PE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.UB.PE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.RB.PE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.BB.PE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bgnd.U.PE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bgnd.M.PE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bgnd.L.PE")));
    }

    protected void paintColProgressUE(Graphics g, JComponent c) {
        this.paintFroggyStyle(g, c, ThemeData.getImageData(c, "PButton.Bord.LUC.UE"), ThemeData.getImageData(c, "PButton.Bord.LBC.UE"), ThemeData.getImageData(c, "PButton.Bord.RUC.UE"), ThemeData.getImageData(c, "PButton.Bord.RBC.UE"), ThemeData.getImageData(c, "PButton.Bord.LB.UE"), ThemeData.getImageData(c, "PButton.Bord.UB.UE"), ThemeData.getImageData(c, "PButton.Bord.RB.UE"), ThemeData.getImageData(c, "PButton.Bord.BB.UE"), ThemeData.getImageData(c, "PButton.Bgnd.U.UE"), ThemeData.getImageData(c, "PButton.Bgnd.M.UE"), ThemeData.getImageData(c, "PButton.Bgnd.L.UE"), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.LB.UE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.UB.UE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.RB.UE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bord.BB.UE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bgnd.U.UE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bgnd.M.UE")), SystemHueShift.getCropImage(c, ThemeData.getImageData(c, "PButton.Bgnd.L.UE")));
    }

    protected void paintOKButton(Graphics g, JComponent c) {
        FrogBorders.ToolBarBorder cfr_ignored_0 = (FrogBorders.ToolBarBorder)SystemHueShift.getBorder(c, "ToolBar.border");
        FrogImageData upperBorder = FrogBorders.ToolBarBorder.getUpperBorder(c);
        FrogBorders.ToolBarBorder cfr_ignored_1 = (FrogBorders.ToolBarBorder)SystemHueShift.getBorder(c, "ToolBar.border");
        FrogImageData bottomBorder = FrogBorders.ToolBarBorder.getBottomBorder(c);
        g.setColor(SystemHueShift.getColor(c, "ToolBar.background"));
        g.fillRect(0, 0, c.getBounds().width, c.getBounds().height);
        if (mMacVendor) {
            Image A_upperBorder = FrogBorders.ToolBarBorder.getAUpperBorder(c);
            Image A_bottomBorder = FrogBorders.ToolBarBorder.getABottomBorder(c);
            g.drawImage(A_upperBorder, 0, 0, c.getBounds().width, upperBorder.getHeight(), 0, 0, upperBorder.getWidth(), upperBorder.getHeight(), null);
            g.drawImage(A_bottomBorder, 0, c.getBounds().height - bottomBorder.getHeight(), c.getBounds().width, c.getBounds().height, 0, 0, bottomBorder.getWidth(), bottomBorder.getHeight(), null);
        } else {
            g.drawImage(FrogLookAndFeel.getImageFromData(c, upperBorder), 0, 0, c.getBounds().width, upperBorder.getHeight(), upperBorder.getLeft(), upperBorder.getTop(), upperBorder.getRight(), upperBorder.getBottom(), null);
            g.drawImage(FrogLookAndFeel.getImageFromData(c, bottomBorder), 0, c.getBounds().height - bottomBorder.getHeight(), c.getBounds().width, c.getBounds().height, bottomBorder.getLeft(), bottomBorder.getTop(), bottomBorder.getRight(), bottomBorder.getBottom(), null);
        }
    }

    protected void paintStatusOpenCloseButton(Graphics g, JComponent c) {
        FrogImageData upperBorder = FrogBorders.StatusTextFieldBorder.getUpperBorder();
        FrogImageData bottomBorder = FrogBorders.StatusTextFieldBorder.getBottomBorder();
        g.setColor(SystemHueShift.getColor(c, "StatusBar.background"));
        g.fillRect(0, 0, c.getBounds().width, c.getBounds().height);
        if (mMacVendor) {
            Image A_upperBorder = FrogBorders.StatusTextFieldBorder.getAUpperBorder(c);
            Image A_bottomBorder = FrogBorders.StatusTextFieldBorder.getABottomBorder(c);
            g.drawImage(A_upperBorder, 0, 0, c.getBounds().width, upperBorder.getHeight(), 0, 0, upperBorder.getWidth(), upperBorder.getHeight(), null);
            g.drawImage(A_bottomBorder, 0, c.getBounds().height - bottomBorder.getHeight(), c.getBounds().width, c.getBounds().height, 0, 0, bottomBorder.getWidth(), bottomBorder.getHeight(), null);
        } else {
            g.drawImage(FrogLookAndFeel.getImageFromData(c, upperBorder), 0, 0, c.getBounds().width, upperBorder.getHeight(), upperBorder.getLeft(), upperBorder.getTop(), upperBorder.getRight(), upperBorder.getBottom(), null);
            g.drawImage(FrogLookAndFeel.getImageFromData(c, bottomBorder), 0, c.getBounds().height - bottomBorder.getHeight(), c.getBounds().width, c.getBounds().height, bottomBorder.getLeft(), bottomBorder.getTop(), bottomBorder.getRight(), bottomBorder.getBottom(), null);
        }
    }

    protected void paintStatusMenuButton(Graphics g, JComponent c) {
        FrogImageData upperBorder = FrogBorders.SystemInfoBorder.getUpperBorder();
        FrogImageData bottomBorder = FrogBorders.SystemInfoBorder.getBottomBorder();
        g.setColor(SystemHueShift.getColor(c, "StatusBar.background"));
        g.fillRect(0, 0, c.getBounds().width, c.getBounds().height);
        if (mMacVendor) {
            Image A_upperBorder = FrogBorders.SystemInfoBorder.getAUpperBorder(c);
            Image A_bottomBorder = FrogBorders.SystemInfoBorder.getABottomBorder(c);
            g.drawImage(A_upperBorder, 0, 0, c.getBounds().width, upperBorder.getHeight() - 2, 0, 0, upperBorder.getWidth(), upperBorder.getHeight() - 2, null);
            g.drawImage(A_bottomBorder, 0, c.getBounds().height - bottomBorder.getHeight() + 2, c.getBounds().width, c.getBounds().height, 0, 2, bottomBorder.getWidth(), bottomBorder.getHeight(), null);
        } else {
            g.drawImage(FrogLookAndFeel.getImageFromData(c, upperBorder), 0, 0, c.getBounds().width, upperBorder.getHeight() - 2, upperBorder.getLeft(), upperBorder.getTop(), upperBorder.getRight(), upperBorder.getBottom() - 2, null);
            g.drawImage(FrogLookAndFeel.getImageFromData(c, bottomBorder), 0, c.getBounds().height - bottomBorder.getHeight() + 2, c.getBounds().width, c.getBounds().height, bottomBorder.getLeft(), bottomBorder.getTop() + 2, bottomBorder.getRight(), bottomBorder.getBottom(), null);
        }
        g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Statusbar.Menu")), 0, 3, ThemeData.getImageData(c, "Statusbar.Menu").getWidth(), ThemeData.getImageData(c, "Statusbar.Menu").getHeight() + 3, ThemeData.getImageData(c, "Statusbar.Menu").getLeft(), ThemeData.getImageData(c, "Statusbar.Menu").getTop(), ThemeData.getImageData(c, "Statusbar.Menu").getRight(), ThemeData.getImageData(c, "Statusbar.Menu").getBottom(), null);
    }

    protected void paintStatusSizeBoxButton(Graphics g, JComponent c) {
        g.setColor(SystemHueShift.getColor(c, "StatusBar.background"));
        g.fillRect(0, 0, c.getBounds().width, c.getBounds().height);
        g.drawImage(FrogLookAndFeel.getImageFromData(c, ThemeData.getImageData(c, "Statusbar.Sizebox")), 0, 0, c.getBounds().width, c.getBounds().height, ThemeData.getImageData(c, "Statusbar.Sizebox").getLeft(), ThemeData.getImageData(c, "Statusbar.Sizebox").getTop(), ThemeData.getImageData(c, "Statusbar.Sizebox").getRight(), ThemeData.getImageData(c, "Statusbar.Sizebox").getBottom(), null);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.getClientProperty("ComboBoxButton") == null && b.getClientProperty("StatusbarMenuButton") == null && b.getClientProperty("StatusbarSizeBox") == null && b.getClientProperty("OKCodeFieldButton") == null && b.getClientProperty("StatusbarOpenCloseButton") == null && !this.isInToolbar(b) || b.getClientProperty("paintFocusBorder") != null) {
            FrogBorders.FocusBorder.drawFocus(g, b);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), textRect.x, textRect.y + fm.getAscent());
        } else {
            g.setColor(SystemHueShift.getColor((JComponent)b, String.valueOf(this.getPropertyPrefix()) + "disabledText"));
            BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), textRect.x, textRect.y + fm.getAscent());
        }
    }

    private void paintFroggyStyle(Graphics g, JComponent c, FrogImageData LUC, FrogImageData LBC, FrogImageData RUC, FrogImageData RBC, FrogImageData LB, FrogImageData UB, FrogImageData RB, FrogImageData BB, FrogImageData BGND_U, FrogImageData BGND_M, FrogImageData BGND_L, Image A_LB, Image A_UB, Image A_RB, Image A_BB, Image A_BGND_U, Image A_BGND_M, Image A_BGND_L) {
        Rectangle bounds = c.getBounds();
        ColorUIResource color = null;
        if (mMacVendor) {
            g.drawImage(A_LB, 0, LUC.getHeight(), LB.getWidth(), bounds.height - LBC.getHeight(), 0, 0, LB.getWidth(), LB.getHeight(), Color.magenta, null);
            if (BGND_U != null || BGND_M != null || BGND_L != null) {
                g.drawImage(A_BGND_U, LUC.getWidth(), LUC.getHeight(), bounds.width - RUC.getWidth(), BGND_U.getHeight() + LUC.getHeight(), 0, 0, BGND_U.getWidth(), BGND_U.getHeight(), Color.green, null);
                g.drawImage(A_BGND_M, LUC.getWidth(), LUC.getHeight() + BGND_U.getHeight(), bounds.width - RUC.getWidth(), bounds.height - LBC.getHeight() - BGND_L.getHeight(), 0, 0, BGND_M.getWidth(), BGND_M.getHeight(), Color.green, null);
                g.drawImage(A_BGND_L, LBC.getWidth(), bounds.height - BGND_L.getHeight() - BB.getHeight(), bounds.width - LBC.getWidth(), bounds.height - 1, 0, 0, BGND_L.getWidth(), BGND_L.getHeight(), null);
                g.drawImage(A_UB, LUC.getWidth(), 0, bounds.width - RUC.getWidth(), UB.getHeight(), 0, 0, UB.getWidth(), UB.getHeight(), null);
                g.drawImage(A_BB, LBC.getWidth(), bounds.height - LBC.getHeight(), bounds.width - RBC.getWidth(), bounds.height, 0, 0, BB.getWidth(), BB.getHeight(), null);
                g.drawImage(A_RB, bounds.width - RUC.getWidth(), RUC.getHeight(), bounds.width, bounds.height - RBC.getHeight(), 0, 0, RB.getWidth(), RB.getHeight(), Color.magenta, null);
            }
        } else {
            color = FrogGIFReader.getColor(c, BGND_M.getPath(), BGND_M.getLeft(), BGND_M.getTop());
            if (color != null) {
                g.setColor(color);
                g.fillRect(0, 0, bounds.width, bounds.height);
            }
            int i = 0;
            while (i < LB.getWidth()) {
                color = FrogGIFReader.getColor(c, LB.getPath(), LB.getLeft() + i, LB.getTop());
                if (color != null) {
                    g.setColor(color);
                    g.drawLine(i, LUC.getHeight(), i, bounds.height - LBC.getHeight());
                }
                ++i;
            }
            i = 0;
            while (i < BGND_U.getHeight()) {
                color = FrogGIFReader.getColor(c, BGND_U.getPath(), BGND_U.getLeft(), BGND_U.getTop() + i);
                if (color != null) {
                    g.setColor(color);
                    g.drawLine(LUC.getWidth(), UB.getHeight() + i, bounds.width - RUC.getWidth(), UB.getHeight() + i);
                }
                ++i;
            }
            i = 0;
            while (i < BGND_L.getHeight()) {
                color = FrogGIFReader.getColor(c, BGND_L.getPath(), BGND_L.getLeft(), BGND_L.getTop() + i);
                if (color != null) {
                    g.setColor(color);
                    g.drawLine(LB.getWidth(), bounds.height - BGND_U.getHeight() - UB.getHeight() + i, bounds.width - RB.getWidth(), bounds.height - BGND_U.getHeight() - UB.getHeight() + i);
                }
                ++i;
            }
            i = 0;
            while (i < UB.getHeight()) {
                color = FrogGIFReader.getColor(c, UB.getPath(), UB.getLeft(), UB.getTop() + i);
                if (color != null) {
                    g.setColor(color);
                    g.drawLine(LUC.getWidth(), i, bounds.width - RUC.getWidth(), i);
                }
                ++i;
            }
            i = 0;
            while (i < BB.getHeight()) {
                color = FrogGIFReader.getColor(c, BB.getPath(), BB.getLeft(), BB.getTop() + i);
                if (color != null) {
                    g.setColor(color);
                    g.drawLine(RBC.getWidth(), bounds.height - BB.getHeight() + i, bounds.width - RBC.getWidth(), bounds.height - BB.getHeight() + i);
                }
                ++i;
            }
            i = 0;
            while (i < RB.getWidth()) {
                color = FrogGIFReader.getColor(c, RB.getPath(), RB.getLeft() + i, RB.getTop());
                if (color != null) {
                    g.setColor(color);
                    g.drawLine(bounds.width - RB.getWidth() + i, RUC.getHeight(), bounds.width - RB.getWidth() + i, bounds.height - RBC.getHeight());
                }
                ++i;
            }
            g.drawImage(FrogLookAndFeel.getImageFromData(c, LUC), 0, 0, LUC.getWidth(), LUC.getHeight(), LUC.getLeft(), LUC.getTop(), LUC.getRight(), LUC.getBottom(), null);
            g.drawImage(FrogLookAndFeel.getImageFromData(c, LBC), 0, bounds.height - LBC.getHeight(), LBC.getWidth(), bounds.height, LBC.getLeft(), LBC.getTop(), LBC.getRight(), LBC.getBottom(), null);
            g.drawImage(FrogLookAndFeel.getImageFromData(c, RUC), bounds.width - RUC.getWidth(), 0, bounds.width, RUC.getHeight(), RUC.getLeft(), RUC.getTop(), RUC.getRight(), RUC.getBottom(), null);
            g.drawImage(FrogLookAndFeel.getImageFromData(c, RBC), bounds.width - RBC.getWidth(), bounds.height - RBC.getHeight(), bounds.width, bounds.height, RBC.getLeft(), RBC.getTop(), RBC.getRight(), RBC.getBottom(), null);
        }
    }

    protected static void initializeImageData() {
        if (FrogLookAndFeel.isMACOS9()) {
            mMacVendor = true;
        }
    }

    private boolean isInToolbar(JComponent component) {
        return component.getClientProperty("buttontype") != null && ((String)component.getClientProperty("buttontype")).equals("Toolbar");
    }

    private boolean isInAppToolbar(JComponent component) {
        return component.getClientProperty("buttontype") != null && ((String)component.getClientProperty("buttontype")).equals("AppToolbar");
    }

    public static FrogImageData[] getImageDataResources() {
        if (mImageDataResources == null) {
            FrogButtonUI.initializeImageData();
            FrogImageData[] datas = new FrogImageData[]{ThemeData.getImageData(null, "PButton.Bord.LB.UE"), ThemeData.getImageData(null, "PButton.Bord.UB.UE"), ThemeData.getImageData(null, "PButton.Bord.RB.UE"), ThemeData.getImageData(null, "PButton.Bord.BB.UE"), ThemeData.getImageData(null, "PButton.Bgnd.U.UE"), ThemeData.getImageData(null, "PButton.Bgnd.M.UE"), ThemeData.getImageData(null, "PButton.Bgnd.L.UE"), ThemeData.getImageData(null, "Toolbar.Btn.RMB.Out"), ThemeData.getImageData(null, "PButton.Bord.LB.PE"), ThemeData.getImageData(null, "PButton.Bord.UB.PE"), ThemeData.getImageData(null, "PButton.Bord.RB.PE"), ThemeData.getImageData(null, "PButton.Bord.BB.PE"), ThemeData.getImageData(null, "PButton.Bgnd.U.PE"), ThemeData.getImageData(null, "PButton.Bgnd.M.PE"), ThemeData.getImageData(null, "PButton.Bgnd.L.PE"), ThemeData.getImageData(null, "PButton.Bord.LB.FL"), ThemeData.getImageData(null, "PButton.Bord.UB.FL"), ThemeData.getImageData(null, "PButton.Bord.RB.FL"), ThemeData.getImageData(null, "PButton.Bord.BB.FL"), ThemeData.getImageData(null, "Toolbar.Btn.RMB.In"), ThemeData.getImageData(null, "Toolbar.Btn.MLB.In"), ThemeData.getImageData(null, "Toolbar.Btn.LMB.In"), ThemeData.getImageData(null, "Toolbar.Btn.MMM.In"), ThemeData.getImageData(null, "Toolbar.Btn.MUB.In"), ThemeData.getImageData(null, "Toolbar.Btn.MUB.Out"), ThemeData.getImageData(null, "Toolbar.Btn.LMB.Out"), ThemeData.getImageData(null, "Toolbar.Btn.MMM.Out"), ThemeData.getImageData(null, "Toolbar.Btn.MLB.Out")};
            mImageDataResources = datas;
        }
        return mImageDataResources;
    }
}

