/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import com.sap.plaf.frog.BumpBuffer;
import com.sap.plaf.frog.FrogLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;

class FrogBumps
implements Icon {
    protected int xBumps;
    protected int yBumps;
    protected Color topColor = FrogLookAndFeel.getPrimaryControlHighlight();
    protected Color shadowColor = FrogLookAndFeel.getPrimaryControlDarkShadow();
    protected Color backColor = FrogLookAndFeel.getPrimaryControlShadow();
    protected static Vector buffers = new Vector();
    protected BumpBuffer buffer;

    public FrogBumps(Dimension bumpArea) {
        this(bumpArea.width, bumpArea.height);
    }

    public FrogBumps(int width, int height) {
        this.setBumpArea(width, height);
        this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
        if (this.buffer == null) {
            this.createBuffer();
        }
    }

    public FrogBumps(int width, int height, Color newTopColor, Color newShadowColor, Color newBackColor) {
        this.setBumpArea(width, height);
        this.setBumpColors(newTopColor, newShadowColor, newBackColor);
        this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
        if (this.buffer == null) {
            this.createBuffer();
        }
    }

    protected void createBuffer() {
        this.buffer = new BumpBuffer(this.topColor, this.shadowColor, this.backColor);
        buffers.addElement(this.buffer);
    }

    protected BumpBuffer getBuffer(Color aTopColor, Color aShadowColor, Color aBackColor) {
        BumpBuffer result = null;
        Enumeration elements = buffers.elements();
        while (elements.hasMoreElements()) {
            BumpBuffer aBuffer = (BumpBuffer)elements.nextElement();
            if (!aBuffer.hasSameColors(aTopColor, aShadowColor, aBackColor)) continue;
            result = aBuffer;
            break;
        }
        return result;
    }

    public void setBumpArea(Dimension bumpArea) {
        this.setBumpArea(bumpArea.width, bumpArea.height);
    }

    public void setBumpArea(int width, int height) {
        this.xBumps = width / 2;
        this.yBumps = height / 2;
    }

    public void setBumpColors(Color newTopColor, Color newShadowColor, Color newBackColor) {
        this.topColor = newTopColor;
        this.shadowColor = newShadowColor;
        this.backColor = newBackColor;
        this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
        if (this.buffer == null) {
            this.createBuffer();
        }
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int bufferWidth = this.buffer.getImageSize().width;
        int bufferHeight = this.buffer.getImageSize().height;
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        int x2 = x + iconWidth;
        int y2 = y + iconHeight;
        int savex = x;
        while (y < y2) {
            int h = Math.min(y2 - y, bufferHeight);
            x = savex;
            while (x < x2) {
                int w = Math.min(x2 - x, bufferWidth);
                g.drawImage(this.buffer.getImage(), x, y, x + w, y + h, 0, 0, w, h, null);
                x += bufferWidth;
            }
            y += bufferHeight;
        }
    }

    public int getIconWidth() {
        return this.xBumps * 2;
    }

    public int getIconHeight() {
        return this.yBumps * 2;
    }
}

