/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.frog;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;

class BumpBuffer {
    static Frame frame;
    static Component component;
    static final int IMAGE_SIZE = 64;
    static Dimension imageSize;
    transient Image image;
    Color topColor;
    Color shadowColor;
    Color backColor;

    static {
        imageSize = new Dimension(64, 64);
    }

    public BumpBuffer(Color aTopColor, Color aShadowColor, Color aBackColor) {
        this.createComponent();
        this.image = this.getComponent().createImage(64, 64);
        this.topColor = aTopColor;
        this.shadowColor = aShadowColor;
        this.backColor = aBackColor;
        this.fillBumpBuffer();
    }

    public boolean hasSameColors(Color aTopColor, Color aShadowColor, Color aBackColor) {
        return this.topColor.equals(aTopColor) && this.shadowColor.equals(aShadowColor) && this.backColor.equals(aBackColor);
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = this.getComponent().createImage(64, 64);
            this.fillBumpBuffer();
        }
        return this.image;
    }

    public Dimension getImageSize() {
        return imageSize;
    }

    protected void fillBumpBuffer() {
        int y;
        Graphics g = this.image.getGraphics();
        g.setColor(this.backColor);
        g.fillRect(0, 0, 64, 64);
        g.setColor(this.topColor);
        int x = 0;
        while (x < 64) {
            y = 0;
            while (y < 64) {
                g.drawLine(x, y, x, y);
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
                y += 4;
            }
            x += 4;
        }
        g.setColor(this.shadowColor);
        x = 0;
        while (x < 64) {
            y = 0;
            while (y < 64) {
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 3, y + 3, x + 3, y + 3);
                y += 4;
            }
            x += 4;
        }
    }

    protected Component getComponent() {
        return component;
    }

    protected void createComponent() {
        if (frame == null) {
            frame = new Frame("bufferCreator");
        }
        if (component == null) {
            component = new Canvas();
            frame.add(component, "Center");
            frame.addNotify();
        }
    }
}

