/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.common;

import com.sap.xml.XMLNode;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class LookAndFeelUtil {
    public static final String __PerforceId = "$Id: //javagui/700_COR/src/java/com/sap/plaf/common/LookAndFeelUtil.java#1 $";
    static /* synthetic */ Class class$0;

    public static void fixLookAndFeel() {
        if (!LookAndFeelUtil.isMacintosh()) {
            return;
        }
        Keymap defaultKeymap = JTextComponent.getKeymap("default");
        defaultKeymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction(){

            public void actionPerformed(ActionEvent e) {
                JTextComponent target = this.getTextComponent(e);
                if (target != null && e != null && target.isEditable() && target.isEnabled()) {
                    char c;
                    String content = e.getActionCommand();
                    int mod = e.getModifiers();
                    if (content != null && content.length() > 0 && (mod & 4) == 0 && (c = content.charAt(0)) >= ' ' && c != '\u007f') {
                        target.replaceSelection(content);
                    }
                }
            }
        });
    }

    public static void fixInputMap(InputMap bindings) {
        if (bindings == null || !LookAndFeelUtil.isMacintosh()) {
            return;
        }
        KeyStroke[] keystrokes = bindings.allKeys();
        int i = 0;
        while (i < keystrokes.length) {
            if (bindings.get(keystrokes[i]).equals("copy-to-clipboard")) {
                bindings.remove(keystrokes[i]);
                bindings.put(KeyStroke.getKeyStroke(67, 4), "copy-to-clipboard");
            } else if (bindings.get(keystrokes[i]).equals("paste-from-clipboard")) {
                bindings.remove(keystrokes[i]);
                bindings.put(KeyStroke.getKeyStroke(86, 4), "paste-from-clipboard");
            } else if (bindings.get(keystrokes[i]).equals("cut-to-clipboard")) {
                bindings.remove(keystrokes[i]);
                bindings.put(KeyStroke.getKeyStroke(88, 4), "cut-to-clipboard");
            } else if (bindings.get(keystrokes[i]).equals("select-all")) {
                bindings.remove(keystrokes[i]);
                bindings.put(KeyStroke.getKeyStroke(65, 4), "select-all");
            } else if (bindings.get(keystrokes[i]).equals("caret-previous-word")) {
                bindings.remove(keystrokes[i]);
                bindings.put(KeyStroke.getKeyStroke(37, 8), "caret-previous-word");
            } else if (bindings.get(keystrokes[i]).equals("caret-next-word")) {
                bindings.remove(keystrokes[i]);
                bindings.put(KeyStroke.getKeyStroke(39, 8), "caret-next-word");
            } else if (bindings.get(keystrokes[i]).equals("caret-begin-line")) {
                bindings.put(KeyStroke.getKeyStroke(37, 4), "caret-begin-line");
            } else if (bindings.get(keystrokes[i]).equals("caret-end-line")) {
                bindings.put(KeyStroke.getKeyStroke(39, 4), "caret-end-line");
            } else if (bindings.get(keystrokes[i]).equals("selection-previous-word")) {
                bindings.remove(keystrokes[i]);
                bindings.put(KeyStroke.getKeyStroke(37, 9), "selection-previous-word");
            } else if (bindings.get(keystrokes[i]).equals("selection-next-word")) {
                bindings.remove(keystrokes[i]);
                bindings.put(KeyStroke.getKeyStroke(39, 9), "selection-next-word");
            } else if (bindings.get(keystrokes[i]).equals("selection-begin-line")) {
                bindings.remove(keystrokes[i]);
                bindings.put(KeyStroke.getKeyStroke(37, 5), "selection-begin-line");
            } else if (bindings.get(keystrokes[i]).equals("selection-end-line")) {
                bindings.remove(keystrokes[i]);
                bindings.put(KeyStroke.getKeyStroke(39, 5), "selection-end-line");
            }
            ++i;
        }
    }

    public static boolean isMacintosh() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Mac");
    }

    public static XMLNode getXMLNode(String filename) {
        ClassLoader loader;
        InputStream inputStream;
        XMLNode xmlNode = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sap.plaf.frog.util.ThemeData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((inputStream = (loader = clazz.getClassLoader()) == null ? ClassLoader.getSystemResourceAsStream(filename) : loader.getResourceAsStream(filename)) != null) {
            InputStreamReader inputreader = new InputStreamReader(inputStream);
            try {
                xmlNode = XMLNode.parseFrom(inputreader, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Error: Can not load xmlFile: " + filename);
        }
        return xmlNode;
    }
}

