/*
 * Decompiled with CFR 0.152.
 */
package com.sap.plaf.common;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class FontInfo {
    public static final String __PerforceId = "$Id: //javagui/700_COR/src/java/com/sap/plaf/common/FontInfo.java#1 $";
    public static final String LABELFONTSIZE = "labelFontSize";
    public static final String PROPFONTSIZE = "propFontSize";
    public static final String FIXEDFONTSIZE = "fixedFontSize";
    public static final String LABELFONT = "labelFont";
    public static final String PROPFONT = "propFont";
    public static final String FIXEDFONT = "fixedFont";
    public static final String LOOKANDFEEL = "lookAndFeel";
    public static final int EDITPROP = 0;
    public static final int EDITFIXED = 1;
    public static final int LABEL = 2;
    public static final int CONTROL = 3;
    public static final int EDITPROPBOLD = 4;
    public static final int EDITPROPBOLDITALIC = 5;
    public static final int EDITPROPITALIC = 6;
    public static final int MENU = 7;
    public static final int CONTROLBOLD = 8;
    public static final int CONTROLBIG1 = 9;
    public static final int CONTROLBIG2 = 10;
    public static final int MIN = 0;
    public static final int MAX = 10;
    public static String[] mJavaFontNames = FontInfo.initJavaFontNames();
    public static int[] mDefaultFontSizes = FontInfo.initDefaultFontSizes();
    public static final String[] mFontMap = new String[]{"proportionalFont", "fixedFont", "labelFont", "controlFont", "proportionalFontBold", "proportionalFontBoldItalic", "proportionalFontItalic", "Menu.font", "controlFontBold", "controlFontBoldBig1", "controlFontBoldBig2"};
    private static final int HEIGHTKLUDGE = 2;

    public static String[] initJavaFontNames() {
        String[] javaFontNames = new String[]{"SansSerif", "Monospaced", "Dialog", "Dialog", "SansSerif", "SansSerif", "SansSerif", "Dialog"};
        return javaFontNames;
    }

    public static int[] initDefaultFontSizes() {
        int[] defaultFontSizes = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
        if (System.getProperty("os.name").toUpperCase().startsWith("OS/2")) {
            defaultFontSizes[1] = 13;
        }
        if (System.getProperty("os.name").toUpperCase().startsWith("MAC")) {
            defaultFontSizes[0] = 10;
        }
        if (System.getProperty("os.name").toUpperCase().startsWith("MAC OS X")) {
            int i = 0;
            while (i <= 10) {
                defaultFontSizes[i] = 11;
                ++i;
            }
        }
        return defaultFontSizes;
    }

    public static FontMetrics getDefaultFontMetrics() {
        return Toolkit.getDefaultToolkit().getFontMetrics(FontInfo.getDefaultFont());
    }

    public static FontMetrics getFontMetrics(int fontIndex) {
        return Toolkit.getDefaultToolkit().getFontMetrics(FontInfo.getFont(fontIndex));
    }

    public static Font getDefaultFont() {
        return FontInfo.getFont(0);
    }

    public static Font getDefaultFont(int inFontType) {
        return new Font(FontInfo.getFontName(inFontType), 0, FontInfo.getDefaultFontSize(inFontType));
    }

    public static int getDefaultFontSize(int value) {
        int result = 12;
        if (value >= 0 && value <= 10) {
            result = mDefaultFontSizes[value];
        }
        return result;
    }

    public static String getFontName(int value) {
        String result = "Dialog";
        if (value >= 0 && value <= 10) {
            result = mJavaFontNames[value];
        }
        return result;
    }

    public static String getFontString(int value) {
        String retVal = FIXEDFONT;
        if (value >= 0 && value <= 10) {
            retVal = mFontMap[value];
        }
        return retVal;
    }

    public static Font getFont(int index) {
        if (index >= 0 && index <= 10) {
            return UIManager.getFont(FontInfo.getFontString(index));
        }
        Thread.dumpStack();
        return null;
    }

    public static Dimension getFontDimension(int fontIndex) {
        Font fnt = FontInfo.getFont(fontIndex);
        Toolkit tk = Toolkit.getDefaultToolkit();
        FontMetrics fm = tk.getFontMetrics(fnt);
        Dimension retVal = null;
        if (fontIndex >= 0 && fontIndex <= 10) {
            retVal = new Dimension(fm.charWidth('1'), fm.getHeight() - 2);
        }
        return retVal;
    }

    public static int getEMWidth(int fontIndex) {
        Font fnt = FontInfo.getFont(fontIndex);
        Toolkit tk = Toolkit.getDefaultToolkit();
        FontMetrics fm = tk.getFontMetrics(fnt);
        int retVal = -1;
        if (fontIndex >= 0 && fontIndex <= 10) {
            retVal = fm.charWidth('m');
        }
        return retVal;
    }

    public static int getEXHeight(int fontIndex) {
        Font fnt = FontInfo.getFont(fontIndex);
        Toolkit tk = Toolkit.getDefaultToolkit();
        FontMetrics fm = tk.getFontMetrics(fnt);
        int retVal = -1;
        if (fontIndex >= 0 && fontIndex <= 10) {
            retVal = fm.getAscent();
        }
        return retVal;
    }

    public static int getLength(int fontIndex) {
        Font fnt = FontInfo.getFont(fontIndex);
        Toolkit tk = Toolkit.getDefaultToolkit();
        FontMetrics fm = tk.getFontMetrics(fnt);
        int retVal = -1;
        if (fontIndex >= 0 && fontIndex <= 10) {
            retVal = fm.charWidth('1');
        }
        return retVal;
    }

    public static void updateFonts(Font labelFont, Font propFont, Font fixedFont) {
        int propFontSize = propFont.getSize();
        int fixedFontSize = fixedFont.getSize();
        int labelFontSize = labelFont.getSize();
        UIManager.put("currentProportionalFontSize", new Integer(propFontSize));
        UIManager.put("currentFixedFontSize", new Integer(fixedFontSize));
        UIManager.put("currentLabelFontSize", new Integer(labelFontSize));
        Font controlFontConstSize = new Font(labelFont.getName(), 0, FontInfo.getDefaultFontSize(3));
        Font fixedFontConstSize = new Font(fixedFont.getName(), 0, FontInfo.getDefaultFontSize(1));
        FontUIResource proportionalFont = new FontUIResource(propFont.getName(), 0, propFontSize);
        FontUIResource proportionalFontBold = new FontUIResource(propFont.getName(), 1, propFontSize);
        FontUIResource proportionalFontBoldItalic = new FontUIResource(propFont.getName(), 3, propFontSize);
        FontUIResource proportionalFontItalic = new FontUIResource(propFont.getName(), 2, propFontSize);
        FontUIResource controlFont = new FontUIResource(labelFont.getName(), 0, labelFontSize);
        FontUIResource controlFontBold = new FontUIResource(labelFont.getName(), 1, labelFontSize);
        labelFont = new FontUIResource(labelFont.getName(), 0, labelFontSize);
        FontUIResource smallFont = new FontUIResource(labelFont.getName(), 0, propFontSize - 2);
        FontUIResource okCodeFont = new FontUIResource(labelFont.getName(), 0, propFontSize - 1);
        fixedFont = new FontUIResource(fixedFont.getName(), 0, fixedFontSize);
        FontUIResource controlFontBoldBig1 = new FontUIResource(labelFont.getName(), 1, labelFontSize + 2);
        FontUIResource controlFontBoldBig2 = new FontUIResource(labelFont.getName(), 1, labelFontSize + 4);
        UIManager.put("currentProportionalFontSize", new Integer(propFontSize));
        UIManager.put("currentFixedFontSize", new Integer(fixedFontSize));
        UIManager.put(LABELFONTSIZE, new Integer(labelFontSize));
        UIManager.put("proportionalFont", proportionalFont);
        UIManager.put("proportionalFontBold", proportionalFontBold);
        UIManager.put("proportionalFontBoldItalic", proportionalFontBoldItalic);
        UIManager.put("proportionalFontItalic", proportionalFontItalic);
        UIManager.put(LABELFONT, labelFont);
        UIManager.put("controlFont", controlFont);
        UIManager.put("controlFontBold", controlFont);
        UIManager.put("controlFontBoldBig1", controlFontBoldBig1);
        UIManager.put("controlFontBoldBig2", controlFontBoldBig2);
        UIManager.put(FIXEDFONT, fixedFont);
        UIManager.put("TextField.font", labelFont);
        UIManager.put("PasswordField.font", labelFont);
        UIManager.put("TextArea.font", labelFont);
        UIManager.put("TextPane.font", labelFont);
        UIManager.put("EditorPane.font", labelFont);
        UIManager.put("Button.font", labelFont);
        UIManager.put("CheckBox.font", labelFont);
        UIManager.put("RadioButton.font", labelFont);
        UIManager.put("ToggleButton.font", controlFont);
        UIManager.put("ToolTip.font", labelFont);
        UIManager.put("ProgressBar.font", controlFont);
        UIManager.put("ComboBox.font", controlFont);
        UIManager.put("InternalFrame.font", controlFont);
        UIManager.put("TitledBorder.font", controlFont);
        UIManager.put("Label.font", labelFont);
        UIManager.put("TabbedPane.font", controlFont);
        UIManager.put("Table.font", labelFont);
        UIManager.put("MenuBar.font", labelFont);
        UIManager.put("Menu.font", labelFont);
        UIManager.put("Menu.font", labelFont);
        UIManager.put("MenuItem.font", labelFont);
        UIManager.put("CheckBoxMenuItem.font", labelFont);
        UIManager.put("RadioButtonMenuItem.font", labelFont);
        UIManager.put("ToolBar.font", controlFont);
        UIManager.put("Panel.okCodeField.Font", okCodeFont);
        UIManager.put("Tree.font", labelFont);
        UIManager.put("Menu.acceleratorFont", smallFont);
        UIManager.put("MenuItem.acceleratorFont", smallFont);
        UIManager.put("CheckBoxMenuItem.acceleratorFont", smallFont);
        UIManager.put("RadioButtonMenuItem.acceleratorFont", smallFont);
        UIManager.put("controlFontConstSize", controlFontConstSize);
        UIManager.put("fixedFontConstSize", fixedFontConstSize);
    }
}

