/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webservices.wsd.properties;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.vi.EndpointReference;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.ws.WSDRoot;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.metamodel.ws.plugin.WSRootManager;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.dtr.WsDtrService;
import com.sap.ide.ws.core.services.selena.UniqueNameUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class WsPPProperties {
    private static final String WSD_REFS_ENTRY_HEADER = "WSD Reference Entry";
    private static final String DC_CFG_FOLDER = "cfg";
    private static final String WS_PP_LIST_FILENAME = "wspp.properties";
    private static final String WSD_KEY = "WSD";
    private static final String VI_KEY = "VI";
    static /* synthetic */ Class class$com$sap$ide$webservices$wsd$properties$WsPPProperties;

    private static Properties getReferencedFilesQNamesForWsd(String projectName, WebServiceDefinition wsd) {
        Properties props = new Properties();
        VirtualInterface vi = WebServiceMdoResolver.resolveViReferenceByGuidForProject(projectName, wsd.getVirtualInterfaceReferences()[0].getViGuid());
        String wsdQName = UniqueNameUtil.createQualifiedNameForMdo((MainDevelopmentObject)wsd);
        String viQName = "Not found";
        String endpointImplQName = "Not found";
        if (vi != null) {
            viQName = UniqueNameUtil.createQualifiedNameForMdo((MainDevelopmentObject)vi) + ".videf";
            props.setProperty(wsdQName + '.' + VI_KEY, viQName);
            EndpointReference ref = vi.getEndpointReference();
            props.setProperty(wsdQName + '.' + EndpointAnalyser.getKeyForConfiguration((EndpointReference)ref), EndpointAnalyser.getEndPointName((EndpointReference)ref) + ".java");
        }
        return props;
    }

    private static Properties[] getWsdReferencedFileQNames(String projectName, WebServiceDefinition[] wsds) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        int i = 0;
        while (i < wsds.length) {
            Properties props = WsPPProperties.getReferencedFilesQNamesForWsd(projectName, wsds[i]);
            list.add(props);
            ++i;
        }
        return list.toArray(new Properties[list.size()]);
    }

    public static synchronized void createPPListPropertyFile(String projectName) {
        WSDRoot modelRoot = WSRootManager.getWSRoot((String)projectName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            if (project != null && project.hasNature("com.sap.ide.eclipse.component.provider.dcnature")) {
                WebServiceDefinition[] wsds = modelRoot.getWebServiceDefinitions();
                Properties[] props = WsPPProperties.getWsdReferencedFileQNames(projectName, wsds);
                WsPPProperties.writeProperies(project, props);
            }
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$wsd$properties$WsPPProperties == null ? (class$com$sap$ide$webservices$wsd$properties$WsPPProperties = WsPPProperties.class$("com.sap.ide.webservices.wsd.properties.WsPPProperties")) : class$com$sap$ide$webservices$wsd$properties$WsPPProperties));
        }
        catch (LoadException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$wsd$properties$WsPPProperties == null ? (class$com$sap$ide$webservices$wsd$properties$WsPPProperties = WsPPProperties.class$("com.sap.ide.webservices.wsd.properties.WsPPProperties")) : class$com$sap$ide$webservices$wsd$properties$WsPPProperties));
        }
    }

    private static synchronized void writeProperies(IProject project, Properties[] props) {
        String absoluteProjectPath = project.getLocation().toOSString();
        File f = new File(absoluteProjectPath = absoluteProjectPath + File.separator + DC_CFG_FOLDER + File.separator + WS_PP_LIST_FILENAME);
        if (!f.canWrite() && f.exists() && !WsDtrService.checkOutFile((String)absoluteProjectPath)) {
            WsPPProperties.warnUserAboutUpdateWsPPPropsFileNotPossible();
            return;
        }
        WsPPProperties.doWriteToFile(f, props);
    }

    private static void warnUserAboutUpdateWsPPPropsFileNotPossible() {
        MessageDialog dlg = new MessageDialog(Display.getCurrent().getActiveShell(), "Warning", null, "Read only wspp.properties cannot be updated", 4, new String[]{"Ok"}, 0);
        dlg.open();
    }

    private static void doWriteToFile(File f, Properties[] props) {
        try {
            FileOutputStream fos = new FileOutputStream(f);
            int i = 0;
            while (i < props.length) {
                props[i].store(fos, WSD_REFS_ENTRY_HEADER);
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$wsd$properties$WsPPProperties == null ? (class$com$sap$ide$webservices$wsd$properties$WsPPProperties = WsPPProperties.class$("com.sap.ide.webservices.wsd.properties.WsPPProperties")) : class$com$sap$ide$webservices$wsd$properties$WsPPProperties));
        }
        catch (IOException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$wsd$properties$WsPPProperties == null ? (class$com$sap$ide$webservices$wsd$properties$WsPPProperties = WsPPProperties.class$("com.sap.ide.webservices.wsd.properties.WsPPProperties")) : class$com$sap$ide$webservices$wsd$properties$WsPPProperties));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

