/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webservices.tsmodel.wsd.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.metamodel.vi.EndpointReference;
import com.sap.ide.metamodel.ws.VirtualInterfaceReference;
import com.sap.ide.metamodel.ws.WSDRoot;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.metamodel.ws.plugin.WSRootManager;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.webservices.tsmodel.generic.provider.mdo.DataSourceManager;
import com.sap.ide.webservices.tsmodel.generic.provider.util.UpdateDescription;
import com.sap.ide.webservices.tsmodel.vi.provider.VIDataSourceManager;
import com.sap.ide.webservices.tsmodel.vi.provider.ViDeleteListener;
import com.sap.ide.webservices.wsd.properties.WsPPProperties;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.dtr.MdoDtrService;
import com.sap.ide.ws.core.services.dtr.WsDtrService;
import com.sap.ide.ws.core.services.editors.DescriptorEditorUtils;
import com.sap.ide.ws.core.services.resources.WsRefreshAction;
import com.sap.ide.ws.core.services.selena.UniqueNameUtil;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.sap.ide.ws.wsddman.WebService;
import com.tssap.j2ee.core.providers.vi.ViModelMetaInfo;
import com.tssap.j2ee.core.providers.ws.WsdModelMetaInfo;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class WSDDataSourceManager
extends DataSourceManager
implements ViDeleteListener {
    private static WSDDataSourceManager mDataSourceManager;
    private static HashMap mInstanceMap;
    static /* synthetic */ Class class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager;

    public static DataSourceManager getDataSourceManager(String projectName) {
        WSDDataSourceManager dataSourceManager = (WSDDataSourceManager)((Object)mInstanceMap.get(projectName));
        if (dataSourceManager == null) {
            dataSourceManager = new WSDDataSourceManager(projectName);
            mInstanceMap.put(projectName, dataSourceManager);
        }
        return dataSourceManager;
    }

    protected WSDDataSourceManager(String projectName) {
        super(projectName);
        WSRootManager.getWSRoot((String)projectName).attachGlobalObserver((DevelopmentObjectObserver)this);
        VIDataSourceManager.addViDeleteListener((ViDeleteListener)this);
    }

    public void viDeleled(String viName, String viPackage) {
        try {
            WebServiceDefinition[] wsDefs = WSRootManager.getWSRoot((String)this.getProjectName()).getWebServiceDefinitions();
            int i = 0;
            while (i < wsDefs.length) {
                VirtualInterfaceReference[] viRefs = wsDefs[i].getVirtualInterfaceReferences();
                int j = 0;
                while (j < viRefs.length) {
                    MessageDialog dlg;
                    if (viRefs[j].getName().equals(viName) && viRefs[j].getPackage().equals(viPackage) && (dlg = new MessageDialog(Display.getCurrent().getActiveShell(), "Warning", null, "Web Service Definition: " + wsDefs[i].getName() + " has become invalid, delete?", 4, new String[]{"Yes", "No"}, 0)).open() == 0) {
                        WSDDataSourceManager.deleteWsd(WSRootManager.getWSRoot((String)this.getProjectName()).getMetamodel().getName(), wsDefs[i], true);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (LoadException e) {
            WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
        }
    }

    public static void deleteWsd(String projectName, WebServiceDefinition wsDefinition, final boolean refresh) {
        final String prjName = projectName;
        final WebServiceDefinition wsd = wsDefinition;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (WsDtrService.isDtrRelevant((String)wsd.getAbsolutePath())) {
                    if (MdoDtrService.checkOutMdoAndLanguageFiles((MainDevelopmentObject)wsd).hasFailedFilePaths()) {
                        WSDDataSourceManager.access$001(wsd.getName() + ".wsdef");
                        return;
                    }
                    WSDDataSourceManager.doDelete(prjName, wsd, refresh);
                } else {
                    if (wsd.isReadOnly()) {
                        WSDDataSourceManager.access$201(wsd.getName() + ".wsdef");
                        return;
                    }
                    WSDDataSourceManager.doDelete(prjName, wsd, refresh);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager = WSDDataSourceManager.class$("com.sap.ide.webservices.tsmodel.wsd.provider.WSDDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager));
        }
    }

    private static void doDelete(String projectName, WebServiceDefinition wsDefinition, boolean refresh) {
        try {
            DataSourceManager.doDeleteMdo((MainDevelopmentObject)wsDefinition);
            WsPPProperties.createPPListPropertyFile(projectName);
        }
        catch (DeleteException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager = WSDDataSourceManager.class$("com.sap.ide.webservices.tsmodel.wsd.provider.WSDDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager));
        }
        catch (SaveException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager = WSDDataSourceManager.class$("com.sap.ide.webservices.tsmodel.wsd.provider.WSDDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager));
        }
        if (refresh) {
            new WsRefreshAction().refresh(projectName);
        }
    }

    private static void deleteServicesBasedOnWsd(String projectName, WebServiceDefinition wsDefinition) {
        String wsdGuid = wsDefinition.getGuid();
        IProject[] referencingProjects = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            try {
                if (referencingProjects[i].hasNature("com.tssap.j2ee.core.ejbjar.ejbJarNature") && DescriptorManager.getDeploymentDescriptor((String)referencingProjects[i].getName()) != null) {
                    DeploymentDescriptor dd = DescriptorManager.getDeploymentDescriptor((String)referencingProjects[i].getName());
                    WebService[] services = dd.getWebServices();
                    int j = 0;
                    while (j < services.length) {
                        String wsdId = services[j].getGUID();
                        if (wsdId.equals(wsdGuid)) {
                            boolean editorClosed = DescriptorEditorUtils.closeEditor((String)referencingProjects[i].getName());
                            if (editorClosed) {
                                dd = DescriptorManager.getDeploymentDescriptor((String)referencingProjects[i].getName());
                            }
                            WSDDataSourceManager.deleteServiceMarkers(services[j].getInternalName(), referencingProjects[i].getName());
                            dd.deleteWebService(wsdGuid);
                            DescriptorManager.saveDeploymentDescriptor((DeploymentDescriptor)dd, (String)referencingProjects[i].getName());
                            if (editorClosed) {
                                DescriptorEditorUtils.start((IFile)DescriptorManager.getDescriptorFileByProjectName((String)referencingProjects[i].getName()), (String)"com.sap.ide.ws.editors.descriptor.WsDDEditor");
                            }
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager == null ? WSDDataSourceManager.class$("com.sap.ide.webservices.tsmodel.wsd.provider.WSDDataSourceManager") : class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager));
            }
            ++i;
        }
    }

    public static void deleteServiceMarkers(String serviceName, String projectName) {
        IFile dd = DescriptorManager.getDescriptorFileByProjectName((String)projectName);
        try {
            IMarker[] markers = dd.findMarkers("com.sap.ide.ws.checkMarker", false, 0);
            int i = 0;
            while (i < markers.length) {
                String serviceCfgName = (String)markers[i].getAttribute("location");
                if ((serviceCfgName = serviceCfgName.substring(0, serviceCfgName.indexOf(47))).startsWith(serviceName)) {
                    markers[i].delete();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager = WSDDataSourceManager.class$("com.sap.ide.webservices.tsmodel.wsd.provider.WSDDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager));
        }
    }

    public WebServiceDefinition[] getWebServiceDefinitionsBasedOnBean(Element element) {
        String qualifedBeanName = UniqueNameUtil.createQualifiedEntityName((Element)element);
        ArrayList<WebServiceDefinition> wsdList = new ArrayList<WebServiceDefinition>();
        try {
            WebServiceDefinition[] wsDefs = WSRootManager.getWSRoot((String)this.getProjectName()).getWebServiceDefinitions();
            int i = 0;
            while (i < wsDefs.length) {
                if (EndpointAnalyser.getEndPointName((EndpointReference)WebServiceMdoResolver.resolveViReferenceByGuidForProject(this.getProjectName(), wsDefs[i].getVirtualInterfaceReferences()[0].getViGuid()).getEndpointReference()).equals(qualifedBeanName)) {
                    wsdList.add(wsDefs[i]);
                }
                ++i;
            }
        }
        catch (LoadException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager = WSDDataSourceManager.class$("com.sap.ide.webservices.tsmodel.wsd.provider.WSDDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager));
        }
        return wsdList.toArray(new WebServiceDefinition[wsdList.size()]);
    }

    public WSDRoot getWSDRoot() {
        return WSRootManager.getWSRoot((String)this.getProjectName());
    }

    public void removeDataSourceManager(String projectName) {
        WSDDataSourceManager dataSourceManager = (WSDDataSourceManager)((Object)mInstanceMap.get(projectName));
        if (dataSourceManager == null) {
            return;
        }
        mInstanceMap.remove(projectName);
        WSRootManager.getWSRoot((String)projectName).detachGlobalObserver((DevelopmentObjectObserver)this);
        VIDataSourceManager.removeViDeleteListener((ViDeleteListener)this);
        dataSourceManager.destructor();
    }

    public UpdateDescription[] getObjectsToUpdate(MetamodelEvent event) {
        ArrayList<UpdateDescription> list = new ArrayList<UpdateDescription>();
        UniqueName uniqueName = null;
        DevelopmentObject object = event.getModifiedObject();
        if (object == null) {
            return null;
        }
        if (event.getEventId() == 1 || event.getEventId() == 2) {
            DevelopmentObject changedObject = event.getModifiedObject();
            if (changedObject instanceof WebServiceDefinition) {
                uniqueName = WSDDataSourceManager.createUniqueNameForStructureNode(WsdModelMetaInfo.getSubDomainForStructureNode());
            }
            if (uniqueName != null) {
                list.add(new UpdateDescription(uniqueName, ModelDeltaNodeKind.CHANGED));
            } else {
                return null;
            }
        }
        if (list.size() > 0) {
            UpdateDescription[] helperArray = new UpdateDescription[]{};
            return list.toArray(helperArray);
        }
        return null;
    }

    public static UniqueName createUniqueNameForStructureNode(String subDomain) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)subDomain, null, (String)WsdModelMetaInfo.getNameForStructureNode(), null);
        return uniqueName;
    }

    public static WebServiceDefinition getWebServiceDefinition(Entity sourceEntity) {
        WSDDataSourceManager manager = (WSDDataSourceManager)WSDDataSourceManager.getDataSourceManager(sourceEntity.getModel().getUniqueName().getName());
        if (manager != null) {
            return (WebServiceDefinition)manager.getDevelopmentObject(sourceEntity.getUniqueName());
        }
        return null;
    }

    static /* synthetic */ void access$001(String x0) {
        DataSourceManager.warnUserAboutDeleteNotPossible((String)x0);
    }

    static /* synthetic */ void access$201(String x0) {
        DataSourceManager.warnUserAboutDeleteNotPossible((String)x0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mInstanceMap = new HashMap();
    }
}

