/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webservices.tsmodel.prx.provider;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.metamodel.wsproxy.LogicalPort;
import com.sap.ide.metamodel.wsproxy.LogicalPortTemplate;
import com.sap.ide.metamodel.wsproxy.PRXRoot;
import com.sap.ide.metamodel.wsproxy.ProxyClass;
import com.sap.ide.metamodel.wsproxy.ProxyDefinition;
import com.sap.ide.metamodel.wsproxy.ServiceInterface;
import com.sap.ide.metamodel.wsproxy.WsdlFile;
import com.sap.ide.metamodel.wsproxy.plugin.PRXRootManager;
import com.sap.ide.webservices.tsmodel.generic.provider.mdo.DataSourceManager;
import com.sap.ide.webservices.tsmodel.generic.provider.util.UpdateDescription;
import com.sap.ide.webservices.tsmodel.prx.provider.DtrPrxPropertyProvider;
import com.sap.ide.webservices.tsmodel.prx.provider.WsProxyDeletion;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.dtr.CheckOutInfo;
import com.sap.ide.ws.core.services.dtr.MdoDtrService;
import com.sap.ide.ws.core.services.dtr.WsDtrService;
import com.sap.ide.ws.core.services.resources.WsRefreshAction;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.j2ee.core.providers.vi.ViModelMetaInfo;
import com.tssap.j2ee.core.providers.wsproxy.LpModelMetaInfo;
import com.tssap.j2ee.core.providers.wsproxy.LptModelMetaInfo;
import com.tssap.j2ee.core.providers.wsproxy.PrxClassesModelMetaInfo;
import com.tssap.j2ee.core.providers.wsproxy.SeiModelMetaInfo;
import com.tssap.j2ee.core.providers.wsproxy.WsdlModelMetaInfo;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PRXDataSourceManager
extends DataSourceManager {
    private PRXDataSourceManager mDataSourceManager;
    private static HashMap mInstanceMap = new HashMap();
    private static final int SOURCE_PATH = 0;
    private static final int FILE_PATH = 1;
    static /* synthetic */ Class class$com$sap$ide$webservices$tsmodel$prx$provider$PRXDataSourceManager;
    static /* synthetic */ Class class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager;

    public static DataSourceManager getDataSourceManager(String projectName) {
        PRXDataSourceManager dataSourceManager = (PRXDataSourceManager)((Object)mInstanceMap.get(projectName));
        if (dataSourceManager == null) {
            dataSourceManager = new PRXDataSourceManager(projectName);
            mInstanceMap.put(projectName, dataSourceManager);
        }
        return dataSourceManager;
    }

    protected PRXDataSourceManager(String projectName) {
        super(projectName);
        Metamodel metamodel = MetamodelManager.getMetamodel((String)projectName);
        PRXRootManager.getPRXRoot((String)projectName).attachGlobalObserver((DevelopmentObjectObserver)this);
    }

    public static boolean isJavaClass(IProject project, String relativeLocation, String fileName) {
        ICompilationUnit unit = PRXDataSourceManager.getCompilationUnit(project.getName(), relativeLocation, fileName);
        if (unit != null) {
            IType type = unit.getType(fileName.substring(0, fileName.indexOf(46)));
            try {
                return type.isClass();
            }
            catch (JavaModelException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$prx$provider$PRXDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$prx$provider$PRXDataSourceManager = PRXDataSourceManager.class$("com.sap.ide.webservices.tsmodel.prx.provider.PRXDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$prx$provider$PRXDataSourceManager));
            }
        }
        return true;
    }

    public static ICompilationUnit getCompilationUnit(String projectName, String relativeLocation, String fileName) {
        IClasspathEntry[] classpaths = MetamodelManager.getJavaProjectClassPaths((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        int i = 0;
        while (i < classpaths.length) {
            String completePath = classpaths[i].getPath().toOSString() + File.separator + relativeLocation + File.separator + fileName;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(completePath));
            if (file.exists()) {
                return JavaCore.createCompilationUnitFrom((IFile)file);
            }
            ++i;
        }
        return null;
    }

    public static void deleteProxy(ProxyDefinition proxyDefinition, final boolean refresh) {
        final String prjName = proxyDefinition.getMetamodel().getName();
        final ProxyDefinition prxDef = proxyDefinition;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                PRXDataSourceManager.doDelete(prjName, prxDef, refresh);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static void doDelete(String projectName, ProxyDefinition proxyDefinition, boolean refresh) {
        if (WsDtrService.isDtrRelevant((String)proxyDefinition.getAbsolutePath())) {
            CheckOutInfo checkOutInfo = MdoDtrService.checkOutMdoAndLanguageFiles((MainDevelopmentObject)proxyDefinition);
            if (checkOutInfo.hasFailedFilePaths()) {
                DataSourceManager.warnUserAboutDeleteNotPossible((String)(proxyDefinition.getName() + ".prxdef"));
                return;
            }
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dialog.open();
                IProgressMonitor progressMonitor = dialog.getProgressMonitor();
                checkOutInfo = WsDtrService.checkOutFilesAndDelete((String[])DtrPrxPropertyProvider.getProxyFilePathsAsString(projectName, proxyDefinition), (IVfsActivity)checkOutInfo.getActivity(), (IProgressMonitor)progressMonitor);
                dialog.close();
            }
            catch (Exception e) {
                System.out.println();
            }
            try {
                DataSourceManager.doDeleteMdo((MainDevelopmentObject)proxyDefinition);
            }
            catch (DeleteException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager = PRXDataSourceManager.class$("com.sap.ide.webservices.tsmodel.wsd.provider.WSDDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager));
            }
            catch (SaveException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager = PRXDataSourceManager.class$("com.sap.ide.webservices.tsmodel.wsd.provider.WSDDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$wsd$provider$WSDDataSourceManager));
            }
            if (checkOutInfo.hasFailedFilePaths()) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Information", (String)"Some files could not be checked out for delete from DTR, please delete them manually");
            }
        } else {
            if (MdoDtrService.isMdoOrLanguageFileReadOnly((MainDevelopmentObject)proxyDefinition)) {
                DataSourceManager.warnUserAboutDeleteNotPossible((String)(proxyDefinition.getName() + ".prxdef"));
                return;
            }
            WsProxyDeletion.deleteProxy(proxyDefinition);
        }
        if (refresh) {
            new WsRefreshAction().refresh(projectName);
        }
    }

    public static String getAbsolutePathForFileAcrossAllSourcePaths(String projectName, String relativeLocation, String fileName) {
        return PRXDataSourceManager.getPathForFile(projectName, relativeLocation, fileName, 1);
    }

    public static String getSourcePathForFile(String projectName, String relativeLocation, String fileName) {
        return PRXDataSourceManager.getPathForFile(projectName, relativeLocation, fileName, 0);
    }

    private static String getPathForFile(String projectName, String relativeLocation, String fileName, int fileOrSourcePath) {
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)projectName);
        ArrayList sourcePaths = manager.getProjectSourcePaths();
        String absolutePath = null;
        int i = 0;
        while (i < sourcePaths.size()) {
            Object sourcePath = sourcePaths.get(i);
            absolutePath = sourcePath + "\\" + relativeLocation + "\\" + fileName;
            File f = new File(absolutePath);
            if (f.exists()) {
                if (fileOrSourcePath == 0) {
                    return (String)sourcePath;
                }
                if (fileOrSourcePath == 1) {
                    return absolutePath;
                }
            }
            ++i;
        }
        return null;
    }

    public UpdateDescription[] getObjectsToUpdate(MetamodelEvent event) {
        ArrayList<UpdateDescription> list = new ArrayList<UpdateDescription>();
        UniqueName uniqueName = null;
        DevelopmentObject object = event.getModifiedObject();
        if (object == null) {
            return null;
        }
        DevelopmentObject changedObject = event.getModifiedObject();
        if (event.getEventId() == 1 || event.getEventId() == 2) {
            if (changedObject instanceof ProxyDefinition || changedObject instanceof LogicalPort || changedObject instanceof ProxyClass || changedObject instanceof ServiceInterface || changedObject instanceof WsdlFile || changedObject instanceof LogicalPortTemplate) {
                uniqueName = PRXDataSourceManager.createUniqueNameForProjectNode(object);
            }
            if (uniqueName != null) {
                list.add(new UpdateDescription(uniqueName, ModelDeltaNodeKind.TOTALLY_CHANGED));
            } else {
                return null;
            }
        }
        if (event.getEventId() == 4) {
            if (changedObject instanceof LogicalPort) {
                uniqueName = PRXDataSourceManager.createUniqueNameForProjectNode(object);
                list.add(new UpdateDescription(uniqueName, ModelDeltaNodeKind.CHANGED));
            } else {
                return null;
            }
        }
        if (list.size() > 0) {
            UpdateDescription[] helperArray = new UpdateDescription[]{};
            return list.toArray(helperArray);
        }
        return null;
    }

    public void removeDataSourceManager(String projectName) {
        PRXDataSourceManager dataSourceManager = (PRXDataSourceManager)((Object)mInstanceMap.get(projectName));
        if (dataSourceManager == null) {
            return;
        }
        mInstanceMap.remove(projectName);
        PRXRootManager.getPRXRoot((String)this.getProjectName()).detachGlobalObserver((DevelopmentObjectObserver)this);
        dataSourceManager.destructor();
    }

    public PRXRoot getPRXRoot() {
        return PRXRootManager.getPRXRoot((String)this.getProjectName());
    }

    public static UniqueName createUniqueNameForProjectNode(DevelopmentObject object) {
        return PRXDataSourceManager.createUniqueNameForProjectNode(object.getRoot().getMetamodel().getName());
    }

    public static UniqueName createUniqueNameForProjectNode(String projectName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)"model", (String)"project", null, (String)projectName, null);
        return uniqueName;
    }

    public static UniqueName createUniqueNameForWSDLStructNode(String parentPackage, String parentName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)WsdlModelMetaInfo.getSubDomainForStructureNode(), (String)parentPackage, (String)WsdlModelMetaInfo.getNameForStructureNode(), (String[])new String[]{parentName});
        return uniqueName;
    }

    public static UniqueName createUniqueNameForWSDLNode(String name, String location, String parentName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)WsdlModelMetaInfo.getSubDomain(), (String)location, (String)name, (String[])new String[]{parentName});
        return uniqueName;
    }

    public static UniqueName createUniqueNameForSEIStructNode(String parentPackage, String parentName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)SeiModelMetaInfo.getSubDomainForStructureNode(), (String)parentPackage, (String)SeiModelMetaInfo.getNameForStructureNode(), (String[])new String[]{parentName});
        return uniqueName;
    }

    public static UniqueName createUniqueNameForSEIClassNode(String name, String location, String parentName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)SeiModelMetaInfo.getSeiClassSubDomain(), (String)location, (String)name, (String[])new String[]{parentName});
        return uniqueName;
    }

    public static UniqueName createUniqueNameForSEIInterfaceNode(String name, String location, String parentName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)SeiModelMetaInfo.getSeiInterfaceSubDomain(), (String)location, (String)name, (String[])new String[]{parentName});
        return uniqueName;
    }

    public static UniqueName createUniqueNameForLPStructNode(String parentPackage, String parentName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)LpModelMetaInfo.getSubDomainForStructureNode(), (String)parentPackage, (String)LpModelMetaInfo.getNameForStructureNode(), (String[])new String[]{parentName});
        return uniqueName;
    }

    public static UniqueName createUniqueNameForLPNode(String name, String location, String parentName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)LpModelMetaInfo.getSubDomain(), (String)location, (String)name, (String[])new String[]{parentName});
        return uniqueName;
    }

    public static UniqueName createUniqueNameForPrxClassStructNode(String parentPackage, String parentName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)PrxClassesModelMetaInfo.getSubDomainForStructureNode(), (String)parentPackage, (String)PrxClassesModelMetaInfo.getNameForStructureNode(), (String[])new String[]{parentName});
        return uniqueName;
    }

    public static UniqueName createUniqueNameForPrxClassNode(String name, String location, String parentName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)PrxClassesModelMetaInfo.getSubDomainForPrxClass(), (String)location, (String)name, (String[])new String[]{parentName});
        return uniqueName;
    }

    public static UniqueName createUniqueNameForPrxClassInterfaceNode(String name, String location, String parentName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)PrxClassesModelMetaInfo.getSubDomainForPrxClassInterface(), (String)location, (String)name, (String[])new String[]{parentName});
        return uniqueName;
    }

    public static UniqueName createUniqueNameForLPTStructNode() {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)LptModelMetaInfo.getSubDomainForStructureNode(), null, (String)LptModelMetaInfo.getNameForStructureNode(), null);
        return uniqueName;
    }

    public static UniqueName createUniqueNameForLPTNode(String name) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)LptModelMetaInfo.getSubDomain(), null, (String)name, null);
        return uniqueName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

