/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webservices.tsmodel.prx.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.wsproxy.LogicalPort;
import com.sap.ide.metamodel.wsproxy.MetaFile;
import com.sap.ide.metamodel.wsproxy.ProxyClass;
import com.sap.ide.metamodel.wsproxy.ProxyDefinition;
import com.sap.ide.metamodel.wsproxy.ServiceInterface;
import com.sap.ide.metamodel.wsproxy.Wsdl;
import com.sap.ide.metamodel.wsproxy.WsdlFile;
import com.sap.ide.webservices.tsmodel.generic.provider.base.DtrPropertyProvider;
import com.sap.ide.webservices.tsmodel.generic.provider.mdo.DataSourceManager;
import com.sap.ide.webservices.tsmodel.prx.provider.PRXDataSourceManager;
import com.sap.ide.webservices.tsmodel.wsd.provider.WSDDataSourceManager;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.proxygenerator.FileDescriptor;
import com.sap.ide.ws.proxygenerator.HelperClassDescriptor;
import com.sap.ide.ws.proxygenerator.LpDescriptor;
import com.sap.ide.ws.proxygenerator.MetaDataDescriptor;
import com.sap.ide.ws.proxygenerator.SeiDescriptor;
import com.sap.ide.ws.proxygenerator.WsdlDescriptor;
import com.tssap.dii.dtri.DtriCheckedObjects;
import com.tssap.dii.dtri.DtriRelevantObjects;
import com.tssap.dii.dtri.DtriUtil;
import com.tssap.j2ee.core.providers.wsproxy.PrxModelMetaInfo;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DtrPrxPropertyProvider
extends DtrPropertyProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return super.isPropertyProviderApplicable(element, propertyName) && PrxModelMetaInfo.isProxy((UniqueName)element.getUniqueName());
    }

    protected DataSourceManager getDataSourceManager(String projectName) {
        return WSDDataSourceManager.getDataSourceManager(projectName);
    }

    public Object getObjectPropertyValue(Element element, String propertyName) {
        DtriRelevantObjects ret = null;
        ArrayList<IFile> dtrList = new ArrayList<IFile>();
        String projectName = element.getModel().getUniqueName().getName();
        DataSourceManager manager = this.getDataSourceManager(projectName);
        if (manager == null) {
            return null;
        }
        DevelopmentObject object = manager.getDevelopmentObject(element.getUniqueName());
        if (object instanceof MainDevelopmentObject) {
            Path path = new Path(((MainDevelopmentObject)object).getAbsolutePath());
            dtrList.add(ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path));
            IPath[] paths = DtrPrxPropertyProvider.getProxyFilePaths(projectName, (ProxyDefinition)object);
            int i = 0;
            while (i < paths.length) {
                dtrList.add(ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(paths[i]));
                ++i;
            }
            DtriCheckedObjects dtrCheckedObjects = DtriUtil.getDtrCheckedObjects(dtrList);
            if (dtrCheckedObjects.hasDtrRelevantObjects()) {
                ret = new DtriRelevantObjects(dtrCheckedObjects.getDtrRelevantObjectList());
            }
        }
        return ret;
    }

    public static IPath[] getProxyFilePaths(String projectName, ProxyDefinition prxDef) {
        ArrayList<Path> list = new ArrayList<Path>();
        FileDescriptor[] files = DtrPrxPropertyProvider.unmarshallProxyFiles(prxDef);
        int i = 0;
        while (i < files.length) {
            String pathString;
            if (files[i] instanceof WsdlDescriptor) {
                WsdlDescriptor[] childFiles = ((WsdlDescriptor)files[i]).getChildWSDLs();
                int j = 0;
                while (j < childFiles.length) {
                    String path = PRXDataSourceManager.getAbsolutePathForFileAcrossAllSourcePaths(projectName, childFiles[j].path, childFiles[j].name);
                    if (path != null) {
                        list.add(new Path(path));
                    }
                    ++j;
                }
            }
            if ((pathString = PRXDataSourceManager.getAbsolutePathForFileAcrossAllSourcePaths(projectName, files[i].path, files[i].name)) != null) {
                list.add(new Path(pathString));
            }
            ++i;
        }
        return list.toArray(new IPath[list.size()]);
    }

    public static String[] getProxyFilePathsAsString(String projectName, ProxyDefinition prxDef) {
        IPath[] paths = DtrPrxPropertyProvider.getProxyFilePaths(projectName, prxDef);
        String[] pathStrings = new String[paths.length];
        int i = 0;
        while (i < paths.length) {
            pathStrings[i] = paths[i].toOSString();
            ++i;
        }
        return pathStrings;
    }

    public static FileDescriptor[] unmarshallProxyFiles(ProxyDefinition prxDef) {
        try {
            return DtrPrxPropertyProvider.unmarshallProxyFiles(prxDef, false);
        }
        catch (DeleteException e) {
            WebServiceCorePlugin.logErrorSimulated((Throwable)e);
            return null;
        }
    }

    public static FileDescriptor[] unmarshallProxyFiles(ProxyDefinition prxDef, boolean delete) throws DeleteException {
        ArrayList<Object> files = new ArrayList<Object>();
        LogicalPort[] lps = prxDef.getLogicalPorts();
        int i = 0;
        while (i < lps.length) {
            files.add(new LpDescriptor(lps[i].getRelativeLocation(), lps[i].getFileName(), lps[i].getDisplayName()));
            if (delete) {
                lps[i].delete();
            }
            ++i;
        }
        Wsdl[] wsdls = prxDef.getWsdls();
        int i2 = 0;
        while (i2 < wsdls.length) {
            WsdlDescriptor wsdlsDesc = new WsdlDescriptor(wsdls[i2].getRelativeLocation(), wsdls[i2].getFileName());
            WsdlFile[] childWSDLs = wsdls[i2].getWsdlFiles();
            int j = 0;
            while (j < childWSDLs.length) {
                wsdlsDesc.addChildWSDL(new WsdlDescriptor(childWSDLs[j].getRelativeLocation(), childWSDLs[j].getFileName()));
                ++j;
            }
            files.add(wsdlsDesc);
            if (delete) {
                wsdls[i2].delete();
            }
            ++i2;
        }
        ServiceInterface[] seis = prxDef.getServiceInterfaces();
        int i3 = 0;
        while (i3 < seis.length) {
            files.add(new SeiDescriptor(seis[i3].getRelativeLocation(), seis[i3].getFileName(), seis[i3].getName()));
            if (delete) {
                seis[i3].delete();
            }
            ++i3;
        }
        MetaFile[] metafiles = prxDef.getMetaFiles();
        int i4 = 0;
        while (i4 < metafiles.length) {
            files.add(new MetaDataDescriptor(metafiles[i4].getRelativeLocation(), metafiles[i4].getFileName()));
            if (delete) {
                metafiles[i4].delete();
            }
            ++i4;
        }
        ProxyClass[] prxClasses = prxDef.getProxyClasses();
        int i5 = 0;
        while (i5 < prxClasses.length) {
            files.add(new HelperClassDescriptor(prxClasses[i5].getRelativeLocation(), prxClasses[i5].getFileName(), prxClasses[i5].getName()));
            if (delete) {
                prxClasses[i5].delete();
            }
            ++i5;
        }
        return files.toArray(new FileDescriptor[files.size()]);
    }
}

