/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webservices.tsmodel.ejbjarprj.provider;

import com.sap.ide.webservices.tsmodel.generic.provider.base.RegisteredProvider;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.descriptors.DescriptorChangeListener;
import com.sap.ide.ws.core.services.editors.DescriptorEditorUtils;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import org.eclipse.core.resources.IFile;

public final class WsdRefListDeltaProvider
extends RegisteredProvider
implements DeltaTreeProvider,
DescriptorChangeListener {
    private RootModelDeltaNode myRoot;

    public void registered(Model model) {
        super.registered(model);
        DescriptorManager manager = DescriptorManager.getWebServiceDescriptorManager((String)model.getUniqueName().getName());
        if (manager != null) {
            manager.addWsdProjectListener((DescriptorChangeListener)this);
        }
        this.getModelChanges();
    }

    public void unregistered(Model model) {
        DescriptorManager manager = DescriptorManager.getWebServiceDescriptorManager((String)model.getUniqueName().getName());
        if (manager != null) {
            manager.removeWsdProjectListener((DescriptorChangeListener)this);
        }
        super.unregistered(model);
    }

    public ModelDeltaNode getModelChanges() {
        RootModelDeltaNode myPrevRoot = this.myRoot;
        this.myRoot = new RootModelDeltaNode(this.getModel());
        return myPrevRoot;
    }

    public void wsdDDModified(IFile file) {
        this.addWsdDDDelta(file, ModelDeltaNodeKind.CHANGED);
        this.fireContentsChanged();
    }

    public void wsdDDRemoved(IFile file) {
        DescriptorEditorUtils.closeEditor((String)file.getProject().getName());
        this.addWsdDDDelta(file, ModelDeltaNodeKind.DELETED);
        this.fireContentsChanged();
    }

    public void wsdDDAdded(IFile file) {
        this.addWsdDDDelta(file, ModelDeltaNodeKind.NEW);
        this.fireContentsChanged();
    }

    private void addWsdDDDelta(IFile file, ModelDeltaNodeKind kind) {
        UniqueName uniqueName = EjbJarModelMetaInfo.getEjbJar((IFile)file);
        final Model model = this.getModel();
        if (model == null) {
            return;
        }
        DefaultModelDeltaNode ejbJarNode = new DefaultModelDeltaNode(model, uniqueName, kind){

            public UniqueName getParentUniqueName() {
                return model.getUniqueName();
            }

            public boolean isEmpty() {
                return false;
            }
        };
        this.myRoot.addDeltaNode((TreeModelDeltaNode)ejbJarNode);
    }

    private void fireContentsChanged() {
        Model model = this.getModel();
        if (model == null) {
            return;
        }
        model.getExtensionManager().modelContentsChanged();
    }
}

