/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webservices.tsmodel.ejbjarprj.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.webservices.mdos.ProjectReferenceResolver;
import com.sap.ide.webservices.mdos.ProjectWsdRefs;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.webservices.tsmodel.generic.provider.base.RegisteredProvider;
import com.sap.ide.webservices.tsmodel.generic.provider.mdo.DataSourceManager;
import com.sap.ide.webservices.tsmodel.wsd.provider.WSDDataSourceManager;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.sap.ide.ws.wsddman.WebService;
import com.sap.ide.ws.wsddman.impl0.WebServiceImpl;
import com.tssap.j2ee.core.providers.ws.WsModelMetaInfo;
import com.tssap.j2ee.core.providers.ws.WsdModelMetaInfo;
import com.tssap.j2ee.model.wsd.dd.impl.WsdRefList;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class WsProvider
extends RegisteredProvider
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public UniqueName getParentUniqueName(Element child) {
        Entity wsDescriptor;
        ReferenceCollection rc;
        String serviceGUID = child.getUniqueName().getParameter(0);
        String serviceName = child.getUniqueName().getParameter(1);
        Model m = child.getModel();
        WsdRefList list = null;
        EntityEnumeration entityEnumeration = m.children();
        while (entityEnumeration.hasMoreElements()) {
            Entity ent = entityEnumeration.next();
            if (!ent.getUniqueName().getDomain().equals(WsModelMetaInfo.getDomainForWebServiceList()) || !ent.getUniqueName().getSubDomain().equals(WsModelMetaInfo.getSubDomainForWebServiceList())) continue;
            list = new WsdRefList(ent.getModel(), ent.getUniqueName());
        }
        if (list != null && (rc = WsModelMetaInfo.getAssociatedReferenceCollection((Entity)(wsDescriptor = list.getEntity()))) != null) {
            ReferenceEnumeration refs = rc.references();
            while (refs.hasMoreElements()) {
                Reference ent = refs.next();
                if (!WsModelMetaInfo.getWsReferenceName((UniqueName)ent.getEntity().getUniqueName()).equals(serviceName) || !WsModelMetaInfo.getSourceWsdGuid((UniqueName)ent.getEntity().getUniqueName()).equals(serviceGUID)) continue;
                return ent.getEntity().getUniqueName();
            }
        }
        return null;
    }

    public void registered(Model model) {
        super.registered(model);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!WsModelMetaInfo.isWsdRefList((UniqueName)parent.getUniqueName())) {
            return false;
        }
        if (template == null) {
            return false;
        }
        Entity wsdEntity = WsModelMetaInfo.getSourceWsd((Entity)template);
        return wsdEntity != null && WsdModelMetaInfo.isWsd((UniqueName)wsdEntity.getUniqueName());
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Entity sourceEntity = (Entity)template.getObjectPropertyValue("definition");
        String beanName = (String)template.getObjectPropertyValue("beanName");
        String wsdReferenceName = (String)template.getObjectPropertyValue("refName");
        WebServiceDefinition definition = WSDDataSourceManager.getWebServiceDefinition(sourceEntity);
        if (definition != null) {
            DeploymentDescriptor dd = DescriptorManager.getDeploymentDescriptor((String)parent.getModel().getUniqueName().getName());
            WebServiceImpl ws = new WebServiceImpl();
            ws.setGUID(definition.getGuid());
            ws.setEJBNameTemp(beanName);
            ws.setInternalname(wsdReferenceName);
            dd.addWebService((WebService)ws);
            DescriptorManager.saveDeploymentDescriptor((DeploymentDescriptor)dd, (String)parent.getModel().getUniqueName().getName());
            UniqueName sourceModel = sourceEntity.getModel().getUniqueName();
            return ProxyMetaInfo.getProxyUniqueName((UniqueName)parent.getUniqueName(), (UniqueName)sourceModel, (UniqueName)sourceEntity.getUniqueName(), (String[])new String[]{definition.getGuid()});
        }
        return null;
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WsModelMetaInfo.isWsdRefList((UniqueName)parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        DeploymentDescriptor dd = DescriptorManager.getDeploymentDescriptor((String)parent.getModel().getUniqueName().getName());
        if (dd == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        WebService[] services = dd.getWebServices();
        ArrayList<UniqueName> uniqueNames = new ArrayList<UniqueName>(services.length);
        int i = 0;
        while (i < services.length) {
            String serviceGuid = services[i].getGUID();
            String serviceName = services[i].getInternalName();
            ArrayList<IProject> list = new ArrayList<IProject>();
            IProject[] referencedProjects = ProjectReferenceResolver.getReferencedProjects(parent);
            int j = 0;
            while (j < referencedProjects.length) {
                list.add(referencedProjects[j]);
                ++j;
            }
            list.add(ResourcesPlugin.getWorkspace().getRoot().getProject(parent.getModel().getUniqueName().getName()));
            ProjectWsdRefs retObj = WebServiceMdoResolver.resolveWsdReferenceByGuidForProjects(list.toArray(new IProject[list.size()]), services[i].getGUID());
            if (retObj != null) {
                UniqueName sourceModel = ModelUinSupport.createModelUin((String)retObj.getProjectName());
                UniqueName wsdUniqueName = DataSourceManager.createUniqueName((DevelopmentObject)retObj.getDefinition(0), (String)WsdModelMetaInfo.getSubDomain());
                if (ModelAccess.getModel((UniqueName)sourceModel).findEntity(wsdUniqueName) == null) {
                    System.err.println("WSD [" + services[i].getGUID() + "] is not provided in the model: " + sourceModel.getName());
                } else {
                    UniqueName proxy = ProxyMetaInfo.getProxyUniqueName((UniqueName)parent.getUniqueName(), (UniqueName)sourceModel, (UniqueName)wsdUniqueName, (String[])new String[]{serviceGuid, services[i].getInternalName()});
                    ProxyMetaInfo.bind((UniqueName)proxy, (UniqueName)this.getModel().getUniqueName());
                    if (proxy != null) {
                        uniqueNames.add(proxy);
                    }
                }
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uniqueNames.iterator());
    }

    public boolean exists(UniqueName uniqueName) {
        return false;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        if (!ProxyMetaInfo.isProxyUniqueName((UniqueName)uniqueName)) {
            return false;
        }
        UniqueName source = ProxyMetaInfo.getSourceUniqueName((UniqueName)uniqueName);
        return WsdModelMetaInfo.isWsd((UniqueName)source);
    }

    public boolean canDelete(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        DeploymentDescriptor dd = DescriptorManager.getDeploymentDescriptor((String)((Entity)element).getModel().getUniqueName().getName());
        if (dd == null) {
            return false;
        }
        if (ProxyMetaInfo.getParametersCount((UniqueName)uniqueName) < 1) {
            return false;
        }
        String guid = ProxyMetaInfo.getParameter((UniqueName)uniqueName, (int)0);
        if (guid == null || guid.length() == 0) {
            return false;
        }
        WebService service = dd.getWebService(guid, WsModelMetaInfo.getWsReferenceName((UniqueName)element.getUniqueName()));
        return service != null;
    }

    public void delete(Element element) {
        DeploymentDescriptor dd = DescriptorManager.getDeploymentDescriptor((String)element.getModel().getUniqueName().getName());
        Element source = ProxyMetaInfo.getSourceElement((UniqueName)element.getUniqueName());
        WebServiceDefinition definition = null;
        if (source instanceof Entity) {
            definition = WSDDataSourceManager.getWebServiceDefinition((Entity)source);
        }
        if (definition != null) {
            String serviceName = WsModelMetaInfo.getWsReferenceName((UniqueName)element.getUniqueName());
            dd.deleteWebService(definition.getGuid(), serviceName);
            WSDDataSourceManager.deleteServiceMarkers(serviceName, this.getProjectName());
            DescriptorManager.saveDeploymentDescriptor((DeploymentDescriptor)dd, (String)element.getModel().getUniqueName().getName());
        }
    }

    public boolean isDeleted(Element element) {
        return false;
    }
}

