/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webservices.tsmodel.ejbjarprj.provider;

import com.sap.ide.webservices.tsmodel.ejbjarprj.provider.PropertyHelper;
import com.sap.ide.webservices.tsmodel.generic.provider.base.RegisteredPropertyProvider;
import com.sap.ide.ws.wsddman.Configuration;
import com.tssap.j2ee.core.providers.ws.WsConfigModelInfo;
import com.tssap.j2ee.core.providers.ws.WsModelMetaInfo;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class WsConfigPropertyProvider
extends RegisteredPropertyProvider
implements PropertySetProvider {
    private static final String WS_NAME = "ws_name";
    private static final String WSD_REFD = "wsd_name";
    private static final String CONFIG_STATE = "cfg_state";
    private static final String WS_TARGET_NS = "ws_target_ns";
    private static final String TP_BINDING = "tp_Binding_Name";
    private static final String TARGET_SERVER_URL = "target_url";

    public WsConfigPropertyProvider() {
        super(new String[]{"$metaclass", WS_NAME, WSD_REFD, WS_TARGET_NS, TP_BINDING});
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (propertyName.equals("$metaclass")) {
            return WsConfigModelInfo.getMetaClass();
        }
        if (propertyName.equals(WS_NAME)) {
            Entity parent = element.getParent();
            return WsModelMetaInfo.getWsReferenceName((UniqueName)parent.getUniqueName());
        }
        if (propertyName.equals(WSD_REFD)) {
            return PropertyHelper.getQualifiedWsdNameFromConfig(element);
        }
        if (propertyName.equals(TP_BINDING)) {
            Configuration cfg = PropertyHelper.getConfiguration(element);
            return cfg.getTransportBinding().getWSDLBindingName().getLocalName();
        }
        if (propertyName.equals(WS_TARGET_NS)) {
            // empty if block
        }
        if (propertyName.equals(TARGET_SERVER_URL)) {
            return PropertyHelper.getConfiguration(element).getTargetServerURL();
        }
        return null;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyName.equals(CONFIG_STATE);
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
    }

    public PropertyEnumeration properties(Element element) {
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(this.getProperty(element, WS_NAME));
        list.add(this.getProperty(element, WSD_REFD));
        list.add(this.getProperty(element, WS_TARGET_NS));
        list.add(this.getProperty(element, TP_BINDING));
        return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(list));
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return WsConfigModelInfo.isWsConfiguration((UniqueName)element.getUniqueName()) && this.getPropertyNames().contains(propertyName);
    }
}

