/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webservices.tsmodel.archive.provider;

import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.sap.ide.ws.model.WebServiceProjectManager;
import com.sap.ide.ws.model.projects.IWebServiceProject;
import com.sap.ide.ws.model.projects.java.IJavaProject;
import com.sap.ide.ws.model.projects.proxy.IDeployableProxyProject;
import com.sap.ide.ws.model.projects.proxy.IProxyProject;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.filefolder.FileAndFolderManagement;
import com.tssap.selena.model.util.ChildrenProviderAdapter;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.core.resources.IFile;

public class ArchiveFileProvider
extends ChildrenProviderAdapter {
    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebServiceFilterFactory.isDeployableProxyDCProject((UniqueName)parent.getUniqueName()) || WebServiceFilterFactory.isJavaDcProject((UniqueName)parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        IWebServiceProject wsProject = WebServiceProjectManager.getWebServiceProject((Element)parent);
        Vector<UniqueName> uniqueNames = new Vector<UniqueName>();
        if (wsProject != null) {
            UniqueName uniqueName;
            if (wsProject instanceof IProxyProject) {
                UniqueName uniqueName2;
                IFile[] file = ((IProxyProject)wsProject).getClientApiJarFiles();
                int i = 0;
                while (i < file.length) {
                    uniqueNames.add(this.createUniqueName(file[i]));
                    ++i;
                }
                if (wsProject instanceof IDeployableProxyProject && (uniqueName2 = this.createUniqueName(((IDeployableProxyProject)wsProject).getDeployableArchiveFile())) != null) {
                    uniqueNames.add(uniqueName2);
                }
            } else if (wsProject instanceof IJavaProject && (uniqueName = this.createUniqueName(((IJavaProject)wsProject).getDeployableArchiveFile())) != null) {
                uniqueNames.add(uniqueName);
            }
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(uniqueNames));
    }

    public UniqueName createUniqueName(IFile archiveFile) {
        UniqueName ret = null;
        if (archiveFile != null) {
            UniqueName uniqueName;
            ret = uniqueName = FileAndFolderManagement.getInstance().getUniqueName((Object)archiveFile);
        }
        return ret;
    }

    public boolean exists(String uniqueName) {
        return false;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return false;
    }

    public boolean isDeleted(Element element) {
        return false;
    }

    public boolean exists(UniqueName uniqueName) {
        return false;
    }
}

