/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.util;

import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.util.IErrorUtil;
import org.eclipse.help.internal.util.RuntimeHelpStatus;
import org.eclipse.help.ui.internal.WorkbenchHelpPlugin;
import org.eclipse.help.ui.internal.util.RuntimeErrorDialog;
import org.eclipse.help.ui.internal.util.WorkbenchResources;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ErrorUtil
implements IErrorUtil {
    public void displayError(String msg) {
        ErrorUtil.displayErrorDialog(msg);
    }

    public void displayError(final String msg, Thread uiThread) {
        try {
            Display.findDisplay((Thread)uiThread).asyncExec(new Runnable(){

                public void run() {
                    ErrorUtil.displayErrorDialog(msg);
                }
            });
        }
        catch (Exception exception) {}
    }

    public static void displayErrorDialog(String msg) {
        String title = WorkbenchResources.getString("Help_Error");
        IWorkbenchWindow workbenchWindow = ErrorUtil.getActiveWorkbenchWindow();
        Shell shell = workbenchWindow != null ? workbenchWindow.getShell() : new Shell();
        MessageDialog.openError((Shell)shell, (String)title, (String)msg);
        WorkbenchHelpPlugin.logError(msg, null);
    }

    public static void displayErrorDialog(String msg, Throwable ex) {
        String title = WorkbenchResources.getString("Help_Error");
        IWorkbenchWindow workbenchWindow = ErrorUtil.getActiveWorkbenchWindow();
        Shell shell = workbenchWindow != null ? workbenchWindow.getShell() : new Shell();
        MessageDialog.openError((Shell)shell, (String)title, (String)msg);
        WorkbenchHelpPlugin.logError(msg, ex);
    }

    public static void displayInfoDialog(String msg) {
        String title = WorkbenchResources.getString("Help_Info");
        IWorkbenchWindow workbenchWindow = ErrorUtil.getActiveWorkbenchWindow();
        Shell shell = workbenchWindow != null ? workbenchWindow.getShell() : new Shell();
        MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
        if (HelpPlugin.DEBUG) {
            System.out.println(msg);
        }
    }

    public static boolean displayQuestionDialog(String msg) {
        String title = WorkbenchResources.getString("Help_Question");
        IWorkbenchWindow workbenchWindow = ErrorUtil.getActiveWorkbenchWindow();
        Shell shell = workbenchWindow != null ? workbenchWindow.getShell() : new Shell();
        return MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg);
    }

    public static void displayStatus() {
        if (RuntimeHelpStatus.getInstance().errorsExist()) {
            String title = WorkbenchResources.getString("Help_Error");
            String msg = WorkbenchResources.getString("WE005");
            String errorMessage = RuntimeHelpStatus.getInstance().toString();
            Shell parent = ErrorUtil.getActiveWorkbenchWindow().getShell();
            RuntimeErrorDialog.open(parent, title, msg, errorMessage);
            RuntimeHelpStatus.getInstance().reset();
        }
    }

    protected static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }
}

