/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import java.util.Vector;
import org.apache.xerces.dom.ASModelImpl;
import org.apache.xerces.dom3.as.ASModel;
import org.apache.xerces.dom3.as.DOMASBuilder;
import org.apache.xerces.dom3.as.DOMASException;
import org.apache.xerces.dom3.ls.DOMInputSource;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.validation.XMLGrammarPoolImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.parsers.DOMBuilderImpl;
import org.apache.xerces.parsers.DTDXSParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;

public class DOMASBuilderImpl
extends DOMBuilderImpl
implements DOMASBuilder {
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected XSGrammarBucket fGrammarBucket;
    protected SubstitutionGroupHandler fSubGroupHandler;
    protected CMBuilder fCMBuilder;
    protected XSDHandler fSchemaHandler;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected SymbolTable fSymbolTable;
    protected XMLGrammarPool fGrammarPool = null;
    protected ASModelImpl fAbstractSchema;
    String XMLNS;
    String URI_XSI;
    String XSI_SCHEMALOCATION;
    String XSI_NONAMESPACESCHEMALOCATION;
    String XSI_TYPE;
    String XSI_NIL;
    String URI_SCHEMAFORSCHEMA;

    public DOMASBuilderImpl() {
        super(new DTDXSParserConfiguration());
    }

    public DOMASBuilderImpl(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
    }

    public DOMASBuilderImpl(SymbolTable symbolTable) {
        super(new DTDXSParserConfiguration(symbolTable));
    }

    public DOMASBuilderImpl(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        super(new DTDXSParserConfiguration(symbolTable, xMLGrammarPool));
        this.fGrammarPool = xMLGrammarPool;
    }

    public ASModel getAbstractSchema() {
        return this.fAbstractSchema;
    }

    public void setAbstractSchema(ASModel aSModel) {
        this.fAbstractSchema = (ASModelImpl)aSModel;
        if (this.fGrammarPool == null) {
            this.fGrammarPool = (XMLGrammarPool)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/grammar-pool");
        }
        this.initGrammarPool(this.fAbstractSchema);
    }

    public ASModel parseASURI(String string) throws DOMASException, Exception {
        XMLInputSource xMLInputSource = new XMLInputSource(null, string, null);
        return this.parseASInputSource(xMLInputSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ASModel parseASInputSource(DOMInputSource dOMInputSource) throws DOMASException, Exception {
        XMLInputSource xMLInputSource = this.dom2xmlInputSource(dOMInputSource);
        try {
            try {
                ASModel aSModel = this.parseASInputSource(xMLInputSource);
                Object var6_5 = null;
                if (dOMInputSource.getStringData() == null) return aSModel;
                try {
                    xMLInputSource.getCharacterStream().close();
                    return aSModel;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return aSModel;
            }
            catch (XNIException xNIException) {
                Exception exception = xNIException.getException();
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (dOMInputSource.getStringData() == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            xMLInputSource.getCharacterStream().close();
            throw throwable;
        }
    }

    ASModel parseASInputSource(XMLInputSource xMLInputSource) throws Exception {
        if (this.fSchemaHandler == null) {
            this.fGrammarBucket = new XSGrammarBucket();
            this.fSubGroupHandler = new SubstitutionGroupHandler(this.fGrammarBucket);
            this.fSchemaHandler = new XSDHandler(this.fGrammarBucket);
            this.fCMBuilder = new CMBuilder(new XSDeclarationPool());
        }
        this.fErrorReporter = (XMLErrorReporter)this.fConfiguration.getProperty(ERROR_REPORTER);
        this.fEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty(ENTITY_MANAGER);
        this.fSymbolTable = (SymbolTable)this.fConfiguration.getProperty(SYMBOL_TABLE);
        String string = (String)this.fConfiguration.getProperty("http://apache.org/xml/properties/schema/external-schemaLocation");
        String string2 = (String)this.fConfiguration.getProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation");
        boolean bl = this.fConfiguration.getFeature("http://apache.org/xml/features/allow-java-encodings");
        boolean bl2 = this.fConfiguration.getFeature("http://apache.org/xml/features/continue-after-fatal-error");
        this.XMLNS = this.fSymbolTable.addSymbol("xmlns");
        this.URI_XSI = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
        this.XSI_SCHEMALOCATION = this.fSymbolTable.addSymbol("schemaLocation");
        this.XSI_NONAMESPACESCHEMALOCATION = this.fSymbolTable.addSymbol("noNamespaceSchemaLocation");
        this.XSI_TYPE = this.fSymbolTable.addSymbol("type");
        this.XSI_NIL = this.fSymbolTable.addSymbol("nil");
        this.URI_SCHEMAFORSCHEMA = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema");
        this.initGrammarBucket();
        this.fSubGroupHandler.reset();
        this.fSchemaHandler.reset(this.fErrorReporter, this.fEntityResolver, this.fSymbolTable, string, string2, bl, bl2);
        SchemaGrammar schemaGrammar = this.fSchemaHandler.parseSchema(null, xMLInputSource, (short)3);
        if (this.getFeature(SCHEMA_FULL_CHECKING)) {
            XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
        }
        ASModelImpl aSModelImpl = new ASModelImpl();
        this.addGrammars(aSModelImpl, this.fGrammarBucket);
        return aSModelImpl;
    }

    private void initGrammarBucket() {
        this.fGrammarBucket.reset();
        if (this.fAbstractSchema != null) {
            this.initGrammarBucketRecurse(this.fAbstractSchema);
        }
    }

    private void initGrammarBucketRecurse(ASModelImpl aSModelImpl) {
        if (aSModelImpl.getGrammar() != null) {
            this.fGrammarBucket.putGrammar(aSModelImpl.getGrammar());
        }
        int n = 0;
        while (n < aSModelImpl.getInternalASModels().size()) {
            ASModelImpl aSModelImpl2 = (ASModelImpl)aSModelImpl.getInternalASModels().elementAt(n);
            this.initGrammarBucketRecurse(aSModelImpl2);
            ++n;
        }
    }

    private void addGrammars(ASModelImpl aSModelImpl, XSGrammarBucket xSGrammarBucket) {
        SchemaGrammar[] schemaGrammarArray = xSGrammarBucket.getGrammars();
        int n = 0;
        while (n < schemaGrammarArray.length) {
            ASModelImpl aSModelImpl2 = new ASModelImpl();
            aSModelImpl2.setGrammar(schemaGrammarArray[n]);
            aSModelImpl.addASModel(aSModelImpl2);
            ++n;
        }
    }

    private void initGrammarPool(ASModelImpl aSModelImpl) {
        Object object;
        if (!(this.fGrammarPool instanceof XMLGrammarPoolImpl)) {
            return;
        }
        XMLGrammarPoolImpl xMLGrammarPoolImpl = (XMLGrammarPoolImpl)this.fGrammarPool;
        SchemaGrammar schemaGrammar = null;
        schemaGrammar = aSModelImpl.getGrammar();
        if (schemaGrammar != null) {
            object = schemaGrammar.getTargetNamespace();
            xMLGrammarPoolImpl.putGrammarNS((String)object, schemaGrammar);
        }
        object = aSModelImpl.getInternalASModels();
        int n = 0;
        while (n < ((Vector)object).size()) {
            this.initGrammarPool((ASModelImpl)((Vector)object).elementAt(n));
            ++n;
        }
    }
}

