/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.db.search;

import com.sap.exception.BaseException;
import com.sap.exception.BaseRuntimeException;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.db.RepositoryDB;
import com.sap.ip.mmr.dbmodel.Index;
import com.sap.ip.mmr.dbmodel.Table;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.QueryFilter;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.Attribute;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.reflect.RefObject;

public class AttributesValues {
    public static final int VALUE_MAX_SIZE = 50;
    public static final String ATTRIBUTE_NAME = "ATRNAME";
    public static final int ATTRIBUTE_TYPE = 1;
    public static final int ATTRIBUTE_SIZE = 40;
    public static final String VALUE_NAME = "ATRVALUE";
    public static final int VALUE_TYPE = 1;
    public static final int VALUE_SIZE = 50;
    public static final String VALUEUC_NAME = "ATRVALUEUC";
    public static final int VALUEUC_TYPE = 1;
    public static final int VALUEUC_SIZE = 50;
    private static final String PERF_COUNTER_INSERT = "AttributesValues insert";
    private static final String PERF_COUNTER_UPDATE = "AttributesValues update";
    private static final String PERF_COUNTER_DELETE = "AttributesValues delete";
    private static final String PERF_COUNTER_SELECT = "AttributesValues select";
    private Table table;
    protected RepositoryDB repositoryDB;
    protected int mofLayer;
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$db$search$AttributesValues == null ? (class$com$sap$ip$mmr$db$search$AttributesValues = AttributesValues.class$("com.sap.ip.mmr.db.search.AttributesValues")) : class$com$sap$ip$mmr$db$search$AttributesValues);
    static /* synthetic */ Class class$com$sap$ip$mmr$db$search$AttributesValues;

    public AttributesValues(RepositoryDB repositoryDB, int mofLayer) {
        this.repositoryDB = repositoryDB;
        this.mofLayer = mofLayer;
        this.initialize();
    }

    public List query(int workspaceSid, int typeSid, QueryFilters filters, IConnection connection, Workspace workspace) {
        LinkedList mofIds = new LinkedList();
        if (filters == null) {
            Collection col = null;
            try {
                switch (this.mofLayer) {
                    case 1: {
                        col = this.repositoryDB.selectM1AllOfClass(workspaceSid, typeSid);
                        break;
                    }
                    case 2: {
                        col = this.repositoryDB.selectM2AllOfClass(workspaceSid, typeSid);
                    }
                }
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (col != null && col.size() > 0) {
                mofIds.addAll(col);
            }
        } else {
            int n = 0;
            Iterator iter = filters.iterator();
            while (iter.hasNext()) {
                QueryFilter qf = (QueryFilter)iter.next();
                List l = this.queryFilter(workspaceSid, typeSid, qf, connection, workspace);
                if (n > 0) {
                    if (mofIds.size() == 0) break;
                    mofIds.retainAll(l);
                } else {
                    mofIds.addAll(l);
                }
                ++n;
            }
        }
        return mofIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected List queryFilter(int workspaceSid, int typeSid, QueryFilter qf, IConnection connection, Workspace workspace) {
        LinkedList<String> mofIds;
        block18: {
            String method = "queryFilter(int workspaceSid, int typeSid, QueryFilter qf)";
            mofIds = new LinkedList<String>();
            if (qf.getAttribute() == null || qf.getValue() == null) {
                return mofIds;
            }
            String operator = ' ' + qf.getComparatorAsSQLString() + ' ';
            String sql = null;
            Statement stmt = null;
            ResultSet res = null;
            Connection con = this.repositoryDB.getConnection();
            if (typeSid < 0) {
                sql = "SELECT MOFID FROM " + this.table.getName() + " WHERE " + "WORKSPACE" + " = ? AND " + ATTRIBUTE_NAME + " = ? AND " + VALUE_NAME + operator + " ?";
                stmt = con.prepareStatement(sql);
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, qf.getAttribute());
                stmt.setString(3, qf.getValue());
            } else {
                sql = "SELECT MOFID FROM " + this.table.getName() + " WHERE " + "WORKSPACE" + " = ? AND " + ATTRIBUTE_NAME + " = ? AND " + VALUE_NAME + operator + " ? AND " + "OBJTYPE" + " = ?";
                stmt = con.prepareStatement(sql);
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, qf.getAttribute());
                stmt.setString(3, qf.getValue());
                stmt.setInt(4, typeSid);
            }
            res = stmt.executeQuery();
            int posMofId = res.findColumn("MOFID");
            while (res.next()) {
                String mofId = res.getString(posMofId).trim();
                if (mofId == null) continue;
                mofIds.add(mofId);
            }
            connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_SELECT);
            Object var16_16 = null;
            RepositoryDB.conClose(con, "queryFilter(int workspaceSid, int typeSid, QueryFilter qf)");
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                break block18;
            }
            catch (SQLException ex) {
                RepositoryDB.writeExceptionToLog("queryFilter(int workspaceSid, int typeSid, QueryFilter qf)", ex);
            }
            break block18;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("queryFilter(int workspaceSid, int typeSid, QueryFilter qf)", e);
                    Object var16_17 = null;
                    RepositoryDB.conClose(con, "queryFilter(int workspaceSid, int typeSid, QueryFilter qf)");
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (res != null) {
                            res.close();
                        }
                        break block18;
                    }
                    catch (SQLException ex) {
                        RepositoryDB.writeExceptionToLog("queryFilter(int workspaceSid, int typeSid, QueryFilter qf)", ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                RepositoryDB.conClose(con, "queryFilter(int workspaceSid, int typeSid, QueryFilter qf)");
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                }
                catch (SQLException ex) {
                    RepositoryDB.writeExceptionToLog("queryFilter(int workspaceSid, int typeSid, QueryFilter qf)", ex);
                }
                throw throwable;
            }
        }
        return mofIds;
    }

    public void delete(Connection con, int workspaceSid, String mofId, IConnection connection, Workspace workspace) {
        String method = "delete(Connection con, String mofId)";
        try {
            PreparedStatement ps = this.getPSDelete(con);
            ps.setInt(1, workspaceSid);
            ps.setString(2, mofId);
            ps.executeUpdate();
            ps.close();
            connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_DELETE);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("delete(Connection con, String mofId)", e);
        }
    }

    public void add(Connection con, int workspaceSid, com.sap.ip.mmr.search.AttributesValues av, IConnection connection, Workspace workspace) {
        String method = "add(Connection con, int workspaceSid, com.sap.ip.mmr.search.AttributesValues av, IConnection connection, Workspace workspace)";
        PreparedStatement psInsert = null;
        PreparedStatement psUpdate = null;
        try {
            psInsert = this.getPSInsert(con);
            psUpdate = this.getPSUpdate(con);
            Iterator i1 = av.getMapType().keySet().iterator();
            while (i1.hasNext()) {
                String type = (String)i1.next();
                int typeSid = this.repositoryDB.getSIDForValue("OBJTYPE", type);
                Map mapAtr = (Map)av.getMapType().get(type);
                Iterator i2 = mapAtr.keySet().iterator();
                while (i2.hasNext()) {
                    String atrName = (String)i2.next();
                    Map mapVal = (Map)mapAtr.get(atrName);
                    Iterator i3 = mapVal.keySet().iterator();
                    while (i3.hasNext()) {
                        String atrValue = (String)i3.next();
                        Set setMofId = (Set)mapVal.get(atrValue);
                        Iterator i4 = setMofId.iterator();
                        if (atrName.length() > 40) {
                            atrName = atrName.substring(0, 40);
                        }
                        if (atrValue.length() > 50) {
                            atrValue = atrValue.substring(0, 50);
                        }
                        atrName = atrName.trim();
                        if ((atrValue = atrValue.trim()).length() == 0) continue;
                        while (i4.hasNext()) {
                            String mofId = (String)i4.next();
                            psUpdate.setInt(1, typeSid);
                            psUpdate.setInt(2, workspaceSid);
                            psUpdate.setString(3, mofId);
                            psUpdate.setString(4, atrName);
                            psUpdate.setString(5, atrValue);
                            int numUpd = psUpdate.executeUpdate();
                            if (numUpd == 1) {
                                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_UPDATE);
                                continue;
                            }
                            try {
                                psInsert.setInt(1, workspaceSid);
                                psInsert.setString(2, mofId);
                                psInsert.setString(3, atrName);
                                psInsert.setString(4, atrValue);
                                psInsert.setInt(5, typeSid);
                                psInsert.executeUpdate();
                                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_INSERT);
                            }
                            catch (Exception e1) {
                                RepositoryDB.writeExceptionToLog("add(Connection con, int workspaceSid, com.sap.ip.mmr.search.AttributesValues av, IConnection connection, Workspace workspace)", e1);
                            }
                        }
                    }
                }
            }
            psInsert.close();
            psUpdate.close();
        }
        catch (Exception e) {
            try {
                if (psInsert != null) {
                    psInsert.close();
                }
                if (psUpdate != null) {
                    psUpdate.close();
                }
            }
            catch (SQLException ex) {
                RepositoryServer.category.errorT(location, ex.toString());
            }
        }
    }

    public void add(Connection con, int workspaceSid, RefObject refObject, IConnection connection, Workspace workspace) {
        String method = "add(int conId, int workspaceSid, RefObject refObject)";
        RefObject metaObject = refObject.refMetaObject();
        if (metaObject == null) {
            RepositoryServer.getCategory().errorT(location, "add(int conId, int workspaceSid, RefObject refObject)", MMRResourceAccessor.getInstance().getMessageText("3011"), new Object[]{refObject.toString()});
            return;
        }
        if (!(metaObject instanceof MofClass)) {
            RepositoryServer.getCategory().errorT(location, "add(int conId, int workspaceSid, RefObject refObject)", MMRResourceAccessor.getInstance().getMessageText("3012"), new Object[]{refObject.toString()});
            return;
        }
        MofClass mc = (MofClass)metaObject;
        String mofId = refObject.refMofId();
        String qn = Utilities.getUtilities().encodeQualifiedName(mc.getQualifiedName());
        int type = this.repositoryDB.getSIDForValue("OBJTYPE", qn);
        this.delete(con, workspaceSid, mofId, connection, workspace);
        Iterator iter = Utilities.getUtilities().getAllContent((ModelElement)mc).iterator();
        PreparedStatement ps = null;
        try {
            ps = this.getPSInsert(con);
            while (iter.hasNext()) {
                String str;
                Object atrValue;
                Object o = iter.next();
                if (!(o instanceof Attribute)) continue;
                String atrName = ((Attribute)o).getName().trim();
                if (atrName.length() > 40) {
                    atrName = atrName.substring(0, 40);
                }
                if ((atrValue = refObject.refGetValue(atrName)) == null || (str = atrValue instanceof String ? ((String)atrValue).trim() : atrValue.toString().trim()) == null || str.length() >= 50) continue;
                if (str.length() < 1) {
                    str = " ";
                }
                try {
                    ps.setInt(1, workspaceSid);
                    ps.setString(2, mofId);
                    ps.setString(3, atrName);
                    ps.setString(4, str);
                    ps.setInt(5, type);
                    ps.executeUpdate();
                    connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_INSERT);
                }
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("add(int conId, int workspaceSid, RefObject refObject)", e);
                }
            }
            ps.close();
        }
        catch (Exception e) {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                RepositoryDB.writeExceptionToLog("add(int conId, int workspaceSid, RefObject refObject)", e);
            }
        }
    }

    public Collection getTables() {
        LinkedList<Table> l = new LinkedList<Table>();
        if (this.table == null) {
            String name = null;
            switch (this.mofLayer) {
                case 2: {
                    name = "BI_MMRL2AV";
                    break;
                }
                case 1: {
                    name = "BI_MMRL1AV";
                }
            }
            this.table = new Table(name);
            this.table.addColumn("WORKSPACE", 4, 10, true);
            this.table.addColumn("MOFID", 0, 32, true);
            this.table.addColumn(ATTRIBUTE_NAME, 1, 40, true);
            this.table.addColumn(VALUE_NAME, 1, 50, true);
            this.table.addColumn("OBJTYPE", 4, 10, false);
            Index idx = new Index(this.table.getName(), "idx1");
            idx.setUnique(true);
            idx.addColumn("WORKSPACE");
            idx.addColumn(ATTRIBUTE_NAME);
            idx.addColumn(VALUE_NAME);
            idx.addColumn("OBJTYPE");
            this.table.addIndex(idx);
        }
        l.add(this.table);
        return l;
    }

    protected PreparedStatement getPSInsert(Connection con) {
        String method = "getPSInsert(Connection con)";
        String sql = "INSERT INTO " + this.table.getName() + this.table.getColumnList() + " VALUES (?, ?, ?, ?, ?)";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSInsert(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSUpdate(Connection con) {
        String method = "getPSUpdate(Connection con)";
        String sql = "UPDATE " + this.table.getName() + " SET " + "OBJTYPE" + " = ? WHERE " + "WORKSPACE" + " = ? AND " + "MOFID" + " = ? AND " + ATTRIBUTE_NAME + " = ? AND " + VALUE_NAME + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSUpdate(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSDelete(Connection con) {
        String method = "getPSDelete(Connection con)";
        String sql = "DELETE FROM " + this.table.getName() + " WHERE " + "WORKSPACE" + " = ? AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSDelete(Connection con)", e);
        }
        return ps;
    }

    private void initialize() {
        this.getTables();
    }

    protected String getComponentNameMeasurement(Workspace w) {
        return "AttributesValues::" + w.getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

