/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.db;

import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.db.RepositoryDB;
import com.sap.ip.mmr.dbmodel.Index;
import com.sap.ip.mmr.dbmodel.Table;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NumberRange {
    protected static final String DBTABLENUMBERRANGE = "BI_MMRNRRANGE";
    protected static final String DBTABLENRSID = "BI_MMRNRSIDS";
    protected static final String FIELD_NRID_NAME = "NRID";
    protected static final int FIELD_NRID_SIZE = 10;
    protected static final String FIELD_NRSID_NAME = "NRSID";
    protected static final String FIELD_NMVALUE_NAME = "NRVALUE";
    protected static int FIELD_NMVALUE_SIZE = 240;
    protected static final String INDEX_NRSID_1_NAME = "01";
    protected static final int SID_INITIAL = 0;
    protected RepositoryDB repositoryDB;
    protected Table tableRange = null;
    protected Table tableSIDs = null;
    protected Index index1 = null;
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$db$NumberRange == null ? (class$com$sap$ip$mmr$db$NumberRange = NumberRange.class$("com.sap.ip.mmr.db.NumberRange")) : class$com$sap$ip$mmr$db$NumberRange);
    static /* synthetic */ Class class$com$sap$ip$mmr$db$NumberRange;

    public NumberRange(RepositoryDB repositoryDB) {
        this.repositoryDB = repositoryDB;
        this.initialize();
    }

    private void initialize() {
        this.getTables();
    }

    public List getTables() {
        ArrayList<Table> list = new ArrayList<Table>(3);
        if (this.tableRange == null) {
            this.tableRange = new Table(DBTABLENUMBERRANGE);
            this.tableRange.addColumn(FIELD_NRID_NAME, 0, 10, true);
            this.tableRange.addColumn(FIELD_NRSID_NAME, 4, 10, false);
        }
        list.add(this.tableRange);
        if (this.tableSIDs == null) {
            this.tableSIDs = new Table(DBTABLENRSID);
            this.tableSIDs.addColumn(FIELD_NRID_NAME, 0, 10, true);
            this.tableSIDs.addColumn(FIELD_NMVALUE_NAME, 1, FIELD_NMVALUE_SIZE, true);
            this.tableSIDs.addColumn(FIELD_NRSID_NAME, 4, 10, false);
            this.index1 = new Index(DBTABLENRSID, INDEX_NRSID_1_NAME);
            this.index1.addColumn(FIELD_NRID_NAME);
            this.index1.addColumn(FIELD_NRSID_NAME);
            this.index1.setUnique(true);
            this.tableSIDs.addIndex(this.index1);
        }
        list.add(this.tableSIDs);
        return list;
    }

    protected PreparedStatement getPSSelect(Connection con) {
        String method = "getPSSelect(Connection con)";
        String sql = "SELECT NRSID FROM BI_MMRNRRANGE WHERE NRID = ? FOR UPDATE";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("SELECT NRSID FROM BI_MMRNRRANGE WHERE NRID = ? FOR UPDATE");
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "getPSSelect(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSUpdate(Connection con) {
        String method = "getPSUpdate(Connection con))";
        String sql = "UPDATE BI_MMRNRRANGE SET NRSID = NRSID + 1 WHERE NRID = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("UPDATE BI_MMRNRRANGE SET NRSID = NRSID + 1 WHERE NRID = ?");
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "getPSUpdate(Connection con))", e);
        }
        return ps;
    }

    protected PreparedStatement getPSInsert(Connection con) {
        String method = "getPSInsert(Connection con)";
        String sql = "INSERT INTO BI_MMRNRRANGE" + this.tableRange.getColumnList() + " VALUES (?, ?)";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "getPSInsert(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSMapInsert(Connection con) {
        String method = "getPSMapInsert(Connection con)";
        String sql = "INSERT INTO BI_MMRNRSIDS" + this.tableSIDs.getColumnList() + " VALUES (?, ?, ?)";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "getPSMapInsert(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSMapReadAll(Connection con) {
        String method = "getPSMapReadAll(Connection con)";
        String sql = "SELECT NRVALUE, NRSID FROM BI_MMRNRSIDS WHERE NRID = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("SELECT NRVALUE, NRSID FROM BI_MMRNRSIDS WHERE NRID = ?");
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "getPSMapReadAll(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSMapReadValue(Connection con) {
        String method = "getPSMapReadValue(Connection con)";
        String sql = "SELECT NRVALUE FROM BI_MMRNRSIDS WHERE NRID = ? AND NRSID = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("SELECT NRVALUE FROM BI_MMRNRSIDS WHERE NRID = ? AND NRSID = ?");
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "getPSMapReadValue(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSMapReadSID(Connection con) {
        String method = "getPSMapReadSID(Connection con)";
        String sql = "SELECT NRSID FROM BI_MMRNRSIDS WHERE NRID = ? AND NRVALUE = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("SELECT NRSID FROM BI_MMRNRSIDS WHERE NRID = ? AND NRVALUE = ?");
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "getPSMapReadSID(Connection con)", e);
        }
        return ps;
    }

    public void finalize() {
    }

    public int getNextNumber(String numberRangeID) {
        String method = "getNextNumber(String numberRangeID)";
        Connection con = this.repositoryDB.getConnection();
        PreparedStatement ps = null;
        ResultSet res = null;
        int number = -1;
        try {
            ps = this.getPSSelect(con);
            ps.setString(1, numberRangeID.trim());
            res = ps.executeQuery();
            while (res.next()) {
                number = res.getInt(FIELD_NRSID_NAME);
            }
            res.close();
            ps.close();
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "getNextNumber(String numberRangeID)", e);
            RepositoryDB.conRollback(con, "getNextNumber(String numberRangeID)");
            RepositoryDB.conClose(con, "getNextNumber(String numberRangeID)");
            return -1;
        }
        if (number < 0) {
            try {
                ps = this.getPSInsert(con);
                ps.setString(1, numberRangeID.trim());
                ps.setInt(2, 0);
                int nUpdates = ps.executeUpdate();
                if (nUpdates != 1) {
                    RepositoryServer.getCategory().errorT(location, "getNextNumber(String numberRangeID)", MMRResourceAccessor.getInstance().getMessageText("3108"), new Object[]{numberRangeID});
                    ps.close();
                    RepositoryDB.conRollback(con, "getNextNumber(String numberRangeID)");
                    RepositoryDB.conClose(con, "getNextNumber(String numberRangeID)");
                    return -1;
                }
                number = 0;
                ps.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog(location, "getNextNumber(String numberRangeID)", e2);
            }
        } else {
            try {
                ++number;
                ps = this.getPSUpdate(con);
                ps.setString(1, numberRangeID.trim());
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog(location, "getNextNumber(String numberRangeID)", e);
            }
        }
        RepositoryDB.conCommit(con, "getNextNumber(String numberRangeID)");
        RepositoryDB.conClose(con, "getNextNumber(String numberRangeID)");
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMapping(String numberRangeID, String value, int sid) {
        String method = "addMapping(String numberRangeID, String value, int sid)";
        Connection con = this.repositoryDB.getConnection();
        PreparedStatement ps = null;
        boolean retcode = true;
        try {
            ps = this.getPSMapInsert(con);
            ps.setString(1, numberRangeID.trim());
            ps.setString(2, value);
            ps.setInt(3, sid);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "addMapping(String numberRangeID, String value, int sid)", e);
            retcode = false;
        }
        finally {
            RepositoryDB.conCommit(con, "addMapping(String numberRangeID, String value, int sid)");
            RepositoryDB.conClose(con, "addMapping(String numberRangeID, String value, int sid)");
        }
        return retcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap readAll(String numberRangeID) {
        String method = "readAll(String numberRangeID)";
        Connection con = this.repositoryDB.getConnection();
        PreparedStatement ps = null;
        HashMap<String, String> mappings = new HashMap<String, String>(100);
        try {
            ps = this.getPSMapReadAll(con);
            ps.setString(1, numberRangeID.trim());
            ResultSet res = ps.executeQuery();
            int posValue = res.findColumn(FIELD_NMVALUE_NAME);
            int posSID = res.findColumn(FIELD_NRSID_NAME);
            while (res.next()) {
                String value = res.getString(posValue).trim();
                int sid = res.getInt(posSID);
                mappings.put(value, String.valueOf(sid));
            }
            res.close();
            ps.close();
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "readAll(String numberRangeID)", e);
        }
        finally {
            RepositoryDB.conCommit(con, "readAll(String numberRangeID)");
            RepositoryDB.conClose(con, "readAll(String numberRangeID)");
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readValue(String numberRangeID, int SID) {
        String method = "readValue(String numberRangeID, int SID)";
        if (SID == 0) {
            return "";
        }
        Connection con = this.repositoryDB.getConnection();
        PreparedStatement ps = null;
        String value = null;
        try {
            ps = this.getPSMapReadValue(con);
            ps.setString(1, numberRangeID.trim());
            ps.setInt(2, SID);
            ResultSet res = ps.executeQuery();
            int posValue = res.findColumn(FIELD_NMVALUE_NAME);
            if (res.next()) {
                value = res.getString(posValue).trim();
            }
            res.close();
            ps.close();
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "readValue(String numberRangeID, int SID)", e);
        }
        finally {
            RepositoryDB.conCommit(con, "readValue(String numberRangeID, int SID)");
            RepositoryDB.conClose(con, "readValue(String numberRangeID, int SID)");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readSID(String numberRangeID, String value) {
        String method = "readSID(String numberRangeID, String value)";
        if (value != null && value.length() < 1) {
            return 0;
        }
        Connection con = this.repositoryDB.getConnection();
        PreparedStatement ps = null;
        int sid = -1;
        try {
            ps = this.getPSMapReadSID(con);
            ps.setString(1, numberRangeID.trim());
            ps.setString(2, value.trim());
            ResultSet res = ps.executeQuery();
            int posSID = res.findColumn(FIELD_NRSID_NAME);
            if (res.next()) {
                sid = res.getInt(posSID);
            }
            res.close();
            ps.close();
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(location, "readSID(String numberRangeID, String value)", e);
        }
        finally {
            RepositoryDB.conCommit(con, "readSID(String numberRangeID, String value)");
            RepositoryDB.conClose(con, "readSID(String numberRangeID, String value)");
        }
        return sid;
    }

    public String getDBInformation(Connection con) {
        StringBuffer state = new StringBuffer();
        state.append("<table cellspacing=\"0\" cellpadding=\"5\" width=\"100%\">");
        state.append("\n");
        state.append("<tr><th>Number Range</th><th>Number</th></tr>\n");
        String sql = "SELECT NRID, NRSID FROM BI_MMRNRRANGE";
        try {
            PreparedStatement stmt = con.prepareStatement("SELECT NRID, NRSID FROM BI_MMRNRRANGE");
            ResultSet set = stmt.executeQuery();
            while (set.next()) {
                String nrid = set.getString(1);
                long nrsid = set.getLong(2);
                state.append("<tr>");
                state.append("<td>");
                state.append(nrid);
                state.append("</td>");
                state.append("<td>");
                state.append(nrsid);
                state.append("</td>");
                state.append("</tr>");
            }
        }
        catch (Exception e) {
            RepositoryServer.category.errorT(location, e.toString());
        }
        state.append("</table>");
        state.append("\n");
        return state.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

