/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.io.IOException;
import java.net.URL;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.core.PDECore;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidatingSAXParser {
    private SAXParser parser = new SAXParser();

    public ValidatingSAXParser() {
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", true);
            this.parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        }
        catch (SAXException e) {
            PDE.log(e);
        }
    }

    public SAXParser getParser() {
        return this.parser;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.parser.setErrorHandler(handler);
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        URL dtdLocation = PDECore.getDefault().getDescriptor().getInstallURL();
        inputSource.setSystemId(dtdLocation.toString());
        this.parser.parse(inputSource);
    }
}

