/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.builders.ISchemaTransformer;
import org.eclipse.pde.internal.builders.PluginErrorReporter;
import org.eclipse.pde.internal.core.SourceDOMParser;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaInclude;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.schema.ChoiceRestriction;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaTransformer
implements ISchemaTransformer {
    private static final String KEY_BOOLEAN_INVALID = "Builders.Schema.Verifier.booleanInvalid";
    private static final String KEY_RESTRICTION_INVALID = "Builders.Schema.Verifier.restrictionInvalid";
    private static final String KEY_BASED_ON_INVALID = "Builders.Schema.Verifier.basedOnInvalid";
    private static final String KEY_VALUE_WITHOUT_DEFAULT = "Builders.Schema.Verifier.valueWithoutDefault";
    private static final String KEY_DEFAULT_WITHOUT_VALUE = "Builders.Schema.Verifier.defaultWithoutValue";
    public static final String KEY_DEPRECATED_TYPE = "Builders.Schema.deprecatedType";
    private static final String COLOR_TAG = "#000080";
    private static final String COLOR_CSTRING = "#008000";
    private static final String COLOR_DTD = "#800000";
    private static final String COLOR_COPYRIGHT = "#336699";

    private void appendAttlist(PrintWriter out, ISchemaAttribute att, int maxWidth) {
        String typeName;
        out.print("<br><samp>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        out.print(att.getName());
        int delta = maxWidth - att.getName().length();
        int i = 0;
        while (i < delta + 1) {
            out.print("&nbsp;");
            ++i;
        }
        ISchemaSimpleType type = att.getType();
        ISchemaRestriction restriction = null;
        boolean choices = false;
        if (type != null) {
            restriction = type.getRestriction();
        }
        String string = typeName = type != null ? type.getName().toLowerCase() : "string";
        if (typeName.equals("boolean")) {
            out.print("(true | false) ");
            choices = true;
        } else if (restriction != null) {
            this.appendRestriction(restriction, out);
            choices = true;
        } else {
            out.print("CDATA ");
        }
        if (att.getUse() == 1) {
            if (!choices) {
                out.print("#REQUIRED");
            }
        } else if (att.getUse() == 2) {
            out.print("\"" + att.getValue() + "\"");
        } else if (!choices) {
            out.print("#IMPLIED");
        }
        out.println("</samp>");
    }

    private void appendRestriction(ISchemaRestriction restriction, PrintWriter out) {
        if (restriction instanceof ChoiceRestriction) {
            ChoiceRestriction cr = (ChoiceRestriction)restriction;
            String[] choices = cr.getChoicesAsStrings();
            out.print("(");
            int i = 0;
            while (i < choices.length) {
                if (i > 0) {
                    out.print("|");
                }
                out.print(choices[i]);
                ++i;
            }
            out.print(") ");
        }
    }

    private int calculateMaxAttributeWidth(ISchemaAttribute[] attributes) {
        int width = 0;
        int i = 0;
        while (i < attributes.length) {
            ISchemaAttribute att = attributes[i];
            width = Math.max(width, att.getName().length());
            ++i;
        }
        return width;
    }

    private SourceDOMParser createDOMTree(InputStream schema, PluginErrorReporter reporter) {
        SourceDOMParser parser = new SourceDOMParser();
        parser.setErrorHandler((ErrorHandler)reporter);
        try {
            InputSource source = new InputSource(schema);
            parser.parse(source);
            return parser;
        }
        catch (SAXException sAXException) {
        }
        catch (IOException e) {
            PDE.logException(e);
        }
        return null;
    }

    private boolean isPreEnd(String text, int loc) {
        if (loc + 5 >= text.length()) {
            return false;
        }
        String tag = text.substring(loc, loc + 6);
        return tag.toLowerCase().equals("</pre>");
    }

    private boolean isPreStart(String text, int loc) {
        if (loc + 4 >= text.length()) {
            return false;
        }
        String tag = text.substring(loc, loc + 5);
        return tag.toLowerCase().equals("<pre>");
    }

    public void transform(URL schemaURL, InputStream is, PrintWriter out, PluginErrorReporter reporter) {
        SourceDOMParser parser = this.createDOMTree(is, reporter);
        if (parser == null) {
            return;
        }
        Element root = parser.getDocument().getDocumentElement();
        Schema schema = new Schema(null, schemaURL);
        schema.traverseDocumentTree((Node)root, parser.getLineTable());
        if (this.verifySchema(schema, reporter) && CompilerFlags.getBoolean("compilers.s.create-docs")) {
            this.transform(out, (ISchema)schema);
        }
    }

    private boolean verifySchema(Schema schema, PluginErrorReporter reporter) {
        if (!schema.isLoaded()) {
            return false;
        }
        if (!schema.isValid()) {
            return false;
        }
        this.checkFileType(reporter.getFile(), reporter);
        ISchemaElement[] elements = schema.getElements();
        int errors = 0;
        int i = 0;
        while (i < elements.length) {
            ISchemaElement element = elements[i];
            ISchemaAttribute[] attributes = element.getAttributes();
            int j = 0;
            while (j < attributes.length) {
                ISchemaAttribute attribute = attributes[j];
                errors += this.verifyAttribute(element, attribute, reporter);
                ++j;
            }
            ++i;
        }
        return errors == 0;
    }

    private void checkFileType(IFile file, PluginErrorReporter reporter) {
        String ext;
        String name = file.getName();
        int dot = name.lastIndexOf(46);
        if (dot != -1 && (ext = name.substring(dot + 1)).equalsIgnoreCase("xsd")) {
            String message = PDE.getResourceString(KEY_DEPRECATED_TYPE);
            reporter.reportWarning(message);
        }
    }

    private int verifyAttribute(ISchemaElement element, ISchemaAttribute attribute, PluginErrorReporter reporter) {
        String message;
        int errors = 0;
        ISchemaSimpleType type = attribute.getType();
        String[] args = new String[]{element.getName(), attribute.getName()};
        int line = -1;
        if (attribute instanceof ISourceObject) {
            line = ((ISourceObject)attribute).getStartLine();
        }
        if (attribute.getKind() != 0 && type != null) {
            if (type.getName().equals("boolean")) {
                message = PDE.getFormattedMessage(KEY_BOOLEAN_INVALID, args);
                reporter.reportError(message, line);
                ++errors;
            }
            if (type instanceof SchemaSimpleType && ((SchemaSimpleType)type).getRestriction() != null) {
                message = PDE.getFormattedMessage(KEY_RESTRICTION_INVALID, args);
                reporter.reportError(message, line);
                ++errors;
            }
        }
        if (attribute.getKind() != 1 && attribute.getBasedOn() != null) {
            message = PDE.getFormattedMessage(KEY_BASED_ON_INVALID, args);
            reporter.reportError(message, line);
            ++errors;
        }
        if (type != null && type.getName().equals("boolean") && type instanceof SchemaSimpleType && ((SchemaSimpleType)type).getRestriction() != null) {
            message = PDE.getFormattedMessage(KEY_RESTRICTION_INVALID, args);
            reporter.reportError(message, line);
            ++errors;
        }
        if (attribute.getUse() != 2) {
            if (attribute.getValue() != null) {
                message = PDE.getFormattedMessage(KEY_VALUE_WITHOUT_DEFAULT, args);
                reporter.reportError(message, line);
                ++errors;
            }
        } else if (attribute.getValue() == null) {
            message = PDE.getFormattedMessage(KEY_DEFAULT_WITHOUT_VALUE, args);
            reporter.reportError(message, line);
            ++errors;
        }
        return errors;
    }

    public void transform(PrintWriter out, ISchema schema) {
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
        out.print("<HEAD>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        this.addStyle(out);
        out.println("</HEAD>");
        out.println("<HTML>");
        out.println("<BODY>");
        out.println("<H1><CENTER>" + schema.getName() + "</CENTER></H1>");
        out.print("<b><i>Identifier: </i></b>");
        out.print(schema.getQualifiedPointId());
        out.println("<p>");
        this.transformSection(out, schema, "Since:", "since");
        this.transformDescription(out, schema);
        out.println("<p><b><i>Configuration Markup:</i></b><p>");
        this.transformMarkup(out, schema);
        this.transformSection(out, schema, "Examples:", "examples");
        this.transformSection(out, schema, "API Information:", "apiInfo");
        this.transformSection(out, schema, "Supplied Implementation:", "implementation");
        out.println("<font size=\"-1\" color=\"#336699\">");
        this.transformSection(out, schema, "copyright");
        out.println("</font>");
        out.println("</BODY>");
        out.println("</HTML>");
    }

    private void addStyle(PrintWriter out) {
        out.println("<STYLE type=\"text/css\">");
        out.println("div.dtd-fragment {");
        out.println("\twidth: 100%;");
        out.println("\tborder: none;");
        out.println("\tbackground-color: #eee;");
        out.println("}");
        out.println("</STYLE>");
    }

    private void transformDescription(PrintWriter out, ISchema schema) {
        out.print("<b><i>Description: </i></b>");
        this.transformText(out, schema.getDescription());
        ISchemaInclude[] includes = schema.getIncludes();
        int i = 0;
        while (i < includes.length) {
            ISchema ischema = includes[i].getIncludedSchema();
            if (ischema != null) {
                out.println("<p>");
                this.transformText(out, ischema.getDescription());
            }
            ++i;
        }
    }

    private void transformElement(PrintWriter out, ISchemaElement element) {
        String name = element.getName();
        String dtd = element.getDTDRepresentation(true);
        String nameLink = "<a name=\"e." + name + "\">" + name + "</a>";
        out.print("<p><samp><font color=\"#800000\">&nbsp;&nbsp; &lt;!ELEMENT " + nameLink + " " + dtd);
        out.println("&gt;</font></samp>");
        ISchemaAttribute[] attributes = element.getAttributes();
        String description = element.getDescription();
        if (description != null && description.trim().length() > 0) {
            out.print("<p>");
            out.print("&nbsp;&nbsp; ");
            this.transformText(out, description);
            out.println("</p>");
            if (attributes.length > 0) {
                out.println("<p></p>");
            }
        } else if (attributes.length > 0) {
            out.print("<br><br>");
        }
        if (attributes.length > 0) {
            out.println("<samp><font color=\"#800000\">&nbsp;&nbsp; &lt;!ATTLIST " + name + "</samp>");
            int maxWidth = this.calculateMaxAttributeWidth(element.getAttributes());
            int i = 0;
            while (i < attributes.length) {
                this.appendAttlist(out, attributes[i], maxWidth);
                ++i;
            }
            out.println("<br><samp>&nbsp;&nbsp; &gt;</font></samp>");
        }
        if (attributes.length == 0) {
            return;
        }
        out.println("<ul>");
        int i = 0;
        while (i < attributes.length) {
            ISchemaAttribute att = attributes[i];
            if (!name.equals("extension") || att.getDescription() != null && att.getDescription().trim().length() != 0) {
                out.print("<li><b>" + att.getName() + "</b> - ");
                this.transformText(out, att.getDescription());
                out.println("</li>");
            }
            ++i;
        }
        out.println("</ul>");
    }

    private void transformMarkup(PrintWriter out, ISchema schema) {
        ISchemaElement lastElement;
        ISchemaElement[] elements = schema.getResolvedElements();
        int i = 0;
        while (i < elements.length) {
            ISchemaElement element = elements[i];
            this.transformElement(out, element);
            ++i;
        }
        if (elements.length > 0 && (lastElement = elements[elements.length - 1]).getAttributeCount() == 0 && lastElement.getDescription() == null) {
            out.print("<br><br>");
        }
    }

    private void transformSection(PrintWriter out, ISchema schema, String sectionId) {
        this.transformSection(out, schema, null, sectionId);
    }

    private void transformSection(PrintWriter out, ISchema schema, String title, String sectionId) {
        IDocumentSection[] sections = schema.getDocumentSections();
        IDocumentSection section = null;
        int i = 0;
        while (i < sections.length) {
            if (sections[i].getSectionId().equals(sectionId)) {
                section = sections[i];
                break;
            }
            ++i;
        }
        if (section == null) {
            return;
        }
        String description = section.getDescription();
        if (description == null || description.trim().length() == 0) {
            return;
        }
        if (title != null) {
            out.print("<b><i>" + title + " </i></b>");
        }
        this.transformText(out, description);
        out.println("<p>");
    }

    private void transformText(PrintWriter out, String text) {
        if (text == null) {
            return;
        }
        boolean preformatted = false;
        boolean inTag = false;
        boolean inCstring = false;
        int i = 0;
        while (i < text.length()) {
            block13: {
                char c;
                block14: {
                    block11: {
                        block12: {
                            c = text.charAt(i);
                            if (c != '<') break block11;
                            if (!this.isPreStart(text, i)) break block12;
                            out.print("<pre>");
                            i += 4;
                            preformatted = true;
                            break block13;
                        }
                        if (!this.isPreEnd(text, i)) break block11;
                        out.print("</pre>");
                        i += 5;
                        preformatted = false;
                        inTag = false;
                        inCstring = false;
                        break block13;
                    }
                    if (!preformatted) break block14;
                    switch (c) {
                        case '<': {
                            inTag = true;
                            out.print("<font color=\"#000080\">");
                            out.print("&lt;");
                            break;
                        }
                        case '>': {
                            out.print("&gt;");
                            out.print("</font>");
                            inTag = false;
                            inCstring = false;
                            break;
                        }
                        case '&': {
                            out.print("&amp;");
                            break;
                        }
                        case '\'': {
                            out.print("&apos;");
                            break;
                        }
                        case '\"': {
                            if (inTag) {
                                if (inCstring) {
                                    out.print("&quot;");
                                    out.print("</font>");
                                    inCstring = false;
                                    break;
                                }
                                inCstring = true;
                                out.print("<font color=\"#008000\">");
                                out.print("&quot;");
                                break;
                            }
                            break block13;
                        }
                        default: {
                            out.print(c);
                            break;
                        }
                    }
                    break block13;
                }
                out.print(c);
            }
            ++i;
        }
    }
}

