/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.builders.IMarkerFactory;
import org.eclipse.pde.internal.core.PDECore;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PluginErrorReporter
implements ErrorHandler {
    private IFile file;
    private int errorCount = 0;
    private IMarkerFactory markerFactory;
    private DefaultMarkerFactory defaultMarkerFactory;

    public PluginErrorReporter(IFile file) {
        this.file = file;
        if (file != null) {
            this.removeFileMarkers();
            this.defaultMarkerFactory = new DefaultMarkerFactory();
            this.markerFactory = this.defaultMarkerFactory;
        }
    }

    public IFile getFile() {
        return this.file;
    }

    public void setMarkerFactory(IMarkerFactory factory) {
        this.markerFactory = factory != null ? factory : this.defaultMarkerFactory;
    }

    private void addMarker(String message, int lineNumber, int severity, boolean fatal) {
        try {
            IMarker marker = this.markerFactory.createMarker(this.file);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber != -1) {
                marker.setAttribute("lineNumber", lineNumber);
            }
        }
        catch (CoreException e) {
            PDECore.logException((Throwable)e);
        }
    }

    private void addMarker(SAXParseException e, int severity, boolean fatal) {
        this.addMarker(e.getMessage(), e.getLineNumber(), severity, fatal);
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.file != null) {
            this.addMarker(exception, 2, false);
        }
        ++this.errorCount;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.file != null) {
            this.addMarker(exception, 2, true);
        }
        ++this.errorCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    private void removeFileMarkers() {
        try {
            this.file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            this.file.deleteMarkers("org.eclipse.pde.validation-marker", false, 0);
        }
        catch (CoreException e) {
            PDECore.logException((Throwable)e);
        }
    }

    public void reportError(String message) {
        this.reportError(message, -1);
    }

    public void report(String message, int line, int severity) {
        if (severity == 0) {
            this.reportError(message, line);
        } else if (severity == 1) {
            this.reportWarning(message, line);
        }
    }

    public void reportError(String message, int line) {
        ++this.errorCount;
        if (this.file != null) {
            this.addMarker(message, line, 2, false);
        }
    }

    public void reportWarning(String message) {
        this.reportWarning(message, -1);
    }

    public void reportWarning(String message, int line) {
        this.addMarker(message, line, 1, false);
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.addMarker(exception, 1, false);
    }

    class DefaultMarkerFactory
    implements IMarkerFactory {
        DefaultMarkerFactory() {
        }

        public IMarker createMarker(IFile file) throws CoreException {
            return file.createMarker("org.eclipse.core.resources.problemmarker");
        }
    }
}

