/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.extensions;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;

public class AcceptableResponses
extends V3Extension {
    private ObjectID[] a;
    public static final ObjectID oid = new ObjectID("1.3.6.1.5.5.7.48.1.4", "AcceptableResponses");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("acceptable responses: {");
        if (this.a != null) {
            int n = 0;
            while (n < this.a.length) {
                stringBuffer.append("\n" + this.a[n].getName());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            int n = 0;
            while (n < this.a.length) {
                sEQUENCE.addComponent(this.a[n]);
                ++n;
            }
        }
        return sEQUENCE;
    }

    public void setAcceptableResponseTypes(ObjectID[] objectIDArray) {
        this.a = objectIDArray;
    }

    public boolean isResponseTypeAcceptable(ObjectID objectID) {
        if (this.a == null) {
            return true;
        }
        int n = 0;
        while (n < this.a.length) {
            if (this.a.equals(objectID)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            int n = aSN1Object.countComponents();
            this.a = new ObjectID[n];
            int n2 = 0;
            while (n2 < n) {
                this.a[n2] = (ObjectID)aSN1Object.getComponentAt(n2);
                ++n2;
            }
            return;
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public ObjectID[] getAcceptableResponseTypes() {
        return this.a;
    }

    public AcceptableResponses(ObjectID[] objectIDArray) {
        this.a = objectIDArray;
    }

    public AcceptableResponses() {
    }
}

