/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.GeneralizedTime;
import iaik.asn1.ObjectID;
import iaik.asn1.UNIString;
import iaik.asn1.UTCTime;
import iaik.asn1.UTF8String;
import iaik.asn1.b;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.math.BigInteger;

public class DerInputStream
extends InputStream {
    int a;
    InputStream c;
    boolean d = false;
    int b;
    public static final int BMPString = 30;
    public static final int UNIString = 28;
    public static final int GeneralString = 27;
    public static final int VisibleString = 26;
    public static final int GeneralizedTime = 24;
    public static final int UTCTime = 23;
    public static final int IA5String = 22;
    public static final int T61String = 20;
    public static final int PrintableString = 19;
    public static final int NumericString = 18;
    public static final int SET = 17;
    public static final int SEQUENCE = 16;
    public static final int UTF8String = 12;
    public static final int ENUMERATED = 10;
    public static final int EXTERNAL = 8;
    public static final int OBJECT_DESCRIPTOR = 7;
    public static final int OBJECT_ID = 6;
    public static final int NULL = 5;
    public static final int OCTET_STRING = 4;
    public static final int BIT_STRING = 3;
    public static final int INTEGER = 2;
    public static final int BOOLEAN = 1;
    public static final int CONSTRUCTED = 32;
    public static final int PRIVATE = 192;
    public static final int CONTEXT_SPECIFIC = 128;
    public static final int APPLICATION = 64;
    public static final int UNIVERSAL = 0;

    private void a(byte[] byArray, int n) throws IOException {
        if (this.c instanceof PushbackInputStream) {
            ((PushbackInputStream)this.c).unread(byArray, 0, n);
        } else {
            ((DerInputStream)this.c).a(byArray, n);
        }
        if (this.b >= 0) {
            this.b += n;
        }
    }

    private void a(int n) throws IOException {
        if (this.c instanceof PushbackInputStream) {
            ((PushbackInputStream)this.c).unread(n);
        } else {
            ((DerInputStream)this.c).a(n);
        }
        if (this.b >= 0) {
            ++this.b;
        }
    }

    public int skipObjects(int n) throws IOException {
        int n2;
        int n3 = 0;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        while (n3 < n && (n2 = this.a(false)) > 0) {
            int n4 = this.a();
            if (n4 >= 0) {
                this.skip(n4);
            } else {
                DerInputStream derInputStream = new DerInputStream(this, n4, n2);
                derInputStream.skipObjects(-1);
            }
            ++n3;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        if (this.b < 0) {
            return this.c.skip(l);
        }
        int n = Math.min((int)l, this.b);
        this.c.skip(n);
        return n;
    }

    public UTCTime readUTCTime() throws IOException {
        if (this.a(false) != 23) {
            throw new IOException("Next ASN.1 object is no UTC TIME!");
        }
        UTCTime uTCTime = new UTCTime();
        uTCTime.decode(this.a(), this);
        return uTCTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int a(boolean bl) throws IOException {
        if (this.d) {
            return -1;
        }
        int n = this.read();
        if (n == -1) {
            this.d = true;
        } else if (n == 0) {
            if (this.b >= 0) throw new IOException("Found 0 tag but no indefinite length encoding!");
            this.d = true;
            n = -1;
            if (this.read() != 0) {
                throw new IOException("Indefinite length: second byte not 0!");
            }
        } else if ((n & 0x1F) == 31) {
            int n2;
            byte[] byArray = new byte[10];
            int n3 = 0;
            byArray[n3++] = (byte)n;
            n = 0;
            do {
                n <<= 7;
                n2 = this.read();
                byArray[n3++] = (byte)n2;
                n |= n2 & 0x7F;
            } while ((n2 & 0x80) != 0);
            if (bl) {
                this.a(byArray, n3);
            }
        } else {
            if (bl) {
                this.a(n);
            }
            n &= 0x1F;
        }
        if (!this.d || this.b == -2) return n;
        ((DerInputStream)this.c).b();
        return n;
    }

    public String readString() throws IOException {
        int n = this.a(false);
        byte[] byArray = new byte[this.a()];
        Util.fillArray(byArray, this);
        switch (n) {
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 27: {
                return Util.toASCIIString(byArray);
            }
            case 28: {
                return iaik.asn1.UNIString.a(byArray);
            }
            case 30: {
                return new String(byArray, "UnicodeBig");
            }
            case 12: {
                try {
                    return iaik.asn1.UTF8String.getStringFromUTF8Encoding(byArray);
                }
                catch (CodingException codingException) {
                    throw new IOException(codingException.getMessage());
                }
            }
        }
        throw new IOException("Next ASN.1 object is no STRING type!");
    }

    public DerInputStream readSet() throws IOException {
        int n = this.a(false);
        if (n != 17) {
            throw new IOException("Next ASN.1 object is no SET!");
        }
        return new DerInputStream(this, this.a(), n);
    }

    public DerInputStream readSequence() throws IOException {
        int n = this.a(false);
        if (n != 16) {
            throw new IOException("Next ASN.1 object is no SEQUENCE!");
        }
        return new DerInputStream(this, this.a(), n);
    }

    public byte[] readOctetStringByteArray() throws IOException {
        int n = this.a(false);
        if (n == -1) {
            return null;
        }
        if (n != 4) {
            throw new IOException("Next ASN.1 object is no OCTET_STRING!");
        }
        int n2 = this.a();
        if (n2 >= 0) {
            byte[] byArray = new byte[n2];
            Util.fillArray(byArray, this);
            return byArray;
        }
        throw new IOException("DER decode ERROR: indefinite length encoding not allowed for primitive octet strings!");
    }

    public InputStream readOctetString() throws IOException {
        int n = this.read();
        if (n == -1) {
            return null;
        }
        if ((n & 0x1F) != 4) {
            throw new IOException("Next ASN.1 object is no OCTET_STRING!");
        }
        int n2 = this.a();
        if ((n & 0x20) == 0) {
            byte[] byArray = new byte[n2];
            Util.fillArray(byArray, this);
            this.a(true);
            return new ByteArrayInputStream(byArray);
        }
        if (this.nextIsConstructed()) {
            return new DerInputStream(this, n2, n);
        }
        return new b(this, new DerInputStream(this, n2, n));
    }

    public ObjectID readObjectID() throws IOException {
        if (this.a(false) != 6) {
            throw new IOException("Next ASN.1 object is no OBJECT IDENTIFIER!");
        }
        ObjectID objectID = new ObjectID();
        objectID.decode(this.a(), this);
        return objectID;
    }

    public void readNull() throws IOException {
        if (this.a(false) != 5) {
            throw new IOException("Next ASN.1 object is not NULL!");
        }
        this.a();
    }

    public BigInteger readInteger() throws IOException {
        if (this.a(false) != 2) {
            throw new IOException("Next ASN.1 object is no INTEGER!");
        }
        byte[] byArray = new byte[this.a()];
        Util.fillArray(byArray, this);
        return new BigInteger(byArray);
    }

    public GeneralizedTime readGeneralizedTime() throws IOException {
        if (this.a(false) != 24) {
            throw new IOException("Next ASN.1 object is no GeneralizedTime!");
        }
        GeneralizedTime generalizedTime = new GeneralizedTime();
        generalizedTime.decode(this.a(), this);
        return generalizedTime;
    }

    public void readEOC() throws IOException {
        if (!this.d && this.b < 0) {
            int n = this.read();
            if (n == 0) {
                if (this.read() != 0) {
                    throw new IOException("Indefinite length: second byte not 0!");
                }
            } else {
                throw new IOException("Indefinite length encoding not closed by EOC!");
            }
            this.d = true;
        }
    }

    public int readContextSpecific(int n) throws IOException {
        if (!this.nextIsContextSpecific()) {
            throw new IOException("Next ASN.1 object is no CONTEXT SPECIFIC!");
        }
        if (this.nextIsConstructed()) {
            n |= 0x20;
        }
        int n2 = this.a(false);
        this.a(n);
        return n2;
    }

    public DerInputStream readContextSpecific() throws IOException {
        if (!this.nextIsContextSpecific()) {
            throw new IOException("Next ASN.1 object is no CONTEXT SPECIFIC!");
        }
        int n = this.a(false);
        return new DerInputStream(this, this.a(), n);
    }

    public DerInputStream readConstructed() throws IOException {
        if (!this.nextIsConstructed()) {
            throw new IOException("Next ASN.1 object is not CONSTRUCTED!");
        }
        int n = this.a(false);
        return new DerInputStream(this, this.a(), n);
    }

    public boolean readBoolean() throws IOException {
        if (this.a(false) != 1) {
            throw new IOException("Next ASN.1 object is no BOOLEAN!");
        }
        if (this.a() != 1) {
            throw new IOException("Boolean length not 1!");
        }
        return this.read() != 0;
    }

    public BIT_STRING readBitString() throws IOException {
        if (this.a(false) != 3) {
            throw new IOException("Next ASN.1 object is no BIT_STRING!");
        }
        BIT_STRING bIT_STRING = new BIT_STRING();
        bIT_STRING.decode(this.a(), this);
        return bIT_STRING;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.b < 0) {
            return this.c.read(byArray, n, n2);
        }
        if (this.b > 0) {
            int n3 = Math.min(n2, this.b);
            this.b -= n3;
            int n4 = n3;
            while (n4 > 0) {
                int n5 = this.c.read(byArray, n, n4);
                if (n5 < 0) {
                    throw new EOFException();
                }
                n4 -= n5;
                n += n5;
            }
            return n3;
        }
        return -1;
    }

    public int read(boolean bl) throws IOException {
        int n = this.read();
        if (bl && n != -1) {
            this.a(n);
        }
        return n;
    }

    public int read() throws IOException {
        if (this.b < 0) {
            return this.c.read();
        }
        if (this.b > 0) {
            --this.b;
            return this.c.read();
        }
        return -1;
    }

    private void b() throws IOException {
        if (this.d) {
            throw new IOException("Stream already closed!");
        }
        int n = this.read();
        if (n > 0) {
            this.a(n);
            return;
        }
        if (n == 0) {
            if (this.b < 0) {
                this.d = true;
                if (this.read() != 0) {
                    throw new IOException("Indefinite length: second byte not 0!");
                }
            } else {
                throw new IOException("Found 0 tag but no indefinite length encoding!");
            }
        }
        if (this.c instanceof DerInputStream) {
            ((DerInputStream)this.c).b();
        }
    }

    public int nextTag() throws IOException {
        return this.a(true);
    }

    public boolean nextIsUniversal() throws IOException {
        return (this.read(true) & 0xC0) == 0;
    }

    public boolean nextIsPrivate() throws IOException {
        return (this.read(true) & 0xC0) == 192;
    }

    public boolean nextIsContextSpecific() throws IOException {
        return (this.read(true) & 0xC0) == 128;
    }

    public boolean nextIsConstructed() throws IOException {
        return (this.read(true) & 0x20) == 32;
    }

    public boolean nextIsApplication() throws IOException {
        return (this.read(true) & 0xC0) == 64;
    }

    public int getTag() {
        return this.a;
    }

    private int a() throws IOException {
        int n = this.read() & 0xFF;
        if (n < 128) {
            return n;
        }
        if (n == 128) {
            return -1;
        }
        if ((n &= 0x7F) > 4) {
            throw new IOException("Length: Too large ASN.1 object: " + n);
        }
        int n2 = 0;
        while (--n >= 0) {
            n2 = n2 << 8 | this.read() & 0xFF;
        }
        return n2;
    }

    public void close() throws IOException {
        this.c.close();
    }

    public int available() {
        return this.b;
    }

    public DerInputStream(InputStream inputStream) {
        this.b = -2;
        this.a = -2;
        this.c = new PushbackInputStream(inputStream, 32);
    }

    private DerInputStream(DerInputStream derInputStream, int n, int n2) {
        this.c = derInputStream;
        this.b = n;
        this.a = n2;
    }
}

