/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BIT_STRING
extends ASN1Object {
    protected byte[] value;
    protected int bits_not_valid;

    public String toString() {
        return String.valueOf(super.toString()) + this.value.length + " byte(s); " + this.bits_not_valid + " bit(s) not valid";
    }

    public void setValue(Object object) {
        this.value = (byte[])object;
        this.bits_not_valid = 0;
    }

    public Object getValue() {
        return this.value;
    }

    public String getBinaryString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.value.length - 1) {
            n = 7;
            while (n >= 0) {
                if ((this.value[n2] & 1 << n) != 0) {
                    stringBuffer.append('1');
                } else {
                    stringBuffer.append('0');
                }
                --n;
            }
            ++n2;
        }
        n = 7;
        while (n >= this.bits_not_valid) {
            if ((this.value[n2] & 1 << n) != 0) {
                stringBuffer.append('1');
            } else {
                stringBuffer.append('0');
            }
            --n;
        }
        return stringBuffer.toString();
    }

    protected void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.value);
        outputStream.write(this.bits_not_valid);
    }

    protected void decode(int n, InputStream inputStream) throws IOException {
        this.bits_not_valid = inputStream.read();
        this.value = new byte[n - 1];
        Util.fillArray(this.value, inputStream);
    }

    public int bitsNotValid() {
        return this.bits_not_valid;
    }

    public BIT_STRING(boolean[] blArray) {
        this();
        int n = blArray.length;
        this.bits_not_valid = 8 - n % 8;
        this.value = new byte[(n + 7) / 8];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 / 8;
            this.value[n3] = (byte)(this.value[n3] << 1);
            if (blArray[n2]) {
                int n4 = n2 / 8;
                this.value[n4] = (byte)(this.value[n4] + 1);
            }
            ++n2;
        }
        if (this.bits_not_valid > 0) {
            int n5 = n2 / 8;
            this.value[n5] = (byte)(this.value[n5] << this.bits_not_valid);
        }
    }

    public BIT_STRING(byte[] byArray, int n) {
        this();
        this.value = byArray;
        this.bits_not_valid = n;
    }

    public BIT_STRING(byte[] byArray) {
        this();
        this.value = byArray;
        this.bits_not_valid = 0;
    }

    public BIT_STRING(String string) {
        this();
        int n = string.length();
        this.bits_not_valid = (8 - n % 8) % 8;
        int n2 = (n + 7) / 8;
        this.value = new byte[n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3 / 8;
            this.value[n4] = (byte)(this.value[n4] << 1);
            if (string.charAt(n3) == '1') {
                int n5 = n3 / 8;
                this.value[n5] = (byte)(this.value[n5] + 1);
            }
            ++n3;
        }
        if (this.bits_not_valid > 0) {
            int n6 = n3 / 8;
            this.value[n6] = (byte)(this.value[n6] << this.bits_not_valid);
        }
    }

    protected BIT_STRING() {
        this.asnType = ASN.BIT_STRING;
    }
}

