/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.sap;

import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.sap.DbSapEnvironment;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbSapPrimaryKey
extends DbPrimaryKey {
    private static Location loc = Logger.getLocation("sap.DbSapPrimaryKey");

    public DbSapPrimaryKey() {
    }

    public DbSapPrimaryKey(DbFactory factory, DbPrimaryKey other) {
        super(factory, other);
    }

    public DbSapPrimaryKey(DbFactory factory) {
        super(factory);
    }

    public DbSapPrimaryKey(DbFactory factory, DbSchema schema, String tablename) {
        super(factory, schema, tablename);
    }

    public DbSapPrimaryKey(DbFactory factory, String tablename) {
        super(factory, tablename);
    }

    public void setSpecificContentViaXml(XmlMap xml) {
    }

    public void setCommonContentViaDb() {
        loc.entering("setCommonContentViaDb");
        Connection conn = this.getDbFactory().getConnection();
        String tabname = this.getTableName().toUpperCase();
        ArrayList<DbIndexColumnInfo> columnList = new ArrayList<DbIndexColumnInfo>();
        try {
            PreparedStatement ps = NativeSQLAccess.prepareNativeStatement((Connection)conn, (String)"select columnname from domain.columns where owner = USER and tablename = ? and mode='KEY' order by keypos");
            ps.setString(1, tabname);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                columnList.add(new DbIndexColumnInfo(rs.getString(1), false));
            }
            rs.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            System.out.println("Exception caught : " + ex.getMessage());
        }
        this.setContent(columnList);
        loc.exiting();
    }

    public void setSpecificContentViaDb() {
    }

    public void writeSpecificContentToXmlFile() {
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        loc.entering("getDdlStatementsForCreate");
        String columns = "\"" + ((DbIndexColumnInfo)super.getColumnNames().get(0)).getName().toUpperCase() + "\"";
        int column = 1;
        while (column < super.getColumnNames().size()) {
            columns = columns + ", \"" + ((DbIndexColumnInfo)super.getColumnNames().get(column)).getName().toUpperCase() + "\"";
            ++column;
        }
        DbObjectSqlStatements dbObjectSqlStatements = new DbObjectSqlStatements(this.getTableName());
        DbSqlStatement dbSqlStatement = new DbSqlStatement();
        dbSqlStatement.addLine("ALTER TABLE \"" + this.getTableName().toUpperCase() + "\" ");
        dbSqlStatement.addLine("ADD PRIMARY KEY ( " + columns + " ) ");
        dbObjectSqlStatements.add(dbSqlStatement);
        loc.exiting();
        return dbObjectSqlStatements;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() {
        loc.entering("getDdlStatementsForDrop");
        DbObjectSqlStatements dbObjectSqlStatements = new DbObjectSqlStatements(this.getTableName());
        DbSqlStatement dbSqlStatement = new DbSqlStatement(true);
        dbSqlStatement.addLine("ALTER TABLE \"" + this.getTableName().toUpperCase() + "\" ");
        dbSqlStatement.addLine("DROP PRIMARY KEY");
        dbObjectSqlStatements.add(dbSqlStatement);
        loc.exiting();
        return dbObjectSqlStatements;
    }

    public boolean checkWidth() {
        loc.entering("checkWidth");
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        String colName = null;
        DbColumns columns = this.getTable().getColumns();
        int total = 0;
        int maxWidth = DbSapEnvironment.MaxKeyLength();
        while (iter.hasNext()) {
            colName = ((DbIndexColumnInfo)iter.next()).getName();
            DbColumn column = columns.getColumn(colName);
            if (column == null) {
                Object[] arguments = new Object[]{this.getTableName()};
                loc.errorT("checkWidth {0}: no such column in table", arguments);
                loc.exiting();
                return false;
            }
            switch (column.getJavaSqlType()) {
                case -4: 
                case -1: 
                case 2004: 
                case 2005: {
                    Object[] arguments = new Object[]{this.getTableName()};
                    loc.errorT("checkWidth {0}: index on BLOB, CLOB, LONGVARBINARY or LONGVARCHAR is not allowed", arguments);
                    loc.exiting();
                    return false;
                }
            }
            total = (int)((long)total + DbSapEnvironment.GetColumnLength(column, true));
        }
        if (total > maxWidth) {
            Object[] arguments = new Object[]{this.getTableName(), new Integer(total), new Integer(maxWidth)};
            loc.errorT("checkWidth {0}: total width({1}) greater than allowed maximum ({2})", arguments);
            loc.exiting();
            return false;
        }
        loc.exiting();
        return true;
    }

    public boolean checkNumberOfColumns() {
        loc.entering("checkNumberOfColumns");
        int numCols = this.getColumnNames().size();
        int maxCols = DbSapEnvironment.MaxKeysPerTable();
        if (numCols <= 0 || numCols > maxCols) {
            Object[] arguments = new Object[]{this.getTableName(), new Integer(numCols), new Integer(maxCols)};
            loc.errorT("checkNumberOfColumns{0}: column count {1} not in allowed range [1..{2}]", arguments);
            loc.exiting();
            return false;
        }
        loc.exiting();
        return true;
    }
}

