/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.sap;

import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndex;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.sap.DbSapEnvironment;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbSapIndex
extends DbIndex {
    private static Location loc = Logger.getLocation("sap.DbSapIndex");

    public DbSapIndex() {
    }

    public DbSapIndex(DbFactory factory) {
        super(factory);
    }

    public DbSapIndex(DbFactory factory, DbIndex other) {
        super(factory, other);
    }

    public DbSapIndex(DbFactory factory, String tableName, String indexName) {
        super(factory, tableName, indexName);
    }

    public DbSapIndex(DbFactory factory, DbSchema schema, String tableName, String indexName) {
        super(factory, schema, tableName, indexName);
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) {
    }

    public void setCommonContentViaDb() {
        loc.entering("setCommonContentViaDb");
        String tabname = this.getTableName().toUpperCase();
        String indname = this.getName();
        boolean isUnique = false;
        boolean isDescending = false;
        ArrayList<DbIndexColumnInfo> columnsInfo = new ArrayList<DbIndexColumnInfo>();
        Connection conn = this.getDbFactory().getConnection();
        try {
            PreparedStatement ps = NativeSQLAccess.prepareNativeStatement((Connection)conn, (String)"select type from domain.indexes where owner = USER and indexname = ? and tablename = ?");
            ps.setString(1, indname);
            ps.setString(2, tabname);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                isUnique = rs.getString(1).equals("UNIQUE");
            }
            rs.close();
            ps.close();
            ps = NativeSQLAccess.prepareNativeStatement((Connection)conn, (String)"select columnname, sort from domain.indexcolumns where owner = USER and indexname = ? and tablename = ? order by columnno");
            ps.setString(1, indname);
            ps.setString(2, tabname);
            rs = ps.executeQuery();
            while (rs.next()) {
                isDescending = rs.getString(2).equalsIgnoreCase("DESC");
                columnsInfo.add(new DbIndexColumnInfo(rs.getString(1), isDescending));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            System.out.println("Exception caught : " + ex.getMessage());
        }
        this.setContent(isUnique, columnsInfo);
        loc.exiting();
    }

    public void setSpecificContentViaDb() {
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        loc.entering("getDdlStatementsForCreate");
        DbObjectSqlStatements indexDef = new DbObjectSqlStatements(this.getName());
        DbSqlStatement createStatement = new DbSqlStatement();
        createStatement.addLine("CREATE " + (this.isUnique() ? "UNIQUE " : "") + "INDEX \"" + this.getName() + "\" ON \"" + this.getTableName() + "\"");
        createStatement.merge(this.getDdlColumnsClause());
        indexDef.add(createStatement);
        loc.exiting();
        return indexDef;
    }

    public DbSqlStatement getDdlColumnsClause() {
        loc.entering("getDdlColumnsClause");
        DbSqlStatement colDef = new DbSqlStatement();
        colDef.addLine("(");
        Iterator icIterator = ((AbstractList)this.getColumnNames()).iterator();
        DbIndexColumnInfo indColumn = null;
        String sep = ",";
        while (icIterator.hasNext()) {
            indColumn = (DbIndexColumnInfo)icIterator.next();
            if (!icIterator.hasNext()) {
                sep = "";
            }
            if (indColumn.isDescending()) {
                colDef.addLine("\"" + indColumn.getName() + "\" DESC" + sep);
                continue;
            }
            colDef.addLine("\"" + indColumn.getName() + "\"" + sep);
        }
        colDef.addLine(")");
        loc.exiting();
        return colDef;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() {
        loc.entering("getDdlStatementsForDrop");
        DbObjectSqlStatements dropDef = new DbObjectSqlStatements(this.getName());
        DbSqlStatement dropLine = new DbSqlStatement(true);
        dropLine.addLine("DROP INDEX \"" + this.getName() + "\" ON \"" + this.getTableName() + "\"");
        dropDef.add(dropLine);
        loc.exiting();
        return dropDef;
    }

    public boolean checkWidth() {
        loc.entering("checkWidth");
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        String colName = null;
        DbColumns columns = this.getIndexes().getTable().getColumns();
        int total = 0;
        int maxWidth = DbSapEnvironment.MaxIndexLength();
        while (iter.hasNext()) {
            colName = ((DbIndexColumnInfo)iter.next()).getName();
            DbColumn column = columns.getColumn(colName);
            if (column == null) {
                Object[] arguments = new Object[]{this.getName()};
                loc.errorT("checkWidth {0}: no such column in table", arguments);
                loc.exiting();
                return false;
            }
            switch (column.getJavaSqlType()) {
                case -4: 
                case -1: 
                case 2004: 
                case 2005: {
                    Object[] arguments = new Object[]{this.getName()};
                    loc.errorT("checkWidth {0}: index on BLOB, CLOB, LONGVARBINARY or LONGVARCHAR is not allowed", arguments);
                    loc.exiting();
                    return false;
                }
            }
            total = (int)((long)total + DbSapEnvironment.GetColumnLength(column, true));
        }
        if (total > maxWidth) {
            Object[] arguments = new Object[]{this.getName(), new Integer(total), new Integer(maxWidth)};
            loc.errorT("checkWidth {0}: total width({1}) greater than allowed maximum ({2})", arguments);
            loc.exiting();
            return false;
        }
        loc.exiting();
        return true;
    }

    public boolean checkNameLength() {
        loc.entering("checkNameLength");
        int nameLen = this.getName().length();
        int maxLen = DbSapEnvironment.MaxNameLength();
        if (nameLen > 0 && nameLen <= maxLen) {
            loc.exiting();
            return true;
        }
        Object[] arguments = new Object[]{this.getName(), new Integer(nameLen), new Integer(maxLen)};
        loc.errorT("checkNameLength {0}: length {1} invalid (allowed range [1..{2}])", arguments);
        loc.exiting();
        return false;
    }

    public boolean checkNameForReservedWord() {
        loc.entering("checkNameForReservedWord");
        boolean isReserved = DbSapEnvironment.isReservedWord(this.getName());
        if (isReserved) {
            Object[] arguments = new Object[]{this.getName()};
            loc.errorT("{0} is a reserved word", arguments);
        }
        loc.exiting();
        return !isReserved;
    }

    public boolean checkNumberOfColumns() {
        loc.entering("checkNumberOfColumns");
        int numCols = this.getColumnNames().size();
        int maxCols = DbSapEnvironment.MaxColumnsPerIndex();
        if (numCols <= 0 || numCols > maxCols) {
            Object[] arguments = new Object[]{this.getName(), new Integer(numCols), new Integer(maxCols)};
            loc.errorT("checkNumberOfColumns{0}: column count {1} not in allowed range [1..{2}]", arguments);
            loc.exiting();
            return false;
        }
        loc.exiting();
        return true;
    }
}

