/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.sap;

import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbEnvironment;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;

public class DbSapEnvironment
extends DbEnvironment {
    private static ArrayList reservedWords = null;

    public DbSapEnvironment() {
    }

    public DbSapEnvironment(Connection con) {
        super(con);
    }

    public static int MaxNameLength() {
        return 32;
    }

    public static int MaxTableLength() {
        return 8088;
    }

    public static int MaxIndexLength() {
        return 1024;
    }

    public static int MaxKeyLength() {
        return 1024;
    }

    public static int MaxColumnsPerTable() {
        return 1024;
    }

    public static int MaxColumnsPerIndex() {
        return 16;
    }

    public static int MaxKeysPerTable() {
        return 512;
    }

    public static int MaxIndicesPerTable() {
        return 255;
    }

    public static int MaxCharacterLength() {
        return 4000;
    }

    public static int MaxBinaryLength() {
        return 8000;
    }

    public static int MaxDecimalLength() {
        return 38;
    }

    public static long GetColumnLength(DbColumn col, boolean isKey) {
        long len = 0L;
        long collen = 0L;
        switch (col.getJavaSqlType()) {
            case -4: 
            case 2004: 
            case 2005: {
                len = 9L;
                break;
            }
            case -5: {
                len = 12L;
                break;
            }
            case -3: 
            case -2: {
                collen = col.getLength();
                if (collen <= 30L || isKey && collen <= 254L) {
                    len = collen + 1L;
                    break;
                }
                if (collen <= 254L) {
                    len = collen + 2L;
                    break;
                }
                len = collen + 3L;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                collen = col.getLength();
                if (collen <= 15L || isKey && collen <= 127L) {
                    len = collen * 2L + 1L;
                    break;
                }
                if (collen <= 127L) {
                    len = collen * 2L + 2L;
                    break;
                }
                len = collen * 2L + 3L;
                break;
            }
            case 91: 
            case 92: {
                len = 9L;
                break;
            }
            case 93: {
                len = 21L;
                break;
            }
            case 2: 
            case 3: {
                len = (col.getLength() + 1L) / 2L + 2L;
                break;
            }
            case 6: 
            case 8: {
                len = 22L;
                break;
            }
            case 7: {
                len = 11L;
                break;
            }
            case 4: {
                len = 7L;
                break;
            }
            case 5: {
                len = 5L;
            }
        }
        return len;
    }

    public static boolean isReservedWord(String id) {
        if (reservedWords == null) {
            reservedWords = new ArrayList();
            reservedWords.add("ABS");
            reservedWords.add("ABSOLUTE");
            reservedWords.add("ACOS");
            reservedWords.add("ADDDATE");
            reservedWords.add("ADDTIME");
            reservedWords.add("ALL");
            reservedWords.add("ALPHA");
            reservedWords.add("ALTER");
            reservedWords.add("ANY");
            reservedWords.add("ASCII");
            reservedWords.add("ASIN");
            reservedWords.add("ATAN");
            reservedWords.add("ATAN2");
            reservedWords.add("AVG");
            reservedWords.add("BINARY");
            reservedWords.add("BIT");
            reservedWords.add("BOOLEAN");
            reservedWords.add("BYTE");
            reservedWords.add("CEIL");
            reservedWords.add("CEILING");
            reservedWords.add("CHAR");
            reservedWords.add("CHARACTER");
            reservedWords.add("CHECK");
            reservedWords.add("CHR");
            reservedWords.add("COLUMN");
            reservedWords.add("CONCAT");
            reservedWords.add("CONNECTED");
            reservedWords.add("CONSTRAINT");
            reservedWords.add("COS");
            reservedWords.add("COSH");
            reservedWords.add("COT");
            reservedWords.add("COUNT");
            reservedWords.add("CROSS");
            reservedWords.add("CURDATE");
            reservedWords.add("CURRENT");
            reservedWords.add("CURTIME");
            reservedWords.add("DATABASE");
            reservedWords.add("DATE");
            reservedWords.add("DATEDIFF");
            reservedWords.add("DAY");
            reservedWords.add("DAYNAME");
            reservedWords.add("DAYOFMONTH");
            reservedWords.add("DAYOFWEEK");
            reservedWords.add("DAYOFYEAR");
            reservedWords.add("DBYTE");
            reservedWords.add("DEC");
            reservedWords.add("DECIMAL");
            reservedWords.add("DECODE");
            reservedWords.add("DEFAULT");
            reservedWords.add("DEGREES");
            reservedWords.add("DELETE");
            reservedWords.add("DIGITS");
            reservedWords.add("DIRECT");
            reservedWords.add("DISTINCT");
            reservedWords.add("DOUBLE");
            reservedWords.add("EBCDIC");
            reservedWords.add("EXCEPT");
            reservedWords.add("EXISTS");
            reservedWords.add("EXP");
            reservedWords.add("EXPAND");
            reservedWords.add("FIRST");
            reservedWords.add("FIXED");
            reservedWords.add("FLOAT");
            reservedWords.add("FLOOR");
            reservedWords.add("FOR");
            reservedWords.add("FROM");
            reservedWords.add("FULL");
            reservedWords.add("GRAPHIC");
            reservedWords.add("GREATEST");
            reservedWords.add("GROUP");
            reservedWords.add("HAVING");
            reservedWords.add("HEX");
            reservedWords.add("HOUR");
            reservedWords.add("IFNULL");
            reservedWords.add("IGNORE");
            reservedWords.add("INDEX");
            reservedWords.add("INITCAP");
            reservedWords.add("INNER");
            reservedWords.add("INSERT");
            reservedWords.add("INT");
            reservedWords.add("INTEGER");
            reservedWords.add("INTERNAL");
            reservedWords.add("INTERSECT");
            reservedWords.add("INTO");
            reservedWords.add("JOIN");
            reservedWords.add("KEY");
            reservedWords.add("LAST");
            reservedWords.add("LCASE");
            reservedWords.add("LEAST");
            reservedWords.add("LEFT");
            reservedWords.add("LENGTH");
            reservedWords.add("LFILL");
            reservedWords.add("LINK");
            reservedWords.add("LIST");
            reservedWords.add("LN");
            reservedWords.add("LOCALSYSDBA");
            reservedWords.add("LOCATE");
            reservedWords.add("LOG");
            reservedWords.add("LOG10");
            reservedWords.add("LONG");
            reservedWords.add("LONGFILE");
            reservedWords.add("LOWER");
            reservedWords.add("LPAD");
            reservedWords.add("LTRIM");
            reservedWords.add("MAKEDATE");
            reservedWords.add("MAKETIME");
            reservedWords.add("MAPCHAR");
            reservedWords.add("MAX");
            reservedWords.add("MBCS");
            reservedWords.add("MICROSECOND");
            reservedWords.add("MIN");
            reservedWords.add("MINUTE");
            reservedWords.add("MOD");
            reservedWords.add("MONTH");
            reservedWords.add("MONTHNAME");
            reservedWords.add("NATURAL");
            reservedWords.add("NCHAR");
            reservedWords.add("NEXT");
            reservedWords.add("NOROUND");
            reservedWords.add("NO");
            reservedWords.add("NOT");
            reservedWords.add("NOW");
            reservedWords.add("NULL");
            reservedWords.add("NUM");
            reservedWords.add("NUMERIC");
            reservedWords.add("OBJECT");
            reservedWords.add("OF");
            reservedWords.add("ON");
            reservedWords.add("ORDER");
            reservedWords.add("PACKED");
            reservedWords.add("PI");
            reservedWords.add("POWER");
            reservedWords.add("PREV");
            reservedWords.add("PRIMARY");
            reservedWords.add("RADIANS");
            reservedWords.add("REAL");
            reservedWords.add("REFERENCED");
            reservedWords.add("REJECT");
            reservedWords.add("RELATIVE");
            reservedWords.add("REPLACE");
            reservedWords.add("RFILL");
            reservedWords.add("RIGHT");
            reservedWords.add("ROUND");
            reservedWords.add("ROWID");
            reservedWords.add("ROWNO");
            reservedWords.add("RPAD");
            reservedWords.add("RTRIM");
            reservedWords.add("SECOND");
            reservedWords.add("SELECT");
            reservedWords.add("SELUPD");
            reservedWords.add("SERIAL");
            reservedWords.add("SET");
            reservedWords.add("SHOW");
            reservedWords.add("SIGN");
            reservedWords.add("SIN");
            reservedWords.add("SINH");
            reservedWords.add("SMALLINT");
            reservedWords.add("SOME");
            reservedWords.add("SOUNDEX");
            reservedWords.add("SPACE");
            reservedWords.add("SQRT");
            reservedWords.add("STAMP");
            reservedWords.add("STATISTICS");
            reservedWords.add("STDDEV");
            reservedWords.add("SUBDATE");
            reservedWords.add("SUBSTR");
            reservedWords.add("SUBSTRING");
            reservedWords.add("SUBTIME");
            reservedWords.add("SUM");
            reservedWords.add("SYSDBA");
            reservedWords.add("TABLE");
            reservedWords.add("TAN");
            reservedWords.add("TANH");
            reservedWords.add("TIME");
            reservedWords.add("TIMEDIFF");
            reservedWords.add("TIMESTAMP");
            reservedWords.add("TIMEZONE");
            reservedWords.add("TO");
            reservedWords.add("TOIDENTIFIER");
            reservedWords.add("TRANSACTION");
            reservedWords.add("TRANSLATE");
            reservedWords.add("TRIM");
            reservedWords.add("TRUNC");
            reservedWords.add("TRUNCATE");
            reservedWords.add("UCASE");
            reservedWords.add("UID");
            reservedWords.add("UNICODE");
            reservedWords.add("UNION");
            reservedWords.add("UPDATE");
            reservedWords.add("UPPER");
            reservedWords.add("USER");
            reservedWords.add("USERGROUP");
            reservedWords.add("USING");
            reservedWords.add("UTCDIFF");
            reservedWords.add("VALUE");
            reservedWords.add("VALUES");
            reservedWords.add("VARCHAR");
            reservedWords.add("VARGRAPHIC");
            reservedWords.add("VARIANCE");
            reservedWords.add("WEEK");
            reservedWords.add("WEEKOFYEAR");
            reservedWords.add("WHERE");
            reservedWords.add("WITH");
            reservedWords.add("YEAR");
            reservedWords.add("ZONED");
            Collections.sort(reservedWords);
        }
        return Collections.binarySearch(reservedWords, id) >= 0;
    }

    public static boolean isSpecJ2EEColumn(String tabName, String colName, String dbType) {
        return (dbType == null || dbType.equalsIgnoreCase("") || dbType.equalsIgnoreCase("LONGVARBINARY")) && colName.equalsIgnoreCase("VBYTES") && tabName.equalsIgnoreCase("J2EE_CONFIGENTRY");
    }
}

