/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexIterator;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.DbTableDifference;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.ora.DbOraEnvironment;
import com.sap.dictionary.database.ora.DbOraFactory;
import com.sap.dictionary.database.ora.DbOraIndex;
import com.sap.dictionary.database.ora.DbOraLobStorage;
import com.sap.dictionary.database.ora.DbOraPartitioning;
import com.sap.dictionary.database.ora.DbOraPrimaryKey;
import com.sap.dictionary.database.ora.DbOraSegmentAttributes;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class DbOraTable
extends DbTable {
    private DbOraSegmentAttributes segmentAttributes = null;
    private DbOraPartitioning partitioning = null;
    private boolean hasLobs = false;
    private ArrayList lobStorageList = null;
    private boolean isPartitioned = false;
    private String partitioningType = null;
    private String subPartitioningType = null;
    private int partitionCount = 0;
    private Boolean cache = null;
    private Boolean monitoring = null;
    private static Location location = Logger.getLocation("ora.DbOraTable");

    public DbOraTable() {
    }

    public DbOraTable(DbFactory factory) {
        super(factory);
    }

    public DbOraTable(DbFactory factory, String name) {
        super(factory, name);
    }

    public DbOraTable(DbFactory factory, DbSchema schema, String name) {
        super(factory, name);
    }

    public DbOraTable(DbFactory factory, DbTable other) {
        super(factory, other);
    }

    public boolean hasLobs() {
        return this.hasLobs;
    }

    public boolean hasSubPartitions() {
        return this.subPartitioningType.equalsIgnoreCase("HASH");
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSpecificContentViaXml(XmlMap xmlMap) throws JddException {
        block16: {
            block15: {
                try {
                    try {
                        XmlMap xmlPrimaryKey;
                        XmlMap indexes;
                        XmlMap tableProperties;
                        location.entering("setSpecificContentViaXml");
                        XmlMap table = xmlMap.getXmlMap("table");
                        String xmlName = table.getString("name");
                        if (!this.getName().equalsIgnoreCase(xmlName.trim())) {
                            System.err.println("Table Name is " + this.getName() + " but XML Table Name is " + xmlName);
                            Object var11_6 = null;
                            break block15;
                        }
                        XmlMap physicalProperties = table.getXmlMap("physical-properties");
                        if (!physicalProperties.isEmpty()) {
                            XmlMap xmlSegmentAttributes = physicalProperties.getXmlMap("segment-attributes");
                            DbOraSegmentAttributes segmentAttributes = new DbOraSegmentAttributes();
                            segmentAttributes.setContentViaXml(xmlSegmentAttributes);
                            if (!segmentAttributes.isNull()) {
                                this.segmentAttributes = segmentAttributes;
                            }
                            XmlMap xmlLobStorageList = physicalProperties.getXmlMap("lob-storage-list");
                            this.lobStorageList = DbOraLobStorage.setListContentViaXml(xmlLobStorageList);
                            if (this.lobStorageList != null) {
                                this.hasLobs = true;
                            }
                        }
                        if (!(tableProperties = table.getXmlMap("table-properties")).isEmpty()) {
                            XmlMap xmlPartitioning = tableProperties.getXmlMap("partitioning");
                            if (!xmlPartitioning.isEmpty()) {
                                DbOraPartitioning partitioning = DbOraFactory.makePartitioning(xmlPartitioning);
                                if (partitioning != null) {
                                    this.isPartitioned = true;
                                    partitioning.setRowMovementEnabled(xmlPartitioning.getBooleanObject("enable-row-movement"));
                                }
                                partitioning.setContentViaXml(xmlPartitioning);
                                this.partitioning = partitioning;
                            }
                            this.cache = tableProperties.getBooleanObject("cache");
                            this.monitoring = tableProperties.getBooleanObject("monitoring");
                        }
                        if (!(indexes = table.getXmlMap("indexes")).isEmpty()) {
                            XmlMap xmlIndex = null;
                            DbOraIndex index = null;
                            int i = 0;
                            while (!(xmlIndex = indexes.getXmlMap("index" + (i == 0 ? "" : "" + i))).isEmpty()) {
                                index = (DbOraIndex)this.getIndexes().getIndex(xmlIndex.getString("name"));
                                index.setSpecificContentViaXml(xmlIndex);
                                ++i;
                            }
                        }
                        if (!(xmlPrimaryKey = table.getXmlMap("primary-key")).isEmpty()) {
                            DbOraPrimaryKey primaryKey = null;
                            primaryKey = (DbOraPrimaryKey)this.getPrimaryKey();
                            primaryKey.setSpecificContentViaXml(xmlPrimaryKey);
                        }
                        break block16;
                    }
                    catch (Exception exception) {
                        Object[] arguments = new Object[]{exception.getMessage()};
                        location.infoT("setSpecificContentViaXml failed: {0}", arguments);
                        throw JddException.createInstance(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    location.exiting();
                    throw throwable;
                }
            }
            location.exiting();
            return;
        }
        Object var11_7 = null;
        location.exiting();
    }

    public void setSpecificContentViaDb() {
        DbOraSegmentAttributes segmentAttributes = new DbOraSegmentAttributes();
        Boolean rowMovementEnabled = null;
        String tableName = this.getName();
        Connection connection = this.getDbFactory().getConnection();
        try {
            PreparedStatement preparedStatement = NativeSQLAccess.prepareNativeStatement((Connection)connection, (String)"SELECT * FROM   \"USER_TABLES\" WHERE \"TABLE_NAME\" = ? ");
            preparedStatement.setString(1, tableName.toUpperCase());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String partitioned;
                String cache = resultSet.getString("CACHE");
                if (!resultSet.wasNull()) {
                    this.cache = cache.trim().charAt(0) == 'N' ? new Boolean(false) : new Boolean(true);
                }
                String rowMovement = resultSet.getString("ROW_MOVEMENT");
                if (!resultSet.wasNull()) {
                    rowMovementEnabled = rowMovement.equalsIgnoreCase("DISABLED") ? new Boolean(false) : new Boolean(true);
                }
                String monitoring = resultSet.getString("MONITORING");
                if (!resultSet.wasNull()) {
                    this.monitoring = monitoring.equalsIgnoreCase("YES") ? new Boolean(true) : new Boolean(false);
                }
                if ((partitioned = resultSet.getString("PARTITIONED")).equalsIgnoreCase("YES")) {
                    this.isPartitioned = true;
                } else {
                    segmentAttributes.setContentViaDbCatalog(connection, resultSet, "USER_TABLES");
                    if (!segmentAttributes.isNull()) {
                        this.segmentAttributes = segmentAttributes;
                    }
                }
            } else {
                System.err.println("Table " + this.getName() + " does not exist in USER_TABLES");
                return;
            }
            preparedStatement.close();
            resultSet.close();
            if (this.isPartitioned) {
                boolean multiply = true;
                preparedStatement = NativeSQLAccess.prepareNativeStatement((Connection)connection, (String)"SELECT * FROM   \"USER_PART_TABLES\" WHERE  \"TABLE_NAME\" = ? ");
                preparedStatement.setString(1, tableName.toUpperCase());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    this.partitioningType = resultSet.getString("PARTITIONING_TYPE");
                    this.subPartitioningType = resultSet.getString("SUBPARTITIONING_TYPE");
                    this.partitionCount = resultSet.getInt("PARTITION_COUNT");
                    segmentAttributes.setContentViaDbCatalog(connection, resultSet, "USER_PART_TABLES");
                    if (!segmentAttributes.isNull()) {
                        this.segmentAttributes = segmentAttributes;
                    }
                } else {
                    System.err.println("Partitioned Table " + this.getName() + " does not exist in USER_PART_TABLES");
                    return;
                }
                preparedStatement.close();
                resultSet.close();
            }
            String partitionName = null;
            this.lobStorageList = DbOraLobStorage.setListContentViaDbCatalog(connection, tableName, partitionName, this.isPartitioned);
            if (this.lobStorageList != null) {
                this.hasLobs = true;
            }
            if (this.isPartitioned) {
                DbOraPartitioning partitioning = DbOraFactory.makePartitioning(this.partitioningType, this.subPartitioningType);
                if (partitioning != null) {
                    partitioning.setRowMovementEnabled(rowMovementEnabled);
                    partitioning.setContentViaDbCatalog(connection, this);
                }
                this.partitioning = partitioning;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.segmentAttributes != null || this.lobStorageList != null || this.partitioning != null || this.cache != null || this.monitoring != null) {
            this.setDbSpecificIsSet(true);
        }
    }

    public void setIndexesViaDb() throws JddException {
        ArrayList names = new ArrayList();
        DbFactory factory = this.getDbFactory();
        Connection connection = factory.getConnection();
        names = this.dbGetIndexNames(connection);
        if (!names.isEmpty()) {
            DbIndexes indexes = new DbIndexes(factory);
            int i = 0;
            while (i < names.size()) {
                DbOraIndex index = new DbOraIndex(factory, this.getSchema(), this.getName(), (String)names.get(i));
                index.setIndexes(indexes);
                index.setCommonContentViaDb();
                indexes.add(index);
                ++i;
            }
            this.setIndexes(indexes);
        }
    }

    public void setPrimaryKeyViaDb() throws JddException {
        DbOraPrimaryKey primaryKey = new DbOraPrimaryKey(this.getDbFactory(), this.getSchema(), this.getName());
        primaryKey.setCommonContentViaDb();
        this.setPrimaryKey(primaryKey);
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() throws JddException {
        try {
            if (!this.DbSpecificIsSet()) {
                return super.getDdlStatementsForCreate();
            }
            DbObjectSqlStatements statements = new DbObjectSqlStatements(this.getName());
            DbSqlStatement statement = new DbSqlStatement();
            statement.addLine("CREATE TABLE \"" + this.getName().toUpperCase() + "\"");
            statement.merge(this.getColumns().getDdlClause());
            if (this.segmentAttributes != null) {
                statement.merge(this.segmentAttributes.getDdlClause());
            }
            if (this.lobStorageList != null) {
                statement.merge(DbOraLobStorage.getDdlClauses(this.lobStorageList));
            }
            if (this.partitioning != null) {
                statement.merge(this.partitioning.getDdlClause());
            }
            if (this.cache != null) {
                if (this.cache.booleanValue()) {
                    statement.addLine(" CACHE");
                } else {
                    statement.addLine(" NOCACHE");
                }
            }
            if (this.monitoring != null) {
                if (this.monitoring.booleanValue()) {
                    statement.addLine(" MONITORING");
                } else {
                    statement.addLine(" NOMONITORING");
                }
            }
            statements.add(statement);
            statements.merge(this.getIndexes().getDdlStatementsForCreate());
            statements.merge(this.getPrimaryKey().getDdlStatementsForCreate());
            return statements;
        }
        catch (Exception exception) {
            throw JddException.createInstance(exception);
        }
    }

    public DbTableDifference compareTo(DbTable target) throws Exception {
        DbTableDifference tableDifference = null;
        if (!this.DbSpecificIsSet()) {
            return super.compareTo(target);
        }
        return tableDifference;
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        try {
            try {
                location.entering("writeSpecificContentToXmlFile");
                String offset1 = offset0 + XmlHelper.tabulate();
                String offset2 = offset1 + XmlHelper.tabulate();
                file.println(offset0 + "<?xml version=\"1.0\"?>");
                file.println(offset0 + "<table name=" + "\"" + this.getName() + "\">");
                if (this.segmentAttributes != null || this.lobStorageList != null) {
                    file.println(offset1 + "<physical-properties>");
                    if (this.segmentAttributes != null) {
                        this.segmentAttributes.writeContentToXmlFile(file, offset2);
                    }
                    if (this.lobStorageList != null) {
                        DbOraLobStorage.writeListContentToXmlFile(this.lobStorageList, file, offset2);
                    }
                    file.println(offset1 + "</physical-properties>");
                }
                if (this.partitioning != null || this.cache != null || this.monitoring != null) {
                    file.println(offset1 + "<table-properties>");
                    if (this.partitioning != null) {
                        this.partitioning.writeContentToXmlFile(file, offset2);
                    }
                    if (this.cache != null) {
                        file.println(offset2 + "<cache>" + this.cache + "</cache>");
                    }
                    if (this.monitoring != null) {
                        file.println(offset2 + "<monitoring>" + this.monitoring + "</monitoring>");
                    }
                    file.println(offset1 + "</table-properties>");
                }
                if (this.getIndexes() != null) {
                    file.println(offset1 + "<indexes>");
                    DbIndexIterator dbIndexIterator = this.getIndexes().iterator();
                    DbOraIndex dbindex = null;
                    while (dbIndexIterator.hasNext()) {
                        dbindex = (DbOraIndex)dbIndexIterator.next();
                        dbindex.writeSpecificContentToXmlFile(file, offset2);
                    }
                    file.println(offset1 + "</indexes>");
                }
                if (this.getPrimaryKey() != null) {
                    DbOraPrimaryKey dbPrimaryKey = (DbOraPrimaryKey)this.getPrimaryKey();
                    dbPrimaryKey.writeSpecificContentToXmlFile(file, offset1);
                }
                file.println(offset0 + "</table>");
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.infoT("setSpecificContentViaXml failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
    }

    public ArrayList dbGetIndexNames(Connection connection) {
        String primaryKeyName = this.dbGetPrimaryKeyName(connection);
        ArrayList<String> indexNames = new ArrayList<String>();
        try {
            Statement statement = NativeSQLAccess.createNativeStatement((Connection)connection);
            ResultSet resultSet = statement.executeQuery("SELECT \"USER_INDEXES\".\"INDEX_NAME\" FROM   \"USER_INDEXES\" WHERE  \"USER_INDEXES\".\"TABLE_NAME\" = '" + this.getName().toUpperCase() + "'  " + "AND    \"USER_INDEXES\".\"INDEX_TYPE\" = 'NORMAL' ");
            while (resultSet.next()) {
                String indexName = resultSet.getString(1);
                if (indexName.equals(primaryKeyName)) continue;
                indexNames.add(indexName);
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return indexNames;
    }

    public String dbGetPrimaryKeyName(Connection connection) {
        String primaryKeyName = "";
        try {
            Statement statement = NativeSQLAccess.createNativeStatement((Connection)connection);
            ResultSet resultSet = statement.executeQuery("SELECT \"USER_CONSTRAINTS\".\"CONSTRAINT_NAME\" FROM   \"USER_CONSTRAINTS\" WHERE  \"USER_CONSTRAINTS\".\"TABLE_NAME\" = '" + this.getName().toUpperCase() + "' " + "AND    \"USER_CONSTRAINTS\".\"CONSTRAINT_TYPE\" = 'P' ");
            while (resultSet.next()) {
                primaryKeyName = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return primaryKeyName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsOnDb() {
        location.entering("existsOnDb");
        boolean exists = false;
        try {
            try {
                Connection connection = this.getDbFactory().getConnection();
                Statement statement = NativeSQLAccess.createNativeStatement((Connection)connection);
                ResultSet resultSet = statement.executeQuery("SELECT 1 FROM   \"DUAL\" WHERE  EXISTS(SELECT *               FROM   \"DBA_TABLES\"               WHERE  \"TABLE_NAME\" = '" + this.getName().toUpperCase() + "') ");
                if (resultSet.next()) {
                    exists = true;
                }
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("existsOnDb failed: {0}", arguments);
                Object var6_8 = null;
                location.exiting();
                return exists;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
        return exists;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsData() {
        location.entering("existsData");
        boolean exists = false;
        try {
            try {
                Connection connection = this.getDbFactory().getConnection();
                Statement statement = NativeSQLAccess.createNativeStatement((Connection)connection);
                ResultSet resultSet = statement.executeQuery("SELECT 1 FROM   \"DUAL\" WHERE  EXISTS(SELECT *               FROM   \"" + this.getName().toUpperCase() + "\") ");
                if (resultSet.next()) {
                    exists = true;
                }
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("existsData failed: {0}", arguments);
                Object var6_8 = null;
                location.exiting();
                return exists;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
        return exists;
    }

    public String toString() {
        return super.toString() + "Segment Attributes    : " + "\n" + this.segmentAttributes + "\n" + "hasLobs               : " + this.hasLobs + "\n" + "LobStorageList        : " + DbOraFactory.listToString(this.lobStorageList, "LOB Storage List") + "IsPartitioned         : " + this.isPartitioned + "\n" + "Partitioning          : " + "\n" + this.partitioning + "\n" + "Cache                 : " + this.cache + "\n" + "Monitoring            : " + this.monitoring + "\n";
    }

    public boolean checkWidth() {
        location.entering("checkWidth");
        boolean correct = true;
        if (!correct) {
            Object[] arguments = new Object[]{this.getName()};
            location.errorT("checkWidth: width of table {0} is too great", arguments);
        }
        location.exiting();
        return correct;
    }

    public boolean checkNameLength() {
        boolean correct;
        location.entering("checkNameLength");
        boolean bl = correct = this.getName().length() > 0 && this.getName().length() < 31;
        if (!correct) {
            Object[] arguments = new Object[]{this.getName()};
            location.errorT("checkNameLength: length of table name {0} is zero or greater than 30", arguments);
        }
        location.exiting();
        return correct;
    }

    public boolean checkNameForReservedWord() {
        boolean correct;
        location.entering("checkNameForReservedWord");
        boolean bl = correct = !DbOraEnvironment.isReservedWord(this.getName());
        if (!correct) {
            Object[] arguments = new Object[]{this.getName()};
            location.errorT("checkNameForReservedWord: name of table {0} is reserved word", arguments);
        }
        location.exiting();
        return correct;
    }
}

