/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.ora.DbOraStorage;
import com.sap.dictionary.database.ora.DbOraTablespace;
import com.sap.dictionary.database.ora.DbOraTablespaces;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;

public class DbOraSegmentAttributes {
    private DbOraTablespace tablespace = null;
    private Integer pctfree = null;
    private Integer pctused = null;
    private Integer initrans = null;
    private Integer maxtrans = null;
    private DbOraStorage storage = null;
    private Boolean logging = null;
    private boolean isNull = true;

    public DbOraTablespace getTablespace() {
        return this.tablespace;
    }

    public Integer getPctfree() {
        return this.pctfree;
    }

    public Integer getPctused() {
        return this.pctused;
    }

    public Integer getInitrans() {
        return this.initrans;
    }

    public Integer getMaxtrans() {
        return this.maxtrans;
    }

    public DbOraStorage getStorage() {
        return this.storage;
    }

    public Boolean getLogging() {
        return this.logging;
    }

    public boolean isNull() {
        return this.isNull;
    }

    protected void setContentViaXml(XmlMap xmlSegmentAttributes) {
        if (xmlSegmentAttributes.isEmpty()) {
            return;
        }
        String tablespaceName = xmlSegmentAttributes.getString("tablespace");
        if (tablespaceName != null && tablespaceName.trim() != "") {
            this.tablespace = new DbOraTablespace(tablespaceName);
        }
        this.logging = xmlSegmentAttributes.getBooleanObject("logging");
        XmlMap physicalAttributes = xmlSegmentAttributes.getXmlMap("physical-attributes");
        if (!physicalAttributes.isEmpty()) {
            this.pctfree = physicalAttributes.getIntegerObject("pctfree");
            this.pctused = physicalAttributes.getIntegerObject("pctused");
            this.initrans = physicalAttributes.getIntegerObject("initrans");
            this.maxtrans = physicalAttributes.getIntegerObject("maxtrans");
        }
        XmlMap xmlStorage = physicalAttributes.getXmlMap("storage");
        DbOraStorage storage = new DbOraStorage();
        storage.setContentViaXml(xmlStorage);
        if (!storage.isNull()) {
            this.storage = storage;
        }
        if (this.tablespace != null || this.pctfree != null || this.pctused != null || this.initrans != null || this.maxtrans != null || this.logging != null || storage != null) {
            this.isNull = false;
        }
    }

    protected void setContentViaDbCatalog(Connection connection, ResultSet resultSet, String ddicTable) {
        String prefix = "";
        if (ddicTable.equals("USER_PART_TABLES") || ddicTable.equals("USER_PART_LOBS")) {
            prefix = "DEF_";
        }
        try {
            String tablespaceName = resultSet.getString(prefix + "TABLESPACE_NAME");
            if (!resultSet.wasNull()) {
                this.isNull = false;
                this.tablespace = DbOraTablespaces.getTablespace(tablespaceName);
            }
            int pctfree = resultSet.getInt(prefix + "PCT_FREE");
            if (!resultSet.wasNull()) {
                this.isNull = false;
                this.pctfree = new Integer(pctfree);
            }
            if (!ddicTable.equals("USER_INDEXES")) {
                int pctused = resultSet.getInt(prefix + "PCT_USED");
                if (!resultSet.wasNull()) {
                    this.isNull = false;
                    this.pctused = new Integer(pctused);
                }
            }
            int initrans = resultSet.getInt(prefix + "INI_TRANS");
            if (!resultSet.wasNull()) {
                this.isNull = false;
                this.initrans = new Integer(initrans);
            }
            int maxtrans = resultSet.getInt(prefix + "MAX_TRANS");
            if (!resultSet.wasNull()) {
                this.isNull = false;
                this.maxtrans = new Integer(maxtrans);
            }
            String logging = resultSet.getString(prefix + "LOGGING");
            if (!resultSet.wasNull()) {
                this.isNull = false;
                this.logging = logging.equalsIgnoreCase("YES") ? new Boolean(true) : new Boolean(false);
            }
            DbOraStorage storage = new DbOraStorage();
            storage.setContentViaDbCatalog(resultSet, ddicTable);
            if (!storage.isNull()) {
                this.isNull = false;
                this.storage = storage;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.isNull = true;
        }
    }

    protected DbSqlStatement getDdlClause() {
        DbSqlStatement statement = new DbSqlStatement();
        if (this.tablespace != null) {
            statement.addLine(" TABLESPACE \"" + this.tablespace.getName().toUpperCase() + "\"");
        }
        if (this.pctfree != null) {
            statement.addLine(" PCTFREE " + this.pctfree);
        }
        if (this.pctused != null) {
            statement.addLine(" PCTUSED " + this.pctused);
        }
        if (this.initrans != null) {
            statement.addLine(" INITRANS " + this.initrans);
        }
        if (this.maxtrans != null) {
            statement.addLine(" MAXTRANS " + this.maxtrans);
        }
        if (this.storage != null) {
            statement.merge(this.storage.getDdlClause());
        }
        if (this.logging != null) {
            if (this.logging.booleanValue()) {
                statement.addLine(" LOGGING");
            } else {
                statement.addLine(" NOLOGGING");
            }
        }
        return statement;
    }

    public void writeContentToXmlFile(PrintWriter file, String offset0) {
        String offset1 = offset0 + XmlHelper.tabulate();
        String offset2 = offset1 + XmlHelper.tabulate();
        file.println(offset0 + "<segment-attributes>");
        if (this.tablespace != null) {
            file.println(offset1 + "<tablespace>" + this.tablespace.getName() + "</tablespace>");
        }
        if (this.pctfree != null || this.pctused != null || this.initrans != null || this.maxtrans != null || this.storage != null) {
            file.println(offset1 + "<physical-attributes>");
            if (this.pctfree != null) {
                file.println(offset2 + "<pctfree>" + this.pctfree + "</pctfree>");
            }
            if (this.pctused != null) {
                file.println(offset2 + "<pctused>" + this.pctused + "</pctused>");
            }
            if (this.initrans != null) {
                file.println(offset2 + "<initrans>" + this.initrans + "</initrans>");
            }
            if (this.maxtrans != null) {
                file.println(offset2 + "<maxtrans>" + this.maxtrans + "</maxtrans>");
            }
            if (this.storage != null) {
                this.storage.writeContentToXmlFile(file, offset2);
            }
            file.println(offset1 + "</physical-attributes>");
        }
        if (this.logging != null) {
            file.println(offset1 + "<logging>" + this.logging + "</logging>");
        }
        file.println(offset0 + "</segment-attributes>");
    }

    public String toString() {
        return "Tablespace            : \n" + this.tablespace + "\n" + "Pctfree               : " + this.pctfree + "\n" + "Pctused               : " + this.pctused + "\n" + "Initrans              : " + this.initrans + "\n" + "Maxtrans              : " + this.maxtrans + "\n" + "Storage               : " + "\n" + this.storage + "\n" + "Logging               : " + this.logging + "\n";
    }
}

