/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.ora.DbOraFactory;
import com.sap.dictionary.database.ora.DbOraPartitionColumn;
import com.sap.dictionary.database.ora.DbOraPartitionValue;
import com.sap.dictionary.database.ora.DbOraPartitioning;
import com.sap.dictionary.database.ora.DbOraRangePartition;
import com.sap.dictionary.database.ora.DbOraTable;
import com.sap.sql.NativeSQLAccess;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;

public class DbOraRangePartitioning
extends DbOraPartitioning {
    private ArrayList columnList = null;
    private ArrayList partitionList = null;

    public ArrayList getColumnList() {
        return this.columnList;
    }

    public ArrayList getPartitionList() {
        return this.partitionList;
    }

    protected void setContentViaXml(XmlMap xmlPartitioning) {
        if (xmlPartitioning.isEmpty()) {
            return;
        }
        XmlMap xmlRangePartitioning = xmlPartitioning.getXmlMap("range-partitioning");
        XmlMap xmlColumnList = xmlRangePartitioning.getXmlMap("column-list");
        XmlMap xmlPartitionDefinitionList = xmlRangePartitioning.getXmlMap("partition-definition-list");
        if (xmlColumnList.isEmpty()) {
            System.out.println("A Column List within <range-partitioning> must be given!");
            return;
        }
        if (xmlPartitionDefinitionList.isEmpty()) {
            System.out.println("A Partition Definition List within <range-partitioning> must be given!");
            return;
        }
        ArrayList<DbOraPartitionColumn> columnList = new ArrayList<DbOraPartitionColumn>();
        String columnName = null;
        int columnPosition = 0;
        int i = 0;
        while ((columnName = xmlColumnList.getString("column" + (i == 0 ? "" : "" + i))) != null) {
            if (columnName.trim() == "") {
                System.out.println("Invalid Column Name within <range-partitioning>");
                return;
            }
            columnPosition = i + 1;
            columnList.add(new DbOraPartitionColumn(columnName, columnPosition));
            ++i;
        }
        if (columnPosition == 0) {
            System.out.println("No Column Name within <range-partitioning>");
            return;
        }
        this.columnList = columnList;
        ArrayList<DbOraRangePartition> partitionList = new ArrayList<DbOraRangePartition>();
        XmlMap xmlPartition = null;
        int partitionNumber = 0;
        while (!(xmlPartition = xmlPartitionDefinitionList.getXmlMap("partition-definition" + (partitionNumber == 0 ? "" : "" + partitionNumber))).isEmpty()) {
            XmlMap xmlValueList = xmlPartition.getXmlMap("value-list");
            if (xmlValueList.isEmpty()) {
                System.out.println("No Value List within <partition-definition>");
                return;
            }
            ArrayList<DbOraPartitionValue> valueList = new ArrayList<DbOraPartitionValue>();
            String xmlValue = null;
            int valueNumber = 0;
            while ((xmlValue = xmlValueList.getString("value" + (valueNumber == 0 ? "" : "" + valueNumber))) != null) {
                valueList.add(new DbOraPartitionValue(xmlValue, valueNumber + 1));
                ++valueNumber;
            }
            if (valueNumber == 0) {
                System.out.println("No Values within <partition-definition>");
                return;
            }
            DbOraRangePartition rangePartition = new DbOraRangePartition(valueList);
            rangePartition.setContentViaXml(xmlPartition, partitionNumber + 1);
            partitionList.add(partitionNumber, rangePartition);
            ++partitionNumber;
        }
        if (partitionNumber == 0) {
            System.out.println("No Partition Definition within <range-partitioning>");
            return;
        }
        this.partitionList = partitionList;
    }

    protected void setContentViaDbCatalog(Connection connection, DbOraTable table) {
        try {
            PreparedStatement preparedStatement = NativeSQLAccess.prepareNativeStatement((Connection)connection, (String)"SELECT * FROM   \"USER_PART_KEY_COLUMNS\" WHERE  \"NAME\" = ? ");
            preparedStatement.setString(1, table.getName().toUpperCase());
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<DbOraPartitionColumn> newColumnList = new ArrayList<DbOraPartitionColumn>();
            boolean newColumnListExists = false;
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                int position = resultSet.getInt("COLUMN_POSITION");
                if (resultSet.wasNull()) continue;
                newColumnListExists = true;
                newColumnList.add(new DbOraPartitionColumn(columnName, position));
            }
            if (newColumnListExists) {
                Collections.sort(newColumnList);
                this.columnList = newColumnList;
            }
            preparedStatement.close();
            resultSet.close();
            preparedStatement = NativeSQLAccess.prepareNativeStatement((Connection)connection, (String)"SELECT * FROM   \"USER_TAB_PARTITIONS\" WHERE  \"TABLE_NAME\" = ? ");
            preparedStatement.setString(1, table.getName().toUpperCase());
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbOraRangePartition> newPartitionList = new ArrayList<DbOraRangePartition>();
            boolean newPartitionListExists = false;
            while (resultSet.next()) {
                newPartitionListExists = true;
                ArrayList valueList = null;
                String values = resultSet.getString("HIGH_VALUE");
                if (!resultSet.wasNull()) {
                    valueList = this.extractValueList(values);
                }
                DbOraRangePartition rangePartition = new DbOraRangePartition(valueList);
                rangePartition.setContentViaDbCatalog(connection, resultSet, table, "USER_TAB_PARTITIONS");
                newPartitionList.add(rangePartition);
            }
            if (newPartitionListExists) {
                Collections.sort(newPartitionList);
                this.partitionList = newPartitionList;
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ArrayList extractValueList(String values) {
        if (values == null) {
            return null;
        }
        ArrayList<DbOraPartitionValue> list = new ArrayList<DbOraPartitionValue>();
        int position = 0;
        StringTokenizer tokenizer = new StringTokenizer(values, ",()", true);
        int numberOfTokens = tokenizer.countTokens();
        StringBuffer buffer = new StringBuffer();
        int numberOfParenthesisOpened = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (numberOfParenthesisOpened == 0 && token.equals(",") || --numberOfTokens == 0) {
                if (numberOfTokens == 0) {
                    buffer.append(token);
                }
                String value = buffer.toString();
                value = value.trim();
                list.add(new DbOraPartitionValue(value, ++position));
                buffer.delete(0, buffer.length());
                continue;
            }
            if (token.equals("(")) {
                ++numberOfParenthesisOpened;
                buffer.append(token);
                continue;
            }
            if (token.equals(")")) {
                if (--numberOfParenthesisOpened < 0) {
                    System.out.println("HIGHVALUE is a malformed string : " + values);
                    return null;
                }
                buffer.append(token);
                continue;
            }
            buffer.append(token);
        }
        return list;
    }

    protected DbSqlStatement getDdlClause() {
        DbSqlStatement statement = new DbSqlStatement();
        statement.addLine(" PARTITION BY RANGE");
        statement.merge(this.getDdlColumnListClause());
        statement.merge(this.getDdlPartitionListClause());
        return statement;
    }

    protected DbSqlStatement getDdlColumnListClause() {
        DbSqlStatement statement = new DbSqlStatement();
        statement.addLine(" (");
        int i = 0;
        while (i < this.columnList.size()) {
            DbOraPartitionColumn column = (DbOraPartitionColumn)this.columnList.get(i);
            if (column.getPosition() != i + 1) {
                System.out.println("Partition column position differs from its list index");
                return null;
            }
            if (i + 1 == this.columnList.size()) {
                statement.addLine("\"" + column.getName().toUpperCase() + "\"");
            } else {
                statement.addLine("\"" + column.getName().toUpperCase() + "\", ");
            }
            ++i;
        }
        statement.addLine(" )");
        return statement;
    }

    protected DbSqlStatement getDdlPartitionListClause() {
        DbSqlStatement statement = new DbSqlStatement();
        statement.addLine(" (");
        int i = 0;
        while (i < this.partitionList.size()) {
            DbOraRangePartition partition = (DbOraRangePartition)this.partitionList.get(i);
            if (i + 1 == this.partitionList.size()) {
                statement.merge(partition.getDdlClause());
            } else {
                statement.merge(partition.getDdlClause());
                statement.addLine(", ");
            }
            ++i;
        }
        statement.addLine(" )");
        return statement;
    }

    public void writeContentToXmlFile(PrintWriter file, String offset0) {
        String offset1 = offset0 + XmlHelper.tabulate();
        String offset2 = offset1 + XmlHelper.tabulate();
        String offset3 = offset2 + XmlHelper.tabulate();
        file.println(offset0 + "<partitioning>");
        file.println(offset1 + "<range-partitioning>");
        file.println(offset2 + "<column-list>");
        int i = 0;
        while (i < this.columnList.size()) {
            DbOraPartitionColumn column = (DbOraPartitionColumn)this.columnList.get(i);
            file.println(offset3 + "<column>" + column.getName() + "</column>");
            ++i;
        }
        file.println(offset2 + "</column-list>");
        file.println(offset2 + "<partition-definition-list>");
        int i2 = 0;
        while (i2 < this.partitionList.size()) {
            DbOraRangePartition partition = (DbOraRangePartition)this.partitionList.get(i2);
            partition.writeContentToXmlFile(file, offset3);
            ++i2;
        }
        file.println(offset2 + "</partition-definition-list>");
        file.println(offset1 + "</range-partitioning>");
        file.println(offset0 + "</partitioning>");
    }

    public String toString() {
        return super.toString() + "Partitioning Columns  : " + DbOraFactory.listToString(this.columnList, "Column List") + "Partition List        : " + DbOraFactory.listToString(this.partitionList, "Partition List");
    }
}

