/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.ora.DbOraFactory;
import com.sap.dictionary.database.ora.DbOraLobStorage;
import com.sap.dictionary.database.ora.DbOraPartitionValue;
import com.sap.dictionary.database.ora.DbOraPartitions;
import com.sap.dictionary.database.ora.DbOraSegmentAttributes;
import com.sap.dictionary.database.ora.DbOraTable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;

public class DbOraRangePartition
implements Comparable {
    private DbOraPartitions subPartitions = null;
    private DbOraSegmentAttributes segmentAttributes = null;
    private String name = null;
    private Integer position = null;
    private ArrayList valueList = null;
    private ArrayList lobStorageList = null;
    private ArrayList subPartitionList = null;
    private boolean hasSubPartitioning = false;

    public DbOraRangePartition(ArrayList valueList) {
        this.valueList = valueList;
    }

    public Object getSubPartitions() {
        if (this.hasSubPartitioning) {
            if (this.subPartitions != null) {
                return this.subPartitions;
            }
            return this.subPartitionList;
        }
        return null;
    }

    public DbOraSegmentAttributes getSegmentAttributes() {
        return this.segmentAttributes;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPosition() {
        return this.position;
    }

    public ArrayList getLobStorageList() {
        return this.lobStorageList;
    }

    public boolean getHasSubPartitioning() {
        return this.hasSubPartitioning;
    }

    protected void setContentViaXml(XmlMap xmlPartition, int position) {
        this.name = xmlPartition.getString("name").trim();
        this.position = new Integer(position);
        XmlMap xmlSegmentAttributes = xmlPartition.getXmlMap("segment-attributes");
        DbOraSegmentAttributes newSegmentAttributes = new DbOraSegmentAttributes();
        newSegmentAttributes.setContentViaXml(xmlSegmentAttributes);
        if (!newSegmentAttributes.isNull()) {
            this.segmentAttributes = newSegmentAttributes;
        }
        XmlMap xmlLobStorage = xmlPartition.getXmlMap("lob-storage-list");
        this.lobStorageList = DbOraLobStorage.setListContentViaXml(xmlLobStorage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setContentViaDbCatalog(Connection connection, ResultSet resultSet, DbOraTable table, String ddicTable) {
        try {
            String tableName = table.getName().toUpperCase();
            String partitionName = resultSet.getString("PARTITION_NAME");
            if (!resultSet.wasNull()) {
                this.name = partitionName;
            }
            int partitionPosition = resultSet.getInt("PARTITION_POSITION");
            if (!resultSet.wasNull()) {
                this.position = new Integer(partitionPosition);
            }
            DbOraSegmentAttributes newSegmentAttributes = new DbOraSegmentAttributes();
            newSegmentAttributes.setContentViaDbCatalog(connection, resultSet, ddicTable);
            if (!newSegmentAttributes.isNull()) {
                this.segmentAttributes = newSegmentAttributes;
            }
            if (table.hasLobs()) {
                this.lobStorageList = DbOraLobStorage.setListContentViaDbCatalog(connection, tableName, this.name, false);
            }
            if (!table.hasSubPartitions()) return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected DbSqlStatement getDdlClause() {
        DbSqlStatement statement = new DbSqlStatement();
        statement.addLine(" PARTITION ");
        if (this.name != null) {
            statement.addLine(this.name + " ");
        }
        statement.addLine(" VALUES LESS THAN");
        statement.addLine(" (");
        int i = 0;
        while (i < this.valueList.size()) {
            int index = i + 1;
            DbOraPartitionValue highValue = (DbOraPartitionValue)this.valueList.get(i);
            if (highValue.getPosition() != index) {
                System.out.println("Partition high value position differs from its list index");
                return null;
            }
            if (index == this.valueList.size()) {
                statement.addLine(highValue.getValue());
            } else {
                statement.addLine(highValue.getValue() + ", ");
            }
            ++i;
        }
        statement.addLine(" )");
        if (this.segmentAttributes != null) {
            statement.merge(this.segmentAttributes.getDdlClause());
        }
        if (this.lobStorageList != null) {
            statement.merge(DbOraLobStorage.getDdlClauses(this.lobStorageList));
        }
        if (this.hasSubPartitioning) {
            // empty if block
        }
        return statement;
    }

    public int compareTo(Object object) {
        int pos2;
        DbOraRangePartition part = (DbOraRangePartition)object;
        Integer compPosition = ((DbOraRangePartition)object).getPosition();
        int pos1 = this.position != null ? this.position : 0;
        int n = pos2 = compPosition != null ? compPosition : 0;
        return pos1 < pos2 ? -1 : (pos1 > pos2 ? 1 : 0);
    }

    public void writeContentToXmlFile(PrintWriter file, String offset0) {
        String offset1 = offset0 + XmlHelper.tabulate();
        String offset2 = offset1 + XmlHelper.tabulate();
        if (this.name != null) {
            file.println(offset0 + "<partition-definition name=" + "\"" + this.name + "\">");
        } else {
            file.println(offset0 + "<partition-definition>");
        }
        file.println(offset1 + "<value-list>");
        int i = 0;
        while (i < this.valueList.size()) {
            DbOraPartitionValue value = (DbOraPartitionValue)this.valueList.get(i);
            file.println(offset2 + "<value>" + value.getValue() + "</value>");
            ++i;
        }
        file.println(offset1 + "</value-list>");
        if (this.segmentAttributes != null) {
            this.segmentAttributes.writeContentToXmlFile(file, offset1);
        }
        if (this.lobStorageList != null) {
            DbOraLobStorage.writeListContentToXmlFile(this.lobStorageList, file, offset1);
        }
        if (this.hasSubPartitioning) {
            // empty if block
        }
        file.println(offset0 + "</partition-definition>");
    }

    public String toString() {
        return "Partition Name        : " + this.name + "\n" + "Partitioning Keys     : " + DbOraFactory.listToString(this.valueList, "High Value List") + "Segment Attributes    : " + "\n" + this.segmentAttributes + "\n" + "Lob Storage List      : " + DbOraFactory.listToString(this.lobStorageList, "LOB Storage List") + "Has SubPartitioning   : " + this.hasSubPartitioning + "\n" + "SubPartitions         : " + this.subPartitions + "\n" + "SubPartition List     : " + DbOraFactory.listToString(this.subPartitionList, "SubPartition List");
    }
}

