/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbPrimaryKeyDifference;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbOraPrimaryKey
extends DbPrimaryKey {
    DbFactory factory = null;
    DbSchema schema = null;
    private boolean enabled = true;
    private boolean deferred = false;
    private boolean deferrable = false;
    private boolean validated = true;
    private static Location location = Logger.getLocation("ora.DbOraPrimaryKey");

    public DbOraPrimaryKey() {
    }

    public DbOraPrimaryKey(DbFactory factory) {
        super(factory);
    }

    public DbOraPrimaryKey(DbFactory factory, DbPrimaryKey other) {
        super(factory, other);
    }

    public DbOraPrimaryKey(DbFactory factory, DbSchema schema, String tableName) {
        super(factory, schema, tableName);
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) throws JddException {
        try {
            try {
                location.entering("setSpecificContentViaXml");
                XmlMap enforcement = xmlMap.getXmlMap("enforcement");
                this.enabled = enforcement.getBoolean("enabled");
                this.deferred = enforcement.getBoolean("initially-deferred");
                this.deferrable = enforcement.getBoolean("deferrable");
                this.validated = enforcement.getBoolean("validated");
                super.setDbSpecificIsSet(true);
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("setSpecificContentViaXml failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
    }

    public void setCommonContentViaDb() throws JddException {
        try {
            try {
                location.entering("setCommonContentViaDb");
                Connection connection = this.getDbFactory().getConnection();
                ArrayList<DbIndexColumnInfo> columnsInfo = new ArrayList<DbIndexColumnInfo>();
                Statement statement = NativeSQLAccess.createNativeStatement((Connection)connection);
                ResultSet resultSet = statement.executeQuery("SELECT   \"USER_CONS_COLUMNS\".\"COLUMN_NAME\" FROM     \"USER_CONSTRAINTS\", \"USER_CONS_COLUMNS\" WHERE    \"USER_CONSTRAINTS\".\"CONSTRAINT_NAME\" = \"USER_CONS_COLUMNS\".\"CONSTRAINT_NAME\" AND      \"USER_CONSTRAINTS\".\"TABLE_NAME\" = '" + this.getTableName().toUpperCase() + "' " + "AND      \"USER_CONSTRAINTS\".\"CONSTRAINT_TYPE\" = 'P' " + "ORDER BY \"USER_CONS_COLUMNS\".\"POSITION\" ");
                while (resultSet.next()) {
                    columnsInfo.add(new DbIndexColumnInfo(resultSet.getString(1), false));
                }
                statement.close();
                resultSet.close();
                this.setContent(columnsInfo);
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("setCommonContentViaDb failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
    }

    public void setSpecificContentViaDb() throws JddException {
        try {
            try {
                location.entering("setSpecificContentViaDb");
                Connection connection = this.getDbFactory().getConnection();
                ArrayList columnsInfo = new ArrayList();
                Statement statement = NativeSQLAccess.createNativeStatement((Connection)connection);
                ResultSet resultSet = statement.executeQuery("SELECT \"STATUS\", \"DEFERRED\", \"DEFERRABLE\", \"VALIDATED\" FROM   \"USER_CONSTRAINTS\" WHERE  \"USER_CONSTRAINTS\".\"TABLE_NAME\" = '" + this.getTableName().toUpperCase() + "' " + "AND    \"USER_CONSTRAINTS\".\"CONSTRAINT_TYPE\" = 'P' ");
                resultSet.next();
                if (resultSet.getString(1) != null) {
                    this.enabled = resultSet.getString(1).equalsIgnoreCase("enabled");
                }
                if (resultSet.getString(2) != null) {
                    this.deferred = resultSet.getString(2).equalsIgnoreCase("deferred");
                }
                if (resultSet.getString(3) != null) {
                    this.deferrable = resultSet.getString(3).equalsIgnoreCase("deferrable");
                }
                if (resultSet.getString(4) != null) {
                    this.validated = resultSet.getString(4).equalsIgnoreCase("validated");
                }
                statement.close();
                resultSet.close();
                super.setDbSpecificIsSet(true);
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("setSpecificContentViaDb failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        try {
            try {
                location.entering("writeSpecificContentToXmlFile");
                String offset1 = offset0 + XmlHelper.tabulate();
                String offset2 = offset1 + XmlHelper.tabulate();
                file.println(offset0 + "<primary-key>");
                file.println(offset1 + "<enforcement>");
                file.println(offset2 + "<enabled>" + this.enabled + "</enabled>");
                file.println(offset2 + "<initially-deferred>" + this.deferred + "</initially-deferred>");
                file.println(offset2 + "<deferrable>" + this.deferrable + "</deferrable>");
                file.println(offset2 + "<validated>" + this.validated + "</validated>");
                file.println(offset1 + "</enforcement>");
                file.println(offset0 + "</primary-key>");
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("writeCommonContentToXmlFile failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getDeferred() {
        return this.deferred;
    }

    public boolean getDeferrable() {
        return this.deferrable;
    }

    public boolean getValidated() {
        return this.validated;
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        location.entering("getDdlStatementsForCreate");
        String columns = "\"" + ((DbIndexColumnInfo)super.getColumnNames().get(0)).getName().toUpperCase() + "\"";
        int column = 1;
        while (column < super.getColumnNames().size()) {
            columns = columns + ", \"" + ((DbIndexColumnInfo)super.getColumnNames().get(column)).getName().toUpperCase() + "\"";
            ++column;
        }
        String enforcement = "";
        enforcement = enforcement + (this.deferrable ? "DEFERRABLE " : "NOT DEFERRABLE ");
        enforcement = enforcement + (this.deferred ? "INITIALLY DEFERRED " : "INITIALLY IMMEDIATE ");
        enforcement = enforcement + (this.enabled ? "ENABLE " : "DISABLE ");
        enforcement = enforcement + (this.validated ? "VALIDATE " : "NOVALIDATE ");
        DbObjectSqlStatements dbObjectSqlStatements = new DbObjectSqlStatements(this.getTableName() + " <primary-key>");
        DbSqlStatement dbSqlStatement = new DbSqlStatement();
        dbSqlStatement.addLine("ALTER TABLE \"" + this.getTableName().toUpperCase() + "\" ");
        dbSqlStatement.addLine("ADD PRIMARY KEY (" + columns + ") ");
        dbSqlStatement.addLine(enforcement);
        dbObjectSqlStatements.add(dbSqlStatement);
        location.exiting();
        return dbObjectSqlStatements;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() {
        location.entering("getDdlStatementsForDrop");
        DbObjectSqlStatements dbObjectSqlStatements = new DbObjectSqlStatements(this.getTableName() + " <primary-key>");
        DbSqlStatement dbSqlStatement = new DbSqlStatement(true);
        dbSqlStatement.addLine("ALTER TABLE \"" + this.getTableName().toUpperCase() + "\" ");
        dbSqlStatement.addLine("DROP PRIMARY KEY");
        dbObjectSqlStatements.add(dbSqlStatement);
        location.exiting();
        return dbObjectSqlStatements;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DbPrimaryKeyDifference compareTo(DbOraPrimaryKey target) throws JddException {
        DbPrimaryKeyDifference dbPrimaryKeyDifference;
        try {
            try {
                DbPrimaryKeyDifference primaryKeyDifference;
                location.entering("compareTo");
                if (!this.getDbSpecificIsSet()) {
                    primaryKeyDifference = super.compareTo(target);
                } else {
                    primaryKeyDifference = null;
                    boolean different = false;
                    different = different || this.getColumnNames().size() != target.getColumnNames().size();
                    different = different || this.getEnabled() != target.getEnabled();
                    different = different || this.getDeferred() != target.getDeferred();
                    different = different || this.getDeferrable() != target.getDeferrable();
                    different = different || this.getValidated() != target.getValidated();
                    int i = 0;
                    while (true) {
                        if (i >= Math.min(this.getColumnNames().size(), target.getColumnNames().size())) {
                            if (!different) break;
                            primaryKeyDifference = this.factory.makeDbPrimaryKeyDifference(this, target, Action.DROP_CREATE);
                            break;
                        }
                        different = different || !((DbIndexColumnInfo)this.getColumnNames().get(i)).equals((DbIndexColumnInfo)target.getColumnNames().get(i));
                        ++i;
                    }
                }
                dbPrimaryKeyDifference = primaryKeyDifference;
                Object var6_8 = null;
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{target.getTableName(), exception.getMessage()};
                location.errorT("compareTo failed: comparison to primary key of table {0} yields {1}", arguments);
                throw JddException.createInstance(exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
        return dbPrimaryKeyDifference;
    }

    public boolean checkWidth() {
        boolean correct;
        location.entering("checkWidth");
        int blockSize = 0x400000;
        int width = 0;
        DbColumns columns = this.getTable().getColumns();
        Iterator iterator = ((AbstractList)this.getColumnNames()).iterator();
        while (iterator.hasNext()) {
            DbColumn column = columns.getColumn(((DbIndexColumnInfo)iterator.next()).getName());
            switch (column.getJavaSqlType()) {
                case -5: {
                    width += 22;
                    break;
                }
                case -2: {
                    width = (int)((long)width + column.getLength());
                    break;
                }
                case 2004: {
                    width += 0;
                    break;
                }
                case 1: {
                    width = (int)((long)width + Math.min(column.getLength() * 3L, 2000L));
                    break;
                }
                case 2005: {
                    width += 0;
                    break;
                }
                case 91: {
                    width += 7;
                    break;
                }
                case 3: {
                    width += 22;
                    break;
                }
                case 8: {
                    width += 22;
                    break;
                }
                case 6: {
                    width += 22;
                    break;
                }
                case 4: {
                    width += 22;
                    break;
                }
                case 2: {
                    width += 22;
                    break;
                }
                case 1111: {
                    width += 0;
                    break;
                }
                case 5: {
                    width += 22;
                    break;
                }
                case 92: {
                    width += 7;
                    break;
                }
                case 93: {
                    width += 11;
                    break;
                }
                case -3: {
                    width = (int)((long)width + column.getLength());
                    break;
                }
                case 12: {
                    width = (int)((long)width + Math.min(column.getLength() * 3L, 4000L));
                }
            }
        }
        boolean bl = correct = width < (int)(0.72 * (double)blockSize);
        if (!correct) {
            Object[] arguments = new Object[]{this.getTableName()};
            location.errorT("checkWidth: width of primary key of table {0} is too large", arguments);
        }
        location.exiting();
        return correct;
    }

    public boolean checkNumberOfColumns() {
        boolean correct;
        location.entering("checkNumberOfColumns");
        boolean bl = correct = this.getColumnNames().size() <= 32;
        if (!correct) {
            Object[] arguments = new Object[]{this.getTableName()};
            location.errorT("checkWidth: primary key of table {0} has too many columns", arguments);
        }
        location.exiting();
        return correct;
    }

    public boolean checkColumnsNotNull() {
        location.entering("checkColumnsNotNull");
        DbColumns columns = this.getTable().getColumns();
        boolean correct = true;
        Iterator iterator = ((AbstractList)this.getColumnNames()).iterator();
        while (iterator.hasNext()) {
            DbColumn column = columns.getColumn(((DbIndexColumnInfo)iterator.next()).getName());
            boolean bl = correct = correct && column != null && column.isNotNull();
        }
        if (!correct) {
            Object[] arguments = new Object[]{this.getTableName()};
            location.errorT("checkColumnsNotNull: primary key of table {0} may not allow null values", arguments);
        }
        location.exiting();
        return correct;
    }
}

