/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.ora.DbOraParameters;
import com.sap.dictionary.database.ora.DbOraStorage;
import com.sap.dictionary.database.ora.DbOraTablespace;
import com.sap.dictionary.database.ora.DbOraTablespaces;
import com.sap.sql.NativeSQLAccess;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;

public class DbOraLobStorage
implements Comparable {
    private DbOraTablespace tablespace = null;
    private DbOraStorage storage = null;
    private String lobColumnName = null;
    private String lobSegmentName = null;
    private Integer chunk = null;
    private Integer pctversion = null;
    private Boolean storageInRow = null;
    private Boolean cache = null;
    private Boolean logging = null;
    static /* synthetic */ Class class$java$lang$String;

    public DbOraLobStorage(String lobColumnName) {
        this.lobColumnName = lobColumnName;
    }

    public DbOraTablespace getTablespace() {
        return this.tablespace;
    }

    public DbOraStorage getStorage() {
        return this.storage;
    }

    public String getLobColumnName() {
        return this.lobColumnName;
    }

    public String getLobSegmentName() {
        return this.lobSegmentName;
    }

    public Integer getChunk() {
        return this.chunk;
    }

    public Integer getPctversion() {
        return this.pctversion;
    }

    public Boolean getStorageInRow() {
        return this.storageInRow;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public Boolean getLogging() {
        return this.logging;
    }

    protected static ArrayList setListContentViaXml(XmlMap xmlLobStorageList) {
        if (xmlLobStorageList.isEmpty()) {
            return null;
        }
        XmlMap xmlLobStorage = null;
        ArrayList<DbOraLobStorage> lobStorageList = new ArrayList<DbOraLobStorage>();
        boolean lobStorageExists = false;
        int i = 0;
        while (!(xmlLobStorage = xmlLobStorageList.getXmlMap("lob-storage" + (i == 0 ? "" : "" + i))).isEmpty()) {
            XmlMap lobs = xmlLobStorage.getXmlMap("lobs");
            XmlMap lob = xmlLobStorage.getXmlMap("lob");
            if (!lobs.isEmpty()) {
                XmlMap lobItemList = lobs.getXmlMap("lob-item-list");
                if (lobItemList.isEmpty()) {
                    System.err.println("A Lob Item List must be given!");
                    return null;
                }
                String lobItem = null;
                int k = 0;
                while ((lobItem = lobItemList.getString("lob-item" + (k == 0 ? "" : "" + k))) != null) {
                    if (lobItem.trim() != "") {
                        XmlMap lobParameters = lobs.getXmlMap("lob-parameters");
                        if (lobParameters == null) {
                            System.err.println("Lob Parameters must be given!");
                            return null;
                        }
                        lobStorageExists = true;
                        DbOraLobStorage lobStorage = new DbOraLobStorage(lobItem.trim());
                        String segmentName = null;
                        lobStorage.setContentViaXml(lobParameters, segmentName);
                        lobStorageList.add(lobStorage);
                        ++k;
                        continue;
                    }
                    break;
                }
            } else if (!lob.isEmpty()) {
                String lobItem = lob.getString("lob-item");
                if (lobItem == null) {
                    System.err.println("A Lob Item must be given!");
                    return null;
                }
                XmlMap lobParameters = lob.getXmlMap("lob-parameters");
                String segmentName = lob.getString("lob-segname");
                if (segmentName != null) {
                    segmentName = segmentName == "" ? null : segmentName.trim();
                }
                if (lobParameters.isEmpty() && segmentName == null) {
                    System.err.println("Lob Parameters or Segment Name must be given!");
                    return null;
                }
                lobStorageExists = true;
                DbOraLobStorage lobStorage = new DbOraLobStorage(lobItem.trim());
                if (segmentName == null) {
                    lobStorage.setContentViaXml(lobParameters, segmentName);
                }
                lobStorageList.add(lobStorage);
            } else {
                System.err.println("<lobs> or <lob> must be given!");
                return null;
            }
            ++i;
        }
        if (lobStorageExists) {
            Collections.sort(lobStorageList);
            return lobStorageList;
        }
        return null;
    }

    protected static ArrayList setListContentViaDbCatalog(Connection connection, String tableName, String partitionName, boolean isPartitioned) {
        ArrayList<DbOraLobStorage> lobStorageList = new ArrayList<DbOraLobStorage>();
        boolean lobStorageExists = false;
        Object prefix = null;
        String ddicTable = null;
        try {
            PreparedStatement preparedStatement;
            if (partitionName == null) {
                ddicTable = !isPartitioned ? "USER_LOBS" : "USER_PART_LOBS";
                preparedStatement = NativeSQLAccess.prepareNativeStatement((Connection)connection, (String)("SELECT * FROM   \"" + ddicTable.toUpperCase() + "\" " + "WHERE  \"TABLE_NAME\" = ? "));
                preparedStatement.setString(1, tableName.toUpperCase());
            } else {
                ddicTable = "USER_LOB_PARTITIONS";
                preparedStatement = NativeSQLAccess.prepareNativeStatement((Connection)connection, (String)("SELECT * FROM  \"" + ddicTable.toUpperCase() + "\" " + "WHERE \"TABLE_NAME\" = ? " + "AND   \"PARTITION_NAME\" = ? "));
                preparedStatement.setString(1, tableName.toUpperCase());
                preparedStatement.setString(2, partitionName.toUpperCase());
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                lobStorageExists = true;
                String lobColumnName = resultSet.getString("COLUMN_NAME");
                if (resultSet.wasNull()) {
                    System.err.println("Column name is NULL in " + ddicTable + " for table " + tableName);
                    return null;
                }
                DbOraLobStorage lobStorage = new DbOraLobStorage(lobColumnName);
                lobStorage.setContentViaDbCatalog(connection, resultSet, ddicTable);
                lobStorageList.add(lobStorage);
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (lobStorageExists) {
            Collections.sort(lobStorageList);
            return lobStorageList;
        }
        return null;
    }

    protected void setContentViaXml(XmlMap lobParameters, String segmentName) {
        this.lobSegmentName = segmentName;
        if (lobParameters.isEmpty()) {
            return;
        }
        String tablespaceName = lobParameters.getString("tablespace");
        if (tablespaceName != null) {
            this.tablespace = new DbOraTablespace(tablespaceName.trim());
        }
        this.storageInRow = lobParameters.getBooleanObject("enable-storage-in-row");
        this.chunk = lobParameters.getIntegerObject("chunk");
        this.pctversion = lobParameters.getIntegerObject("pctversion");
        Object cache = lobParameters.get("cache");
        if (cache != null) {
            if (cache.getClass() == (class$java$lang$String == null ? (class$java$lang$String = DbOraLobStorage.class$("java.lang.String")) : class$java$lang$String)) {
                cache = lobParameters.getBooleanObject("cache");
            } else {
                XmlMap xmlCache = lobParameters.getXmlMap("cache");
                cache = xmlCache.getBooleanObject("cache");
                this.logging = xmlCache.getBooleanObject("logging");
            }
        }
        XmlMap xmlStorage = lobParameters.getXmlMap("storage");
        DbOraStorage storage = new DbOraStorage();
        storage.setContentViaXml(xmlStorage);
        if (!storage.isNull()) {
            this.storage = storage;
        }
    }

    protected void setContentViaDbCatalog(Connection connection, ResultSet resultSet, String ddicTable) {
        String segmentName = null;
        String prefix = "";
        int factor = 1;
        if (ddicTable.equals("USER_PART_LOBS")) {
            prefix = "DEF_";
            factor = DbOraParameters.getDbBlockSize();
        }
        try {
            if (ddicTable.equals("USER_LOBS")) {
                segmentName = resultSet.getString("SEGMENT_NAME");
                if (!resultSet.wasNull()) {
                    this.lobSegmentName = segmentName;
                } else {
                    segmentName = null;
                }
            }
            String inRow = resultSet.getString(prefix + "IN_ROW");
            if (!resultSet.wasNull()) {
                if (inRow.equalsIgnoreCase("YES")) {
                    this.storageInRow = new Boolean(true);
                } else if (inRow.equalsIgnoreCase("NO")) {
                    this.storageInRow = new Boolean(false);
                }
            }
            int chunk = resultSet.getInt(prefix + "CHUNK");
            if (!resultSet.wasNull()) {
                this.chunk = new Integer(chunk * factor);
            }
            int pctversion = resultSet.getInt(prefix + "PCTVERSION");
            if (!resultSet.wasNull()) {
                this.pctversion = new Integer(pctversion);
            }
            String cache = resultSet.getString(prefix + "CACHE");
            if (!resultSet.wasNull()) {
                if (cache.equalsIgnoreCase("YES")) {
                    this.cache = new Boolean(true);
                } else if (cache.equalsIgnoreCase("NO")) {
                    this.cache = new Boolean(false);
                }
            }
            String logging = resultSet.getString(prefix + "LOGGING");
            if (!resultSet.wasNull()) {
                if (logging.equalsIgnoreCase("YES")) {
                    this.logging = new Boolean(true);
                } else if (logging.equalsIgnoreCase("NO")) {
                    this.logging = new Boolean(false);
                }
            }
            DbOraStorage storage = new DbOraStorage();
            if (segmentName != null) {
                PreparedStatement preparedStatement = NativeSQLAccess.prepareNativeStatement((Connection)connection, (String)"SELECT * FROM   \"USER_SEGMENTS\" WHERE  \"SEGMENT_NAME\" = ? ");
                preparedStatement.setString(1, segmentName.toUpperCase());
                ResultSet temporary = preparedStatement.executeQuery();
                if (temporary.next()) {
                    String tablespaceName = temporary.getString(prefix + "TABLESPACE_NAME");
                    if (!temporary.wasNull()) {
                        this.tablespace = DbOraTablespaces.getTablespace(tablespaceName);
                    }
                    storage.setContentViaDbCatalog(temporary, "USER_SEGMENTS");
                }
                preparedStatement.close();
                temporary.close();
            } else if (!ddicTable.equals("USER_LOBS")) {
                String tablespaceName = resultSet.getString(prefix + "TABLESPACE_NAME");
                if (!resultSet.wasNull()) {
                    this.tablespace = DbOraTablespaces.getTablespace(tablespaceName);
                }
                storage.setContentViaDbCatalog(resultSet, ddicTable);
            }
            if (!storage.isNull()) {
                this.storage = storage;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static DbSqlStatement getDdlClauses(ArrayList lobList) {
        DbSqlStatement statement = new DbSqlStatement();
        int i = 0;
        while (i < lobList.size()) {
            DbOraLobStorage lobStorage = (DbOraLobStorage)lobList.get(i);
            statement.merge(lobStorage.getDdlClause());
            ++i;
        }
        return statement;
    }

    protected DbSqlStatement getDdlClause() {
        DbSqlStatement statement = new DbSqlStatement();
        statement.addLine(" LOB (\"" + this.lobColumnName.toUpperCase() + "\") STORE AS");
        if (this.lobSegmentName != null) {
            statement.addLine(this.lobSegmentName);
        }
        if (this.tablespace != null || this.storageInRow != null || this.storage != null || this.chunk != null || this.pctversion != null || this.cache != null) {
            statement.addLine(" (");
            if (this.tablespace != null) {
                statement.addLine(" TABLESPACE \"" + this.tablespace.getName().toUpperCase() + "\"");
            }
            if (this.storageInRow != null) {
                if (this.storageInRow.booleanValue()) {
                    statement.addLine(" ENABLE STORAGE IN ROW");
                } else {
                    statement.addLine(" DISABLE STORAGE IN ROW");
                }
            }
            if (this.storage != null) {
                statement.merge(this.storage.getDdlClause());
            }
            if (this.chunk != null) {
                statement.addLine(" CHUNK " + this.chunk);
            }
            if (this.pctversion != null) {
                statement.addLine(" PCTVERSION " + this.pctversion);
            }
            if (this.cache != null) {
                if (this.cache.booleanValue()) {
                    statement.addLine(" CACHE");
                } else if (this.logging != null) {
                    if (this.logging.booleanValue()) {
                        statement.addLine(" NOCACHE LOGGING");
                    } else {
                        statement.addLine(" NOCACHE NOLOGGING");
                    }
                }
            }
            statement.addLine(" )");
        }
        return statement;
    }

    public static void writeListContentToXmlFile(ArrayList lobList, PrintWriter file, String offset0) {
        String offset1 = offset0 + XmlHelper.tabulate();
        file.println(offset0 + "<lob-storage-list>");
        int i = 0;
        while (i < lobList.size()) {
            DbOraLobStorage lobStorage = (DbOraLobStorage)lobList.get(i);
            lobStorage.writeContentToXmlFile(file, offset1);
            ++i;
        }
        file.println(offset0 + "</lob-storage-list>");
    }

    public int compareTo(Object object) {
        DbOraLobStorage lobStorage = (DbOraLobStorage)object;
        return this.lobColumnName.compareTo(lobStorage.getLobColumnName());
    }

    public void writeContentToXmlFile(PrintWriter file, String offset0) {
        String offset1 = offset0 + XmlHelper.tabulate();
        String offset2 = offset1 + XmlHelper.tabulate();
        String offset3 = offset2 + XmlHelper.tabulate();
        file.println(offset0 + "<lob-storage>");
        file.println(offset1 + "<lob>");
        file.println(offset2 + "<lob-item>" + this.lobColumnName + "</lob-item>");
        if (this.lobSegmentName != null && !this.lobSegmentName.startsWith(DbOraParameters.getSchemaObjectPrefix())) {
            file.println(offset2 + "<lob-segname>" + this.lobSegmentName + "</lob-segname>");
        }
        if (this.tablespace != null || this.storageInRow != null || this.storage != null || this.chunk != null || this.pctversion != null || this.cache != null) {
            file.println(offset2 + "<lob-parameters>");
            if (this.tablespace != null) {
                file.println(offset3 + "<tablespace>" + this.tablespace.getName() + "</tablespace>");
            }
            if (this.storageInRow != null) {
                file.println(offset3 + "<enable-storage-in-row>" + this.storageInRow + "</enable-storage-in-row>");
            }
            if (this.storage != null) {
                this.storage.writeContentToXmlFile(file, offset3);
            }
            if (this.chunk != null) {
                file.println(offset3 + "<chunk>" + this.chunk + "</chunk>");
            }
            if (this.pctversion != null) {
                file.println(offset3 + "<pctversion>" + this.pctversion + "</pctversion>");
            }
            if (this.cache != null) {
                if (this.logging != null) {
                    file.println(offset3 + "<cache logging=" + "\"" + this.logging + "\">" + this.cache + "</cache>");
                } else {
                    file.println(offset3 + "<cache>" + this.cache + "</cache>");
                }
            }
            file.println(offset2 + "</lob-parameters>");
        }
        file.println(offset1 + "</lob>");
        file.println(offset0 + "</lob-storage>");
    }

    public String toString() {
        return "Lob Column Name       : " + this.lobColumnName + "\n" + "Lob Segment Name      : " + this.lobSegmentName + "\n" + "Tablespace            : " + "\n" + this.tablespace + "\n" + "Storage in Row        : " + this.storageInRow + "\n" + "Storage               : " + "\n" + this.storage + "\n" + "Chunk                 : " + this.chunk + "\n" + "Pctversion            : " + this.pctversion + "\n" + "Cache                 : " + this.cache + "\n" + "Logging               : " + this.logging + "\n";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

