/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.inf;

import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.DbTableDifference;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.inf.DbInfIndex;
import com.sap.dictionary.database.inf.DbInfPrimaryKey;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class DbInfTable
extends DbTable {
    private String dataFilegroup = "DEFAULT";
    private String textimageFilegroup = "DEFAULT";

    public DbInfTable() {
    }

    public DbInfTable(DbFactory factory) {
        super(factory);
    }

    public DbInfTable(DbFactory factory, DbSchema schema, String name) {
        super(factory, name);
    }

    public DbInfTable(DbFactory factory, String name) {
        super(factory, name);
    }

    public DbInfTable(DbFactory factory, DbTable other) {
        super(factory, other);
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) {
    }

    public void setIndexesViaDb() throws JddException {
        ArrayList names = new ArrayList();
        DbFactory factory = this.getDbFactory();
        Connection con = factory.getConnection();
        names = this.dbGetIndexNames(con);
        if (!names.isEmpty()) {
            DbIndexes indexes = new DbIndexes(factory);
            int i = 0;
            while (i < names.size()) {
                DbInfIndex index = new DbInfIndex(factory, this.getSchema(), this.getName().toUpperCase(), (String)names.get(i));
                index.setIndexes(indexes);
                index.setCommonContentViaDb();
                indexes.add(index);
                ++i;
            }
            this.setIndexes(indexes);
        }
    }

    public void setPrimaryKeyViaDb() throws JddException {
        Connection con = this.getDbFactory().getConnection();
        String name = this.getName().toUpperCase();
        if (name != null) {
            DbInfPrimaryKey primaryKey = new DbInfPrimaryKey(this.getDbFactory(), this.getSchema(), name);
            primaryKey.setCommonContentViaDb();
            this.setPrimaryKey(primaryKey);
        }
    }

    public String dbGetPrimaryKeyName(Connection conn) {
        String name = "";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rset = stmt.executeQuery("select c.constrname from sysconstraints c, systables t where  t.tabname = '" + this.getName().toUpperCase() + "' " + "and t.tabid = c.tabid " + "and c.constrtype = 'P'");
            while (rset.next()) {
                name = rset.getString(1);
            }
        }
        catch (Exception ex) {
            System.out.println("Exception caught : " + ex.getMessage());
        }
        return name;
    }

    public void setSpecificContentViaDb() {
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() throws JddException {
        try {
            DbObjectSqlStatements tableDef = new DbObjectSqlStatements(this.getName().toUpperCase());
            DbSqlStatement createLine = new DbSqlStatement();
            createLine.addLine("CREATE TABLE \"" + this.getName().toUpperCase() + "\"");
            createLine.merge(this.getColumns().getDdlClause());
            tableDef.add(createLine);
            DbSqlStatement storageLine = new DbSqlStatement();
            boolean addStorage = false;
            if (!this.dataFilegroup.equals("DEFAULT")) {
                storageLine.addLine(" ON " + this.dataFilegroup);
                addStorage = true;
            }
            if (!this.textimageFilegroup.equals("DEFAULT")) {
                storageLine.addLine("  TEXTIMAGE_ON " + this.textimageFilegroup);
                addStorage = true;
            }
            if (addStorage) {
                tableDef.add(storageLine);
            }
            if (this.getIndexes() != null) {
                tableDef.merge(this.getIndexes().getDdlStatementsForCreate());
            }
            return tableDef;
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() throws JddException {
        DbObjectSqlStatements tableDef = new DbObjectSqlStatements(this.getName().toUpperCase());
        DbSqlStatement dropLine = new DbSqlStatement();
        try {
            dropLine.addLine("DROP TABLE \"" + this.getName().toUpperCase() + "\"");
            tableDef.add(dropLine);
            return tableDef;
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public DbTableDifference compareTo(DbTable target) throws Exception {
        DbTableDifference tableDiff = null;
        if (!this.DbSpecificIsSet()) {
            return super.compareTo(target);
        }
        return tableDiff;
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) {
    }

    public boolean existsOnDb() {
        return false;
    }

    public boolean existsData() {
        return true;
    }

    public ArrayList dbGetIndexNames(Connection conn) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            PreparedStatement ps = conn.prepareStatement("select idxname from sysindexes i, systables t where i.tabid = t.tabid  and i.idxname not in ( select c.idxname from sysconstraints c  where c.tabid = t.tabid  and constrtype = 'P' )  and t.tabname = ?");
            String tabname = this.getName().toUpperCase();
            ps.setString(1, tabname);
            ResultSet rset = ps.executeQuery();
            while (rset.next()) {
                names.add(rset.getString(1));
            }
            rset.close();
        }
        catch (Exception ex) {
            System.out.println("Exception caught : " + ex.getMessage());
        }
        return names;
    }

    public String toString() {
        return super.toString() + "ON " + this.dataFilegroup + "\n" + "TEXTIMAGE_ON " + this.textimageFilegroup + "\n";
    }
}

