/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Database;
import com.sap.dictionary.database.dbs.DbFactory;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class JavaSqlTypeInfo {
    private String name = "OTHER";
    private int intCode = 1111;
    private boolean hasLengthAttribute = false;
    private boolean hasDecimals = false;
    private boolean hasDefaultValue = false;
    private String defaultValuePrefix = "";
    private String defaultValueSuffix = "";
    private boolean isAcceptedByAllDbs = false;
    private long maxLength = 0L;
    private String minValue = null;
    private String maxValue = null;
    private String ddlName = null;
    private String ddlSuffix = "";
    private String dbTypeName = null;
    private int ddlDefaultLength = 0;
    private String defaultDefault = null;
    private int byteFactor = 0;
    private boolean trimDefaultValue = true;
    private static ArrayList limits = null;
    private static HashMap stringLimits = new HashMap();
    private static HashMap binaryLimits = new HashMap();
    private static final SimpleDateFormat FDATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat FTIME = new SimpleDateFormat("H:mm:ss");
    private static final SimpleDateFormat FTIMESTAMP = new SimpleDateFormat("yyyy-MM-dd H:mm:ss.SSS");
    private Format formatter = null;

    public JavaSqlTypeInfo(DbFactory factory, String name, int intCode) {
        this.name = name;
        this.ddlName = name;
        this.intCode = intCode;
        switch (intCode) {
            case 1: {
                this.hasLengthAttribute = true;
                this.hasDecimals = false;
                this.hasDefaultValue = false;
                this.defaultValuePrefix = "'";
                this.defaultValueSuffix = "'";
                this.trimDefaultValue = false;
                this.isAcceptedByAllDbs = false;
                this.maxLength = 0L;
                break;
            }
            case -2: {
                this.hasLengthAttribute = true;
                this.hasDecimals = false;
                this.hasDefaultValue = false;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.isAcceptedByAllDbs = false;
                this.maxLength = 0L;
                break;
            }
            case 12: {
                this.hasLengthAttribute = true;
                this.hasDecimals = false;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "'";
                this.defaultValueSuffix = "'";
                this.trimDefaultValue = false;
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                break;
            }
            case -3: {
                this.hasLengthAttribute = true;
                this.hasDecimals = false;
                this.hasDefaultValue = false;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                break;
            }
            case -1: {
                this.hasLengthAttribute = true;
                this.hasDecimals = false;
                this.hasDefaultValue = false;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.trimDefaultValue = false;
                this.isAcceptedByAllDbs = false;
                this.maxLength = 0L;
                break;
            }
            case -4: {
                this.hasLengthAttribute = true;
                this.hasDecimals = false;
                this.hasDefaultValue = false;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.isAcceptedByAllDbs = false;
                this.maxLength = 0L;
                break;
            }
            case 2005: {
                this.hasLengthAttribute = false;
                this.hasDecimals = false;
                this.hasDefaultValue = false;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.trimDefaultValue = false;
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                break;
            }
            case 2004: {
                this.hasLengthAttribute = false;
                this.hasDecimals = false;
                this.hasDefaultValue = false;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                break;
            }
            case 5: {
                this.hasLengthAttribute = false;
                this.hasDecimals = false;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.defaultDefault = "0";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                this.minValue = "-32767";
                this.maxValue = "32767";
                break;
            }
            case 4: {
                this.hasLengthAttribute = false;
                this.hasDecimals = false;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.defaultDefault = "0";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                this.minValue = "-2147483647";
                this.maxValue = "2147483647";
                break;
            }
            case -5: {
                this.hasLengthAttribute = false;
                this.hasDecimals = false;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.defaultDefault = "0";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                this.minValue = "-9223372036854775808";
                this.maxValue = "9223372036854775807";
                break;
            }
            case 3: {
                this.hasLengthAttribute = true;
                this.hasDecimals = true;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.defaultDefault = "0";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 31L;
                break;
            }
            case 2: {
                this.hasLengthAttribute = true;
                this.hasDecimals = true;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.defaultDefault = "0";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 31L;
                break;
            }
            case 6: {
                this.hasLengthAttribute = false;
                this.hasDecimals = false;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.defaultDefault = "0";
                this.isAcceptedByAllDbs = false;
                this.maxLength = 0L;
                this.minValue = "-1.402e-45";
                this.maxValue = "3.402e+38";
                break;
            }
            case 7: {
                this.hasLengthAttribute = false;
                this.hasDecimals = false;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.defaultDefault = "0";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                this.minValue = "-1.402e-45";
                this.maxValue = "3.402e+38";
                break;
            }
            case 8: {
                this.hasLengthAttribute = false;
                this.hasDecimals = false;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "";
                this.defaultValueSuffix = "";
                this.defaultDefault = "0";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                this.minValue = "-2.225e-308";
                this.maxValue = "1.79769e+308";
                break;
            }
            case 91: {
                this.hasLengthAttribute = false;
                this.hasDecimals = false;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "'";
                this.defaultValueSuffix = "'";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                this.formatter = FDATE;
                break;
            }
            case 92: {
                this.hasLengthAttribute = false;
                this.hasDecimals = false;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "'";
                this.defaultValueSuffix = "'";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                this.formatter = FTIME;
                break;
            }
            case 93: {
                this.hasLengthAttribute = false;
                this.hasDecimals = false;
                this.hasDefaultValue = true;
                this.defaultValuePrefix = "'";
                this.defaultValueSuffix = "'";
                this.isAcceptedByAllDbs = true;
                this.maxLength = 0L;
                this.formatter = FTIMESTAMP;
            }
        }
    }

    public void setHasLengthAttribute(boolean hasLengthAttribute) {
        this.hasLengthAttribute = hasLengthAttribute;
    }

    public void setHasDecimals(boolean hasDecimals) {
        this.hasDecimals = hasDecimals;
    }

    public void setHasDefaultValue(boolean hasDefaultValue) {
        this.hasDefaultValue = hasDefaultValue;
    }

    public void setDefaultValuePrefix(String defaultValuePrefix) {
        this.defaultValuePrefix = defaultValuePrefix;
    }

    public void setDefaultValueSuffix(String defaultValueSuffix) {
        this.defaultValueSuffix = defaultValueSuffix;
    }

    public void setDefaultDefault(String defaultDefault) {
        this.defaultDefault = defaultDefault;
    }

    public void setTrimDefaultValue(boolean trimDefaultValue) {
        this.trimDefaultValue = trimDefaultValue;
    }

    public void setIsAcceptedByAllDbs(boolean isAcceptedByAllDbs) {
        this.isAcceptedByAllDbs = isAcceptedByAllDbs;
    }

    public void setMaxLength(long maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public void setDdlName(String ddlName) {
        this.ddlName = ddlName;
    }

    public void setDdlSuffix(String ddlSuffix) {
        this.ddlSuffix = ddlSuffix;
    }

    public void setDbTypeName(String dbTypeName) {
        this.dbTypeName = dbTypeName;
    }

    public void setDdlDefaultLength(int ddlDefaultLength) {
        this.ddlDefaultLength = ddlDefaultLength;
    }

    public void setByteFactor(int byteFactor) {
        this.byteFactor = byteFactor;
    }

    public String getName() {
        return this.name;
    }

    public int getIntCode() {
        return this.intCode;
    }

    public boolean hasLengthAttribute() {
        return this.hasLengthAttribute;
    }

    public boolean hasByteFactor() {
        return this.byteFactor != 0;
    }

    public boolean hasDecimals() {
        return this.hasDecimals;
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    public String getDefaultValuePrefix() {
        return this.defaultValuePrefix;
    }

    public String getDefaultValueSuffix() {
        return this.defaultValueSuffix;
    }

    public String getDefaultDefault() {
        return this.defaultDefault;
    }

    public boolean trimDefaultValue() {
        return this.trimDefaultValue;
    }

    public boolean isAcceptedByAllDbs() {
        return this.isAcceptedByAllDbs;
    }

    public long maxLength() {
        return this.maxLength;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public String getDdlName() {
        return this.ddlName;
    }

    public String getDdlSuffix() {
        return this.ddlSuffix;
    }

    public String getDbTypeName() {
        return this.dbTypeName;
    }

    public int getDdlDefaultLength() {
        return this.ddlDefaultLength;
    }

    public int getByteFactor() {
        return this.byteFactor;
    }

    public static HashMap getStringLimits() {
        return stringLimits;
    }

    public static HashMap getBinaryLimits() {
        return binaryLimits;
    }

    public Format getFormatterForDefaultString() {
        return this.formatter;
    }

    public String toString() {
        return "JavaSqlTypeInfo = " + this.name + "\n" + "Integer Code           : " + this.intCode + "\n" + "Has Length Attribute   : " + this.hasLengthAttribute + "\n" + "Has Decimals           : " + this.hasDecimals + "\n" + "Has Default Value      : " + this.hasDefaultValue + "\n" + "Default Value Prefix   : " + this.defaultValuePrefix + "\n" + "Default Value Suffix   : " + this.defaultValueSuffix + "\n" + "Is Accepted by all Dbs : " + this.isAcceptedByAllDbs + "\n" + "Max Length             : " + this.maxLength + "\n" + "Byte Factor            : " + this.byteFactor + "\n";
    }

    static {
        try {
            String className = null;
            String abbr = null;
            String[] databaseNames = Database.getDatabaseNames();
            int i = 0;
            while (i <= databaseNames.length - 1) {
                limits = new ArrayList();
                abbr = Database.getDatabase(databaseNames[i]).getAbbreviation();
                try {
                    className = "com.sap.dictionary.database." + abbr.toLowerCase() + "." + "Java" + abbr + "SqlTypeInfo";
                    Class<?> typeInfo = Class.forName(className);
                    limits.add(new Integer(typeInfo.getField("VARCHAR_LIMIT").getInt(typeInfo)));
                    limits.add(new Integer(typeInfo.getField("LONGVARCHAR_LIMIT").getInt(typeInfo)));
                    limits.add(new Integer(typeInfo.getField("VARCHAR_WHERE_CONDITION_LIMIT").getInt(typeInfo)));
                    stringLimits.put(databaseNames[i], limits);
                    limits = new ArrayList();
                    limits.add(new Integer(typeInfo.getField("VARBINARY_LIMIT").getInt(typeInfo)));
                    limits.add(new Integer(typeInfo.getField("LONGVARBINARY_LIMIT").getInt(typeInfo)));
                    limits.add(new Integer(typeInfo.getField("VARBINARY_WHERE_CONDITION_LIMIT").getInt(typeInfo)));
                    binaryLimits.put(databaseNames[i], limits);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

