/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.IGenException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class GenExceptionInfo {
    private ExType exType = null;
    private Throwable action = null;
    private Throwable cause = null;
    private boolean isLogged = false;

    public GenExceptionInfo(Throwable action) {
        this.action = action;
    }

    public GenExceptionInfo(Throwable action, ExType exType) {
        this.action = action;
        this.exType = exType;
    }

    public GenExceptionInfo(Throwable action, ExType exType, Throwable cause) {
        this.action = action;
        this.exType = exType;
        this.cause = cause;
        if (cause != null && cause instanceof IGenException && ((IGenException)((Object)cause)).getInfo().isLogged) {
            this.isLogged = true;
        }
    }

    public GenExceptionInfo(Throwable action, ExType exType, Throwable cause, Object msgCode, Object[] args, Category cat, int severity, Location loc) {
        this.action = action;
        this.exType = exType;
        this.cause = cause;
        String addLogString = "";
        if (cause != null && cause instanceof IGenException && ((IGenException)((Object)cause)).getInfo().isLogged) {
            this.isLogged = true;
        }
        if (!(cat == null && loc == null || this.isLogged)) {
            this.isLogged = true;
            String causeMessage = null;
            if (cause != null) {
                causeMessage = cause.getMessage();
            }
            if (!GenExceptionInfo.isEmpty(causeMessage)) {
                addLogString = " Caused by: " + cause.getMessage();
            }
            addLogString = addLogString + " Stack trace: " + this.getStackTraceString();
        }
        if (cat != null) {
            if (msgCode != null) {
                cat.log(severity, loc, msgCode, args);
            }
            if (!GenExceptionInfo.isEmpty(addLogString)) {
                cat.logT(severity, loc, addLogString);
            }
        } else if (loc != null) {
            if (msgCode != null) {
                loc.log(severity, cat, msgCode, args);
            }
            if (!GenExceptionInfo.isEmpty(addLogString)) {
                loc.logT(severity, cat, addLogString);
            }
        }
    }

    public void intLog(Category cat, int severity, Location loc) {
        String addLogString = "";
        if (!(cat == null && loc == null || this.isLogged)) {
            String causeMessage;
            String string = causeMessage = this.cause != null ? this.cause.getMessage() : null;
            if (!GenExceptionInfo.isEmpty(causeMessage)) {
                addLogString = " Caused by: " + this.cause.getMessage();
            }
            addLogString = addLogString + " Stack trace: " + this.getStackTraceString();
            this.isLogged = true;
        }
        if (!GenExceptionInfo.isEmpty(addLogString)) {
            if (cat != null) {
                cat.logT(severity, loc, addLogString);
            } else if (loc != null) {
                loc.logT(severity, cat, addLogString);
            }
        }
    }

    public String getStackTraceString() {
        String trace = "";
        try {
            StringWriter sw = new StringWriter(128);
            if (this.cause != null) {
                this.cause.printStackTrace(new PrintWriter(sw));
            } else {
                this.action.printStackTrace(new PrintWriter(sw));
            }
            sw.close();
            trace = sw.toString();
            return trace;
        }
        catch (IOException ioex) {
            return trace;
        }
    }

    public ExType getExType() {
        return this.exType;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public boolean isLogged() {
        return this.isLogged;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().equals("");
    }
}

