/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.TraceFormatter;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class DbTraceFormatter
extends TraceFormatter {
    private static final int INITIAL_CAPACITY = 512;
    private static final Format DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private static final Format TIME_FORMATTER = new SimpleDateFormat("H:mm:ss", Locale.US);

    public String format(LogRecord rec) {
        StringBuffer res = new StringBuffer(512);
        int sev = rec.getSeverity();
        if (sev >= 500) {
            res.append(Formatter.EOL);
            res.append("E R R O R *******");
            res.append(" (");
            res.append(rec.getSourceName().substring(32));
            res.append(")");
            res.append(Formatter.EOL);
        }
        res.append(TIME_FORMATTER.format(rec.getTime()));
        res.append(" ");
        res.append(DATE_FORMATTER.format(rec.getTime()));
        res.append(" ");
        res.append(rec.getSourceName().substring(28, 31));
        res.append("-");
        res.append(Severity.toString((int)sev));
        res.append(":");
        res.append("  ");
        try {
            res.append(MessageFormat.format(rec.getMsgClear(), rec.getArgs().toArray()));
        }
        catch (IllegalArgumentException e) {
            res.append(rec.getMsgClear());
        }
        res.append(Formatter.EOL);
        String result = TIME_FORMATTER.format(rec.getTime()) + " " + Severity.toString((int)rec.getSeverity()) + " " + rec.getSourceName().substring(28, Math.min(58, rec.getSourceName().length())) + " " + rec.getMsgClear() + "\n";
        return res.toString();
    }
}

